/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.greenrobot.essentials.io.CircularByteBuffer;

public class PipelineOutputStream
extends OutputStream {
    private final PipelineInputStream inputStream;
    final CircularByteBuffer buffer;
    boolean closedOut;
    boolean closedIn;

    public PipelineOutputStream() {
        this(8192);
    }

    public PipelineOutputStream(int bufferCapacity) {
        this.buffer = new CircularByteBuffer(bufferCapacity);
        this.inputStream = new PipelineInputStream();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public synchronized void write(byte[] data, int off, int len) throws IOException {
        int done = 0;
        while (done != len) {
            this.checkPipelineInput();
            int count = this.buffer.put(data, off + done, len - done);
            if (count > 0) {
                done += count;
                this.notifyBuffer();
                continue;
            }
            this.waitForBuffer();
        }
    }

    private void checkPipelineInput() throws IOException {
        if (this.closedIn) {
            throw new IOException("PipelineInputStream was closed (broken pipeline)");
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.checkPipelineInput();
        while (!this.buffer.put((byte)b)) {
            this.waitForBuffer();
            this.checkPipelineInput();
        }
        this.notifyBuffer();
    }

    @Override
    public synchronized void close() throws IOException {
        this.closedOut = true;
        this.notifyBuffer();
    }

    void waitForBuffer() throws IOException {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    void notifyBuffer() {
        this.notifyAll();
    }

    protected class PipelineInputStream
    extends InputStream {
        protected PipelineInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read;
            if (len == 0) {
                return PipelineOutputStream.this.closedOut ? -1 : 0;
            }
            PipelineOutputStream pipelineOutputStream = PipelineOutputStream.this;
            synchronized (pipelineOutputStream) {
                do {
                    if ((read = PipelineOutputStream.this.buffer.get(b, off, len)) != 0) continue;
                    if (PipelineOutputStream.this.closedOut) {
                        return -1;
                    }
                    PipelineOutputStream.this.waitForBuffer();
                } while (read == 0);
                PipelineOutputStream.this.notifyBuffer();
            }
            return read;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            PipelineOutputStream pipelineOutputStream = PipelineOutputStream.this;
            synchronized (pipelineOutputStream) {
                int value = PipelineOutputStream.this.buffer.get();
                while (value == -1) {
                    if (PipelineOutputStream.this.closedOut) {
                        return -1;
                    }
                    PipelineOutputStream.this.waitForBuffer();
                    value = PipelineOutputStream.this.buffer.get();
                }
                PipelineOutputStream.this.notifyBuffer();
                return value;
            }
        }

        @Override
        public int available() throws IOException {
            return PipelineOutputStream.this.buffer.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            int len = (int)Math.min(n, Integer.MAX_VALUE);
            int total = 0;
            PipelineOutputStream pipelineOutputStream = PipelineOutputStream.this;
            synchronized (pipelineOutputStream) {
                while (total < len) {
                    int skipped = PipelineOutputStream.this.buffer.skip(len - total);
                    if (skipped == 0) {
                        if (PipelineOutputStream.this.closedOut) {
                            return total;
                        }
                        PipelineOutputStream.this.waitForBuffer();
                        continue;
                    }
                    total += skipped;
                    PipelineOutputStream.this.notifyBuffer();
                }
                return total;
            }
        }

        @Override
        public void close() throws IOException {
            PipelineOutputStream.this.closedIn = true;
        }
    }
}

