/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.gelfclient;

public enum GelfMessageLevel {
    EMERGENCY(0),
    ALERT(1),
    CRITICAL(2),
    ERROR(3),
    WARNING(4),
    NOTICE(5),
    INFO(6),
    DEBUG(7);

    private final int numericLevel;

    private GelfMessageLevel(int numericLevel) {
        this.numericLevel = numericLevel;
    }

    public int getNumericLevel() {
        return this.numericLevel;
    }

    public static GelfMessageLevel fromNumericLevel(int level) {
        for (GelfMessageLevel gelfMessageLevel : GelfMessageLevel.values()) {
            if (level != gelfMessageLevel.getNumericLevel()) continue;
            return gelfMessageLevel;
        }
        throw new IllegalArgumentException("Unknown GELF message level: " + level);
    }

    public String toString() {
        return this.name() + "(" + this.numericLevel + ")";
    }
}

