/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.gelfclient.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.graylog2.gelfclient.GelfMessage;
import org.graylog2.gelfclient.util.Uninterruptibles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GelfSenderThread {
    private static final Logger LOG = LoggerFactory.getLogger(GelfSenderThread.class);
    private final ReentrantLock lock;
    private final Condition connectedCond;
    private final AtomicBoolean keepRunning = new AtomicBoolean(true);
    private final Thread senderThread;
    private Channel channel;
    private final int maxInflightSends;

    public GelfSenderThread(final BlockingQueue<GelfMessage> queue, int maxInflightSends) {
        this.maxInflightSends = maxInflightSends;
        this.lock = new ReentrantLock();
        this.connectedCond = this.lock.newCondition();
        if (maxInflightSends <= 0) {
            throw new IllegalArgumentException("maxInflightSends must be larger than 0");
        }
        this.senderThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GelfMessage gelfMessage = null;
                final AtomicInteger inflightSends = new AtomicInteger(0);
                ChannelFutureListener inflightListener = new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        inflightSends.decrementAndGet();
                    }
                };
                while (GelfSenderThread.this.keepRunning.get()) {
                    GelfSenderThread.this.lock.lock();
                    try {
                        while (GelfSenderThread.this.channel == null || !GelfSenderThread.this.channel.isActive()) {
                            try {
                                GelfSenderThread.this.connectedCond.await();
                            }
                            catch (InterruptedException e) {
                                if (GelfSenderThread.this.keepRunning.get()) continue;
                                break;
                            }
                        }
                        try {
                            if (gelfMessage == null) {
                                gelfMessage = (GelfMessage)queue.poll(100L, TimeUnit.MILLISECONDS);
                            }
                            if (gelfMessage == null || GelfSenderThread.this.channel == null || !GelfSenderThread.this.channel.isActive()) continue;
                            while (inflightSends.get() > GelfSenderThread.this.maxInflightSends) {
                                Uninterruptibles.sleepUninterruptibly(1L, TimeUnit.MICROSECONDS);
                            }
                            inflightSends.incrementAndGet();
                            GelfSenderThread.this.channel.writeAndFlush((Object)gelfMessage).addListener((GenericFutureListener)inflightListener);
                            gelfMessage = null;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    finally {
                        GelfSenderThread.this.lock.unlock();
                    }
                }
                LOG.debug("GelfSenderThread exiting!");
            }
        });
        this.senderThread.setDaemon(true);
        this.senderThread.setName("GelfSenderThread-" + this.senderThread.getId());
    }

    public void start(Channel channel) {
        this.lock.lock();
        try {
            this.channel = channel;
            this.connectedCond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.senderThread.start();
    }

    public void stop() {
        this.keepRunning.set(false);
        this.senderThread.interrupt();
    }
}

