/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.gelfclient.encoder;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.graylog2.gelfclient.GelfMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class GelfMessageJsonEncoder
extends MessageToMessageEncoder<GelfMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(GelfMessageJsonEncoder.class);
    private final JsonFactory jsonFactory;

    public GelfMessageJsonEncoder() {
        this(new JsonFactory());
    }

    public GelfMessageJsonEncoder(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        LOG.error("JSON encoding error", cause);
    }

    protected void encode(ChannelHandlerContext ctx, GelfMessage message, List<Object> out) throws Exception {
        out.add(Unpooled.wrappedBuffer((byte[])this.toJson(message)));
    }

    private byte[] toJson(GelfMessage message) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JsonGenerator jg = this.jsonFactory.createGenerator((OutputStream)out, JsonEncoding.UTF8);){
            jg.writeStartObject();
            jg.writeStringField("version", message.getVersion().toString());
            jg.writeNumberField("timestamp", message.getTimestamp());
            jg.writeStringField("host", message.getHost());
            jg.writeStringField("short_message", message.getMessage());
            if (message.getLevel() != null) {
                jg.writeNumberField("level", message.getLevel().getNumericLevel());
            }
            if (null != message.getFullMessage()) {
                jg.writeStringField("full_message", message.getFullMessage());
            }
            for (Map.Entry<String, Object> field : message.getAdditionalFields().entrySet()) {
                String realKey;
                String string = realKey = field.getKey().startsWith("_") ? field.getKey() : "_" + field.getKey();
                if (field.getValue() instanceof Number) {
                    jg.writeObjectField(realKey, field.getValue());
                    continue;
                }
                if (field.getValue() == null) {
                    jg.writeNullField(realKey);
                    continue;
                }
                jg.writeStringField(realKey, field.getValue().toString());
            }
            jg.writeEndObject();
        }
        return out.toByteArray();
    }
}

