/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.BuildSettingsHolder;
import grails.util.Environment;
import grails.util.Holders;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.plugins.GrailsPluginInfo;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.web.pages.FastStringWriter;
import org.codehaus.groovy.grails.web.pages.GSPWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPageConfig;
import org.codehaus.groovy.grails.web.pages.GroovyPageExpressionParser;
import org.codehaus.groovy.grails.web.pages.GroovyPageScanner;
import org.codehaus.groovy.grails.web.pages.SitemeshPreprocessor;
import org.codehaus.groovy.grails.web.pages.Tokens;
import org.codehaus.groovy.grails.web.taglib.GrailsTagRegistry;
import org.codehaus.groovy.grails.web.taglib.GroovySyntaxTag;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;
import org.codehaus.groovy.grails.web.util.StreamByteBuffer;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;

public class GroovyPageParser
implements Tokens {
    public static final Log LOG = LogFactory.getLog(GroovyPageParser.class);
    private static final Pattern PARA_BREAK = Pattern.compile("/p>\\s*<p[^>]*>", 2);
    private static final Pattern ROW_BREAK = Pattern.compile("((/td>\\s*</tr>\\s*<)?tr[^>]*>\\s*<)?td[^>]*>", 2);
    private static final Pattern PAGE_DIRECTIVE_PATTERN = Pattern.compile("(\\w+)\\s*=\\s*\"([^\"]*)\"");
    private static final String TAGLIB_DIRECTIVE = "taglib";
    private static final Pattern PRESCAN_PAGE_DIRECTIVE_PATTERN = Pattern.compile("<%@\\s*(?!taglib )(.*?)\\s*%>", 32);
    private static final Pattern PRESCAN_COMMENT_PATTERN = Pattern.compile("<%--.*?%>", 32);
    public static final String CONSTANT_NAME_JSP_TAGS = "JSP_TAGS";
    public static final String CONSTANT_NAME_CONTENT_TYPE = "CONTENT_TYPE";
    public static final String CONSTANT_NAME_LAST_MODIFIED = "LAST_MODIFIED";
    public static final String CONSTANT_NAME_EXPRESSION_CODEC = "EXPRESSION_CODEC";
    public static final String CONSTANT_NAME_STATIC_CODEC = "STATIC_CODEC";
    public static final String CONSTANT_NAME_OUT_CODEC = "OUT_CODEC";
    public static final String CONSTANT_NAME_TAGLIB_CODEC = "TAGLIB_CODEC";
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final String MULTILINE_GROOVY_STRING_DOUBLEQUOTES = "\"\"\"";
    private static final String MULTILINE_GROOVY_STRING_SINGLEQUOTES = "'''";
    private GroovyPageScanner scan;
    private GSPWriter out;
    private String className;
    private String packageName;
    private String sourceName;
    private boolean finalPass = false;
    private int tagIndex;
    private Map<Object, Object> tagContext;
    private Stack<TagMeta> tagMetaStack = new Stack();
    private GrailsTagRegistry tagRegistry = GrailsTagRegistry.getInstance();
    private Environment environment;
    private List<String> htmlParts = new ArrayList<String>();
    private static SitemeshPreprocessor sitemeshPreprocessor = new SitemeshPreprocessor();
    Set<Integer> bodyVarsDefined = new HashSet<Integer>();
    Map<Integer, String> attrsVarsMapDefinition = new HashMap<Integer, String>();
    int closureLevel = 0;
    private boolean currentlyBufferingWhitespace;
    private boolean previousContentWasNonWhitespace;
    private StringBuffer whitespaceBuffer = new StringBuffer();
    private String contentType = "text/html;charset=UTF-8";
    private boolean doNextScan = true;
    private int state;
    private static final String DEFAULT_CONTENT_TYPE = "text/html;charset=UTF-8";
    private int constantCount = 0;
    private Map<String, Integer> constantsToNumbers = new HashMap<String, Integer>();
    private final String pageName;
    public static final String[] DEFAULT_IMPORTS = new String[]{"org.codehaus.groovy.grails.plugins.metadata.GrailsPlugin", "org.codehaus.groovy.grails.web.pages.GroovyPage", "org.codehaus.groovy.grails.web.taglib.*", "org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException", "org.springframework.web.util.*", "grails.util.GrailsUtil"};
    public static final String CONFIG_PROPERTY_DEFAULT_CODEC = "grails.views.default.codec";
    public static final String CONFIG_PROPERTY_GSP_ENCODING = "grails.views.gsp.encoding";
    public static final String CONFIG_PROPERTY_GSP_KEEPGENERATED_DIR = "grails.views.gsp.keepgenerateddir";
    public static final String CONFIG_PROPERTY_GSP_SITEMESH_PREPROCESS = "grails.views.gsp.sitemesh.preprocess";
    public static final String CONFIG_PROPERTY_GSP_CODECS = "grails.views.gsp.codecs";
    private static final String IMPORT_DIRECTIVE = "import";
    private static final String CONTENT_TYPE_DIRECTIVE = "contentType";
    public static final String CODEC_DIRECTIVE_POSTFIX = "Codec";
    private static final String EXPRESSION_CODEC_DIRECTIVE = "expressionCodec";
    private static final String EXPRESSION_CODEC_DIRECTIVE_ALIAS = "defaultCodec";
    private static final String STATIC_CODEC_DIRECTIVE = "staticpartsCodec";
    private static final String OUT_CODEC_DIRECTIVE = "scriptletCodec";
    private static final String TAGLIB_CODEC_DIRECTIVE = "taglibCodec";
    private static final String SITEMESH_PREPROCESS_DIRECTIVE = "sitemeshPreprocess";
    private String gspEncoding = System.getProperty("file.encoding", "us-ascii");
    private String pluginAnnotation;
    public static final String GROOVY_SOURCE_CHAR_ENCODING = "UTF-8";
    private Map<String, String> jspTags = new HashMap<String, String>();
    private long lastModified;
    private boolean precompileMode;
    private boolean sitemeshPreprocessMode = false;
    private String expressionCodecDirectiveValue;
    private String outCodecDirectiveValue;
    private String staticCodecDirectiveValue;
    private String taglibCodecDirectiveValue;
    private boolean enableSitemeshPreprocessing = true;
    private File keepGeneratedDirectory;

    public String getContentType() {
        return this.contentType;
    }

    public int getCurrentOutputLineNumber() {
        return this.scan.getLineNumberForToken();
    }

    public Map<String, String> getJspTags() {
        return this.jspTags;
    }

    public void setKeepGeneratedDirectory(File keepGeneratedDirectory) {
        this.keepGeneratedDirectory = keepGeneratedDirectory;
    }

    public void setEnableSitemeshPreprocessing(boolean enableSitemeshPreprocessing) {
        this.enableSitemeshPreprocessing = enableSitemeshPreprocessing;
    }

    public GroovyPageParser(String name, String uri, String filename, InputStream in, String encoding, String expressionCodecName) throws IOException {
        Object sitemeshPreprocessEnabled;
        Object gspEnc;
        Map config = Holders.getFlatConfig();
        this.gspEncoding = encoding;
        if (this.gspEncoding == null && config != null && (gspEnc = config.get(CONFIG_PROPERTY_GSP_ENCODING)) != null && gspEnc.toString().trim().length() > 0) {
            this.gspEncoding = gspEnc.toString();
        }
        if (config != null && (sitemeshPreprocessEnabled = config.get(CONFIG_PROPERTY_GSP_SITEMESH_PREPROCESS)) != null) {
            boolean enableSitemeshPreprocessing = BooleanUtils.toBoolean((String)String.valueOf(sitemeshPreprocessEnabled).trim());
            this.setEnableSitemeshPreprocessing(enableSitemeshPreprocessing);
        }
        GrailsPluginInfo pluginInfo = null;
        if (filename != null && BuildSettingsHolder.getSettings() != null && (pluginInfo = GrailsPluginUtils.getPluginBuildSettings().getPluginInfoForSource(filename)) != null) {
            this.pluginAnnotation = "@GrailsPlugin(name='" + pluginInfo.getName() + "', version='" + pluginInfo.getVersion() + "')";
        }
        GroovyPageConfig gspConfig = new GroovyPageConfig(config);
        this.expressionCodecDirectiveValue = expressionCodecName;
        if (this.expressionCodecDirectiveValue == null) {
            this.expressionCodecDirectiveValue = gspConfig.getCodecSettings(pluginInfo, "expression");
        }
        this.staticCodecDirectiveValue = gspConfig.getCodecSettings(pluginInfo, "staticparts");
        this.outCodecDirectiveValue = gspConfig.getCodecSettings(pluginInfo, "scriptlet");
        this.taglibCodecDirectiveValue = gspConfig.getCodecSettings(pluginInfo, TAGLIB_DIRECTIVE);
        String gspSource = this.readStream(in);
        Map<String, String> directives = this.parseDirectives(gspSource);
        if (this.isSitemeshPreprocessingEnabled(directives.get(SITEMESH_PREPROCESS_DIRECTIVE))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Preprocessing " + uri + " for sitemesh. Replacing head, title, meta and body elements with sitemesh:capture*."));
            }
            gspSource = sitemeshPreprocessor.addGspSitemeshCapturing(gspSource);
            this.sitemeshPreprocessMode = true;
        }
        this.scan = new GroovyPageScanner(gspSource, uri);
        this.pageName = uri;
        this.environment = Environment.getCurrent();
        this.makeName(name);
        this.makeSourceName(filename);
    }

    public GroovyPageParser(String name, String uri, String filename, InputStream in) throws IOException {
        this(name, uri, filename, in, null, null);
    }

    public void setGspEncoding(String gspEncoding) {
        this.gspEncoding = gspEncoding;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GSP file encoding set to: " + gspEncoding));
        }
    }

    private Map<String, String> parseDirectives(String gspSource) {
        HashMap<String, String> result = new HashMap<String, String>();
        String input = PRESCAN_COMMENT_PATTERN.matcher(gspSource).replaceAll("");
        Matcher m = PRESCAN_PAGE_DIRECTIVE_PATTERN.matcher(input);
        if (m.find()) {
            Matcher mat = PAGE_DIRECTIVE_PATTERN.matcher(m.group(1));
            while (mat.find()) {
                String name = mat.group(1);
                String value = mat.group(2);
                result.put(name, value);
            }
        }
        return result;
    }

    private boolean isSitemeshPreprocessingEnabled(String gspFilePreprocessDirective) {
        if (gspFilePreprocessDirective != null) {
            return BooleanUtils.toBoolean((String)gspFilePreprocessDirective.trim());
        }
        return this.enableSitemeshPreprocessing;
    }

    public int[] getLineNumberMatrix() {
        return this.out.getLineNumbers();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream parse() {
        this.resolveKeepGeneratedDirectory();
        StreamCharBuffer streamBuffer = new StreamCharBuffer(1024);
        StreamByteBuffer byteOutputBuffer = new StreamByteBuffer(1024, StreamByteBuffer.ReadMode.RETAIN_AFTER_READING);
        try {
            streamBuffer.connectTo(new OutputStreamWriter(byteOutputBuffer.getOutputStream(), "UTF-8"), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Grails cannot run unless your environment supports UTF-8!");
        }
        File keepGeneratedFile = null;
        OutputStreamWriter keepGeneratedWriter = null;
        if (this.keepGeneratedDirectory != null) {
            keepGeneratedFile = new File(this.keepGeneratedDirectory, this.className);
            try {
                keepGeneratedWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(keepGeneratedFile), "UTF-8");
            }
            catch (IOException e) {
                LOG.warn((Object)("Cannot open keepgenerated file for writing. File's absolute path is '" + keepGeneratedFile.getAbsolutePath() + "'"));
                keepGeneratedFile = null;
            }
            streamBuffer.connectTo(keepGeneratedWriter, true);
        }
        Writer target = streamBuffer.getWriter();
        try {
            this.generateGsp(target, false);
            if (LOG.isDebugEnabled()) {
                if (keepGeneratedFile != null) {
                    LOG.debug((Object)("Compiled GSP into Groovy code. Source is in " + keepGeneratedFile));
                } else {
                    LOG.debug((Object)"Configure grails.views.gsp.keepgenerateddir property to view generated source.");
                }
            }
            InputStream inputStream = byteOutputBuffer.getInputStream();
            return inputStream;
        }
        finally {
            IOUtils.closeQuietly(keepGeneratedWriter);
        }
    }

    private void resolveKeepGeneratedDirectory() {
        if (this.keepGeneratedDirectory != null && !this.keepGeneratedDirectory.isDirectory()) {
            LOG.warn((Object)("The directory specified with grails.views.gsp.keepgenerateddir config parameter doesn't exist or isn't a readable directory. Absolute path: '" + this.keepGeneratedDirectory.getAbsolutePath() + "' Keepgenerated will be disabled."));
            this.keepGeneratedDirectory = null;
        }
    }

    public void generateGsp(Writer target) {
        this.generateGsp(target, true);
    }

    public void generateGsp(Writer target, boolean precompileMode) {
        this.precompileMode = precompileMode;
        this.out = new GSPWriter(target, this);
        if (this.packageName != null && this.packageName.length() > 0) {
            this.out.println("package " + this.packageName);
            this.out.println();
        }
        this.page();
        this.finalPass = true;
        this.scan.reset();
        this.previousContentWasNonWhitespace = false;
        this.currentlyBufferingWhitespace = false;
        this.page();
        this.out.flush();
        this.scan = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHtmlParts(File filename) throws IOException {
        DataOutputStream dataOut = null;
        try {
            dataOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
            dataOut.writeInt(this.htmlParts.size());
            for (String part : this.htmlParts) {
                dataOut.writeUTF(part);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dataOut);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)dataOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLineNumbers(File filename) throws IOException {
        DataOutputStream dataOut = null;
        try {
            dataOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
            int lineNumbersCount = this.out.getCurrentLineNumber() - 1;
            int[] lineNumbers = this.out.getLineNumbers();
            dataOut.writeInt(lineNumbersCount);
            for (int i = 0; i < lineNumbersCount; ++i) {
                dataOut.writeInt(lineNumbers[i]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dataOut);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)dataOut);
    }

    private void declare(boolean gsp) {
        if (this.finalPass) {
            return;
        }
        LOG.debug((Object)"parse: declare");
        this.out.println();
        this.write(this.scan.getToken().trim(), gsp);
        this.out.println();
        this.out.println();
    }

    private void direct() {
        if (this.finalPass) {
            return;
        }
        LOG.debug((Object)"parse: direct");
        String text = this.scan.getToken();
        text = text.trim();
        if (text.startsWith(TAGLIB_DIRECTIVE)) {
            this.directJspTagLib(text);
        } else {
            this.directPage(text);
        }
    }

    private void directPage(String text) {
        text = text.trim();
        Matcher mat = PAGE_DIRECTIVE_PATTERN.matcher(text);
        int ix = 0;
        while (mat.find(ix)) {
            String name = mat.group(1);
            String value = mat.group(2);
            if (name.equals(IMPORT_DIRECTIVE)) {
                this.pageImport(value);
            }
            if (name.equalsIgnoreCase(CONTENT_TYPE_DIRECTIVE)) {
                this.contentType(value);
            }
            if (name.equalsIgnoreCase(EXPRESSION_CODEC_DIRECTIVE)) {
                this.expressionCodecDirectiveValue = value.trim();
            }
            if (name.equalsIgnoreCase(EXPRESSION_CODEC_DIRECTIVE_ALIAS)) {
                this.expressionCodecDirectiveValue = value.trim();
            }
            if (name.equalsIgnoreCase(STATIC_CODEC_DIRECTIVE)) {
                this.staticCodecDirectiveValue = value.trim();
            }
            if (name.equalsIgnoreCase(OUT_CODEC_DIRECTIVE)) {
                this.outCodecDirectiveValue = value.trim();
            }
            if (name.equalsIgnoreCase(TAGLIB_CODEC_DIRECTIVE)) {
                this.taglibCodecDirectiveValue = value.trim();
            }
            ix = mat.end();
        }
        return;
    }

    private void directJspTagLib(String text) {
        text = text.substring(TAGLIB_DIRECTIVE.length() + 1, text.length());
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        this.populateMapWithAttributes(attrs, text);
        String prefix = (String)attrs.get("\"prefix\"");
        String uri = (String)attrs.get("\"uri\"");
        if (uri != null && prefix != null) {
            String namespace = prefix.substring(1, prefix.length() - 1);
            if (!"g".equals(namespace)) {
                this.jspTags.put(namespace, uri.substring(1, uri.length() - 1));
            } else {
                LOG.error((Object)"You cannot override the default 'g' namespace with the directive <%@ taglib prefix=\"g\" %>. Please select another namespace.");
            }
        }
    }

    private void contentType(String value) {
        this.contentType = value;
    }

    private void scriptletExpr() {
        if (!this.finalPass) {
            return;
        }
        LOG.debug((Object)"parse: expr");
        String text = this.scan.getToken().trim();
        this.out.printlnToResponse(text);
    }

    private void expr() {
        if (!this.finalPass) {
            return;
        }
        LOG.debug((Object)"parse: expr");
        String text = this.scan.getToken().trim();
        text = this.getExpressionText(text);
        if (text != null && text.length() > 2 && text.startsWith("(") && text.endsWith(")")) {
            this.out.printlnToResponse("expressionOut", text.substring(1, text.length() - 1));
        } else {
            this.out.printlnToResponse("expressionOut", text);
        }
    }

    public String getExpressionText(String text) {
        return this.getExpressionText(text, true);
    }

    public String getExpressionText(String text, boolean _safeDereference) {
        boolean safeDereference = false;
        if (text.endsWith("?")) {
            text = text.substring(0, text.length() - 1);
            safeDereference = _safeDereference;
        }
        if (!(this.precompileMode || this.environment != Environment.DEVELOPMENT && this.environment != Environment.TEST)) {
            String escaped = this.escapeGroovy(text);
            text = "evaluate('" + escaped + "', " + this.getCurrentOutputLineNumber() + ", it) { return " + text + " }" + (safeDereference ? "?" : "");
        } else {
            text = "(" + text + ")" + (safeDereference ? "?" : "");
        }
        return text;
    }

    private String escapeGroovy(String text) {
        return text.replace("\\", "\\\\").replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r");
    }

    private void bufferedPrintlnToResponse(String s) {
        if (this.currentlyBufferingWhitespace) {
            this.whitespaceBuffer.append(s);
        } else {
            this.flushTagBuffering();
            this.out.printlnToResponse(s);
        }
    }

    private void htmlPartPrintlnToResponse(int partNumber) {
        if (!this.tagMetaStack.isEmpty()) {
            TagMeta tm = this.tagMetaStack.peek();
            if (tm.bufferMode && tm.bufferPartNumber == -1) {
                tm.bufferPartNumber = partNumber;
                return;
            }
        }
        this.flushTagBuffering();
        this.htmlPartPrintlnRaw(partNumber);
    }

    private void htmlPartPrintlnRaw(int partNumber) {
        this.out.print("printHtmlPart(");
        this.out.print(String.valueOf(partNumber));
        this.out.print(")");
        this.out.println();
    }

    public void flushTagBuffering() {
        if (!this.tagMetaStack.isEmpty()) {
            TagMeta tm = this.tagMetaStack.peek();
            if (tm.bufferMode) {
                this.writeTagBodyStart(tm);
                if (tm.bufferPartNumber != -1) {
                    this.htmlPartPrintlnRaw(tm.bufferPartNumber);
                }
                tm.bufferMode = false;
            }
        }
    }

    private void html() {
        boolean contentIsWhitespace;
        if (!this.finalPass) {
            return;
        }
        LOG.debug((Object)"parse: html");
        String text = this.scan.getToken();
        if (text.length() == 0) {
            return;
        }
        boolean bl = contentIsWhitespace = !Pattern.compile("\\S").matcher(text).find();
        if (!contentIsWhitespace && this.currentlyBufferingWhitespace) {
            this.flushBufferedWhiteSpace();
        } else {
            this.currentlyBufferingWhitespace = contentIsWhitespace;
        }
        boolean bl2 = this.previousContentWasNonWhitespace = !contentIsWhitespace;
        if (this.currentlyBufferingWhitespace) {
            this.whitespaceBuffer.append(text);
        } else {
            this.appendHtmlPart(text);
        }
    }

    private void appendHtmlPart(String text) {
        Integer constantNumber;
        if (this.whitespaceBuffer.length() > 0) {
            if (text != null) {
                this.whitespaceBuffer.append(text);
            }
            text = this.whitespaceBuffer.toString();
            this.clearBufferedWhiteSpace();
        }
        if ((constantNumber = this.constantsToNumbers.get(text)) == null) {
            constantNumber = this.constantCount++;
            this.constantsToNumbers.put(text, constantNumber);
            this.htmlParts.add(text);
        }
        this.htmlPartPrintlnToResponse(constantNumber);
    }

    private void makeName(String uri) {
        String name;
        int slash = uri.lastIndexOf(47);
        if (slash > -1) {
            name = uri.substring(slash + 1);
            uri = uri.substring(0, uri.length() - 1 - name.length());
            while (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            slash = uri.lastIndexOf(47);
            if (slash > -1) {
                name = uri.substring(slash + 1) + '_' + name;
            }
        } else {
            name = uri;
        }
        StringBuilder buf = new StringBuilder(name.length());
        int ixz = name.length();
        for (int ix = 0; ix < ixz; ++ix) {
            int c = name.charAt(ix);
            if (c < 48 || c > 57 && c < 64 || c > 90 && c < 95 || c > 95 && c < 97 || c > 122) {
                c = 95;
            } else if (ix == 0 && c >= 48 && c <= 57) {
                c = 95;
            }
            buf.append((char)c);
        }
        this.className = buf.toString();
    }

    private void makeSourceName(String filename) {
        if (filename != null) {
            int lastSegmentStart = filename.lastIndexOf(47);
            if (lastSegmentStart == -1) {
                lastSegmentStart = filename.lastIndexOf(92);
            }
            this.sourceName = filename.substring(lastSegmentStart + 1);
        } else {
            this.sourceName = this.className;
        }
    }

    private static boolean match(CharSequence pat, CharSequence text, int start) {
        int ixy;
        int ix = start;
        int ixz = text.length();
        if (ixz > (ixy = start + pat.length())) {
            ixz = ixy;
        }
        if (pat.length() > ixz - start) {
            return false;
        }
        while (ix < ixz) {
            if (Character.toLowerCase(text.charAt(ix)) != Character.toLowerCase(pat.charAt(ix - start))) {
                return false;
            }
            ++ix;
        }
        return true;
    }

    private static int match(Pattern pat, CharSequence text, int start) {
        Matcher mat = pat.matcher(text);
        if (mat.find(start) && mat.start() == start) {
            return mat.end();
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void page() {
        LOG.debug((Object)"parse: page");
        if (this.finalPass) {
            this.out.println();
            if (this.pluginAnnotation != null) {
                this.out.println(this.pluginAnnotation);
            }
            this.out.print("class ");
            this.out.print(this.className);
            this.out.println(" extends GroovyPage {");
            this.out.println("public String getGroovyPageFileName() { \"" + this.pageName.replaceAll("\\\\", "/") + "\" }");
            this.out.println("public Object run() {");
            this.out.println("Writer out = getOut()");
            this.out.println("Writer expressionOut = getExpressionOut()");
            if (this.sitemeshPreprocessMode) {
                this.out.println("registerSitemeshPreprocessMode()");
            }
        }
        block14: while (true) {
            if (this.doNextScan) {
                this.state = this.scan.nextToken();
            } else {
                this.doNextScan = true;
            }
            if (this.state != 15 && this.state != 0) {
                this.flushBufferedWhiteSpace();
                this.previousContentWasNonWhitespace = false;
            }
            switch (this.state) {
                case -1: {
                    break block14;
                }
                case 0: {
                    this.html();
                    break;
                }
                case 1: {
                    this.scriptletExpr();
                    break;
                }
                case 2: {
                    this.script(false);
                    break;
                }
                case 3: {
                    this.direct();
                    break;
                }
                case 4: {
                    this.declare(false);
                    break;
                }
                case 11: {
                    this.expr();
                    break;
                }
                case 12: {
                    this.script(true);
                    break;
                }
                case 13: {
                    this.direct();
                    break;
                }
                case 14: {
                    this.declare(true);
                    break;
                }
                case 15: {
                    this.startTag();
                    break;
                }
                case 16: 
                case 18: {
                    this.endTag();
                }
            }
        }
        if (this.finalPass) {
            if (!this.tagMetaStack.isEmpty()) {
                throw new GrailsTagException("Grails tags were not closed! [" + this.tagMetaStack + "] in GSP " + this.pageName + "", this.pageName, this.getCurrentOutputLineNumber());
            }
            this.out.println("}");
            this.out.println("public static final Map JSP_TAGS = new HashMap()");
            if (this.jspTags != null && this.jspTags.size() > 0) {
                this.out.println("static {");
                for (Map.Entry<String, String> entry : this.jspTags.entrySet()) {
                    this.out.print("\tJSP_TAGS.put('");
                    this.out.print(this.escapeGroovy(entry.getKey()));
                    this.out.print("','");
                    this.out.print(this.escapeGroovy(entry.getValue()));
                    this.out.println("')");
                }
                this.out.println("}");
            }
            this.out.println("protected void init() {");
            this.out.println("\tthis.jspTags = JSP_TAGS");
            this.out.println("}");
            this.out.println("public static final String CONTENT_TYPE = '" + this.escapeGroovy(this.contentType) + "'");
            this.out.println("public static final long LAST_MODIFIED = " + this.lastModified + "L");
            this.out.println("public static final String EXPRESSION_CODEC = '" + this.escapeGroovy(this.expressionCodecDirectiveValue) + "'");
            this.out.println("public static final String STATIC_CODEC = '" + this.escapeGroovy(this.staticCodecDirectiveValue) + "'");
            this.out.println("public static final String OUT_CODEC = '" + this.escapeGroovy(this.outCodecDirectiveValue) + "'");
            this.out.println("public static final String TAGLIB_CODEC = '" + this.escapeGroovy(this.taglibCodecDirectiveValue) + "'");
            this.out.println("}");
            if (!this.shouldAddLineNumbers()) return;
            this.addLineNumbers();
            return;
        }
        int i = 0;
        while (i < DEFAULT_IMPORTS.length) {
            this.out.print("import ");
            this.out.println(DEFAULT_IMPORTS[i]);
            ++i;
        }
    }

    private boolean shouldAddLineNumbers() {
        try {
            return Boolean.valueOf(System.getenv("GROOVY_PAGE_ADD_LINE_NUMBERS"));
        }
        catch (Exception e) {
            return false;
        }
    }

    private void addLineNumbers() {
        this.out.println();
        this.out.println("@org.codehaus.groovy.grails.web.transform.LineNumber(");
        this.out.print("\tlines = [");
        int[] lineNumbers = this.filterTrailing0s(this.out.getLineNumbers());
        for (int i = 0; i < lineNumbers.length; ++i) {
            this.out.print(lineNumbers[i]);
            if (i >= lineNumbers.length - 1) continue;
            this.out.print(", ");
        }
        this.out.println("],");
        this.out.println("\tsourceName = \"" + this.sourceName + "\"");
        this.out.println(")");
        this.out.println("class ___LineNumberPlaceholder { }");
    }

    private int[] filterTrailing0s(int[] lineNumbers) {
        int startLocation = lineNumbers.length - 1;
        for (int i = lineNumbers.length - 1; i >= 0; --i) {
            if (lineNumbers[i] <= 0) continue;
            startLocation = i + 1;
            break;
        }
        int[] newLineNumbers = new int[startLocation];
        System.arraycopy(lineNumbers, 0, newLineNumbers, 0, startLocation);
        return newLineNumbers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void endTag() {
        if (!this.finalPass) {
            return;
        }
        String tagName = this.scan.getToken().trim();
        String ns = this.scan.getNamespace();
        if (this.tagMetaStack.isEmpty()) {
            throw new GrailsTagException("Found closing Grails tag with no opening [" + tagName + "]", this.pageName, this.getCurrentOutputLineNumber());
        }
        TagMeta tm = this.tagMetaStack.pop();
        String lastInStack = tm.name;
        String lastNamespaceInStack = tm.namespace;
        if (StringUtils.isBlank((String)tagName)) {
            tagName = lastInStack;
        }
        if (!lastInStack.equals(tagName) || !lastNamespaceInStack.equals(ns)) {
            throw new GrailsTagException("Grails tag [" + lastNamespaceInStack + ":" + lastInStack + "] was not closed", this.pageName, this.getCurrentOutputLineNumber());
        }
        if ("g".equals(ns) && this.tagRegistry.isSyntaxTag(tagName)) {
            if (!(tm.instance instanceof GroovySyntaxTag)) throw new GrailsTagException("Grails tag [" + tagName + "] was not closed", this.pageName, this.getCurrentOutputLineNumber());
            GroovySyntaxTag tag = (GroovySyntaxTag)tm.instance;
            tag.doEndTag();
        } else {
            int bodyTagIndex = -1;
            if (!tm.emptyTag && !tm.bufferMode) {
                bodyTagIndex = this.tagIndex;
                this.out.println("})");
                --this.closureLevel;
            }
            if (tm.bufferMode && tm.bufferPartNumber != -1) {
                if (!this.bodyVarsDefined.contains(tm.tagIndex)) {
                    this.bodyVarsDefined.add(tm.tagIndex);
                }
                this.out.println("createClosureForHtmlPart(" + tm.bufferPartNumber + ", " + tm.tagIndex + ")");
                bodyTagIndex = tm.tagIndex;
                tm.bufferMode = false;
            }
            if (this.jspTags.containsKey(ns)) {
                String uri = this.jspTags.get(ns);
                this.out.println("jspTag = getJspTag('" + uri + "', '" + tagName + "')");
                this.out.println("if (!jspTag) throw new GrailsTagException('Unknown JSP tag " + ns + ":" + tagName + "')");
                this.out.print("jspTag.doTag(out," + this.attrsVarsMapDefinition.get(this.tagIndex) + ",");
                if (bodyTagIndex > -1) {
                    this.out.print("getBodyClosure(" + bodyTagIndex + ")");
                } else {
                    this.out.print("null");
                }
                this.out.println(")");
            } else if (tm.hasAttributes) {
                this.out.println("invokeTag('" + tagName + "','" + ns + "'," + this.getCurrentOutputLineNumber() + "," + this.attrsVarsMapDefinition.get(this.tagIndex) + "," + bodyTagIndex + ")");
            } else {
                this.out.println("invokeTag('" + tagName + "','" + ns + "'," + this.getCurrentOutputLineNumber() + ",[:]," + bodyTagIndex + ")");
            }
        }
        tm.bufferMode = false;
        --this.tagIndex;
    }

    private void startTag() {
        String tagName;
        if (!this.finalPass) {
            return;
        }
        ++this.tagIndex;
        StringBuilder buf = new StringBuilder(this.scan.getToken());
        String ns = this.scan.getNamespace();
        boolean emptyTag = false;
        this.state = this.scan.nextToken();
        while (this.state != 0 && this.state != 16 && this.state != 18 && this.state != -1) {
            if (this.state == 17) {
                buf.append("${");
                buf.append(this.scan.getToken().trim());
                buf.append("}");
            } else {
                buf.append(this.scan.getToken());
            }
            this.state = this.scan.nextToken();
        }
        if (this.state == 18) {
            emptyTag = true;
        }
        this.doNextScan = false;
        String text = buf.toString();
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        Matcher m = Pattern.compile("\\s").matcher(text);
        if (m.find()) {
            tagName = text.substring(0, m.start());
            if (this.state != -1) {
                String attrTokens = text.substring(m.start(), text.length());
                this.populateMapWithAttributes(attrs, attrTokens);
            }
        } else {
            tagName = text;
        }
        if (this.state == -1) {
            throw new GrailsTagException("Unexpected end of file encountered parsing Tag [" + tagName + "] for " + this.className + ". Are you missing a closing brace '}'?", this.pageName, this.getCurrentOutputLineNumber());
        }
        this.flushTagBuffering();
        TagMeta tm = new TagMeta();
        tm.name = tagName;
        tm.namespace = ns;
        tm.hasAttributes = !attrs.isEmpty();
        tm.lineNumber = this.getCurrentOutputLineNumber();
        tm.emptyTag = emptyTag;
        tm.tagIndex = this.tagIndex;
        this.tagMetaStack.push(tm);
        if ("g".equals(ns) && this.tagRegistry.isSyntaxTag(tagName)) {
            if (this.tagContext == null) {
                this.tagContext = new HashMap<Object, Object>();
                this.tagContext.put("out", this.out);
                this.tagContext.put(GroovyPageParser.class, this);
            }
            GroovySyntaxTag tag = (GroovySyntaxTag)this.tagRegistry.newTag(tagName);
            tag.init(this.tagContext);
            tag.setAttributes(attrs);
            if (tag.isKeepPrecedingWhiteSpace() && this.currentlyBufferingWhitespace) {
                this.flushBufferedWhiteSpace();
            } else {
                if (!tag.isAllowPrecedingContent() && this.previousContentWasNonWhitespace) {
                    throw new GrailsTagException("Tag [" + tag.getName() + "] cannot have non-whitespace characters directly preceding it.", this.pageName, this.getCurrentOutputLineNumber());
                }
                this.clearBufferedWhiteSpace();
            }
            tag.doStartTag();
            tm.instance = tag;
        } else {
            this.flushBufferedWhiteSpace();
            if (attrs.size() > 0) {
                FastStringWriter buffer = new FastStringWriter();
                buffer.print("[");
                Iterator i = attrs.keySet().iterator();
                while (i.hasNext()) {
                    String name;
                    String cleanedName = name = (String)i.next();
                    if (name.startsWith("\"") && name.endsWith("\"")) {
                        cleanedName = "'" + name.substring(1, name.length() - 1) + "'";
                    }
                    buffer.print(cleanedName);
                    buffer.print(':');
                    buffer.print(this.getExpressionText(attrs.get(name).toString()));
                    if (i.hasNext()) {
                        buffer.print(',');
                        continue;
                    }
                    buffer.print("]");
                }
                this.attrsVarsMapDefinition.put(this.tagIndex, buffer.toString());
                buffer.close();
            }
            if (!emptyTag) {
                tm.bufferMode = true;
            }
        }
    }

    private void writeTagBodyStart(TagMeta tm) {
        if (tm.bufferMode) {
            tm.bufferMode = false;
            if (!this.bodyVarsDefined.contains(tm.tagIndex)) {
                this.bodyVarsDefined.add(tm.tagIndex);
            }
            this.out.println("createTagBody(" + tm.tagIndex + ", {->");
            ++this.closureLevel;
        }
    }

    private void clearBufferedWhiteSpace() {
        this.whitespaceBuffer.delete(0, this.whitespaceBuffer.length());
        this.currentlyBufferingWhitespace = false;
    }

    private void flushBufferedWhiteSpace() {
        if (this.currentlyBufferingWhitespace) {
            this.appendHtmlPart(null);
        }
        this.currentlyBufferingWhitespace = false;
    }

    private void populateMapWithAttributes(Map<String, String> attrs, String attrTokens) {
        attrTokens = attrTokens.trim();
        int startPos = 0;
        while (startPos < attrTokens.length()) {
            int equalsignPos = attrTokens.indexOf(61, startPos);
            if (equalsignPos == -1) {
                throw new GrailsTagException("Expecting '=' after attribute name (" + attrTokens + ").", this.pageName, this.getCurrentOutputLineNumber());
            }
            String name = attrTokens.substring(startPos, equalsignPos).trim();
            startPos = equalsignPos + 1;
            char ch = attrTokens.charAt(startPos++);
            while (Character.isWhitespace(ch) && startPos < attrTokens.length()) {
                ch = attrTokens.charAt(startPos++);
            }
            if (ch != '\'' && ch != '\"') {
                throw new GrailsTagException("Attribute value must be quoted (" + attrTokens + ").", this.pageName, this.getCurrentOutputLineNumber());
            }
            char quoteChar = ch;
            GroovyPageExpressionParser expressionParser = new GroovyPageExpressionParser(attrTokens, startPos, quoteChar, '\u0000', false);
            int endQuotepos = expressionParser.parse();
            if (endQuotepos == -1) {
                throw new GrailsTagException("Attribute value quote wasn't closed (" + attrTokens + ").", this.pageName, this.getCurrentOutputLineNumber());
            }
            String val = attrTokens.substring(startPos, endQuotepos);
            if (val.startsWith("${") && val.endsWith("}") && !expressionParser.isContainsGstrings()) {
                val = val.substring(2, val.length() - 1);
            } else if (!val.startsWith("[") || !val.endsWith("]")) {
                if (val.indexOf(34) == -1) {
                    quoteChar = '\"';
                }
                String quoteStr = val.indexOf(10) != -1 || val.indexOf(13) != -1 ? (quoteChar == '\"' ? MULTILINE_GROOVY_STRING_DOUBLEQUOTES : MULTILINE_GROOVY_STRING_SINGLEQUOTES) : String.valueOf(quoteChar);
                val = quoteStr + val + quoteStr;
            }
            attrs.put("\"" + name + "\"", val);
            startPos = endQuotepos + 1;
        }
    }

    private void pageImport(String value) {
        String[] imports = Pattern.compile(";").split(value.subSequence(0, value.length()));
        for (int ix = 0; ix < imports.length; ++ix) {
            this.out.print("import ");
            this.out.print(imports[ix]);
            this.out.println();
        }
    }

    private String readStream(InputStream in) throws IOException {
        return IOUtils.toString((InputStream)in, (String)this.gspEncoding);
    }

    private void script(boolean gsp) {
        this.flushTagBuffering();
        if (!this.finalPass) {
            return;
        }
        LOG.debug((Object)"parse: script");
        this.out.println();
        this.write(this.scan.getToken().trim(), gsp);
        this.out.println();
        this.out.println();
    }

    private void write(CharSequence text, boolean gsp) {
        if (!gsp) {
            this.out.print(text);
            return;
        }
        int ixz = text.length();
        for (int ix = 0; ix < ixz; ++ix) {
            char c = text.charAt(ix);
            String rep = null;
            if (Character.isWhitespace(c)) {
                ++ix;
                while (ix < ixz) {
                    if (!Character.isWhitespace(text.charAt(ix))) {
                        --ix;
                        rep = " ";
                        break;
                    }
                    ++ix;
                }
            } else if (c == '&') {
                if (GroovyPageParser.match("&semi;", text, ix)) {
                    rep = ";";
                    ix += 5;
                } else if (GroovyPageParser.match("&amp;", text, ix)) {
                    rep = "&";
                    ix += 4;
                } else if (GroovyPageParser.match("&lt;", text, ix)) {
                    rep = "<";
                    ix += 3;
                } else if (GroovyPageParser.match("&gt;", text, ix)) {
                    rep = ">";
                    ix += 3;
                }
            } else if (c == '<') {
                if (GroovyPageParser.match("<br>", text, ix) || GroovyPageParser.match("<hr>", text, ix)) {
                    rep = "\n";
                    ix += 3;
                } else {
                    int end = GroovyPageParser.match(PARA_BREAK, text, ix);
                    if (end <= 0) {
                        end = GroovyPageParser.match(ROW_BREAK, text, ix);
                    }
                    if (end > 0) {
                        rep = "\n";
                        ix = end;
                    }
                }
            }
            if (rep != null) {
                this.out.print(rep);
                continue;
            }
            this.out.print(c);
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public List<String> getHtmlParts() {
        return this.htmlParts;
    }

    public String[] getHtmlPartsArray() {
        return this.htmlParts.toArray(new String[this.htmlParts.size()]);
    }

    public boolean isInClosure() {
        return this.closureLevel > 0;
    }

    public String getExpressionCodecDirectiveValue() {
        return this.expressionCodecDirectiveValue;
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getOutCodecDirectiveValue() {
        return this.outCodecDirectiveValue;
    }

    public String getStaticCodecDirectiveValue() {
        return this.staticCodecDirectiveValue;
    }

    public String getTaglibCodecDirectiveValue() {
        return this.taglibCodecDirectiveValue;
    }

    public void setTaglibCodecDirectiveValue(String taglibCodecDirectiveValue) {
        this.taglibCodecDirectiveValue = taglibCodecDirectiveValue;
    }

    class TagMeta {
        String name;
        String namespace;
        Object instance;
        boolean isDynamic;
        boolean hasAttributes;
        int lineNumber;
        boolean emptyTag;
        int tagIndex;
        boolean bufferMode = false;
        int bufferPartNumber = -1;

        TagMeta() {
        }

        public String toString() {
            return "<" + this.namespace + ":" + this.name + ">";
        }
    }
}

