/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.view;

import grails.util.GrailsUtil;
import groovy.lang.GroovyObject;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.PluginManagerAware;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.pages.discovery.GrailsConventionGroovyPageLocator;
import org.codehaus.groovy.grails.web.pages.discovery.GroovyPageScriptSource;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.view.GroovyPageView;
import org.codehaus.groovy.grails.web.util.CacheEntry;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

public class GrailsViewResolver
extends InternalResourceViewResolver
implements PluginManagerAware,
GrailsApplicationAware {
    private static final Log LOG = LogFactory.getLog(GrailsViewResolver.class);
    public static final String GSP_SUFFIX = ".gsp";
    public static final String JSP_SUFFIX = ".jsp";
    protected GroovyPagesTemplateEngine templateEngine;
    protected GrailsConventionGroovyPageLocator groovyPageLocator;
    private Map<String, CacheEntry<View>> VIEW_CACHE = new ConcurrentHashMap<String, CacheEntry<View>>();
    private GrailsApplication grailsApplication;
    private boolean developmentMode = GrailsUtil.isDevelopmentEnv();
    private long cacheTimeout = -1L;

    public GrailsViewResolver() {
        this.setCache(false);
    }

    public void setGroovyPageLocator(GrailsConventionGroovyPageLocator groovyPageLocator) {
        this.groovyPageLocator = groovyPageLocator;
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        Assert.notNull((Object)((Object)this.templateEngine), (String)"Property [templateEngine] cannot be null");
        if (viewName.endsWith(GSP_SUFFIX)) {
            viewName = viewName.substring(0, viewName.length() - GSP_SUFFIX.length());
        }
        if (this.developmentMode) {
            return this.createGrailsView(viewName);
        }
        String viewCacheKey = GrailsConventionGroovyPageLocator.resolveViewFormat(viewName);
        CacheEntry<View> entry = this.VIEW_CACHE.get(viewCacheKey);
        final String lookupViewName = viewName;
        PrivilegedAction<View> updater = new PrivilegedAction<View>(){

            @Override
            public View run() {
                try {
                    return GrailsViewResolver.this.createGrailsView(lookupViewName);
                }
                catch (Exception e) {
                    throw new WrappedInitializationException(e);
                }
            }
        };
        View view = null;
        if (entry == null) {
            try {
                view = (View)updater.run();
            }
            catch (WrappedInitializationException e) {
                e.rethrow();
            }
            entry = new CacheEntry<View>(view);
            this.VIEW_CACHE.put(viewCacheKey, entry);
            return view;
        }
        try {
            view = entry.getValue(this.cacheTimeout, updater);
        }
        catch (WrappedInitializationException e) {
            e.rethrow();
        }
        return view;
    }

    private View createGrailsView(String viewName) throws Exception {
        GroovyPageScriptSource scriptSource;
        GrailsWebRequest webRequest = WebUtils.retrieveGrailsWebRequest();
        HttpServletRequest request = webRequest.getCurrentRequest();
        GroovyObject controller = webRequest.getAttributes().getController((ServletRequest)request);
        if (this.grailsApplication == null) {
            this.grailsApplication = (GrailsApplication)this.getApplicationContext().getBean("grailsApplication", GrailsApplication.class);
        }
        if ((scriptSource = controller == null ? this.groovyPageLocator.findViewByPath(viewName) : this.groovyPageLocator.findView(controller, viewName)) != null) {
            return this.createGroovyPageView(webRequest, scriptSource.getURI(), scriptSource);
        }
        return this.createJstlView(viewName);
    }

    private View createGroovyPageView(GrailsWebRequest webRequest, String gspView, ScriptSource scriptSource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolved GSP view at URI [" + gspView + "]"));
        }
        GroovyPageView gspSpringView = new GroovyPageView();
        gspSpringView.setServletContext(webRequest.getServletContext());
        gspSpringView.setUrl(gspView);
        gspSpringView.setApplicationContext(this.getApplicationContext());
        gspSpringView.setTemplateEngine(this.templateEngine);
        gspSpringView.setScriptSource(scriptSource);
        try {
            gspSpringView.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing GroovyPageView", e);
        }
        return gspSpringView;
    }

    private View createJstlView(String viewName) throws Exception {
        AbstractUrlBasedView view = this.buildView(viewName);
        view.setApplicationContext(this.getApplicationContext());
        view.afterPropertiesSet();
        return view;
    }

    public void setPluginManager(GrailsPluginManager pluginManager) {
    }

    public void setTemplateEngine(GroovyPagesTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public long getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(long cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    private static class WrappedInitializationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WrappedInitializationException(Throwable cause) {
            super(cause);
        }

        public void rethrow() throws Exception {
            if (this.getCause() instanceof Exception) {
                throw (Exception)this.getCause();
            }
            throw this;
        }
    }
}

