/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.support.encoding.EncodedAppender;
import org.codehaus.groovy.grails.support.encoding.EncodedAppenderFactory;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncoderAware;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.sitemesh.GrailsContentBufferingResponse;
import org.codehaus.groovy.grails.web.sitemesh.GrailsRoutablePrintWriter;
import org.codehaus.groovy.grails.web.util.BoundedCharsAsEncodedBytesCounter;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;

public class GSPResponseWriter
extends GrailsRoutablePrintWriter
implements EncoderAware,
EncodedAppenderFactory {
    protected static final Log LOG = LogFactory.getLog(GSPResponseWriter.class);
    private ServletResponse response;
    private BoundedCharsAsEncodedBytesCounter bytesCounter;
    public static final boolean CONTENT_LENGTH_COUNTING_ENABLED = Boolean.getBoolean("GSPResponseWriter.enableContentLength");
    public static final boolean BUFFERING_ENABLED = Boolean.valueOf(System.getProperty("GSPResponseWriter.enableBuffering", "true"));
    public static final boolean AUTOFLUSH_ENABLED = Boolean.getBoolean("GSPResponseWriter.enableAutoFlush");
    private static final int BUFFER_SIZE = Integer.getInteger("GSPResponseWriter.bufferSize", 8042);
    private Encoder encoder;
    private StreamCharBuffer buffer;

    public static GSPResponseWriter getInstance(ServletResponse response) {
        return GSPResponseWriter.getInstance(response, BUFFER_SIZE);
    }

    private static GSPResponseWriter getInstance(final ServletResponse response, final int max) {
        final BoundedCharsAsEncodedBytesCounter bytesCounter = new BoundedCharsAsEncodedBytesCounter();
        StreamCharBuffer streamBuffer = new StreamCharBuffer(max, 0, max);
        streamBuffer.setChunkMinSize(max / 2);
        streamBuffer.setNotifyParentBuffersEnabled(false);
        final StreamCharBuffer.LazyInitializingWriter lazyResponseWriter = new StreamCharBuffer.LazyInitializingWriter(){

            public Writer getWriter() throws IOException {
                return response.getWriter();
            }
        };
        if (!(response instanceof GrailsContentBufferingResponse)) {
            streamBuffer.connectTo(new StreamCharBuffer.LazyInitializingMultipleWriter(){

                public Writer getWriter() throws IOException {
                    return null;
                }

                public StreamCharBuffer.LazyInitializingWriter[] initializeMultiple(StreamCharBuffer buffer, boolean autoFlush) throws IOException {
                    StreamCharBuffer.LazyInitializingWriter[] lazyWriters = CONTENT_LENGTH_COUNTING_ENABLED ? new StreamCharBuffer.LazyInitializingWriter[]{new StreamCharBuffer.LazyInitializingWriter(){

                        public Writer getWriter() throws IOException {
                            bytesCounter.setCapacity(max * 2);
                            bytesCounter.setEncoding(response.getCharacterEncoding());
                            return bytesCounter.getCountingWriter();
                        }
                    }, lazyResponseWriter} : new StreamCharBuffer.LazyInitializingWriter[]{lazyResponseWriter};
                    return lazyWriters;
                }
            }, AUTOFLUSH_ENABLED);
        } else {
            streamBuffer.connectTo(lazyResponseWriter);
        }
        return new GSPResponseWriter(streamBuffer, response, bytesCounter);
    }

    private static GSPResponseWriter getInstance(Writer target, int max) {
        if (BUFFERING_ENABLED && !(target instanceof GrailsRoutablePrintWriter) && !(target instanceof StreamCharBuffer.StreamCharBufferWriter)) {
            StreamCharBuffer streamBuffer = new StreamCharBuffer(max, 0, max);
            streamBuffer.connectTo(target, false);
            Writer writer = streamBuffer.getWriter();
            return new GSPResponseWriter(writer);
        }
        return new GSPResponseWriter(target);
    }

    private GSPResponseWriter(final StreamCharBuffer buffer, ServletResponse response, BoundedCharsAsEncodedBytesCounter bytesCounter) {
        super((GrailsRoutablePrintWriter.DestinationFactory)null);
        GrailsRoutablePrintWriter.DestinationFactory lazyTargetFactory = new GrailsRoutablePrintWriter.DestinationFactory(){

            public Writer activateDestination() throws IOException {
                GrailsWebRequest webRequest = GrailsWebRequest.lookup();
                GSPResponseWriter.this.encoder = webRequest != null ? webRequest.lookupFilteringEncoder() : null;
                if (GSPResponseWriter.this.encoder != null) {
                    return buffer.getWriterForEncoder(GSPResponseWriter.this.encoder, webRequest.getEncodingStateRegistry());
                }
                return buffer.getWriter();
            }
        };
        this.updateDestination(lazyTargetFactory);
        this.response = response;
        this.bytesCounter = bytesCounter;
        this.setBlockFlush(false);
    }

    private GSPResponseWriter(final Writer activeWriter) {
        super((GrailsRoutablePrintWriter.DestinationFactory)null);
        this.updateDestination(new GrailsRoutablePrintWriter.DestinationFactory(){

            public Writer activateDestination() throws IOException {
                return activeWriter;
            }
        });
        this.setBlockFlush(false);
    }

    public void close() {
        GrailsWebRequest webRequest;
        this.flush();
        if (this.canFlushContentLengthAwareResponse()) {
            int size = this.bytesCounter.size();
            if (size > 0) {
                this.response.setContentLength(size);
            }
            this.flushResponse();
        } else if (!this.isTrouble() && (webRequest = GrailsWebRequest.lookup()) != null && webRequest.getCurrentRequest().getAttribute("__sitemesh__page") != null) {
            this.flushResponse();
        }
    }

    private boolean canFlushContentLengthAwareResponse() {
        return CONTENT_LENGTH_COUNTING_ENABLED && this.isDestinationActivated() && this.bytesCounter != null && this.bytesCounter.isWriterReferenced() && this.response != null && !this.response.isCommitted() && !this.isTrouble();
    }

    private void flushResponse() {
        try {
            if (this.isDestinationActivated()) {
                this.response.getWriter().flush();
            }
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    public boolean isAllowUnwrappingOut() {
        return false;
    }

    public Writer unwrap() {
        return this;
    }

    public EncodedAppender getEncodedAppender() {
        if (this.buffer != null) {
            return ((EncodedAppenderFactory)this.buffer.getWriter()).getEncodedAppender();
        }
        this.activateDestination();
        Writer target = this.getTarget().unwrap();
        if (target != this && target instanceof EncodedAppenderFactory) {
            return ((EncodedAppenderFactory)target).getEncodedAppender();
        }
        return null;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }
}

