/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheEntry<T> {
    protected AtomicReference<T> valueRef = new AtomicReference<Object>(null);
    protected long createdMillis;
    protected Lock writeLock = new ReentrantLock();

    public CacheEntry(T value) {
        this.valueRef.set(value);
        this.resetTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getValue(long timeout, PrivilegedAction<T> updater) {
        if (timeout < 0L || updater == null) {
            return this.valueRef.get();
        }
        if (this.hasExpired(timeout)) {
            try {
                long beforeLockingCreatedMillis = this.createdMillis;
                this.writeLock.lock();
                if (this.shouldUpdate(beforeLockingCreatedMillis)) {
                    this.valueRef.set(updater.run());
                    this.resetTimestamp();
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return this.valueRef.get();
    }

    public T getValue() {
        return this.valueRef.get();
    }

    protected boolean hasExpired(long timeout) {
        return System.currentTimeMillis() - timeout > this.createdMillis;
    }

    protected boolean shouldUpdate(long beforeLockingCreatedMillis) {
        return beforeLockingCreatedMillis == this.createdMillis || this.createdMillis == 0L;
    }

    protected void resetTimestamp() {
        this.createdMillis = System.currentTimeMillis();
    }

    public long getCreatedMillis() {
        return this.createdMillis;
    }

    public void expire() {
        this.createdMillis = 0L;
    }
}

