/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import grails.util.GrailsNameUtils;
import groovy.lang.GroovyObject;
import groovy.lang.MissingPropertyException;
import javax.servlet.ServletRequest;
import org.codehaus.groovy.grails.web.pages.FastStringWriter;
import org.springframework.util.Assert;

public class GroovyPagesUriSupport {
    public static final String PATH_TO_VIEWS = "/WEB-INF/grails-app/views";
    private static final char SLASH = '/';
    private static final String SLASH_STR = "/";
    private static final String SLASH_UNDR = "/_";
    private static final String BLANK = "";
    private static final String UNDERSCORE = "_";

    String getTemplateURI(GroovyObject controller, String templateName) {
        Assert.notNull((Object)controller, (String)"Argument [controller] cannot be null");
        return this.getTemplateURI(this.getLogicalControllerName(controller), templateName);
    }

    String getViewURI(GroovyObject controller, String viewName) {
        Assert.notNull((Object)controller, (String)"Argument [controller] cannot be null");
        return this.getViewURI(this.getLogicalControllerName(controller), viewName);
    }

    String getNoSuffixViewURI(GroovyObject controller, String viewName) {
        Assert.notNull((Object)controller, (String)"Argument [controller] cannot be null");
        return this.getNoSuffixViewURI(this.getLogicalControllerName(controller), viewName);
    }

    String getLogicalControllerName(GroovyObject controller) {
        String logicalName;
        ServletRequest request = null;
        try {
            request = (ServletRequest)controller.getProperty("request");
        }
        catch (MissingPropertyException mpe) {
            // empty catch block
        }
        String string = logicalName = request != null ? (String)request.getAttribute("org.codehaus.groovy.grails.CONTROLLER_NAME_ATTRIBUTE") : null;
        if (logicalName == null) {
            logicalName = GrailsNameUtils.getLogicalPropertyName(controller.getClass().getName(), "Controller");
        }
        return logicalName;
    }

    String getTemplateURI(String controllerName, String templateName) {
        FastStringWriter buf = new FastStringWriter();
        if (templateName.startsWith(SLASH_STR)) {
            String tmp = templateName.substring(1, templateName.length());
            if (tmp.indexOf(47) > -1) {
                buf.append('/');
                int i = tmp.lastIndexOf(47);
                buf.append(tmp.substring(0, i));
                buf.append(SLASH_UNDR);
                buf.append(tmp.substring(i + 1, tmp.length()));
            } else {
                buf.append(SLASH_UNDR);
                buf.append(templateName.substring(1, templateName.length()));
            }
        } else {
            String pathToTemplate = BLANK;
            int lastSlash = templateName.lastIndexOf(47);
            if (lastSlash > -1) {
                pathToTemplate = templateName.substring(0, lastSlash + 1);
                templateName = templateName.substring(lastSlash + 1);
            }
            buf.append('/').append(controllerName).append('/').append(pathToTemplate).append(UNDERSCORE).append(templateName);
        }
        return buf.append(".gsp").toString();
    }

    String getViewURI(String controllerName, String viewName) {
        FastStringWriter buf = new FastStringWriter();
        return this.getViewURIInternal(controllerName, viewName, buf, true);
    }

    String getNoSuffixViewURI(String controllerName, String viewName) {
        FastStringWriter buf = new FastStringWriter();
        return this.getViewURIInternal(controllerName, viewName, buf, false);
    }

    String getDeployedViewURI(String controllerName, String viewName) {
        FastStringWriter buf = new FastStringWriter((Object)PATH_TO_VIEWS);
        return this.getViewURIInternal(controllerName, viewName, buf, true);
    }

    String getViewURIInternal(String controllerName, String viewName, FastStringWriter buf, boolean includeSuffix) {
        if (viewName.startsWith(SLASH_STR)) {
            String tmp = viewName.substring(1, viewName.length());
            if (tmp.indexOf(47) > -1) {
                buf.append('/');
                buf.append(tmp.substring(0, tmp.lastIndexOf(47)));
                buf.append('/');
                buf.append(tmp.substring(tmp.lastIndexOf(47) + 1, tmp.length()));
            } else {
                buf.append('/');
                buf.append(viewName.substring(1, viewName.length()));
            }
        } else {
            buf.append('/').append(controllerName).append('/').append(viewName);
        }
        if (includeSuffix) {
            return buf.append(".gsp").toString();
        }
        return buf.toString();
    }
}

