/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.grails.web.mapping.DefaultUrlCreator;
import org.codehaus.groovy.grails.web.mapping.ResponseCodeUrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlCreator;
import org.codehaus.groovy.grails.web.mapping.UrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlMappingEvaluator;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingsHolder;
import org.springframework.core.style.ToStringCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUrlMappingsHolder
implements UrlMappingsHolder {
    private static final transient Log LOG = LogFactory.getLog(DefaultUrlMappingsHolder.class);
    private Map<String, UrlMappingInfo> cachedMatches = new ConcurrentHashMap<String, UrlMappingInfo>();
    private Map<String, List<UrlMappingInfo>> cachedListMatches = new ConcurrentHashMap<String, List<UrlMappingInfo>>();
    private List<UrlMapping> urlMappings = new ArrayList<UrlMapping>();
    private UrlMapping[] mappings;
    private List excludePatterns;
    private Map<UrlMappingKey, UrlMapping> mappingsLookup = new HashMap<UrlMappingKey, UrlMapping>();
    private Map<String, UrlMapping> namedMappings = new HashMap<String, UrlMapping>();
    private UrlMappingsList mappingsListLookup = new UrlMappingsList();
    private Set<String> DEFAULT_CONTROLLER_PARAMS = new HashSet<String>(){
        {
            this.add("controller");
            this.add("action");
        }
    };
    private Set<String> DEFAULT_ACTION_PARAMS = new HashSet<String>(){
        {
            this.add("action");
        }
    };

    public DefaultUrlMappingsHolder(List<UrlMapping> mappings) {
        this.urlMappings = mappings;
        this.initialize();
    }

    public DefaultUrlMappingsHolder(List<UrlMapping> mappings, List excludePatterns) {
        this.urlMappings = mappings;
        this.excludePatterns = excludePatterns;
        this.initialize();
    }

    private void initialize() {
        this.sortMappings();
        for (UrlMapping mapping : this.mappings = this.urlMappings.toArray(new UrlMapping[this.urlMappings.size()])) {
            String mappingName = mapping.getMappingName();
            if (mappingName != null) {
                this.namedMappings.put(mappingName, mapping);
            }
            String controllerName = mapping.getControllerName() instanceof String ? mapping.getControllerName().toString() : null;
            String actionName = mapping.getActionName() instanceof String ? mapping.getActionName().toString() : null;
            ConstrainedProperty[] params = mapping.getConstraints();
            HashSet<String> requiredParams = new HashSet<String>();
            int optionalIndex = -1;
            for (int j = 0; j < params.length; ++j) {
                ConstrainedProperty param = params[j];
                if (param.isNullable()) {
                    optionalIndex = j;
                    break;
                }
                requiredParams.add(param.getPropertyName());
            }
            UrlMappingKey key = new UrlMappingKey(controllerName, actionName, requiredParams);
            this.mappingsLookup.put(key, mapping);
            UrlMappingsListKey listKey = new UrlMappingsListKey(controllerName, actionName);
            this.mappingsListLookup.put(listKey, key);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reverse mapping: " + key + " -> " + mapping));
            }
            HashSet<String> requiredParamsAndOptionals = new HashSet<String>(requiredParams);
            if (optionalIndex <= -1) continue;
            for (int j = optionalIndex; j < params.length; ++j) {
                ConstrainedProperty param = params[j];
                requiredParamsAndOptionals.add(param.getPropertyName());
                key = new UrlMappingKey(controllerName, actionName, new HashSet(requiredParamsAndOptionals));
                this.mappingsLookup.put(key, mapping);
                listKey = new UrlMappingsListKey(controllerName, actionName);
                this.mappingsListLookup.put(listKey, key);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Reverse mapping: " + key + " -> " + mapping));
            }
        }
    }

    private void sortMappings() {
        ArrayList<ResponseCodeUrlMapping> responseCodeUrlMappings = new ArrayList<ResponseCodeUrlMapping>();
        Iterator<UrlMapping> iter = this.urlMappings.iterator();
        while (iter.hasNext()) {
            UrlMapping mapping = iter.next();
            if (!(mapping instanceof ResponseCodeUrlMapping)) continue;
            responseCodeUrlMappings.add((ResponseCodeUrlMapping)mapping);
            iter.remove();
        }
        Collections.sort(this.urlMappings);
        this.urlMappings.addAll(responseCodeUrlMappings);
        Collections.reverse(this.urlMappings);
    }

    @Override
    public UrlMapping[] getUrlMappings() {
        return this.mappings;
    }

    @Override
    public List getExcludePatterns() {
        return this.excludePatterns;
    }

    @Override
    public UrlCreator getReverseMapping(String controller, String action, Map params) {
        HashSet paramKeys;
        HashSet<String> lookupParams;
        if (params == null) {
            params = Collections.EMPTY_MAP;
        }
        UrlMapping mapping = null;
        mapping = this.namedMappings.get(params.remove("mappingName"));
        if (mapping == null) {
            mapping = this.lookupMapping(controller, action, params);
        }
        if (mapping == null || mapping instanceof ResponseCodeUrlMapping) {
            mapping = this.mappingsLookup.get(new UrlMappingKey(controller, action, Collections.EMPTY_SET));
        }
        if (mapping == null || mapping instanceof ResponseCodeUrlMapping) {
            lookupParams = new HashSet<String>(this.DEFAULT_ACTION_PARAMS);
            paramKeys = new HashSet(params.keySet());
            paramKeys.removeAll(lookupParams);
            lookupParams.addAll(paramKeys);
            mapping = this.mappingsLookup.get(new UrlMappingKey(controller, null, lookupParams));
            if (mapping == null) {
                lookupParams.removeAll(paramKeys);
                mapping = this.mappingsLookup.get(new UrlMappingKey(controller, null, lookupParams));
            }
        }
        if (mapping == null || mapping instanceof ResponseCodeUrlMapping) {
            lookupParams = new HashSet<String>(this.DEFAULT_CONTROLLER_PARAMS);
            paramKeys = new HashSet(params.keySet());
            paramKeys.removeAll(lookupParams);
            lookupParams.addAll(paramKeys);
            mapping = this.mappingsLookup.get(new UrlMappingKey(null, null, lookupParams));
            if (mapping == null) {
                lookupParams.removeAll(paramKeys);
                mapping = this.mappingsLookup.get(new UrlMappingKey(null, null, lookupParams));
            }
        }
        if (mapping == null || mapping instanceof ResponseCodeUrlMapping) {
            return new DefaultUrlCreator(controller, action);
        }
        return mapping;
    }

    protected UrlMapping lookupMapping(String controller, String action, Map params) {
        UrlMappingsListKey lookupKey = new UrlMappingsListKey(controller, action);
        SortedSet<UrlMappingKey> mappingKeysSet = this.mappingsListLookup.get(lookupKey);
        String actionName = lookupKey.action;
        boolean secondAttempt = false;
        boolean isIndexAction = "index".equals(actionName);
        if (null == mappingKeysSet && actionName != null) {
            lookupKey.action = null;
            mappingKeysSet = this.mappingsListLookup.get(lookupKey);
            secondAttempt = true;
        }
        if (null == mappingKeysSet) {
            return null;
        }
        UrlMappingKey[] mappingKeys = mappingKeysSet.toArray(new UrlMappingKey[mappingKeysSet.size()]);
        for (int i = mappingKeys.length; i > 0; --i) {
            UrlMappingKey mappingKey = mappingKeys[i - 1];
            if (!params.keySet().containsAll(mappingKey.paramNames)) continue;
            UrlMapping mapping = this.mappingsLookup.get(mappingKey);
            if (this.canInferAction(actionName, secondAttempt, isIndexAction, mapping)) {
                return mapping;
            }
            if (secondAttempt) continue;
            return mapping;
        }
        return null;
    }

    private boolean canInferAction(String actionName, boolean secondAttempt, boolean indexAction, UrlMapping mapping) {
        return secondAttempt && (indexAction || mapping.hasRuntimeVariable("action") || mapping.isRestfulMapping() && UrlMappingEvaluator.DEFAULT_REST_MAPPING.containsValue(actionName));
    }

    @Override
    public UrlMappingInfo match(String uri) {
        UrlMappingInfo info = null;
        if (this.cachedMatches.containsKey(uri)) {
            return this.cachedMatches.get(uri);
        }
        for (UrlMapping mapping : this.mappings) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attempting to match URI [" + uri + "] with pattern [" + mapping.getUrlData().getUrlPattern() + "]"));
            }
            if ((info = mapping.match(uri)) == null) continue;
            this.cachedMatches.put(uri, info);
            break;
        }
        return info;
    }

    @Override
    public UrlMappingInfo[] matchAll(String uri) {
        List<Object> matchingUrls = new ArrayList();
        if (this.cachedListMatches.containsKey(uri)) {
            matchingUrls = this.cachedListMatches.get(uri);
        } else {
            for (UrlMapping mapping : this.mappings) {
                UrlMappingInfo current;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Attempting to match URI [" + uri + "] with pattern [" + mapping.getUrlData().getUrlPattern() + "]"));
                }
                if ((current = mapping.match(uri)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Matched URI [" + uri + "] with pattern [" + mapping.getUrlData().getUrlPattern() + "], adding to posibilities"));
                }
                matchingUrls.add(current);
            }
            this.cachedListMatches.put(uri, matchingUrls);
        }
        return matchingUrls.toArray(new UrlMappingInfo[matchingUrls.size()]);
    }

    @Override
    public UrlMappingInfo[] matchAll(String uri, String httpMethod) {
        return this.matchAll(uri);
    }

    @Override
    public UrlMappingInfo matchStatusCode(int responseCode) {
        for (UrlMapping mapping : this.mappings) {
            UrlMappingInfo current;
            ResponseCodeUrlMapping responseCodeUrlMapping;
            if (!(mapping instanceof ResponseCodeUrlMapping) || (responseCodeUrlMapping = (ResponseCodeUrlMapping)mapping).getExceptionType() != null || (current = responseCodeUrlMapping.match(responseCode)) == null) continue;
            return current;
        }
        return null;
    }

    @Override
    public UrlMappingInfo matchStatusCode(int responseCode, Throwable e) {
        for (UrlMapping mapping : this.mappings) {
            ResponseCodeUrlMapping responseCodeUrlMapping;
            UrlMappingInfo current;
            if (!(mapping instanceof ResponseCodeUrlMapping) || (current = (responseCodeUrlMapping = (ResponseCodeUrlMapping)mapping).match(responseCode)) == null || responseCodeUrlMapping.getExceptionType() == null || !responseCodeUrlMapping.getExceptionType().isInstance(e)) continue;
            return current;
        }
        return null;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("URL Mappings");
        pw.println("------------");
        for (UrlMapping mapping : this.mappings) {
            pw.println(mapping);
        }
        pw.flush();
        return sw.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UrlMappingsList {
        private Map<UrlMappingsListKey, SortedSet<UrlMappingKey>> lookup = new HashMap<UrlMappingsListKey, SortedSet<UrlMappingKey>>();

        UrlMappingsList() {
        }

        public void put(UrlMappingsListKey key, UrlMappingKey mapping) {
            SortedSet<UrlMappingKey> mappingsList = this.lookup.get(key);
            if (null == mappingsList) {
                mappingsList = new TreeSet<UrlMappingKey>();
                this.lookup.put(key, mappingsList);
            }
            mappingsList.add(mapping);
        }

        public SortedSet<UrlMappingKey> get(UrlMappingsListKey key) {
            return this.lookup.get(key);
        }
    }

    class UrlMappingsListKey {
        String controller;
        String action;

        public UrlMappingsListKey(String controller, String action) {
            this.controller = controller;
            this.action = action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlMappingsListKey that = (UrlMappingsListKey)o;
            if (this.action != null && !this.action.equals(that.action)) {
                return false;
            }
            return this.controller == null || this.controller.equals(that.controller);
        }

        public int hashCode() {
            int result = this.controller != null ? this.controller.hashCode() : 0;
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            return result;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("controller", (Object)this.controller).append("action", (Object)this.action).toString();
        }
    }

    class UrlMappingKey
    implements Comparable {
        String controller;
        String action;
        Set paramNames = Collections.EMPTY_SET;

        public UrlMappingKey(String controller, String action, Set paramNames) {
            this.controller = controller;
            this.action = action;
            this.paramNames = paramNames;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlMappingKey that = (UrlMappingKey)o;
            if (this.action != null && !this.action.equals(that.action)) {
                return false;
            }
            if (this.controller != null && !this.controller.equals(that.controller)) {
                return false;
            }
            return ((Object)this.paramNames).equals(that.paramNames);
        }

        public int hashCode() {
            int result = this.controller != null ? this.controller.hashCode() : 0;
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + ((Object)this.paramNames).hashCode();
            return result;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("controller", (Object)this.controller).append("action", (Object)this.action).append("params", (Object)this.paramNames).toString();
        }

        public int compareTo(Object o) {
            int comparison;
            int BEFORE = -1;
            boolean EQUAL = false;
            boolean AFTER = true;
            if (this == o) {
                return 0;
            }
            UrlMappingKey other = (UrlMappingKey)o;
            if (this.paramNames.size() < other.paramNames.size()) {
                return -1;
            }
            if (this.paramNames.size() > other.paramNames.size()) {
                return 1;
            }
            int n = comparison = this.controller != null ? this.controller.compareTo(other.controller) : 0;
            if (comparison != 0) {
                return comparison;
            }
            int n2 = comparison = this.action != null ? this.action.compareTo(other.action) : 0;
            if (comparison != 0) {
                return comparison;
            }
            return 0;
        }
    }
}

