/*
 * Decompiled with CFR 0.152.
 */
package grails.converters;

import grails.util.GrailsWebUtil;
import groovy.lang.Closure;
import groovy.util.BuilderSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.converters.AbstractConverter;
import org.codehaus.groovy.grails.web.converters.Converter;
import org.codehaus.groovy.grails.web.converters.ConverterUtil;
import org.codehaus.groovy.grails.web.converters.configuration.ConverterConfiguration;
import org.codehaus.groovy.grails.web.converters.configuration.ConvertersConfigurationHolder;
import org.codehaus.groovy.grails.web.converters.configuration.DefaultConverterConfiguration;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.ClosureOjectMarshaller;
import org.codehaus.groovy.grails.web.converters.marshaller.ObjectMarshaller;
import org.codehaus.groovy.grails.web.json.JSONArray;
import org.codehaus.groovy.grails.web.json.JSONElement;
import org.codehaus.groovy.grails.web.json.JSONException;
import org.codehaus.groovy.grails.web.json.JSONObject;
import org.codehaus.groovy.grails.web.json.JSONTokener;
import org.codehaus.groovy.grails.web.json.JSONWriter;
import org.codehaus.groovy.grails.web.json.PathCapturingJSONWriterWrapper;
import org.codehaus.groovy.grails.web.json.PrettyPrintJSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSON
extends AbstractConverter<JSONWriter>
implements Converter<JSONWriter> {
    private static final Log log = LogFactory.getLog(JSON.class);
    private Object target = null;
    private final String encoding;
    protected JSONWriter writer;
    protected Stack<Object> referenceStack;
    private static final String CACHED_JSON = "org.codehaus.groovy.grails.CACHED_JSON_REQUEST_CONTENT";
    private final ConverterConfiguration<JSON> config = this.initConfig();
    private final Converter.CircularReferenceBehaviour circularReferenceBehaviour;
    private boolean prettyPrint;

    protected ConverterConfiguration<JSON> initConfig() {
        return ConvertersConfigurationHolder.getConverterConfiguration(JSON.class);
    }

    public JSON() {
        this.encoding = this.config != null ? this.config.getEncoding() : "UTF-8";
        this.circularReferenceBehaviour = this.config != null ? this.config.getCircularReferenceBehaviour() : Converter.CircularReferenceBehaviour.DEFAULT;
        this.prettyPrint = this.config != null && this.config.isPrettyPrint();
    }

    public JSON(Object target) {
        this();
        this.setTarget(target);
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    private void prepareRender(Writer out) {
        JSONWriter jSONWriter = this.writer = this.prettyPrint ? new PrettyPrintJSONWriter(out) : new JSONWriter(out);
        if (this.circularReferenceBehaviour == Converter.CircularReferenceBehaviour.PATH) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Using experimental CircularReferenceBehaviour.PATH for %s", this.getClass().getName()));
            }
            this.writer = new PathCapturingJSONWriterWrapper(this.writer);
        }
        this.referenceStack = new Stack();
    }

    private void finalizeRender(Writer out) {
        try {
            out.flush();
            out.close();
        }
        catch (Exception e) {
            log.warn((Object)("Unexpected exception while closing a writer: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Writer out) throws ConverterException {
        this.prepareRender(out);
        try {
            this.value(this.target);
            Object var3_2 = null;
            this.finalizeRender(out);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.finalizeRender(out);
            throw throwable;
        }
    }

    @Override
    public void render(HttpServletResponse response) throws ConverterException {
        response.setContentType(GrailsWebUtil.getContentType("application/json", this.encoding));
        try {
            this.render(response.getWriter());
        }
        catch (IOException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public JSONWriter getWriter() throws ConverterException {
        return this.writer;
    }

    @Override
    public void convertAnother(Object o) throws ConverterException {
        this.value(o);
    }

    @Override
    public void build(Closure c) throws ConverterException {
        new Builder(this).execute(c);
    }

    public void value(Object o) throws ConverterException {
        o = this.config.getProxyHandler().unwrapIfProxy(o);
        try {
            if (o == null || o.equals(JSONObject.NULL)) {
                this.writer.value(null);
            } else if (o instanceof CharSequence) {
                this.writer.value(o);
            } else if (o instanceof Class) {
                this.writer.value(((Class)o).getName());
            } else if (o.getClass().isPrimitive() && !o.getClass().equals(byte[].class) || o instanceof Number || o instanceof Boolean) {
                this.writer.value(o);
            } else if (this.referenceStack.contains(o)) {
                this.handleCircularRelationship(o);
            } else {
                this.referenceStack.push(o);
                ObjectMarshaller<JSON> marshaller = this.config.getMarshaller(o);
                if (marshaller == null) {
                    throw new ConverterException("Unconvertable Object of class: " + o.getClass().getName());
                }
                marshaller.marshalObject(o, this);
                this.referenceStack.pop();
            }
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (JSONException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public ObjectMarshaller<JSON> lookupObjectMarshaller(Object target) {
        return this.config.getMarshaller(target);
    }

    public int getDepth() {
        return this.referenceStack.size();
    }

    public void property(String key, Object value) throws JSONException, ConverterException {
        this.writer.key(key);
        this.value(value);
    }

    public String toString(boolean prettyPrint) throws JSONException {
        String json = super.toString();
        if (prettyPrint) {
            Object jsonObject = new JSONTokener(json).nextValue();
            if (jsonObject instanceof JSONObject) {
                return ((JSONObject)jsonObject).toString(3);
            }
            if (jsonObject instanceof JSONArray) {
                return ((JSONArray)jsonObject).toString(3);
            }
        }
        return json;
    }

    public static JSONElement parse(Reader reader) throws ConverterException {
        try {
            return JSON.parse(IOUtils.toString((Reader)reader));
        }
        catch (IOException e) {
            throw new ConverterException(e);
        }
    }

    public static JSONElement parse(String source) throws ConverterException {
        try {
            Object value = new JSONTokener(source).nextValue();
            if (value instanceof JSONElement) {
                return (JSONElement)value;
            }
            return new JSONObject();
        }
        catch (JSONException e) {
            throw new ConverterException("Error parsing JSON", e);
        }
    }

    public static JSONElement parse(InputStream is, String encoding) throws ConverterException {
        try {
            return JSON.parse(IOUtils.toString((InputStream)is, (String)encoding));
        }
        catch (IOException e) {
            throw new ConverterException(e);
        }
    }

    public static Object parse(HttpServletRequest request) throws ConverterException {
        Object json = request.getAttribute(CACHED_JSON);
        if (json != null) {
            return json;
        }
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            json = JSON.parse((InputStream)request.getInputStream(), encoding);
            request.setAttribute(CACHED_JSON, json);
            return json;
        }
        catch (IOException e) {
            throw new ConverterException("Error parsing JSON", e);
        }
    }

    @Override
    public void setTarget(Object target) {
        this.target = target;
    }

    protected void handleCircularRelationship(Object o) throws ConverterException {
        switch (this.circularReferenceBehaviour) {
            case DEFAULT: {
                if (Map.class.isAssignableFrom(o.getClass()) || Collection.class.isAssignableFrom(o.getClass())) break;
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("class", o.getClass());
                StringBuilder ref = new StringBuilder();
                int idx = this.referenceStack.indexOf(o);
                for (int i = this.referenceStack.size() - 1; i > idx; --i) {
                    ref.append("../");
                }
                props.put("_ref", ref.substring(0, ref.length() - 1));
                this.value(props);
                break;
            }
            case EXCEPTION: {
                throw new ConverterException("Circular Reference detected: class " + o.getClass().getName());
            }
            case INSERT_NULL: {
                this.value(null);
                break;
            }
            case PATH: {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("class", o.getClass());
                int idx = this.referenceStack.indexOf(o);
                PathCapturingJSONWriterWrapper pcWriter = (PathCapturingJSONWriterWrapper)this.writer;
                props.put("ref", String.format("root%s", pcWriter.getStackReference(idx)));
                this.value(props);
                break;
            }
        }
    }

    public static ConverterConfiguration<JSON> getNamedConfig(String configName) throws ConverterException {
        ConverterConfiguration<JSON> cfg = ConvertersConfigurationHolder.getNamedConverterConfiguration(configName, JSON.class);
        if (cfg == null) {
            throw new ConverterException(String.format("Converter Configuration with name '%s' not found!", configName));
        }
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object use(String configName, Closure callable) throws ConverterException {
        Object object;
        ConverterConfiguration<JSON> old = ConvertersConfigurationHolder.getThreadLocalConverterConfiguration(JSON.class);
        ConverterConfiguration<JSON> cfg = JSON.getNamedConfig(configName);
        ConvertersConfigurationHolder.setTheadLocalConverterConfiguration(JSON.class, cfg);
        try {
            object = callable.call();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ConvertersConfigurationHolder.setTheadLocalConverterConfiguration(JSON.class, old);
            throw throwable;
        }
        ConvertersConfigurationHolder.setTheadLocalConverterConfiguration(JSON.class, old);
        return object;
    }

    public static void use(String cfgName) throws ConverterException {
        if (cfgName == null || "default".equals(cfgName)) {
            ConvertersConfigurationHolder.setTheadLocalConverterConfiguration(JSON.class, null);
        } else {
            ConvertersConfigurationHolder.setTheadLocalConverterConfiguration(JSON.class, JSON.getNamedConfig(cfgName));
        }
    }

    public static void registerObjectMarshaller(Class clazz, Closure callable) throws ConverterException {
        JSON.registerObjectMarshaller(new ClosureOjectMarshaller<JSON>(clazz, callable));
    }

    public static void registerObjectMarshaller(Class clazz, int priority, Closure callable) throws ConverterException {
        JSON.registerObjectMarshaller(new ClosureOjectMarshaller<JSON>(clazz, callable), priority);
    }

    public static void registerObjectMarshaller(ObjectMarshaller<JSON> om) throws ConverterException {
        ConverterConfiguration<JSON> cfg = ConvertersConfigurationHolder.getConverterConfiguration(JSON.class);
        if (cfg == null) {
            throw new ConverterException("Default Configuration not found for class " + JSON.class.getName());
        }
        if (!(cfg instanceof DefaultConverterConfiguration)) {
            cfg = new DefaultConverterConfiguration<JSON>(cfg);
            ConvertersConfigurationHolder.setDefaultConfiguration(JSON.class, cfg);
        }
        ((DefaultConverterConfiguration)cfg).registerObjectMarshaller(om);
    }

    public static void registerObjectMarshaller(ObjectMarshaller<JSON> om, int priority) throws ConverterException {
        ConverterConfiguration<JSON> cfg = ConvertersConfigurationHolder.getConverterConfiguration(JSON.class);
        if (cfg == null) {
            throw new ConverterException("Default Configuration not found for class " + JSON.class.getName());
        }
        if (!(cfg instanceof DefaultConverterConfiguration)) {
            cfg = new DefaultConverterConfiguration<JSON>(cfg);
            ConvertersConfigurationHolder.setDefaultConfiguration(JSON.class, cfg);
        }
        ((DefaultConverterConfiguration)cfg).registerObjectMarshaller(om, priority);
    }

    public static void createNamedConfig(String name, Closure callable) throws ConverterException {
        DefaultConverterConfiguration<JSON> cfg = new DefaultConverterConfiguration<JSON>(ConvertersConfigurationHolder.getConverterConfiguration(JSON.class));
        try {
            callable.call(cfg);
            ConvertersConfigurationHolder.setNamedConverterConfiguration(JSON.class, name, cfg);
        }
        catch (Exception e) {
            throw ConverterUtil.resolveConverterException(e);
        }
    }

    public static void withDefaultConfiguration(Closure callable) throws ConverterException {
        ConverterConfiguration<JSON> cfg = ConvertersConfigurationHolder.getConverterConfiguration(JSON.class);
        if (!(cfg instanceof DefaultConverterConfiguration)) {
            cfg = new DefaultConverterConfiguration<JSON>(cfg);
        }
        try {
            callable.call(cfg);
            ConvertersConfigurationHolder.setDefaultConfiguration(JSON.class, cfg);
            ConvertersConfigurationHolder.setDefaultConfiguration(JSON.class, cfg);
        }
        catch (Throwable t) {
            throw ConverterUtil.resolveConverterException(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BuilderMode {
        ARRAY,
        OBJECT;

    }

    public class Builder
    extends BuilderSupport {
        private JSON json;
        private Stack<BuilderMode> stack = new Stack();
        private boolean start = true;
        private JSONWriter writer;

        public Builder(JSON json) {
            this.json = json;
            this.writer = json.writer;
        }

        public void execute(Closure callable) {
            callable.setDelegate((Object)this);
            this.invokeMethod("json", new Object[]{callable});
        }

        protected Object createNode(Object name) {
            int retVal = 1;
            try {
                if (this.start) {
                    this.start = false;
                    this.writeObject();
                } else {
                    if (this.getCurrent() == null && this.stack.peek() == BuilderMode.OBJECT) {
                        throw new IllegalArgumentException("only call to [element { }] is allowed when creating array");
                    }
                    if (this.stack.peek() == BuilderMode.ARRAY) {
                        this.writeObject();
                        retVal = 2;
                    }
                    this.writer.key(String.valueOf(name)).array();
                    this.stack.push(BuilderMode.ARRAY);
                }
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("invalid element");
            }
            return retVal;
        }

        protected Object createNode(Object key, Map valueMap) {
            try {
                if (this.stack.peek().equals((Object)BuilderMode.OBJECT)) {
                    this.writer.key(String.valueOf(key));
                }
                this.writer.object();
                Iterator i$ = valueMap.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry element = o = i$.next();
                    this.writer.key(String.valueOf(element.getKey()));
                    this.json.convertAnother(element.getValue());
                }
                this.writer.endObject();
                return null;
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("invalid element");
            }
        }

        protected Object createNode(Object arg0, Map arg1, Object arg2) {
            throw new IllegalArgumentException("not implemented");
        }

        protected Object createNode(Object key, Object value) {
            if (this.getCurrent() == null && this.stack.peek() == BuilderMode.OBJECT) {
                throw new IllegalArgumentException("only call to [element { }] is allowed when creating array");
            }
            try {
                int retVal = 0;
                if (this.stack.peek().equals((Object)BuilderMode.ARRAY)) {
                    this.writeObject();
                    retVal = 1;
                }
                if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    this.writer.key(String.valueOf(key));
                    this.handleCollectionRecurse(c);
                } else {
                    this.writer.key(String.valueOf(key));
                    this.json.convertAnother(value);
                }
                return retVal != 0 ? Integer.valueOf(retVal) : null;
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("invalid element");
            }
        }

        private void handleCollectionRecurse(Collection c) throws JSONException {
            this.writer.array();
            for (Object element : c) {
                if (element instanceof Collection) {
                    this.handleCollectionRecurse((Collection)element);
                    continue;
                }
                this.json.convertAnother(element);
            }
            this.writer.endArray();
        }

        protected void nodeCompleted(Object parent, Object node) {
            BuilderMode last = null;
            if (node != null) {
                try {
                    int i = (Integer)node;
                    while (i-- > 0) {
                        last = this.stack.pop();
                        if (BuilderMode.ARRAY == last) {
                            this.writer.endArray();
                        }
                        if (BuilderMode.OBJECT != last) continue;
                        this.writer.endObject();
                    }
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException("invalid element on the stack");
                }
            }
        }

        protected void setParent(Object arg0, Object arg1) {
        }

        private void writeObject() throws JSONException {
            this.writer.object();
            this.stack.push(BuilderMode.OBJECT);
        }
    }
}

