/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import groovy.lang.GroovyObject;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.codehaus.groovy.grails.web.pages.GroovyPagesUriService;
import org.codehaus.groovy.grails.web.pages.GroovyPagesUriSupport;

public class DefaultGroovyPagesUriService
extends GroovyPagesUriSupport
implements GroovyPagesUriService {
    ConcurrentHashMap<TupleStringKey, String> templateURICache = new ConcurrentHashMap();
    ConcurrentHashMap<TupleStringKey, String> deployedViewURICache = new ConcurrentHashMap();
    ConcurrentHashMap<ControllerObjectKey, String> controllerNameCache = new ConcurrentHashMap();
    ConcurrentHashMap<TupleStringKey, String> noSuffixViewURICache = new ConcurrentHashMap();

    public String getTemplateURI(String controllerName, String templateName) {
        String prevuri;
        TupleStringKey key = new TupleStringKey(controllerName, templateName);
        String uri = this.templateURICache.get(key);
        if (uri == null && (prevuri = this.templateURICache.putIfAbsent(key, uri = super.getTemplateURI(controllerName, templateName))) != null) {
            return prevuri;
        }
        return uri;
    }

    public String getDeployedViewURI(String controllerName, String viewName) {
        String prevuri;
        TupleStringKey key = new TupleStringKey(controllerName, viewName);
        String uri = this.deployedViewURICache.get(key);
        if (uri == null && (prevuri = this.deployedViewURICache.putIfAbsent(key, uri = super.getDeployedViewURI(controllerName, viewName))) != null) {
            return prevuri;
        }
        return uri;
    }

    public String getLogicalControllerName(GroovyObject controller) {
        String prevname;
        ControllerObjectKey key = new ControllerObjectKey(controller);
        String name = this.controllerNameCache.get(key);
        if (name == null && (prevname = this.controllerNameCache.putIfAbsent(key, name = super.getLogicalControllerName(controller))) != null) {
            return prevname;
        }
        return name;
    }

    public String getNoSuffixViewURI(GroovyObject controller, String viewName) {
        if (controller == null) {
            throw new IllegalArgumentException("Argument [controller] cannot be null");
        }
        return this.getNoSuffixViewURI(this.getLogicalControllerName(controller), viewName);
    }

    public String getNoSuffixViewURI(String controllerName, String viewName) {
        String prevuri;
        TupleStringKey key = new TupleStringKey(controllerName, viewName);
        String uri = this.noSuffixViewURICache.get(key);
        if (uri == null && (prevuri = this.noSuffixViewURICache.putIfAbsent(key, uri = super.getNoSuffixViewURI(controllerName, viewName))) != null) {
            return prevuri;
        }
        return uri;
    }

    public String getTemplateURI(GroovyObject controller, String templateName) {
        return this.getTemplateURI(this.getLogicalControllerName(controller), templateName);
    }

    public void clear() {
        this.templateURICache.clear();
        this.deployedViewURICache.clear();
        this.controllerNameCache.clear();
        this.noSuffixViewURICache.clear();
    }

    private class ControllerObjectKey {
        private long controllerHashCode;
        private String controllerClassName;

        public ControllerObjectKey(GroovyObject controller) {
            this.controllerHashCode = System.identityHashCode(controller.getClass());
            this.controllerClassName = controller.getClass().getName();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (this.getClass() != that.getClass()) {
                return false;
            }
            ControllerObjectKey thatKey = (ControllerObjectKey)that;
            return new EqualsBuilder().append(this.controllerHashCode, thatKey.controllerHashCode).append((Object)this.controllerClassName, (Object)thatKey.controllerClassName).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.controllerHashCode).append((Object)this.controllerClassName).toHashCode();
        }
    }

    private class TupleStringKey {
        String keyPart1;
        String keyPart2;

        public TupleStringKey(String keyPart1, String keyPart2) {
            this.keyPart1 = keyPart1;
            this.keyPart2 = keyPart2;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (this.getClass() != that.getClass()) {
                return false;
            }
            TupleStringKey thatKey = (TupleStringKey)that;
            return new EqualsBuilder().append((Object)this.keyPart1, (Object)thatKey.keyPart1).append((Object)this.keyPart2, (Object)thatKey.keyPart2).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.keyPart1).append((Object)this.keyPart2).toHashCode();
        }
    }
}

