/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.context;

import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsBootstrapClass;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.spring.GrailsRuntimeConfigurator;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.support.PersistenceContextInterceptor;
import org.codehaus.groovy.grails.web.context.ServletContextHolder;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class GrailsConfigUtils {
    private static final Log LOG = LogFactory.getLog(GrailsConfigUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeGrailsBootstraps(GrailsApplication application, WebApplicationContext webContext, ServletContext servletContext) {
        PersistenceContextInterceptor interceptor = null;
        String[] beanNames = webContext.getBeanNamesForType(PersistenceContextInterceptor.class);
        if (beanNames.length > 0) {
            interceptor = (PersistenceContextInterceptor)webContext.getBean(beanNames[0]);
        }
        if (interceptor != null) {
            interceptor.init();
        }
        try {
            GrailsClass[] bootstraps;
            for (GrailsClass bootstrap : bootstraps = application.getArtefacts("Bootstrap")) {
                GrailsBootstrapClass bootstrapClass = (GrailsBootstrapClass)bootstrap;
                Object instance = bootstrapClass.getReferenceInstance();
                webContext.getAutowireCapableBeanFactory().autowireBeanProperties(instance, 1, false);
                bootstrapClass.callInit(servletContext);
            }
            if (interceptor != null) {
                interceptor.flush();
            }
        }
        finally {
            if (interceptor != null) {
                interceptor.destroy();
            }
        }
    }

    public static WebApplicationContext configureWebApplicationContext(ServletContext servletContext, WebApplicationContext parent) {
        GrailsPluginManager pluginManager;
        GrailsRuntimeConfigurator configurator;
        GrailsApplication application = (GrailsApplication)parent.getBean("grailsApplication");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"[GrailsContextLoader] Configurating Grails Application");
        }
        if (application.getParentContext() == null) {
            application.setApplicationContext((ApplicationContext)parent);
        }
        if (parent.containsBean("grailsConfigurator")) {
            configurator = (GrailsRuntimeConfigurator)parent.getBean("grailsConfigurator");
        } else {
            configurator = new GrailsRuntimeConfigurator(application, (ApplicationContext)parent);
            if (parent.containsBean("pluginManager")) {
                pluginManager = (GrailsPluginManager)parent.getBean("pluginManager");
                configurator.setPluginManager(pluginManager);
            }
        }
        pluginManager = configurator.getPluginManager();
        WebApplicationContext webContext = configurator.configure(servletContext);
        pluginManager.setApplicationContext((ApplicationContext)webContext);
        GrailsConfigUtils.configureServletContextAttributes(servletContext, application, pluginManager, webContext);
        LOG.info((Object)"[GrailsContextLoader] Grails application loaded.");
        return webContext;
    }

    public static void configureServletContextAttributes(ServletContext servletContext, GrailsApplication application, GrailsPluginManager pluginManager, WebApplicationContext webContext) {
        ServletContextHolder.setServletContext(servletContext);
        servletContext.setAttribute("org.codehaus.groovy.grails.GRAILS_PLUGIN_MANAGER", (Object)pluginManager);
        servletContext.setAttribute("org.codehaus.groovy.grails.PARENT_APPLICATION_CONTEXT", (Object)webContext.getParent());
        servletContext.setAttribute("grailsApplication", (Object)application);
        servletContext.setAttribute("org.codehaus.groovy.grails.APPLICATION_CONTEXT", (Object)webContext);
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)webContext);
    }
}

