/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.taglib;

import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.web.taglib.GroovySyntaxTag;
import org.codehaus.groovy.grails.web.taglib.exceptions.GrailsTagException;

public class GroovyIfTag
extends GroovySyntaxTag {
    public static final String TAG_NAME = "if";
    private static final String ATTRIBUTE_TEST = "test";
    private static final String ATTRIBUTE_ENV = "env";

    public void doStartTag() {
        String env = this.attributeValueOrNull(ATTRIBUTE_ENV);
        String test = this.attributeValueOrNull(ATTRIBUTE_TEST);
        if (env == null && test == null) {
            throw new GrailsTagException("Tag [if] must have one or both of the attributes [test] or [env]");
        }
        String envExpression = this.environmentExpressionOrTrue(env);
        String testExpression = this.testExpressionOrTrue(test);
        this.out.print("if(");
        this.out.print(envExpression);
        this.out.print(" && ");
        this.out.print(testExpression);
        this.out.println(") {");
    }

    public void doEndTag() {
        this.out.println("}");
    }

    public String getName() {
        return TAG_NAME;
    }

    public boolean isKeepPrecedingWhiteSpace() {
        return true;
    }

    public boolean isAllowPrecedingContent() {
        return true;
    }

    private String attributeValueOrNull(String attributeName) {
        String attributeValue = (String)this.attributes.get(attributeName);
        return StringUtils.isBlank((String)attributeValue) ? null : attributeValue;
    }

    private String environmentExpressionOrTrue(String envAttributeValue) {
        String expression = "true";
        if (envAttributeValue != null) {
            expression = "(GrailsUtil.environment == '" + this.calculateExpression(envAttributeValue) + "')";
        }
        return expression;
    }

    private String testExpressionOrTrue(String testAttributeValue) {
        String expression = "true";
        if (testAttributeValue != null) {
            expression = "(" + testAttributeValue + ")";
        }
        return expression;
    }
}

