/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;

public class StringCharArrayAccessor {
    static volatile boolean enabled = !Boolean.getBoolean("stringchararrayaccessor.disabled");
    static Field valueField = null;
    static Field countField = null;
    static Field offsetField = null;

    public static void writeStringAsCharArray(Writer writer, String str) throws IOException {
        StringCharArrayAccessor.writeStringAsCharArray(writer, str, 0, str.length());
    }

    public static void writeStringAsCharArray(Writer writer, String str, int off, int len) throws IOException {
        if (enabled) {
            int internalOffset;
            char[] value;
            try {
                value = (char[])valueField.get(str);
                internalOffset = offsetField.getInt(str);
            }
            catch (Exception e) {
                StringCharArrayAccessor.handleError(e);
                StringCharArrayAccessor.writeStringFallback(writer, str, off, len);
                return;
            }
            writer.write(value, internalOffset + off, len);
        } else {
            StringCharArrayAccessor.writeStringFallback(writer, str, off, len);
        }
    }

    private static void writeStringFallback(Writer writer, String str, int off, int len) throws IOException {
        if (str.length() == len && off == 0) {
            writer.write(str.toCharArray());
        } else {
            char[] buf = new char[len];
            str.getChars(off, off + len, buf, 0);
            writer.write(buf);
        }
    }

    static char[] getValue(String str) {
        if (enabled) {
            char[] value = null;
            int internalOffset = 0;
            try {
                value = (char[])valueField.get(str);
                internalOffset = offsetField.getInt(str);
            }
            catch (Exception e) {
                StringCharArrayAccessor.handleError(e);
            }
            if (value != null && internalOffset == 0) {
                return value;
            }
            return StringCharArrayAccessor.getValueFallback(str);
        }
        return StringCharArrayAccessor.getValueFallback(str);
    }

    static char[] getValueFallback(String str) {
        return str.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createString(char[] charBuf) {
        if (enabled) {
            String str = new String();
            try {
                String string = str;
                synchronized (string) {
                    valueField.set(str, charBuf);
                    countField.set(str, charBuf.length);
                }
                string = str;
                synchronized (string) {
                    if (str.length() != charBuf.length) {
                        throw new IllegalStateException("Fast java.lang.String construction failed.");
                    }
                }
            }
            catch (Exception e) {
                StringCharArrayAccessor.handleError(e);
                str = StringCharArrayAccessor.createStringFallback(charBuf);
            }
            return str;
        }
        return StringCharArrayAccessor.createStringFallback(charBuf);
    }

    private static String createStringFallback(char[] charBuf) {
        return new String(charBuf);
    }

    private static synchronized void handleError(Exception e) {
        enabled = false;
        System.err.println("Unable to use direct char[] access of java.lang.String. Disabling this method.");
        valueField = null;
        countField = null;
        offsetField = null;
        e.printStackTrace(System.err);
    }

    public static boolean isEnabled() {
        return enabled;
    }

    static {
        if (enabled) {
            try {
                valueField = String.class.getDeclaredField("value");
                valueField.setAccessible(true);
                countField = String.class.getDeclaredField("count");
                countField.setAccessible(true);
                offsetField = String.class.getDeclaredField("offset");
                offsetField.setAccessible(true);
            }
            catch (Exception e) {
                enabled = false;
                System.err.println("Unable to use direct char[] access of java.lang.String");
                e.printStackTrace(System.err);
            }
        }
    }
}

