/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.grails.web.util.StringCharArrayAccessor;

public class StreamCharBuffer {
    private static final int DEFAULT_CHUNK_SIZE = Integer.getInteger("streamcharbuffer.chunksize", 512);
    private static final int DEFAULT_MAX_CHUNK_SIZE = Integer.getInteger("streamcharbuffer.maxchunksize", 0x100000);
    private static final int DEFAULT_CHUNK_SIZE_GROW_PROCENT = Integer.getInteger("streamcharbuffer.growprocent", 100);
    private static final int STRING_CHUNK_MIN_SIZE = Integer.getInteger("streamcharbuffer.stringchunkminsize", 64);
    private static final int WRITE_DIRECT_MIN_SIZE = Integer.getInteger("streamcharbuffer.writedirectminsize", 512);
    private LinkedList<StreamCharBufferChunk> chunks;
    private StreamCharBufferChunk currentWriteChunk;
    private StreamCharBufferChunk currentReadChunk = null;
    private final int firstChunkSize;
    private final int growProcent;
    private final int maxChunkSize;
    private int stringChunkMinSize = STRING_CHUNK_MIN_SIZE;
    private int writeDirectlyToConnectedMinSize = WRITE_DIRECT_MIN_SIZE;
    private int chunkSize;
    private final StreamCharBufferWriter writer;
    private final StreamCharBufferReader reader;
    private int totalCharsUnreadInList = 0;
    private int totalChunkSize = 0;
    private int totalCharsUnread = 0;
    private List<ConnectedWriter> connectedWriters = new ArrayList<ConnectedWriter>();
    private Writer connectedWritersWriter = new MultiOutputWriter(this.connectedWriters);
    private String cachedToString = null;
    private char[] cachedToCharArray = null;

    public StreamCharBuffer() {
        this(DEFAULT_CHUNK_SIZE, DEFAULT_CHUNK_SIZE_GROW_PROCENT, DEFAULT_MAX_CHUNK_SIZE);
    }

    public StreamCharBuffer(int chunkSize) {
        this(chunkSize, DEFAULT_CHUNK_SIZE_GROW_PROCENT, DEFAULT_MAX_CHUNK_SIZE);
    }

    public StreamCharBuffer(int chunkSize, int growProcent) {
        this(chunkSize, growProcent, DEFAULT_MAX_CHUNK_SIZE);
    }

    public StreamCharBuffer(int chunkSize, int growProcent, int maxChunkSize) {
        this.firstChunkSize = chunkSize;
        this.growProcent = growProcent;
        this.maxChunkSize = maxChunkSize;
        this.stringChunkMinSize = STRING_CHUNK_MIN_SIZE;
        this.writer = new StreamCharBufferWriter();
        this.reader = new StreamCharBufferReader();
        this.reset(true);
    }

    public void reset() {
        this.reset(true);
    }

    public void connectTo(Writer writer) {
        this.connectTo(writer, true);
    }

    public void connectTo(Writer writer, boolean autoFlush) {
        this.connectedWriters.add(new ConnectedWriter(writer, autoFlush));
    }

    public void connectTo(LazyInitializingWriter writer) {
        this.connectTo(writer, true);
    }

    public void connectTo(LazyInitializingWriter writer, boolean autoFlush) {
        this.connectedWriters.add(new ConnectedWriter(writer, autoFlush));
    }

    public void removeConnections() {
        this.connectedWriters.clear();
    }

    public int filledChunkCount() {
        return this.chunks.size();
    }

    public int getStringChunkMinSize() {
        return this.stringChunkMinSize;
    }

    public void setStringChunkMinSize(int stringChunkMinSize) {
        this.stringChunkMinSize = stringChunkMinSize;
    }

    public int getWriteDirectlyToConnectedMinSize() {
        return this.writeDirectlyToConnectedMinSize;
    }

    public void setWriteDirectlyToConnectedMinSize(int writeDirectlyToConnectedMinSize) {
        this.writeDirectlyToConnectedMinSize = writeDirectlyToConnectedMinSize;
    }

    public void reset(boolean resetChunkSize) {
        this.chunks = new LinkedList();
        this.totalCharsUnreadInList = 0;
        this.totalCharsUnread = 0;
        if (resetChunkSize) {
            this.chunkSize = this.firstChunkSize;
            this.totalChunkSize = 0;
        }
        this.currentWriteChunk = new StreamCharBufferChunk(this.chunkSize);
        this.currentReadChunk = null;
        this.cachedToString = null;
        this.cachedToCharArray = null;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void writeTo(Writer target) throws IOException {
        this.writeTo(target, true, true);
    }

    public void writeTo(Writer target, boolean flushAll, boolean flushTarget) throws IOException {
        while (this.prepareRead(flushAll) != -1) {
            this.totalCharsUnread -= this.currentReadChunk.writeTo(target);
        }
        if (flushTarget) {
            target.flush();
        }
    }

    public char[] readAsCharArray() {
        char[] buf = new char[this.calculateTotalCharsUnread()];
        if (buf.length > 0) {
            try {
                this.reader.readImpl(buf, 0, buf.length);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        return buf;
    }

    public String readAsString() {
        if (this.calculateTotalCharsUnread() > 0) {
            char[] buf = this.readAsCharArray();
            return StringCharArrayAccessor.createString(buf);
        }
        return "";
    }

    public String toString() {
        if (this.cachedToString == null) {
            this.cachedToString = this.readAsString();
        } else if (this.calculateTotalCharsUnread() > 0) {
            this.cachedToString = this.cachedToString.length() > 0 ? this.cachedToString + this.readAsString() : this.readAsString();
        }
        return this.cachedToString;
    }

    public char[] toCharArray() {
        if (this.cachedToCharArray == null || this.cachedToCharArray.length == 0) {
            this.cachedToCharArray = this.readAsCharArray();
        } else if (this.calculateTotalCharsUnread() > 0) {
            char[] previousCharArray = this.cachedToCharArray;
            int addedLen = this.calculateTotalCharsUnread();
            this.cachedToCharArray = new char[previousCharArray.length + addedLen];
            StreamCharBuffer.arrayCopy(previousCharArray, 0, this.cachedToCharArray, 0, previousCharArray.length);
            try {
                this.reader.readImpl(this.cachedToCharArray, previousCharArray.length, addedLen);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        return this.cachedToCharArray;
    }

    public int size() {
        return this.calculateTotalCharsUnread();
    }

    public int charsAvailable() {
        return this.totalCharsUnread;
    }

    public int calculateTotalCharsUnread() {
        int total = this.totalCharsUnreadInList;
        if (this.currentReadChunk != null) {
            total += this.currentReadChunk.charsUnread();
        }
        if (this.currentWriteChunk != this.currentReadChunk && this.currentWriteChunk != null) {
            total += this.currentWriteChunk.charsUnread();
        }
        return total;
    }

    protected int allocateSpace() throws IOException {
        int spaceLeft = this.currentWriteChunk.spaceLeft();
        if (spaceLeft == 0) {
            spaceLeft = this.endCurrentWriteChunk();
        }
        return spaceLeft;
    }

    private int endCurrentWriteChunk() throws IOException {
        this.chunks.add(this.currentWriteChunk);
        this.totalCharsUnreadInList += this.currentWriteChunk.charsUnread();
        this.totalChunkSize += this.currentWriteChunk.chunkSize();
        this.resizeChunkSizeAsProcentageOfTotalSize();
        this.currentWriteChunk = new StreamCharBufferChunk(this.chunkSize);
        int spaceLeft = this.currentWriteChunk.spaceLeft();
        this.flushIfConnected(false, true);
        return spaceLeft;
    }

    private void flushCurrentWriteChunkInConnectedMode() throws IOException {
        if (this.isChunkSizeResizeable()) {
            this.endCurrentWriteChunk();
        } else {
            this.flushIfConnected(true, true);
            this.currentWriteChunk.reuseBuffer();
        }
    }

    private void flushIfConnected(boolean flushAll, boolean flushTarget) throws IOException {
        if (!this.connectedWriters.isEmpty()) {
            this.writeTo(this.connectedWritersWriter, flushAll, flushTarget);
        }
    }

    protected boolean isChunkSizeResizeable() {
        return this.growProcent > 0;
    }

    protected void resizeChunkSizeAsProcentageOfTotalSize() {
        if (this.growProcent == 0) {
            return;
        }
        if (this.growProcent == 100) {
            this.chunkSize = Math.min(this.totalChunkSize, this.maxChunkSize);
        } else if (this.growProcent == 200) {
            this.chunkSize = Math.min(this.totalChunkSize << 1, this.maxChunkSize);
        } else if (this.growProcent > 0) {
            this.chunkSize = Math.max(Math.min(this.totalChunkSize * this.growProcent / 100, this.maxChunkSize), this.firstChunkSize);
        }
    }

    protected int prepareRead() {
        return this.prepareRead(true);
    }

    protected int prepareRead(boolean readLast) {
        int charsUnread;
        int n = charsUnread = this.currentReadChunk != null ? this.currentReadChunk.charsUnread() : 0;
        if (charsUnread == 0) {
            if (!this.chunks.isEmpty()) {
                this.currentReadChunk = this.chunks.removeFirst();
                charsUnread = this.currentReadChunk.charsUnread();
                this.totalCharsUnreadInList -= charsUnread;
            } else if (readLast && this.currentReadChunk != this.currentWriteChunk) {
                this.currentReadChunk = this.currentWriteChunk;
                charsUnread = this.currentReadChunk.charsUnread();
                if (charsUnread == 0) {
                    charsUnread = -1;
                }
            } else {
                charsUnread = -1;
            }
        }
        return charsUnread;
    }

    protected static final void arrayCopy(char[] src, int srcPos, char[] dest, int destPos, int length) {
        if (length == 1) {
            dest[destPos] = src[srcPos];
        } else if (length > 0) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MultiOutputWriter
    extends Writer {
        List<ConnectedWriter> writers;

        public MultiOutputWriter(List<ConnectedWriter> writers) {
            this.writers = writers;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
            for (ConnectedWriter writer : this.writers) {
                writer.flush();
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (ConnectedWriter writer : this.writers) {
                writer.getWriter().write(cbuf, off, len);
            }
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            for (ConnectedWriter writer : this.writers) {
                writer.getWriter().append(csq, start, end);
            }
            return this;
        }
    }

    static final class ConnectedWriter {
        Writer writer;
        LazyInitializingWriter lazyInitializingWriter;
        boolean autoFlush;

        ConnectedWriter(Writer writer, boolean autoFlush) {
            this.writer = writer;
            this.autoFlush = autoFlush;
        }

        ConnectedWriter(LazyInitializingWriter lazyInitializingWriter, boolean autoFlush) {
            this.lazyInitializingWriter = lazyInitializingWriter;
            this.autoFlush = autoFlush;
        }

        Writer getWriter() throws IOException {
            if (this.writer == null && this.lazyInitializingWriter != null) {
                this.writer = this.lazyInitializingWriter.getWriter();
            }
            return this.writer;
        }

        public void flush() throws IOException {
            if (this.writer != null && this.isAutoFlush()) {
                this.writer.flush();
            }
        }

        public boolean isAutoFlush() {
            return this.autoFlush;
        }
    }

    public static interface LazyInitializingWriter {
        public Writer getWriter() throws IOException;
    }

    static final class StringChunk {
        private String str;
        private int readOffset;
        private int unreadChars;

        public StringChunk(String str, int off, int len) {
            this.str = str;
            this.readOffset = off;
            this.unreadChars = len;
        }

        public int getUnreadChars() {
            return this.unreadChars;
        }

        public int read(char[] ch, int off, int len) {
            int readCharsLen = Math.min(this.unreadChars, len);
            this.str.getChars(this.readOffset, this.readOffset + readCharsLen, ch, off);
            this.readOffset += readCharsLen;
            this.unreadChars -= readCharsLen;
            return readCharsLen;
        }

        public int writeTo(Writer target) throws IOException {
            int len = this.unreadChars;
            target.write(this.str, this.readOffset, len);
            this.readOffset += len;
            this.unreadChars -= len;
            return len;
        }
    }

    static final class StringChunkGroup {
        private int ownerIndex;
        private LinkedList<StringChunk> unreadStringChunks = new LinkedList();
        private StringChunk currentStringChunkUnderRead;
        private int unreadChars;

        public StringChunkGroup(int ownerIndex) {
            this.ownerIndex = ownerIndex;
        }

        public int getOwnerIndex() {
            return this.ownerIndex;
        }

        public boolean hasUnreadChars() {
            return this.unreadChars > 0 || this.currentStringChunkUnderRead != null && this.currentStringChunkUnderRead.getUnreadChars() > 0;
        }

        public int getUnreadChars() {
            return this.unreadChars + (this.currentStringChunkUnderRead != null ? this.currentStringChunkUnderRead.getUnreadChars() : 0);
        }

        public int appendString(String str, int off, int len) {
            if (str.length() > 0) {
                StringChunk child = new StringChunk(str, off, len);
                this.unreadStringChunks.add(child);
                this.unreadChars += child.getUnreadChars();
                return child.getUnreadChars();
            }
            return 0;
        }

        public boolean prepareReading() {
            if (this.currentStringChunkUnderRead != null && this.currentStringChunkUnderRead.getUnreadChars() > 0) {
                return true;
            }
            if (!this.unreadStringChunks.isEmpty()) {
                this.currentStringChunkUnderRead = this.unreadStringChunks.removeFirst();
                this.unreadChars -= this.currentStringChunkUnderRead.getUnreadChars();
                return true;
            }
            this.currentStringChunkUnderRead = null;
            return false;
        }

        private void afterReading() {
            if (this.currentStringChunkUnderRead != null && this.currentStringChunkUnderRead.getUnreadChars() == 0) {
                this.currentStringChunkUnderRead = null;
            }
        }

        public int read(char[] ch, int off, int len) {
            int totalChars = 0;
            int readLen = Math.min(this.getUnreadChars(), len);
            int readOff = off;
            while (readLen > 0 && this.prepareReading()) {
                int readCharsLen = this.currentStringChunkUnderRead.read(ch, readOff, readLen);
                readLen -= readCharsLen;
                readOff += readCharsLen;
                totalChars += readCharsLen;
            }
            this.afterReading();
            return totalChars;
        }

        public int writeTo(Writer target) throws IOException {
            int writtenCount = 0;
            while (this.prepareReading()) {
                writtenCount += this.currentStringChunkUnderRead.writeTo(target);
            }
            this.afterReading();
            return writtenCount;
        }
    }

    static final class StreamCharBufferChunk {
        private int size;
        private char[] buffer;
        private int pointer = 0;
        private int used = 0;
        private LinkedList<StringChunkGroup> StringChunkGroups;
        private int unreadCharsInStringChunkGroups = 0;
        private StringChunkGroup readingStringChunkGroup;
        private StringChunkGroup writingStringChunkGroup;

        public StreamCharBufferChunk(int size) {
            this.size = size;
            this.buffer = new char[size];
        }

        public void reuseBuffer() {
            this.pointer = 0;
            this.used = 0;
            this.StringChunkGroups = null;
            this.unreadCharsInStringChunkGroups = 0;
            this.readingStringChunkGroup = null;
            this.writingStringChunkGroup = null;
        }

        public boolean write(char ch) {
            if (this.used < this.size) {
                this.buffer[this.used++] = ch;
                return true;
            }
            return false;
        }

        public int chunkSize() {
            return this.buffer.length;
        }

        public void write(char[] ch, int off, int len) {
            StreamCharBuffer.arrayCopy(ch, off, this.buffer, this.used, len);
            this.used += len;
        }

        public void appendStringChunk(String str, int off, int len) throws IOException {
            if (this.writingStringChunkGroup == null || this.used != this.writingStringChunkGroup.getOwnerIndex()) {
                this.writingStringChunkGroup = new StringChunkGroup(this.used);
                if (this.StringChunkGroups == null) {
                    this.StringChunkGroups = new LinkedList();
                }
                this.StringChunkGroups.add(this.writingStringChunkGroup);
            }
            this.unreadCharsInStringChunkGroups += this.writingStringChunkGroup.appendString(str, off, len);
        }

        private boolean prepareChildArrayChunkReading() {
            if (this.StringChunkGroups == null) {
                return false;
            }
            if (this.readingStringChunkGroup != null && this.readingStringChunkGroup.hasUnreadChars()) {
                return true;
            }
            if (this.StringChunkGroups.isEmpty()) {
                return false;
            }
            if (this.StringChunkGroups.peek().getOwnerIndex() != this.pointer) {
                return false;
            }
            this.readingStringChunkGroup = this.StringChunkGroups.removeFirst();
            this.unreadCharsInStringChunkGroups -= this.readingStringChunkGroup.getUnreadChars();
            return true;
        }

        public void writeString(String str, int off, int len) {
            str.getChars(off, off + len, this.buffer, this.used);
            this.used += len;
        }

        public void writeStringBuilder(StringBuilder stringBuilder, int off, int len) {
            stringBuilder.getChars(off, off + len, this.buffer, this.used);
            this.used += len;
        }

        public void writeStringBuffer(StringBuffer stringBuffer, int off, int len) {
            stringBuffer.getChars(off, off + len, this.buffer, this.used);
            this.used += len;
        }

        public void read(char[] ch, int off, int len) {
            int readLen = len;
            int readOff = off;
            while (readLen > 0) {
                if (this.prepareChildArrayChunkReading()) {
                    int readCharsLen = this.readingStringChunkGroup.read(ch, readOff, readLen);
                    readLen -= readCharsLen;
                    readOff += readCharsLen;
                    if (this.readingStringChunkGroup.getUnreadChars() == 0) {
                        this.readingStringChunkGroup = null;
                    }
                }
                if (readLen <= 0) continue;
                int nextCharArrPointerPos = -1;
                if (this.StringChunkGroups != null && !this.StringChunkGroups.isEmpty()) {
                    nextCharArrPointerPos = this.StringChunkGroups.peek().getOwnerIndex();
                }
                int actualReadLen = readLen;
                if (nextCharArrPointerPos != -1 && nextCharArrPointerPos < this.pointer + readLen) {
                    actualReadLen = nextCharArrPointerPos - this.pointer;
                }
                StreamCharBuffer.arrayCopy(this.buffer, this.pointer, ch, readOff, actualReadLen);
                readLen -= actualReadLen;
                readOff += actualReadLen;
                this.pointer += actualReadLen;
            }
        }

        public int writeTo(Writer target) throws IOException {
            int writtenCount = 0;
            while (this.charsUnread() > 0) {
                if (this.prepareChildArrayChunkReading()) {
                    writtenCount += this.readingStringChunkGroup.writeTo(target);
                    if (this.readingStringChunkGroup.getUnreadChars() == 0) {
                        this.readingStringChunkGroup = null;
                    }
                }
                int nextCharArrPointerPos = -1;
                if (this.StringChunkGroups != null && !this.StringChunkGroups.isEmpty()) {
                    nextCharArrPointerPos = this.StringChunkGroups.peek().getOwnerIndex();
                }
                if (this.pointer >= this.used) continue;
                int limit = nextCharArrPointerPos != -1 ? nextCharArrPointerPos : this.used;
                int len = limit - this.pointer;
                target.write(this.buffer, this.pointer, len);
                writtenCount += len;
                this.pointer = limit;
            }
            return writtenCount;
        }

        public int charsUnread() {
            return this.used - this.pointer + this.unreadCharsInStringChunkGroups + (this.readingStringChunkGroup != null ? this.readingStringChunkGroup.getUnreadChars() : 0);
        }

        public int spaceLeft() {
            return this.size - this.used;
        }
    }

    public final class StreamCharBufferReader
    extends Reader {
        boolean eofReached = false;

        public boolean ready() throws IOException {
            return true;
        }

        public int read(char[] b, int off, int len) throws IOException {
            return this.readImpl(b, off, len);
        }

        int readImpl(char[] b, int off, int len) throws EOFException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int charsLeft = len;
            int currentOffset = off;
            int charsUnread = StreamCharBuffer.this.prepareRead();
            if (charsUnread == 0 && this.eofReached) {
                throw new EOFException();
            }
            int totalCharsRead = 0;
            while (charsLeft > 0 && charsUnread != -1) {
                int readChars = Math.min(charsUnread, charsLeft);
                StreamCharBuffer.this.currentReadChunk.read(b, currentOffset, readChars);
                currentOffset += readChars;
                totalCharsRead += readChars;
                if ((charsLeft -= readChars) <= 0) continue;
                charsUnread = StreamCharBuffer.this.prepareRead();
            }
            if (totalCharsRead > 0) {
                StreamCharBuffer.this.totalCharsUnread -= totalCharsRead;
                this.eofReached = false;
                return totalCharsRead;
            }
            this.eofReached = true;
            return -1;
        }

        public void close() throws IOException {
        }

        public StreamCharBuffer getBuffer() {
            return StreamCharBuffer.this;
        }
    }

    public final class StreamCharBufferWriter
    extends Writer {
        private boolean closed = false;
        private boolean writerUsed = false;

        public void write(char[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.writerUsed = true;
            if (this.shouldWriteDirectly(len)) {
                StreamCharBuffer.this.flushCurrentWriteChunkInConnectedMode();
                StreamCharBuffer.this.connectedWritersWriter.write(b, off, len);
            } else {
                int charsLeft = len;
                int currentOffset = off;
                while (charsLeft > 0) {
                    int spaceLeft = StreamCharBuffer.this.allocateSpace();
                    int writeChars = Math.min(spaceLeft, charsLeft);
                    StreamCharBuffer.this.currentWriteChunk.write(b, currentOffset, writeChars);
                    charsLeft -= writeChars;
                    currentOffset += writeChars;
                }
                StreamCharBuffer.this.totalCharsUnread += len;
            }
        }

        private boolean shouldWriteDirectly(int len) {
            if (StreamCharBuffer.this.connectedWriters.isEmpty()) {
                return false;
            }
            return StreamCharBuffer.this.writeDirectlyToConnectedMinSize >= 0 && len > StreamCharBuffer.this.writeDirectlyToConnectedMinSize;
        }

        public void write(String str) throws IOException {
            this.write(str, 0, str.length());
        }

        public void write(String str, int off, int len) throws IOException {
            if (len == 0) {
                return;
            }
            this.writerUsed = true;
            if (this.shouldWriteDirectly(len)) {
                StreamCharBuffer.this.flushCurrentWriteChunkInConnectedMode();
                StreamCharBuffer.this.connectedWritersWriter.write(str, off, len);
            } else if (len > StreamCharBuffer.this.stringChunkMinSize) {
                StreamCharBuffer.this.currentWriteChunk.appendStringChunk(str, off, len);
                StreamCharBuffer.this.totalCharsUnread += len;
            } else {
                int charsLeft = len;
                int currentOffset = off;
                while (charsLeft > 0) {
                    int spaceLeft = StreamCharBuffer.this.allocateSpace();
                    int writeChars = Math.min(spaceLeft, charsLeft);
                    StreamCharBuffer.this.currentWriteChunk.writeString(str, currentOffset, writeChars);
                    charsLeft -= writeChars;
                    currentOffset += writeChars;
                }
                StreamCharBuffer.this.totalCharsUnread += len;
            }
        }

        public Writer append(CharSequence csq, int start, int end) throws IOException {
            this.writerUsed = true;
            if (csq == null) {
                this.write("null");
            } else if (csq instanceof StringBuilder || csq instanceof StringBuffer || csq instanceof String) {
                int len;
                int charsLeft = len = end - start;
                int currentOffset = start;
                while (charsLeft > 0) {
                    int spaceLeft = StreamCharBuffer.this.allocateSpace();
                    int writeChars = Math.min(spaceLeft, charsLeft);
                    if (csq instanceof StringBuilder) {
                        StreamCharBuffer.this.currentWriteChunk.writeStringBuilder((StringBuilder)csq, currentOffset, writeChars);
                    } else if (csq instanceof StringBuffer) {
                        StreamCharBuffer.this.currentWriteChunk.writeStringBuffer((StringBuffer)csq, currentOffset, writeChars);
                    } else if (csq instanceof String) {
                        StreamCharBuffer.this.currentWriteChunk.writeString((String)csq, currentOffset, writeChars);
                    }
                    charsLeft -= writeChars;
                    currentOffset += writeChars;
                }
                StreamCharBuffer.this.totalCharsUnread += len;
            } else {
                this.write(((Object)csq.subSequence(start, end)).toString());
            }
            return this;
        }

        public Writer append(CharSequence csq) throws IOException {
            this.writerUsed = true;
            if (csq == null) {
                this.write("null");
            } else {
                this.append(csq, 0, csq.length());
            }
            return this;
        }

        public void close() throws IOException {
            this.closed = true;
            this.flush();
        }

        public boolean isClosed() {
            return this.closed;
        }

        public boolean isUsed() {
            return this.writerUsed;
        }

        public void write(int b) throws IOException {
            this.writerUsed = true;
            StreamCharBuffer.this.allocateSpace();
            StreamCharBuffer.this.currentWriteChunk.write((char)b);
            StreamCharBuffer.this.totalCharsUnread++;
        }

        public void flush() throws IOException {
            if (this.writerUsed) {
                StreamCharBuffer.this.flushIfConnected(true, true);
            }
        }

        public StreamCharBuffer getBuffer() {
            return StreamCharBuffer.this;
        }
    }
}

