/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.pages;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.sitemesh.GrailsContentBufferingResponse;
import org.codehaus.groovy.grails.web.util.BoundedCharsAsEncodedBytesCounter;
import org.codehaus.groovy.grails.web.util.GrailsPrintWriter;
import org.codehaus.groovy.grails.web.util.StreamCharBuffer;

public class GSPResponseWriter
extends GrailsPrintWriter {
    private static final Log LOG = LogFactory.getLog(GSPResponseWriter.class);
    private ServletResponse response;
    private BoundedCharsAsEncodedBytesCounter bytesCounter;
    private static final boolean CONTENT_LENGTH_COUNTING_ENABLED = Boolean.getBoolean("GSPResponseWriter.enableContentLength");

    public static GSPResponseWriter getInstance(final ServletResponse response, int max) {
        Writer target = null;
        StreamCharBuffer streamBuffer = null;
        BoundedCharsAsEncodedBytesCounter bytesCounter = null;
        if (!(response instanceof GrailsContentBufferingResponse)) {
            streamBuffer = new StreamCharBuffer(max, 0, max);
            target = streamBuffer.getWriter();
            if (CONTENT_LENGTH_COUNTING_ENABLED) {
                bytesCounter = new BoundedCharsAsEncodedBytesCounter(max * 2, response.getCharacterEncoding());
                streamBuffer.connectTo(bytesCounter.getCountingWriter(), true);
            }
            streamBuffer.connectTo(new StreamCharBuffer.LazyInitializingWriter(){

                public Writer getWriter() throws IOException {
                    return response.getWriter();
                }
            }, !CONTENT_LENGTH_COUNTING_ENABLED);
        } else {
            try {
                target = response.getWriter();
            }
            catch (IOException e) {
                LOG.error((Object)"Problem getting writer from response", (Throwable)e);
                throw new RuntimeException("Problem getting writer from response", e);
            }
        }
        return new GSPResponseWriter(target, response, bytesCounter);
    }

    public static GSPResponseWriter getInstance(Writer target, int max) {
        StreamCharBuffer streamBuffer = new StreamCharBuffer(max, 0, max);
        streamBuffer.connectTo(target);
        Writer writer = streamBuffer.getWriter();
        return new GSPResponseWriter(writer);
    }

    private GSPResponseWriter(Writer activeWriter, ServletResponse response, BoundedCharsAsEncodedBytesCounter bytesCounter) {
        super(activeWriter);
        this.response = response;
        this.bytesCounter = bytesCounter;
    }

    private GSPResponseWriter(Writer activeWriter) {
        super(activeWriter);
    }

    public void close() {
        this.flush();
        if (CONTENT_LENGTH_COUNTING_ENABLED && this.bytesCounter != null && this.response != null && !this.response.isCommitted()) {
            int size = this.bytesCounter.size();
            if (size > 0) {
                this.response.setContentLength(size);
            }
            try {
                this.response.getWriter().flush();
            }
            catch (IOException e) {
                this.handleIOException(e);
            }
        }
    }
}

