/*
 * Decompiled with CFR 0.152.
 */
package grails.web.databinding;

import grails.core.GrailsApplication;
import grails.core.GrailsDomainClass;
import grails.core.GrailsDomainClassProperty;
import grails.databinding.CollectionDataBindingSource;
import grails.databinding.DataBinder;
import grails.databinding.DataBindingSource;
import grails.util.Environment;
import grails.util.Holders;
import grails.validation.ValidationErrors;
import grails.web.databinding.GrailsWebDataBinder;
import grails.web.mime.MimeType;
import grails.web.mime.MimeTypeResolver;
import grails.web.mime.MimeTypeUtils;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequest;
import org.grails.web.databinding.bindingsource.DataBindingSourceRegistry;
import org.grails.web.databinding.bindingsource.DefaultDataBindingSourceRegistry;
import org.grails.web.databinding.bindingsource.InvalidRequestBodyException;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class DataBindingUtils {
    public static final String DATA_BINDER_BEAN_NAME = "grailsWebDataBinder";
    private static final String BLANK = "";
    private static final Map<Class, List> CLASS_TO_BINDING_INCLUDE_LIST = new ConcurrentHashMap<Class, List>();

    public static void assignBidirectionalAssociations(Object object, Map source, GrailsDomainClass domainClass) {
        if (source == null) {
            return;
        }
        for (Object key : source.keySet()) {
            GrailsDomainClassProperty prop;
            String propertyName = key.toString();
            if (propertyName.indexOf(46) > -1) {
                propertyName = propertyName.substring(0, propertyName.indexOf(46));
            }
            if (!domainClass.hasPersistentProperty(propertyName) || (prop = domainClass.getPropertyByName(propertyName)) == null || !prop.isOneToOne() || !prop.isBidirectional()) continue;
            Object val = source.get(key);
            GrailsDomainClassProperty otherSide = prop.getOtherSide();
            if (val == null || otherSide == null) continue;
            MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(val.getClass());
            try {
                mc.setProperty(val, otherSide.getName(), object);
            }
            catch (Exception e) {}
        }
    }

    public static BindingResult bindObjectToInstance(Object object, Object source) {
        return DataBindingUtils.bindObjectToInstance(object, source, DataBindingUtils.getBindingIncludeList(object), Collections.EMPTY_LIST, null);
    }

    private static List getBindingIncludeList(Object object) {
        List includeList = Collections.EMPTY_LIST;
        try {
            Class<?> objectClass = object.getClass();
            if (CLASS_TO_BINDING_INCLUDE_LIST.containsKey(objectClass)) {
                includeList = CLASS_TO_BINDING_INCLUDE_LIST.get(objectClass);
            } else {
                Object whiteListValue;
                Field whiteListField = objectClass.getDeclaredField("$defaultDatabindingWhiteList");
                if (whiteListField != null && (whiteListField.getModifiers() & 8) != 0 && (whiteListValue = whiteListField.get(objectClass)) instanceof List) {
                    includeList = (List)whiteListValue;
                }
                if (!Environment.getCurrent().isReloadEnabled()) {
                    CLASS_TO_BINDING_INCLUDE_LIST.put(objectClass, includeList);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return includeList;
    }

    public static BindingResult bindObjectToDomainInstance(GrailsDomainClass domain, Object object, Object source) {
        return DataBindingUtils.bindObjectToDomainInstance(domain, object, source, DataBindingUtils.getBindingIncludeList(object), Collections.EMPTY_LIST, null);
    }

    public static <T> void bindToCollection(Class<T> targetType, Collection<T> collectionToPopulate, CollectionDataBindingSource collectionBindingSource) throws InstantiationException, IllegalAccessException {
        GrailsApplication application = GrailsWebRequest.lookupApplication();
        GrailsDomainClass domain = null;
        if (application != null) {
            domain = (GrailsDomainClass)application.getArtefact("Domain", targetType.getName());
        }
        List dataBindingSources = collectionBindingSource.getDataBindingSources();
        for (DataBindingSource dataBindingSource : dataBindingSources) {
            T newObject = targetType.newInstance();
            DataBindingUtils.bindObjectToDomainInstance(domain, newObject, dataBindingSource, DataBindingUtils.getBindingIncludeList(newObject), Collections.EMPTY_LIST, null);
            collectionToPopulate.add(newObject);
        }
    }

    public static <T> void bindToCollection(Class<T> targetType, Collection<T> collectionToPopulate, ServletRequest request) throws InstantiationException, IllegalAccessException {
        GrailsApplication grailsApplication = GrailsWebRequest.lookupApplication();
        CollectionDataBindingSource collectionDataBindingSource = DataBindingUtils.createCollectionDataBindingSource(grailsApplication, targetType, request);
        DataBindingUtils.bindToCollection(targetType, collectionToPopulate, collectionDataBindingSource);
    }

    public static BindingResult bindObjectToInstance(Object object, Object source, List include, List exclude, String filter) {
        if (include == null && exclude == null) {
            include = DataBindingUtils.getBindingIncludeList(object);
        }
        GrailsApplication application = Holders.findApplication();
        GrailsDomainClass domain = null;
        if (application != null) {
            domain = (GrailsDomainClass)application.getArtefact("Domain", object.getClass().getName());
        }
        return DataBindingUtils.bindObjectToDomainInstance(domain, object, source, include, exclude, filter);
    }

    public static BindingResult bindObjectToDomainInstance(GrailsDomainClass domain, Object object, Object source, List include, List exclude, String filter) {
        MetaClass mc;
        BeanPropertyBindingResult bindingResult = null;
        GrailsApplication grailsApplication = null;
        if (domain != null) {
            grailsApplication = domain.getApplication();
        }
        if (grailsApplication == null) {
            grailsApplication = Holders.findApplication();
        }
        try {
            DataBindingSource bindingSource = DataBindingUtils.createDataBindingSource(grailsApplication, object.getClass(), source);
            DataBinder grailsWebDataBinder = DataBindingUtils.getGrailsWebDataBinder(grailsApplication);
            grailsWebDataBinder.bind(object, bindingSource, filter, include, exclude);
        }
        catch (InvalidRequestBodyException e) {
            String messageCode = "invalidRequestBody";
            Class<?> objectType = object.getClass();
            String defaultMessage = "An error occurred parsing the body of the request";
            String[] codes = DataBindingUtils.getMessageCodes(messageCode, objectType);
            bindingResult = new BeanPropertyBindingResult(object, objectType.getName());
            bindingResult.addError(new ObjectError(bindingResult.getObjectName(), codes, null, defaultMessage));
        }
        catch (Exception e) {
            bindingResult = new BeanPropertyBindingResult(object, object.getClass().getName());
            bindingResult.addError(new ObjectError(bindingResult.getObjectName(), e.getMessage()));
        }
        if (domain != null && bindingResult != null) {
            ValidationErrors newResult = new ValidationErrors(object);
            for (Object error : bindingResult.getAllErrors()) {
                if (error instanceof FieldError) {
                    FieldError fieldError = (FieldError)error;
                    boolean isBlank = BLANK.equals(fieldError.getRejectedValue());
                    if (!isBlank) {
                        newResult.addError((ObjectError)fieldError);
                        continue;
                    }
                    if (domain.hasPersistentProperty(fieldError.getField())) {
                        boolean isOptional = domain.getPropertyByName(fieldError.getField()).isOptional();
                        if (isOptional) continue;
                        newResult.addError((ObjectError)fieldError);
                        continue;
                    }
                    newResult.addError((ObjectError)fieldError);
                    continue;
                }
                newResult.addError((ObjectError)error);
            }
            bindingResult = newResult;
        }
        if ((mc = GroovySystem.getMetaClassRegistry().getMetaClass(object.getClass())).hasProperty(object, "errors") != null && bindingResult != null) {
            ValidationErrors errors = new ValidationErrors(object);
            errors.addAllErrors((Errors)bindingResult);
            mc.setProperty(object, "errors", (Object)errors);
        }
        return bindingResult;
    }

    protected static String[] getMessageCodes(String messageCode, Class objectType) {
        String[] codes = new String[]{objectType.getName() + "." + messageCode, messageCode};
        return codes;
    }

    public static DataBindingSourceRegistry getDataBindingSourceRegistry(GrailsApplication grailsApplication) {
        ApplicationContext context;
        DefaultDataBindingSourceRegistry registry = null;
        if (grailsApplication != null && (context = grailsApplication.getMainContext()) != null && context.containsBean("dataBindingSourceRegistry")) {
            registry = (DataBindingSourceRegistry)context.getBean("dataBindingSourceRegistry", DataBindingSourceRegistry.class);
        }
        if (registry == null) {
            registry = new DefaultDataBindingSourceRegistry();
        }
        return registry;
    }

    public static DataBindingSource createDataBindingSource(GrailsApplication grailsApplication, Class bindingTargetType, Object bindingSource) {
        DataBindingSourceRegistry registry = DataBindingUtils.getDataBindingSourceRegistry(grailsApplication);
        MimeType mimeType = DataBindingUtils.getMimeType(grailsApplication, bindingSource);
        return registry.createDataBindingSource(mimeType, bindingTargetType, bindingSource);
    }

    public static CollectionDataBindingSource createCollectionDataBindingSource(GrailsApplication grailsApplication, Class bindingTargetType, Object bindingSource) {
        DataBindingSourceRegistry registry = DataBindingUtils.getDataBindingSourceRegistry(grailsApplication);
        MimeType mimeType = DataBindingUtils.getMimeType(grailsApplication, bindingSource);
        return registry.createCollectionDataBindingSource(mimeType, bindingTargetType, bindingSource);
    }

    public static MimeType getMimeType(GrailsApplication grailsApplication, Object bindingSource) {
        MimeTypeResolver mimeTypeResolver = DataBindingUtils.getMimeTypeResolver(grailsApplication);
        return DataBindingUtils.resolveMimeType(bindingSource, mimeTypeResolver);
    }

    public static MimeTypeResolver getMimeTypeResolver(GrailsApplication grailsApplication) {
        ApplicationContext context;
        MimeTypeResolver mimeTypeResolver = null;
        if (grailsApplication != null && (context = grailsApplication.getMainContext()) != null && context.containsBean("mimeTypeResolver")) {
            mimeTypeResolver = (MimeTypeResolver)context.getBean("mimeTypeResolver", MimeTypeResolver.class);
        }
        return mimeTypeResolver;
    }

    public static MimeType resolveMimeType(Object bindingSource, MimeTypeResolver mimeTypeResolver) {
        return MimeTypeUtils.resolveMimeType((Object)bindingSource, (MimeTypeResolver)mimeTypeResolver);
    }

    private static DataBinder getGrailsWebDataBinder(GrailsApplication grailsApplication) {
        ApplicationContext mainContext;
        GrailsWebDataBinder dataBinder = null;
        if (grailsApplication != null && (mainContext = grailsApplication.getMainContext()) != null && mainContext.containsBean(DATA_BINDER_BEAN_NAME)) {
            dataBinder = (DataBinder)mainContext.getBean(DATA_BINDER_BEAN_NAME, DataBinder.class);
        }
        if (dataBinder == null) {
            dataBinder = new GrailsWebDataBinder(grailsApplication);
        }
        return dataBinder;
    }

    public static Map convertPotentialGStrings(Map<Object, Object> args) {
        HashMap<Object, Object> newArgs = new HashMap<Object, Object>(args.size());
        for (Map.Entry<Object, Object> entry : args.entrySet()) {
            newArgs.put(DataBindingUtils.unwrapGString(entry.getKey()), DataBindingUtils.unwrapGString(entry.getValue()));
        }
        return newArgs;
    }

    private static Object unwrapGString(Object value) {
        if (value instanceof CharSequence) {
            return value.toString();
        }
        return value;
    }
}

