/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import groovy.lang.GroovyObject;
import groovy.util.ConfigObject;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsStringUtils;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.ParameterCreationListener;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GrailsWebUtil {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final String CHARSET_ATTRIBUTE = ";charset=";
    private static final Pattern CHARSET_IN_CONTENT_TYPE_REGEXP = Pattern.compile(";\\s*charset\\s*=", 2);

    public static GrailsApplication lookupApplication(ServletContext servletContext) {
        if (servletContext == null) {
            return null;
        }
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (context == null || !context.containsBean("grailsApplication")) {
            return null;
        }
        return (GrailsApplication)context.getBean("grailsApplication", GrailsApplication.class);
    }

    public static GrailsApplication currentApplication() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof GrailsWebRequest)) {
            return null;
        }
        return ((GrailsWebRequest)requestAttributes).getAttributes().getGrailsApplication();
    }

    public static Map currentConfiguration() {
        GrailsApplication application = GrailsWebUtil.currentApplication();
        return application == null ? new ConfigObject() : application.getConfig();
    }

    public static Map currentFlatConfiguration() {
        GrailsApplication application = GrailsWebUtil.currentApplication();
        return application == null ? Collections.emptyMap() : application.getFlatConfig();
    }

    public static GrailsWebRequest bindMockWebRequest(WebApplicationContext ctx) {
        return GrailsWebUtil.bindMockWebRequest((ApplicationContext)ctx, new MockHttpServletRequest(ctx.getServletContext()), new MockHttpServletResponse());
    }

    public static GrailsWebRequest bindMockWebRequest(ApplicationContext ctx, MockHttpServletRequest request, MockHttpServletResponse response) {
        ServletContext servletContext = ctx instanceof WebApplicationContext && ((WebApplicationContext)ctx).getServletContext() != null ? ((WebApplicationContext)ctx).getServletContext() : request.getServletContext();
        GrailsWebRequest webRequest = new GrailsWebRequest((HttpServletRequest)request, (HttpServletResponse)response, servletContext, ctx);
        request.setAttribute("org.codehaus.groovy.grails.WEB_REQUEST", (Object)webRequest);
        for (ParameterCreationListener listener : ctx.getBeansOfType(ParameterCreationListener.class).values()) {
            webRequest.addParameterListener(listener);
        }
        RequestContextHolder.setRequestAttributes((RequestAttributes)webRequest);
        return webRequest;
    }

    public static GrailsWebRequest bindMockWebRequest() {
        MockServletContext servletContext = new MockServletContext();
        MockHttpServletRequest request = new MockHttpServletRequest((ServletContext)servletContext);
        MockHttpServletResponse response = new MockHttpServletResponse();
        return GrailsWebUtil.bindMockWebRequest((ServletContext)servletContext, request, response);
    }

    private static GrailsWebRequest bindMockWebRequest(ServletContext servletContext, MockHttpServletRequest request, MockHttpServletResponse response) {
        GrailsWebRequest webRequest = new GrailsWebRequest((HttpServletRequest)request, (HttpServletResponse)response, servletContext);
        request.setAttribute("org.codehaus.groovy.grails.WEB_REQUEST", (Object)webRequest);
        RequestContextHolder.setRequestAttributes((RequestAttributes)webRequest);
        return webRequest;
    }

    public static String getUriFromRequest(HttpServletRequest request) {
        Object includeUri = request.getAttribute("javax.servlet.include.request_uri");
        return includeUri == null ? request.getRequestURI() : (String)includeUri;
    }

    public static GroovyObject getControllerFromRequest(HttpServletRequest request) {
        return (GroovyObject)request.getAttribute("org.codehaus.groovy.grails.CONTROLLER");
    }

    public static String getContentType(String name, String encoding) {
        if (name.indexOf(59) > -1 && CHARSET_IN_CONTENT_TYPE_REGEXP.matcher(name).find()) {
            return name;
        }
        if (GrailsStringUtils.isBlank((String)encoding)) {
            encoding = DEFAULT_ENCODING;
        }
        return name + CHARSET_ATTRIBUTE + encoding;
    }
}

