/*
 * Decompiled with CFR 0.152.
 */
package org.grails.validation;

import grails.core.GrailsDomainClass;
import grails.core.GrailsDomainClassProperty;
import grails.io.IOUtils;
import grails.util.GrailsClassUtils;
import grails.validation.Constrained;
import grails.validation.ConstrainedProperty;
import grails.validation.ConstraintsEvaluator;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.Script;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.grails.core.exceptions.GrailsConfigurationException;
import org.grails.validation.ConstrainedPropertyBuilder;

public class DefaultConstraintEvaluator
implements ConstraintsEvaluator,
org.codehaus.groovy.grails.validation.ConstraintsEvaluator {
    private static final Log LOG = LogFactory.getLog(DefaultConstraintEvaluator.class);
    private Map<String, Object> defaultConstraints;

    public DefaultConstraintEvaluator(Map<String, Object> defaultConstraints) {
        this.defaultConstraints = defaultConstraints;
    }

    public DefaultConstraintEvaluator() {
    }

    public Map<String, Object> getDefaultConstraints() {
        return this.defaultConstraints;
    }

    public Map<String, Constrained> evaluate(Class cls) {
        return this.evaluateConstraints(cls, null, false);
    }

    public Map<String, Constrained> evaluate(Class cls, boolean defaultNullable) {
        return this.evaluateConstraints(cls, null, defaultNullable);
    }

    public Map<String, Constrained> evaluate(GrailsDomainClass cls) {
        return this.evaluate(cls.getClazz(), cls.getPersistentProperties());
    }

    protected Map<String, Constrained> evaluateConstraints(Class<?> theClass, GrailsDomainClassProperty[] properties) {
        return this.evaluateConstraints(theClass, properties, false);
    }

    protected Map<String, Constrained> evaluateConstraints(Class<?> theClass, GrailsDomainClassProperty[] properties, boolean defaultNullable) {
        boolean javaEntity = theClass.isAnnotationPresent(Entity.class);
        LinkedList classChain = DefaultConstraintEvaluator.getSuperClassChain(theClass);
        ConstrainedPropertyBuilder delegate = new ConstrainedPropertyBuilder(theClass);
        for (Object aClassChain : classChain) {
            Class clazz = (Class)aClassChain;
            Closure c = (Closure)GrailsClassUtils.getStaticFieldValue((Class)clazz, (String)"constraints");
            if (c == null) {
                c = this.getConstraintsFromScript(theClass);
            }
            if (c != null) {
                c = (Closure)c.clone();
                c.setResolveStrategy(3);
                c.setDelegate((Object)delegate);
                c.call();
                continue;
            }
            LOG.debug((Object)("User-defined constraints not found on class [" + clazz + "], applying default constraints"));
        }
        Map<String, Constrained> constrainedProperties = delegate.getConstrainedProperties();
        if (!(properties == null || constrainedProperties.isEmpty() && javaEntity)) {
            for (GrailsDomainClassProperty p : properties) {
                if (!this.canPropertyBeConstrained(p)) continue;
                if (p.isDerived()) {
                    if (constrainedProperties.remove(p.getName()) == null) continue;
                    LOG.warn((Object)("Derived properties may not be constrained. Property [" + p.getName() + "] of domain class " + theClass.getName() + " will not be checked during validation."));
                    continue;
                }
                String propertyName = p.getName();
                Constrained cp = constrainedProperties.get(propertyName);
                if (cp == null) {
                    ConstrainedProperty constrainedProperty = new ConstrainedProperty(p.getDomainClass().getClazz(), propertyName, p.getType());
                    cp = constrainedProperty;
                    constrainedProperty.setOrder(constrainedProperties.size() + 1);
                    constrainedProperties.put(propertyName, cp);
                }
                this.applyDefaultConstraints(propertyName, p, cp, this.defaultConstraints);
            }
        }
        if (properties == null || properties.length == 0) {
            Set<Map.Entry<String, Constrained>> entrySet = constrainedProperties.entrySet();
            for (Map.Entry<String, Constrained> entry : entrySet) {
                Constrained constrainedProperty = entry.getValue();
                if (constrainedProperty.hasAppliedConstraint("nullable")) continue;
                this.applyDefaultNullableConstraint(constrainedProperty, defaultNullable);
            }
        }
        this.applySharedConstraints(delegate, constrainedProperties);
        return constrainedProperties;
    }

    protected void applySharedConstraints(ConstrainedPropertyBuilder constrainedPropertyBuilder, Map<String, Constrained> constrainedProperties) {
        for (Map.Entry<String, Constrained> entry : constrainedProperties.entrySet()) {
            String propertyName = entry.getKey();
            Constrained constrainedProperty = entry.getValue();
            String sharedConstraintReference = constrainedPropertyBuilder.getSharedConstraint(propertyName);
            if (sharedConstraintReference == null || this.defaultConstraints == null) continue;
            Object o = this.defaultConstraints.get(sharedConstraintReference);
            if (o instanceof Map) {
                Map constraintsWithinSharedConstraint = (Map)o;
                for (Map.Entry e : constraintsWithinSharedConstraint.entrySet()) {
                    constrainedProperty.applyConstraint((String)e.getKey(), e.getValue());
                }
                continue;
            }
            throw new GrailsConfigurationException("Property [" + constrainedProperty.getOwner().getName() + '.' + propertyName + "] references shared constraint [" + sharedConstraintReference + ":" + o + "], which doesn't exist!");
        }
    }

    protected boolean canPropertyBeConstrained(GrailsDomainClassProperty property) {
        return true;
    }

    public static LinkedList<?> getSuperClassChain(Class<?> theClass) {
        LinkedList classChain = new LinkedList();
        for (Class<?> clazz = theClass; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
            classChain.addFirst(clazz);
        }
        return classChain;
    }

    protected Closure<?> getConstraintsFromScript(Class<?> theClass) {
        String className = theClass.getName();
        String constraintsScript = className.replaceAll("\\.", "/") + "Constraints.groovy";
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(constraintsScript);
        if (stream != null) {
            GroovyClassLoader gcl = new GroovyClassLoader();
            try {
                Class scriptClass = gcl.parseClass(IOUtils.toString((InputStream)stream, (String)"UTF-8"));
                Script script = (Script)scriptClass.newInstance();
                script.run();
                Binding binding = script.getBinding();
                if (binding.getVariables().containsKey("constraints")) {
                    return (Closure)binding.getVariable("constraints");
                }
                LOG.warn((Object)("Unable to evaluate constraints from [" + constraintsScript + "], constraints closure not found!"));
                return null;
            }
            catch (CompilationFailedException e) {
                LOG.error((Object)("Compilation error evaluating constraints for class [" + className + "]: " + e.getMessage()), (Throwable)e);
                return null;
            }
            catch (InstantiationException e) {
                LOG.error((Object)("Instantiation error evaluating constraints for class [" + className + "]: " + e.getMessage()), (Throwable)e);
                return null;
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)("Illegal access error evaluating constraints for class [" + className + "]: " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    protected void applyDefaultConstraints(String propertyName, GrailsDomainClassProperty p, Constrained cp, Map<String, Object> defaultConstraints) {
        Object o;
        if (defaultConstraints != null && !defaultConstraints.isEmpty() && defaultConstraints.containsKey("*") && (o = defaultConstraints.get("*")) instanceof Map) {
            Map globalConstraints = (Map)o;
            this.applyMapOfConstraints(globalConstraints, propertyName, p, cp);
        }
        if (this.canApplyNullableConstraint(propertyName, p, cp)) {
            this.applyDefaultNullableConstraint(p, cp);
        }
    }

    protected void applyDefaultNullableConstraint(GrailsDomainClassProperty p, Constrained cp) {
        this.applyDefaultNullableConstraint(cp, false);
    }

    protected void applyDefaultNullableConstraint(Constrained cp, boolean defaultNullable) {
        boolean isCollection = Collection.class.isAssignableFrom(cp.getPropertyType()) || Map.class.isAssignableFrom(cp.getPropertyType());
        cp.applyConstraint("nullable", (Object)(isCollection || defaultNullable ? 1 : 0));
    }

    protected boolean canApplyNullableConstraint(String propertyName, GrailsDomainClassProperty property, Constrained constrained) {
        if (property == null || property.getType() == null) {
            return false;
        }
        GrailsDomainClass domainClass = property.getDomainClass();
        if (!GroovyObject.class.isAssignableFrom(domainClass.getClazz())) {
            return false;
        }
        GrailsDomainClassProperty versionProperty = domainClass.getVersion();
        boolean isVersion = versionProperty != null && versionProperty.equals(property);
        return !constrained.hasAppliedConstraint("nullable") && this.isConstrainableProperty(property, propertyName) && !property.isIdentity() && !isVersion && !property.isDerived();
    }

    protected void applyMapOfConstraints(Map<String, Object> constraints, String propertyName, GrailsDomainClassProperty p, Constrained cp) {
        for (Map.Entry<String, Object> entry : constraints.entrySet()) {
            String constraintName = entry.getKey();
            Object constrainingValue = entry.getValue();
            if (cp.hasAppliedConstraint(constraintName) || !cp.supportsContraint(constraintName)) continue;
            if ("nullable".equals(constraintName)) {
                if (!this.isConstrainableProperty(p, propertyName)) continue;
                cp.applyConstraint(constraintName, constrainingValue);
                continue;
            }
            cp.applyConstraint(constraintName, constrainingValue);
        }
    }

    protected boolean isConstrainableProperty(GrailsDomainClassProperty p, String propertyName) {
        return !propertyName.equals("dateCreated") && !propertyName.equals("lastUpdated") && (!p.isOneToOne() && !p.isManyToOne() || !p.isCircular());
    }

    public Map<String, Constrained> evaluate(Object object, GrailsDomainClassProperty[] properties) {
        return this.evaluateConstraints(object.getClass(), properties);
    }

    public Map<String, Constrained> evaluate(Class<?> cls, GrailsDomainClassProperty[] properties) {
        return this.evaluateConstraints(cls, properties);
    }
}

