/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import grails.util.GrailsNameUtils;
import grails.web.CamelCaseUrlConverter;
import grails.web.UrlConverter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.web.mapping.AbstractUrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMappingData;
import org.codehaus.groovy.grails.web.mapping.exceptions.UrlMappingException;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;

public class DefaultUrlMappingInfo
extends AbstractUrlMappingInfo {
    private Object controllerName;
    private Object actionName;
    private Object pluginName;
    private Object namespace;
    private Object redirectInfo;
    private Object id;
    private static final String ID_PARAM = "id";
    private UrlMappingData urlData;
    private Object viewName;
    private ServletContext servletContext;
    private static final String SETTING_GRAILS_WEB_DISABLE_MULTIPART = "grails.web.disable.multipart";
    private boolean parsingRequest;
    private Object uri;
    private UrlConverter urlConverter;
    private String httpMethod;
    private String version;

    private DefaultUrlMappingInfo(Map params, UrlMappingData urlData, ServletContext servletContext) {
        this.setParams(params);
        this.id = this.getParams().get(ID_PARAM);
        this.urlData = urlData;
        this.servletContext = servletContext;
        ApplicationContext applicationContext = null;
        if (servletContext != null) {
            applicationContext = WebUtils.findApplicationContext((ServletContext)servletContext);
        }
        this.urlConverter = applicationContext != null && applicationContext.containsBean("grailsUrlConverter") ? (UrlConverter)applicationContext.getBean("grailsUrlConverter", UrlConverter.class) : new CamelCaseUrlConverter();
    }

    public DefaultUrlMappingInfo(Object redirectInfo, Object controllerName, Object actionName, Object namespace, Object pluginName, Object viewName, Map params, UrlMappingData urlData, ServletContext servletContext) {
        this(redirectInfo, controllerName, actionName, namespace, pluginName, viewName, null, "*", params, urlData, servletContext);
    }

    public DefaultUrlMappingInfo(Object redirectInfo, Object controllerName, Object actionName, Object namespace, Object pluginName, Object viewName, String httpMethod, String version, Map<?, ?> params, UrlMappingData urlData, ServletContext servletContext) {
        this(params, urlData, servletContext);
        Assert.isTrue((redirectInfo != null || controllerName != null || viewName != null ? 1 : 0) != 0, (String)"URL mapping must either provide redirect information, a controller or a view name to map to!");
        Assert.notNull(params, (String)"Argument [params] cannot be null");
        this.controllerName = controllerName;
        this.actionName = actionName;
        this.pluginName = pluginName;
        this.namespace = namespace;
        this.httpMethod = httpMethod;
        this.version = version;
        this.redirectInfo = redirectInfo;
        if (actionName == null) {
            this.viewName = viewName;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public DefaultUrlMappingInfo(Object viewName, Map params, UrlMappingData urlData, ServletContext servletContext) {
        this(params, urlData, servletContext);
        this.viewName = viewName;
        Assert.notNull((Object)viewName, (String)"Argument [viewName] cannot be null or blank");
    }

    public DefaultUrlMappingInfo(Object uri, UrlMappingData data, ServletContext servletContext) {
        this(Collections.EMPTY_MAP, data, servletContext);
        this.uri = uri;
        Assert.notNull((Object)uri, (String)"Argument [uri] cannot be null or blank");
    }

    public DefaultUrlMappingInfo(Object uri, String httpMethod, UrlMappingData data, ServletContext servletContext) {
        this(Collections.EMPTY_MAP, data, servletContext);
        this.uri = uri;
        this.httpMethod = httpMethod;
        Assert.notNull((Object)uri, (String)"Argument [uri] cannot be null or blank");
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String toString() {
        return this.urlData.getUrlPattern();
    }

    public Map getParameters() {
        return this.getParams();
    }

    public boolean isParsingRequest() {
        return this.parsingRequest;
    }

    public void setParsingRequest(boolean parsingRequest) {
        this.parsingRequest = parsingRequest;
    }

    public String getPluginName() {
        return this.pluginName == null ? null : this.pluginName.toString();
    }

    public String getNamespace() {
        String name = this.evaluateNameForValue(this.namespace);
        return this.urlConverter.toUrlElement(name);
    }

    public String getControllerName() {
        String name = this.evaluateNameForValue(this.controllerName);
        if (name == null && this.getViewName() == null) {
            throw new UrlMappingException("Unable to establish controller name to dispatch for [" + this.controllerName + "]. Dynamic closure invocation returned null. Check your mapping file is correct, when assigning the controller name as a request parameter it cannot be an optional token!");
        }
        return this.urlConverter.toUrlElement(name);
    }

    public String getActionName() {
        String name;
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes();
        String string = name = webRequest == null ? null : this.checkDispatchAction(webRequest.getCurrentRequest());
        if (name == null) {
            name = this.evaluateNameForValue(this.actionName, webRequest);
        }
        return this.urlConverter.toUrlElement(name);
    }

    public String getViewName() {
        return this.evaluateNameForValue(this.viewName);
    }

    public String getId() {
        return this.evaluateNameForValue(this.id);
    }

    private String checkDispatchAction(HttpServletRequest request) {
        if (request.getAttribute("exception") != null) {
            return null;
        }
        String dispatchActionName = null;
        Enumeration<String> paramNames = this.tryMultipartParams(request, request.getParameterNames());
        while (paramNames.hasMoreElements()) {
            String name = paramNames.nextElement();
            if (!name.startsWith("_action_")) continue;
            if (name.endsWith(".x") || name.endsWith(".y")) {
                name = name.substring(0, name.length() - 2);
            }
            dispatchActionName = GrailsNameUtils.getPropertyNameRepresentation((String)name.substring("_action_".length()));
            break;
        }
        return dispatchActionName;
    }

    private Enumeration<String> tryMultipartParams(HttpServletRequest request, Enumeration<String> originalParams) {
        MultipartResolver resolver;
        Enumeration paramNames = originalParams;
        boolean disabled = this.getMultipartDisabled();
        if (!disabled && (resolver = this.getResolver()).isMultipart(request)) {
            MultipartHttpServletRequest resolvedMultipartRequest = this.getResolvedRequest(request, resolver);
            paramNames = resolvedMultipartRequest.getParameterNames();
        }
        return paramNames;
    }

    private MultipartHttpServletRequest getResolvedRequest(HttpServletRequest request, MultipartResolver resolver) {
        MultipartHttpServletRequest resolvedMultipartRequest = (MultipartHttpServletRequest)request.getAttribute(MultipartHttpServletRequest.class.getName());
        if (resolvedMultipartRequest == null) {
            resolvedMultipartRequest = resolver.resolveMultipart(request);
            request.setAttribute(MultipartHttpServletRequest.class.getName(), (Object)resolvedMultipartRequest);
        }
        return resolvedMultipartRequest;
    }

    private boolean getMultipartDisabled() {
        GrailsApplication app = WebUtils.lookupApplication((ServletContext)this.servletContext);
        Object disableMultipart = app.getFlatConfig().get(SETTING_GRAILS_WEB_DISABLE_MULTIPART);
        boolean disabled = false;
        if (disableMultipart instanceof Boolean) {
            disabled = (Boolean)disableMultipart;
        } else if (disableMultipart instanceof String) {
            disabled = Boolean.valueOf((String)disableMultipart);
        }
        return disabled;
    }

    private MultipartResolver getResolver() {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.servletContext);
        return (MultipartResolver)ctx.getBean("multipartResolver");
    }

    public String getURI() {
        return this.evaluateNameForValue(this.uri);
    }

    public Object getRedirectInfo() {
        return this.redirectInfo;
    }
}

