/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import groovy.lang.Script;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsUrlMappingsClass;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.PluginManagerAware;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.web.mapping.DefaultUrlMappingEvaluator;
import org.codehaus.groovy.grails.web.mapping.DefaultUrlMappings;
import org.codehaus.groovy.grails.web.mapping.DefaultUrlMappingsHolder;
import org.codehaus.groovy.grails.web.mapping.UrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlMappings;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public class UrlMappingsHolderFactoryBean
implements FactoryBean<UrlMappings>,
InitializingBean,
ApplicationContextAware,
GrailsApplicationAware,
PluginManagerAware {
    private static final String URL_MAPPING_CACHE_MAX_SIZE = "grails.urlmapping.cache.maxsize";
    private static final String URL_CREATOR_CACHE_MAX_SIZE = "grails.urlcreator.cache.maxsize";
    private GrailsApplication grailsApplication;
    private UrlMappings urlMappingsHolder;
    private GrailsPluginManager pluginManager;
    private ApplicationContext applicationContext;

    public UrlMappings getObject() throws Exception {
        return this.urlMappingsHolder;
    }

    public Class<UrlMappings> getObjectType() {
        return UrlMappings.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Integer urlCreatorCacheSize;
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"Property [applicationContext] must be set!");
        Assert.state((this.grailsApplication != null ? 1 : 0) != 0, (String)"Property [grailsApplication] must be set!");
        ArrayList<UrlMapping> urlMappings = new ArrayList<UrlMapping>();
        ArrayList excludePatterns = new ArrayList();
        GrailsClass[] mappings = this.grailsApplication.getArtefacts("UrlMappings");
        DefaultUrlMappingEvaluator mappingEvaluator = new DefaultUrlMappingEvaluator((WebApplicationContext)this.applicationContext);
        mappingEvaluator.setPluginManager(this.pluginManager);
        if (mappings.length == 0) {
            urlMappings.addAll(mappingEvaluator.evaluateMappings(DefaultUrlMappings.getMappings()));
        } else {
            for (GrailsClass mapping : mappings) {
                GrailsUrlMappingsClass mappingClass = (GrailsUrlMappingsClass)mapping;
                List<UrlMapping> grailsClassMappings = Script.class.isAssignableFrom(mappingClass.getClazz()) ? mappingEvaluator.evaluateMappings(mappingClass.getClazz()) : mappingEvaluator.evaluateMappings(mappingClass.getMappingsClosure());
                urlMappings.addAll(grailsClassMappings);
                if (mappingClass.getExcludePatterns() == null) continue;
                excludePatterns.addAll(mappingClass.getExcludePatterns());
            }
        }
        DefaultUrlMappingsHolder defaultUrlMappingsHolder = new DefaultUrlMappingsHolder(urlMappings, excludePatterns, true);
        Map flatConfig = this.grailsApplication.getFlatConfig();
        Integer cacheSize = UrlMappingsHolderFactoryBean.mapGetInteger(flatConfig, URL_MAPPING_CACHE_MAX_SIZE);
        if (cacheSize != null) {
            defaultUrlMappingsHolder.setMaxWeightedCacheCapacity(cacheSize);
        }
        if ((urlCreatorCacheSize = UrlMappingsHolderFactoryBean.mapGetInteger(flatConfig, URL_CREATOR_CACHE_MAX_SIZE)) != null) {
            defaultUrlMappingsHolder.setUrlCreatorMaxWeightedCacheCapacity(urlCreatorCacheSize);
        }
        defaultUrlMappingsHolder.initialize();
        this.urlMappingsHolder = defaultUrlMappingsHolder;
    }

    private static Integer mapGetInteger(Map map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return value instanceof Number ? ((Number)value).intValue() : Integer.valueOf(String.valueOf(value)).intValue();
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public void setServletContext(ServletContext servletContext) {
    }

    public void setPluginManager(GrailsPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.setGrailsApplication((GrailsApplication)applicationContext.getBean("grailsApplication", GrailsApplication.class));
        this.setServletContext(applicationContext instanceof WebApplicationContext ? ((WebApplicationContext)applicationContext).getServletContext() : null);
        this.setPluginManager(applicationContext.containsBean("pluginManager") ? (GrailsPluginManager)applicationContext.getBean("pluginManager", GrailsPluginManager.class) : null);
    }
}

