/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller.xml;

import grails.converters.XML;
import grails.persistence.Entity;
import grails.persistence.PersistenceMethod;
import grails.web.controllers.ControllerMethod;
import groovy.lang.GroovyObject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.IncludeExcludePropertyMarshaller;
import org.springframework.beans.BeanUtils;

public class GroovyBeanMarshaller
extends IncludeExcludePropertyMarshaller<XML> {
    @Override
    public boolean supports(Object object) {
        return object instanceof GroovyObject;
    }

    @Override
    public void marshalObject(Object o, XML xml) throws ConverterException {
        try {
            boolean isEntity = o.getClass().getAnnotation(Entity.class) != null;
            for (PropertyDescriptor property : BeanUtils.getPropertyDescriptors(o.getClass())) {
                Method readMethod;
                String name = property.getName();
                if (!this.shouldInclude(o, name) || isEntity && (name.equals("attached") || name.equals("errors")) || (readMethod = property.getReadMethod()) == null || name.equals("metaClass") || name.equals("class") || readMethod.getAnnotation(PersistenceMethod.class) != null || readMethod.getAnnotation(ControllerMethod.class) != null) continue;
                Object value = readMethod.invoke(o, (Object[])null);
                xml.startNode(name);
                xml.convertAnother(value);
                xml.end();
            }
            for (Field field : o.getClass().getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                String name = field.getName();
                if (isEntity && (name.equals("attached") || name.equals("errors"))) continue;
                xml.startNode(name);
                xml.convertAnother(field.get(o));
                xml.end();
            }
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConverterException("Error converting Bean with class " + o.getClass().getName(), e);
        }
    }
}

