/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller.json;

import grails.converters.JSON;
import grails.persistence.PersistenceMethod;
import grails.web.controllers.ControllerMethod;
import groovy.lang.GroovyObject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.IncludeExcludePropertyMarshaller;
import org.codehaus.groovy.grails.web.json.JSONWriter;
import org.springframework.beans.BeanUtils;

public class GroovyBeanMarshaller
extends IncludeExcludePropertyMarshaller<JSON> {
    @Override
    public boolean supports(Object object) {
        return object instanceof GroovyObject;
    }

    @Override
    public void marshalObject(Object o, JSON json) throws ConverterException {
        JSONWriter writer = json.getWriter();
        try {
            writer.object();
            for (PropertyDescriptor property : BeanUtils.getPropertyDescriptors(o.getClass())) {
                Method readMethod = property.getReadMethod();
                String name = property.getName();
                if (!this.shouldInclude(o, name) || readMethod == null || name.equals("metaClass") || name.equals("class") || readMethod.getAnnotation(PersistenceMethod.class) != null || readMethod.getAnnotation(ControllerMethod.class) != null) continue;
                Object value = readMethod.invoke(o, (Object[])null);
                writer.key(name);
                json.convertAnother(value);
            }
            for (Field field : o.getClass().getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                writer.key(field.getName());
                json.convertAnother(field.get(o));
            }
            writer.endObject();
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConverterException("Error converting Bean with class " + o.getClass().getName(), e);
        }
    }
}

