/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.converters.marshaller.json;

import grails.converters.JSON;
import groovy.lang.GroovyObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.support.proxy.DefaultProxyHandler;
import org.codehaus.groovy.grails.support.proxy.EntityProxyHandler;
import org.codehaus.groovy.grails.support.proxy.ProxyHandler;
import org.codehaus.groovy.grails.web.converters.ConverterUtil;
import org.codehaus.groovy.grails.web.converters.exceptions.ConverterException;
import org.codehaus.groovy.grails.web.converters.marshaller.IncludeExcludePropertyMarshaller;
import org.codehaus.groovy.grails.web.json.JSONWriter;
import org.springframework.beans.BeanWrapperImpl;

public class DomainClassMarshaller
extends IncludeExcludePropertyMarshaller<JSON> {
    private boolean includeVersion = false;
    private ProxyHandler proxyHandler;
    private GrailsApplication application;

    public DomainClassMarshaller(boolean includeVersion, GrailsApplication application) {
        this(includeVersion, (ProxyHandler)new DefaultProxyHandler(), application);
    }

    public DomainClassMarshaller(boolean includeVersion, ProxyHandler proxyHandler, GrailsApplication application) {
        this.includeVersion = includeVersion;
        this.proxyHandler = proxyHandler;
        this.application = application;
    }

    public boolean isIncludeVersion() {
        return this.includeVersion;
    }

    public void setIncludeVersion(boolean includeVersion) {
        this.includeVersion = includeVersion;
    }

    @Override
    public boolean supports(Object object) {
        String name = ConverterUtil.trimProxySuffix(object.getClass().getName());
        return this.application.isArtefactOfType("Domain", name);
    }

    @Override
    public void marshalObject(Object value, JSON json) throws ConverterException {
        GrailsDomainClassProperty[] properties;
        GrailsDomainClassProperty id;
        JSONWriter writer = json.getWriter();
        value = this.proxyHandler.unwrapIfProxy(value);
        Class<?> clazz = value.getClass();
        GrailsDomainClass domainClass = (GrailsDomainClass)this.application.getArtefact("Domain", ConverterUtil.trimProxySuffix(clazz.getName()));
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(value);
        writer.object();
        if (this.shouldInclude(domainClass, "class")) {
            writer.key("class").value((Object)domainClass.getClazz().getName());
        }
        if (this.shouldInclude(value, (id = domainClass.getIdentifier()).getName())) {
            Object idValue = this.extractValue(value, id);
            json.property("id", idValue);
        }
        if (this.shouldInclude(value, "version") && this.isIncludeVersion()) {
            GrailsDomainClassProperty versionProperty = domainClass.getVersion();
            Object version = this.extractValue(value, versionProperty);
            json.property("version", version);
        }
        for (GrailsDomainClassProperty property : properties = domainClass.getPersistentProperties()) {
            if (!this.shouldInclude(value, property.getName())) continue;
            writer.key(property.getName());
            if (!property.isAssociation()) {
                Object val = beanWrapper.getPropertyValue(property.getName());
                json.convertAnother(val);
                continue;
            }
            Cloneable referenceObject = beanWrapper.getPropertyValue(property.getName());
            if (this.isRenderDomainClassRelations()) {
                if (referenceObject == null) {
                    writer.value(null);
                    continue;
                }
                if ((referenceObject = this.proxyHandler.unwrapIfProxy((Object)referenceObject)) instanceof SortedMap) {
                    referenceObject = new TreeMap(referenceObject);
                } else if (referenceObject instanceof SortedSet) {
                    referenceObject = new TreeSet((SortedSet)((Object)referenceObject));
                } else if (referenceObject instanceof Set) {
                    referenceObject = new HashSet((Set)((Object)referenceObject));
                } else if (referenceObject instanceof Map) {
                    referenceObject = new HashMap(referenceObject);
                } else if (referenceObject instanceof Collection) {
                    referenceObject = new ArrayList((Collection)((Object)referenceObject));
                }
                json.convertAnother(referenceObject);
                continue;
            }
            if (referenceObject == null) {
                json.value(null);
                continue;
            }
            GrailsDomainClass referencedDomainClass = property.getReferencedDomainClass();
            if (referencedDomainClass == null || property.isEmbedded() || GrailsClassUtils.isJdk5Enum((Class)property.getType())) {
                json.convertAnother(referenceObject);
                continue;
            }
            if (property.isOneToOne() || property.isManyToOne() || property.isEmbedded()) {
                this.asShortObject(referenceObject, json, referencedDomainClass.getIdentifier(), referencedDomainClass);
                continue;
            }
            GrailsDomainClassProperty referencedIdProperty = referencedDomainClass.getIdentifier();
            String refPropertyName = referencedDomainClass.getPropertyName();
            if (referenceObject instanceof Collection) {
                Collection o = (Collection)((Object)referenceObject);
                writer.array();
                for (Object object : o) {
                    this.asShortObject(object, json, referencedIdProperty, referencedDomainClass);
                }
                writer.endArray();
                continue;
            }
            if (!(referenceObject instanceof Map)) continue;
            Map map = referenceObject;
            for (Map.Entry entry : map.entrySet()) {
                String key = String.valueOf(entry.getKey());
                Object o = entry.getValue();
                writer.object();
                writer.key(key);
                this.asShortObject(o, json, referencedIdProperty, referencedDomainClass);
                writer.endObject();
            }
        }
        writer.endObject();
    }

    protected void asShortObject(Object refObj, JSON json, GrailsDomainClassProperty idProperty, GrailsDomainClass referencedDomainClass) throws ConverterException {
        Object idValue;
        if (this.proxyHandler instanceof EntityProxyHandler) {
            idValue = ((EntityProxyHandler)this.proxyHandler).getProxyIdentifier(refObj);
            if (idValue == null) {
                idValue = this.extractValue(refObj, idProperty);
            }
        } else {
            idValue = this.extractValue(refObj, idProperty);
        }
        JSONWriter writer = json.getWriter();
        writer.object();
        writer.key("class").value((Object)referencedDomainClass.getName());
        writer.key("id").value(idValue);
        writer.endObject();
    }

    protected Object extractValue(Object domainObject, GrailsDomainClassProperty property) {
        if (domainObject instanceof GroovyObject) {
            return ((GroovyObject)domainObject).getProperty(property.getName());
        }
        ClassPropertyFetcher propertyFetcher = ClassPropertyFetcher.forClass(domainObject.getClass());
        return propertyFetcher.getPropertyValue(domainObject, property.getName());
    }

    protected boolean isRenderDomainClassRelations() {
        return false;
    }
}

