/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.metaclass;

import grails.async.Promise;
import grails.converters.JSON;
import grails.util.GrailsWebUtil;
import grails.web.JSONBuilder;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MissingMethodException;
import groovy.lang.Writable;
import groovy.text.Template;
import groovy.xml.StreamingMarkupBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.commons.metaclass.AbstractDynamicMethodInvocation;
import org.codehaus.groovy.grails.io.support.GrailsResourceUtils;
import org.codehaus.groovy.grails.plugins.GrailsPlugin;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.web.json.JSONElement;
import org.codehaus.groovy.grails.web.mime.MimeType;
import org.codehaus.groovy.grails.web.mime.MimeUtility;
import org.codehaus.groovy.grails.web.pages.GSPResponseWriter;
import org.codehaus.groovy.grails.web.pages.GroovyPageTemplate;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.servlet.mvc.ActionResultTransformer;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderDynamicMethod
extends AbstractDynamicMethodInvocation {
    public static final String METHOD_SIGNATURE = "render";
    public static final Pattern METHOD_PATTERN = Pattern.compile("^render$");
    public static final String ARGUMENT_TEXT = "text";
    public static final String ARGUMENT_STATUS = "status";
    public static final String ARGUMENT_LAYOUT = "layout";
    public static final String ARGUMENT_CONTENT_TYPE = "contentType";
    public static final String ARGUMENT_ENCODING = "encoding";
    public static final String ARGUMENT_VIEW = "view";
    public static final String ARGUMENT_MODEL = "model";
    public static final String ARGUMENT_TEMPLATE = "template";
    public static final String ARGUMENT_CONTEXTPATH = "contextPath";
    public static final String ARGUMENT_BEAN = "bean";
    public static final String ARGUMENT_COLLECTION = "collection";
    public static final String ARGUMENT_BUILDER = "builder";
    public static final String ARGUMENT_VAR = "var";
    private static final String DEFAULT_ARGUMENT = "it";
    private static final String BUILDER_TYPE_JSON = "json";
    private static final String TEXT_HTML = "text/html";
    public static final String DISPOSITION_HEADER_PREFIX = "attachment;filename=";
    private String gspEncoding = "utf-8";
    private static final String DEFAULT_ENCODING = "utf-8";
    private Object ARGUMENT_PLUGIN = "plugin";
    private static final String ARGUMENT_FILE = "file";
    private static final String ARGUMENT_FILE_NAME = "fileName";
    private MimeUtility mimeUtility;
    private Collection<ActionResultTransformer> actionResultTransformers;

    public RenderDynamicMethod() {
        super(METHOD_PATTERN);
    }

    public void setGspEncoding(String gspEncoding) {
        this.gspEncoding = gspEncoding;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(Object target, String methodName, Object[] arguments) {
        if (arguments.length == 0) {
            throw new MissingMethodException(METHOD_SIGNATURE, target.getClass(), arguments);
        }
        GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = webRequest.getCurrentResponse();
        boolean renderView = true;
        GroovyObject controller = (GroovyObject)target;
        if (arguments[0] instanceof CharSequence) {
            this.setContentType(response, TEXT_HTML, DEFAULT_ENCODING, true);
            CharSequence text = (CharSequence)arguments[0];
            renderView = this.renderText(text, response);
        } else if (arguments[0] instanceof Closure) {
            this.setContentType(response, TEXT_HTML, this.gspEncoding, true);
            Closure closure = (Closure)arguments[arguments.length - 1];
            renderView = this.renderMarkup(closure, response);
        } else {
            Object statusObj;
            if (!(arguments[0] instanceof Map)) throw new MissingMethodException(METHOD_SIGNATURE, target.getClass(), arguments);
            Map argMap = (Map)arguments[0];
            boolean hasContentType = argMap.containsKey(ARGUMENT_CONTENT_TYPE);
            Writer out = null;
            if (hasContentType) {
                out = this.getWriterForConfiguredContentType(response, argMap, hasContentType);
                webRequest.setOut(out);
            }
            if (argMap.containsKey(ARGUMENT_LAYOUT)) {
                webRequest.getCurrentRequest().setAttribute("org.grails.layout.name", argMap.get(ARGUMENT_LAYOUT));
            }
            boolean statusSet = false;
            if (argMap.containsKey(ARGUMENT_STATUS) && (statusObj = argMap.get(ARGUMENT_STATUS)) != null) {
                try {
                    response.setStatus(Integer.parseInt(statusObj.toString()));
                    statusSet = true;
                }
                catch (NumberFormatException e) {
                    throw new ControllerExecutionException("Argument [status] of method [render] must be a valid integer.");
                }
            }
            if (arguments[arguments.length - 1] instanceof Closure) {
                Closure callable = (Closure)arguments[arguments.length - 1];
                renderView = BUILDER_TYPE_JSON.equals(argMap.get(ARGUMENT_BUILDER)) || this.isJSONResponse(response) ? this.renderJSON(callable, response) : this.renderMarkup(callable, response);
            } else if (arguments[arguments.length - 1] instanceof CharSequence) {
                if (out == null) {
                    out = this.getWriterForConfiguredContentType(response, argMap, hasContentType);
                    webRequest.setOut(out);
                }
                CharSequence text = (CharSequence)arguments[arguments.length - 1];
                renderView = this.renderText(text, out);
            } else if (argMap.containsKey(ARGUMENT_TEXT)) {
                Object textArg;
                if (out == null) {
                    out = this.getWriterForConfiguredContentType(response, argMap, hasContentType);
                    webRequest.setOut(out);
                }
                CharSequence text = (textArg = argMap.get(ARGUMENT_TEXT)) instanceof CharSequence ? (CharSequence)textArg : textArg.toString();
                renderView = this.renderText(text, out);
            } else if (argMap.containsKey(ARGUMENT_VIEW)) {
                this.renderView(webRequest, argMap, target, controller, hasContentType);
            } else if (argMap.containsKey(ARGUMENT_TEMPLATE)) {
                if (out == null) {
                    out = this.getWriterForConfiguredContentType(response, argMap, hasContentType);
                    webRequest.setOut(out);
                }
                renderView = this.renderTemplate(target, controller, webRequest, argMap, out);
            } else if (argMap.containsKey(ARGUMENT_FILE)) {
                String fileName;
                renderView = false;
                Object o = argMap.get(ARGUMENT_FILE);
                Object fnO = argMap.get(ARGUMENT_FILE_NAME);
                String string = fnO != null ? fnO.toString() : (fileName = o instanceof File ? ((File)o).getName() : null);
                if (o != null) {
                    if (fileName != null) {
                        this.detectContentTypeFromFileName(webRequest, response, argMap, fileName, hasContentType);
                        if (fnO != null) {
                            response.setHeader("Content-Disposition", DISPOSITION_HEADER_PREFIX + fileName);
                        }
                    } else if (!hasContentType) {
                        throw new ControllerExecutionException("Argument [file] of render method specified without valid [contentType] argument");
                    }
                    InputStream input = null;
                    try {
                        if (o instanceof File) {
                            File f = (File)o;
                            input = FileUtils.openInputStream((File)f);
                        } else {
                            input = o instanceof InputStream ? (InputStream)o : (o instanceof byte[] ? new ByteArrayInputStream((byte[])o) : FileUtils.openInputStream((File)new File(o.toString())));
                        }
                        IOUtils.copy((InputStream)input, (OutputStream)response.getOutputStream());
                    }
                    catch (IOException e) {
                        throw new ControllerExecutionException("I/O error copying file to response: " + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            } else if (statusSet) {
                renderView = false;
            } else {
                Object object = arguments[0];
                if (object instanceof JSONElement) {
                    renderView = this.renderJSON((JSONElement)object, response);
                } else {
                    out = this.getWriterForConfiguredContentType(response, argMap, hasContentType);
                    webRequest.setOut(out);
                    renderView = this.renderObject(object, out);
                }
            }
            try {
                if (!renderView && out != null) {
                    out.flush();
                }
            }
            catch (IOException e) {
                throw new ControllerExecutionException("I/O error executing render method for arguments [" + argMap + "]: " + e.getMessage(), (Throwable)e);
            }
        }
        webRequest.setRenderView(renderView);
        return null;
    }

    private Writer getWriterForConfiguredContentType(HttpServletResponse response, Map argMap, boolean hasContentType) {
        GSPResponseWriter out;
        String contentType;
        String string = contentType = hasContentType ? argMap.get(ARGUMENT_CONTENT_TYPE).toString() : null;
        if (hasContentType && argMap.containsKey(ARGUMENT_ENCODING)) {
            String encoding = argMap.get(ARGUMENT_ENCODING).toString();
            this.setContentType(response, contentType, encoding);
            out = GSPResponseWriter.getInstance((ServletResponse)response);
        } else if (hasContentType) {
            this.setContentType(response, contentType, DEFAULT_ENCODING);
            out = GSPResponseWriter.getInstance((ServletResponse)response);
        } else {
            this.setContentType(response, TEXT_HTML, DEFAULT_ENCODING, true);
            out = GSPResponseWriter.getInstance((ServletResponse)response);
        }
        return out;
    }

    private boolean renderJSON(JSONElement object, HttpServletResponse response) {
        response.setContentType(GrailsWebUtil.getContentType((String)"application/json", (String)this.gspEncoding));
        return this.renderText((CharSequence)object.toString(), response);
    }

    private void detectContentTypeFromFileName(GrailsWebRequest webRequest, HttpServletResponse response, Map argMap, String fileName, boolean hasContentType) {
        if (hasContentType) {
            return;
        }
        MimeUtility mimeUtility = this.lookupMimeUtility(webRequest);
        if (mimeUtility != null) {
            MimeType mimeType = mimeUtility.getMimeTypeForExtension(FilenameUtils.getExtension((String)fileName));
            if (mimeType != null) {
                String contentType = mimeType.getName();
                Object encodingObj = argMap.get(ARGUMENT_ENCODING);
                String encoding = encodingObj != null ? encodingObj.toString() : DEFAULT_ENCODING;
                this.setContentType(response, contentType, encoding);
            } else {
                throw new ControllerExecutionException("Content type could not be determined for file: " + fileName);
            }
        }
    }

    private MimeUtility lookupMimeUtility(GrailsWebRequest webRequest) {
        ApplicationContext applicationContext;
        if (this.mimeUtility == null && (applicationContext = webRequest.getApplicationContext()) != null) {
            this.mimeUtility = (MimeUtility)applicationContext.getBean("grailsMimeUtility", MimeUtility.class);
        }
        return this.mimeUtility;
    }

    private boolean renderTemplate(Object target, GroovyObject controller, GrailsWebRequest webRequest, Map argMap, Writer out) {
        boolean renderView;
        boolean hasModel = argMap.containsKey(ARGUMENT_MODEL);
        Object modelObject = null;
        if (hasModel) {
            modelObject = argMap.get(ARGUMENT_MODEL);
        }
        String templateName = argMap.get(ARGUMENT_TEMPLATE).toString();
        String contextPath = this.getContextPath(webRequest, argMap);
        String var = null;
        if (argMap.containsKey(ARGUMENT_VAR)) {
            var = String.valueOf(argMap.get(ARGUMENT_VAR));
        }
        String templateUri = webRequest.getAttributes().getTemplateURI(controller, templateName);
        GroovyPagesTemplateEngine engine = webRequest.getAttributes().getPagesTemplateEngine();
        try {
            Template t = engine.createTemplateForUri(new String[]{GrailsResourceUtils.appendPiecesForUri((String[])new String[]{contextPath, templateUri}), GrailsResourceUtils.appendPiecesForUri((String[])new String[]{contextPath, "/grails-app/views/", templateUri})});
            if (t == null) {
                throw new ControllerExecutionException("Unable to load template for uri [" + templateUri + "]. Template not found.");
            }
            if (t instanceof GroovyPageTemplate) {
                ((GroovyPageTemplate)t).setAllowSettingContentType(true);
            }
            HashMap binding = new HashMap();
            if (argMap.containsKey(ARGUMENT_BEAN)) {
                Object bean = argMap.get(ARGUMENT_BEAN);
                if (hasModel && modelObject instanceof Map) {
                    this.setTemplateModel(webRequest, binding, modelObject);
                }
                this.renderTemplateForBean(t, binding, bean, var, out);
            } else if (argMap.containsKey(ARGUMENT_COLLECTION)) {
                Object colObject = argMap.get(ARGUMENT_COLLECTION);
                if (hasModel && modelObject instanceof Map) {
                    this.setTemplateModel(webRequest, binding, modelObject);
                }
                this.renderTemplateForCollection(t, binding, colObject, var, out);
            } else if (hasModel) {
                if (modelObject instanceof Map) {
                    this.setTemplateModel(webRequest, binding, modelObject);
                }
                this.renderTemplateForModel(t, modelObject, target, out);
            } else {
                Writable w = t.make((Map)new BeanMap(target));
                w.writeTo(out);
            }
            renderView = false;
        }
        catch (GroovyRuntimeException gre) {
            throw new ControllerExecutionException("Error rendering template [" + templateName + "]: " + gre.getMessage(), (Throwable)gre);
        }
        catch (IOException ioex) {
            throw new ControllerExecutionException("I/O error executing render method for arguments [" + argMap + "]: " + ioex.getMessage(), (Throwable)ioex);
        }
        return renderView;
    }

    protected Collection<ActionResultTransformer> getActionResultTransformers(GrailsWebRequest webRequest) {
        if (this.actionResultTransformers == null) {
            ApplicationContext applicationContext = webRequest.getApplicationContext();
            if (applicationContext != null) {
                this.actionResultTransformers = applicationContext.getBeansOfType(ActionResultTransformer.class).values();
            }
            if (this.actionResultTransformers == null) {
                this.actionResultTransformers = Collections.emptyList();
            }
        }
        return this.actionResultTransformers;
    }

    private void setTemplateModel(GrailsWebRequest webRequest, Map binding, Map modelObject) {
        Map modelMap = modelObject;
        webRequest.setAttribute("org.codehaus.groovy.grails.TEMPLATE_MODEL", (Object)modelMap, 0);
        binding.putAll(modelMap);
    }

    private String getContextPath(GrailsWebRequest webRequest, Map argMap) {
        ApplicationContext applicationContext;
        GrailsPluginManager pluginManager;
        GrailsPlugin plugin;
        Object cp = argMap.get(ARGUMENT_CONTEXTPATH);
        String contextPath = cp != null ? cp.toString() : "";
        Object pluginName = argMap.get(this.ARGUMENT_PLUGIN);
        if (pluginName != null && (plugin = (pluginManager = (GrailsPluginManager)(applicationContext = webRequest.getApplicationContext()).getBean("pluginManager")).getGrailsPlugin(pluginName.toString())) != null && !plugin.isBasePlugin()) {
            contextPath = plugin.getPluginPath();
        }
        return contextPath;
    }

    private void setContentType(HttpServletResponse response, String contentType, String encoding) {
        this.setContentType(response, contentType, encoding, false);
    }

    private void setContentType(HttpServletResponse response, String contentType, String encoding, boolean contentTypeIsDefault) {
        if (response.getContentType() == null || !contentTypeIsDefault) {
            response.setContentType(GrailsWebUtil.getContentType((String)contentType, (String)encoding));
        }
    }

    private boolean renderObject(Object object, Writer out) {
        boolean renderView;
        try {
            out.write(DefaultGroovyMethods.inspect((Object)object));
            renderView = false;
        }
        catch (IOException e) {
            throw new ControllerExecutionException("I/O error obtaining response writer: " + e.getMessage(), (Throwable)e);
        }
        return renderView;
    }

    private void renderTemplateForModel(Template template, Object modelObject, Object target, Writer out) throws IOException {
        if (modelObject instanceof Map) {
            template.make((Map)modelObject).writeTo(out);
        } else {
            template.make((Map)new BeanMap(target)).writeTo(out);
        }
    }

    private void renderTemplateForCollection(Template template, Map binding, Object colObject, String var, Writer out) throws IOException {
        if (colObject instanceof Collection) {
            Collection c = (Collection)colObject;
            for (Object o : c) {
                if (StringUtils.isBlank((String)var)) {
                    binding.put(DEFAULT_ARGUMENT, o);
                } else {
                    binding.put(var, o);
                }
                template.make(binding).writeTo(out);
            }
        } else {
            if (StringUtils.isBlank((String)var)) {
                binding.put(DEFAULT_ARGUMENT, colObject);
            } else {
                binding.put(var, colObject);
            }
            template.make(binding).writeTo(out);
        }
    }

    private void renderTemplateForBean(Template template, Map binding, Object bean, String varName, Writer out) throws IOException {
        if (StringUtils.isBlank((String)varName)) {
            binding.put(DEFAULT_ARGUMENT, bean);
        } else {
            binding.put(varName, bean);
        }
        template.make(binding).writeTo(out);
    }

    private void renderView(GrailsWebRequest webRequest, Map argMap, Object target, GroovyObject controller, boolean hasContentType) {
        String viewName = argMap.get(ARGUMENT_VIEW).toString();
        String viewUri = webRequest.getAttributes().getNoSuffixViewURI((GroovyObject)target, viewName);
        Object modelObject = argMap.get(ARGUMENT_MODEL);
        if (modelObject != null) {
            modelObject = argMap.get(ARGUMENT_MODEL);
            boolean isPromise = modelObject instanceof Promise;
            Collection<ActionResultTransformer> resultTransformers = this.getActionResultTransformers(webRequest);
            for (ActionResultTransformer resultTransformer : resultTransformers) {
                modelObject = resultTransformer.transformActionResult(webRequest, viewUri, modelObject);
            }
            if (isPromise) {
                return;
            }
        }
        this.getWriterForConfiguredContentType(webRequest.getResponse(), argMap, hasContentType);
        BeanMap model = modelObject instanceof Map ? (BeanMap)modelObject : (target instanceof GroovyObject ? new BeanMap(target) : new HashMap());
        controller.setProperty("modelAndView", (Object)new ModelAndView(viewUri, (Map)model));
    }

    private boolean renderJSON(Closure callable, HttpServletResponse response) {
        boolean renderView = true;
        JSONBuilder builder = new JSONBuilder();
        JSON json = builder.build(callable);
        json.render(response);
        renderView = false;
        return renderView;
    }

    private boolean renderMarkup(Closure closure, HttpServletResponse response) {
        StreamingMarkupBuilder b = new StreamingMarkupBuilder();
        b.setEncoding((Object)response.getCharacterEncoding());
        Writable markup = (Writable)b.bind((Object)closure);
        try {
            markup.writeTo((Writer)response.getWriter());
        }
        catch (IOException e) {
            throw new ControllerExecutionException("I/O error executing render method for arguments [" + closure + "]: " + e.getMessage(), (Throwable)e);
        }
        boolean renderView = false;
        return renderView;
    }

    private boolean renderText(CharSequence text, HttpServletResponse response) {
        try {
            PrintWriter writer = response.getWriter();
            return this.renderText(text, writer);
        }
        catch (IOException e) {
            throw new ControllerExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean renderText(CharSequence text, Writer writer) {
        try {
            if (writer instanceof PrintWriter) {
                ((PrintWriter)writer).print(text);
            } else {
                writer.write(((Object)text).toString());
            }
            return false;
        }
        catch (IOException e) {
            throw new ControllerExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isJSONResponse(HttpServletResponse response) {
        String contentType = response.getContentType();
        return contentType != null && (contentType.indexOf("application/json") > -1 || contentType.indexOf("text/json") > -1);
    }
}

