/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.web.support;

import javax.persistence.FlushModeType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreUtils;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

public class OpenSessionInViewInterceptor
implements WebRequestInterceptor {
    private static final Log LOG = LogFactory.getLog(OpenSessionInViewInterceptor.class);
    Datastore datastore;
    FlushModeType flushMode = FlushModeType.AUTO;

    public void setDatastore(Datastore datastore) {
        this.datastore = datastore;
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public void preHandle(WebRequest webRequest) throws Exception {
        if (this.hasSessionBound()) {
            return;
        }
        LOG.debug((Object)"Opening single Datastore Session in OpenSessionInViewInterceptor");
        Session session = DatastoreUtils.getSession((Datastore)this.datastore, (boolean)true);
        session.setFlushMode(this.flushMode);
        if (!this.hasSessionBound()) {
            DatastoreUtils.bindSession((Session)session);
        }
    }

    public void postHandle(WebRequest webRequest, ModelMap modelMap) throws Exception {
        if (!this.hasSessionBound()) {
            return;
        }
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.getDatastore());
        LOG.debug((Object)"Flushing single Datastore Session in OpenSessionInViewInterceptor");
        Session session = sessionHolder.getSession();
        if (session.getFlushMode() == FlushModeType.AUTO) {
            session.flush();
        }
    }

    protected boolean hasSessionBound() {
        return TransactionSynchronizationManager.getResource((Object)this.getDatastore()) != null;
    }

    public void afterCompletion(WebRequest webRequest, Exception e) throws Exception {
        if (!this.hasSessionBound()) {
            return;
        }
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource((Object)this.getDatastore());
        LOG.debug((Object)"Closing single Datastore Session in OpenSessionInViewInterceptor");
        DatastoreUtils.closeSession((Session)sessionHolder.getSession());
    }
}

