/*
 * Decompiled with CFR 0.152.
 */
package org.grails.io.support;

import grails.util.BuildSettings;
import groovy.lang.Closure;
import groovy.util.ConfigObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.io.support.DefaultResourceLoader;
import org.grails.io.support.FileSystemResource;
import org.grails.io.support.Resource;
import org.grails.io.support.UrlResource;

public class GrailsResourceUtils {
    public static final String CLASS_EXTENSION = ".class";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";
    private static final String FOLDER_SEPARATOR = "/";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_CODE_SOURCE = "code-source";
    public static final String WEB_INF = "/WEB-INF";
    public static final String GRAILS_APP_DIR = "grails-app";
    public static final String WEB_APP_DIR = "web-app";
    public static final String VIEWS_DIR_PATH = "grails-app/views/";
    public static final String VIEWS_DIR_PATH_NO_SLASH = "grails-app/views";
    public static final String DOMAIN_DIR_PATH = "grails-app/domain/";
    public static final String REGEX_FILE_SEPARATOR = "[\\\\/]";
    public static Pattern DOMAIN_PATH_PATTERN = Pattern.compile(".+[\\\\/]grails-app[\\\\/]domain[\\\\/](.+)\\.(groovy|java)");
    public static Pattern RESOURCE_PATH_PATTERN = Pattern.compile(".+?[\\\\/]grails-app[\\\\/](.+?)[\\\\/](.+?\\.(groovy|java))");
    public static Pattern SPRING_SCRIPTS_PATH_PATTERN = Pattern.compile(".+?[\\\\/]grails-app[\\\\/]conf[\\\\/]spring[\\\\/](.+?\\.groovy)");
    public static Pattern[] COMPILER_ROOT_PATTERNS = new Pattern[]{SPRING_SCRIPTS_PATH_PATTERN, RESOURCE_PATH_PATTERN};
    public static final Pattern GRAILS_RESOURCE_PATTERN_FIRST_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_SECOND_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_THIRD_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_FOURTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_FIFTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_SIXTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_SEVENTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_EIGHTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_NINTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_TENTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_ELEVENTH_MATCH;
    public static final Pattern[] patterns;
    public static final Pattern[] grailsAppResourcePatterns;
    private static Map<String, Boolean> KNOWN_PATHS;
    private static Map<String, Boolean> KNOWN_DOMAIN_CLASSES;
    private static final Pattern PLUGIN_PATTERN;
    private static final Pattern PLUGIN_RESOURCE_PATTERN;

    private static String createGrailsResourcePattern(String separator, String base) {
        return ".+" + separator + base + separator + "(.+)\\.(groovy|java)$";
    }

    public static boolean isDomainClass(URL url) {
        if (url == null) {
            return false;
        }
        return KNOWN_DOMAIN_CLASSES.get(url.getFile());
    }

    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String classPackageAsResourcePath(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(46);
        if (packageEndIndex == -1) {
            return "";
        }
        String packageName = className.substring(0, packageEndIndex);
        return packageName.replace('.', '/');
    }

    public static void useCachesIfNecessary(URLConnection con) {
        con.setUseCaches(con.getClass().getName().startsWith("JNLP"));
    }

    public static String getClassName(Resource resource) {
        try {
            return GrailsResourceUtils.getClassName(resource.getFile().getAbsolutePath());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getClassName(String path) {
        for (Pattern pattern : patterns) {
            Matcher m = pattern.matcher(path);
            if (!m.find()) continue;
            return m.group(1).replaceAll("[/\\\\]", CURRENT_PATH);
        }
        return null;
    }

    public static String getClassNameForClassFile(String rootDir, String path) {
        path = path.replace(FOLDER_SEPARATOR, CURRENT_PATH);
        path = path.replace('\\', '.');
        path = path.substring(0, path.length() - CLASS_EXTENSION.length());
        if (rootDir != null) {
            path = path.substring(rootDir.length());
        }
        return path;
    }

    public static File getFile(URL resourceUrl, String description) throws FileNotFoundException {
        if (!URL_PROTOCOL_FILE.equals(resourceUrl.getProtocol())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + String.valueOf(resourceUrl));
        }
        try {
            return new File(GrailsResourceUtils.toURI(resourceUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(resourceUrl.getFile());
        }
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol) || URL_PROTOCOL_CODE_SOURCE.equals(protocol) && url.getPath().contains(JAR_URL_SEPARATOR);
    }

    public static File getFile(URI resourceUri, String description) throws FileNotFoundException {
        if (!URL_PROTOCOL_FILE.equals(resourceUri.getScheme())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + String.valueOf(resourceUri));
        }
        return new File(resourceUri.getSchemeSpecificPart());
    }

    public static File getFile(URI resourceUri) throws FileNotFoundException {
        return GrailsResourceUtils.getFile(resourceUri, "URI");
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return GrailsResourceUtils.toURI(url.toString());
    }

    public static boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || protocol.startsWith(URL_PROTOCOL_VFS);
    }

    public static String applyRelativePath(String path, String relativePath) {
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (separatorIndex != -1) {
            Object newPath = path.substring(0, separatorIndex);
            if (!relativePath.startsWith(FOLDER_SEPARATOR)) {
                newPath = (String)newPath + FOLDER_SEPARATOR;
            }
            return (String)newPath + relativePath;
        }
        return relativePath;
    }

    public static String cleanPath(String path) {
        int i;
        if (path == null) {
            return null;
        }
        String pathToUse = GrailsResourceUtils.replace(path, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(":");
        Object prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            pathToUse = pathToUse.substring(prefixIndex + 1);
        }
        if (pathToUse.startsWith(FOLDER_SEPARATOR)) {
            prefix = (String)prefix + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = GrailsResourceUtils.delimitedListToStringArray(pathToUse, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        return (String)prefix + GrailsResourceUtils.collectionToDelimitedString(pathElements, FOLDER_SEPARATOR);
    }

    private static String collectionToDelimitedString(Collection<?> coll, String delim) {
        return GrailsResourceUtils.collectionToDelimitedString(coll, delim, "", "");
    }

    private static String collectionToDelimitedString(Collection<?> coll, String delim, String prefix, String suffix) {
        if (coll == null || coll.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    private static String[] delimitedListToStringArray(String str, String delimiter) {
        return GrailsResourceUtils.delimitedListToStringArray(str, delimiter, null);
    }

    private static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(delimiter)) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(GrailsResourceUtils.deleteAny(str.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(GrailsResourceUtils.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(GrailsResourceUtils.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return GrailsResourceUtils.toStringArray(result);
    }

    private static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    private static String deleteAny(String inString, String charsToDelete) {
        if (!GrailsResourceUtils.hasLength(inString) || !GrailsResourceUtils.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static String replace(String inString, String oldPattern, String newPattern) {
        if (!GrailsResourceUtils.hasLength(inString) || !GrailsResourceUtils.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    private static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static URL extractJarFileURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            Object jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL((String)jarFile);
            }
            catch (MalformedURLException ex) {
                if (!((String)jarFile).startsWith(FOLDER_SEPARATOR)) {
                    jarFile = FOLDER_SEPARATOR + (String)jarFile;
                }
                return new URL(FILE_URL_PREFIX + (String)jarFile);
            }
        }
        return jarUrl;
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(GrailsResourceUtils.replace(location, " ", "%20"));
    }

    public static boolean isGrailsPath(String path) {
        if (KNOWN_PATHS.containsKey(path)) {
            return KNOWN_PATHS.get(path);
        }
        for (Pattern grailsAppResourcePattern : grailsAppResourcePatterns) {
            Matcher m = grailsAppResourcePattern.matcher(path);
            if (!m.find()) continue;
            KNOWN_PATHS.put(path, true);
            return true;
        }
        KNOWN_PATHS.put(path, false);
        return false;
    }

    public static boolean isProjectSource(String path) {
        for (Pattern grailsAppResourcePattern : patterns) {
            Matcher m = grailsAppResourcePattern.matcher(path);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public static boolean isProjectSource(Resource r) {
        try {
            String file = r.getURL().getFile();
            return GrailsResourceUtils.isProjectSource(file) || file.endsWith("GrailsPlugin.groovy");
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isGrailsResource(Resource r) {
        try {
            String file = r.getURL().getFile();
            return GrailsResourceUtils.isGrailsPath(file) || file.endsWith("GrailsPlugin.groovy");
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Resource getViewsDir(Resource resource) {
        if (resource == null) {
            return null;
        }
        Resource appDir = GrailsResourceUtils.getAppDir(resource);
        if (appDir == null) {
            return null;
        }
        return appDir.createRelative("views");
    }

    public static Resource getAppDir(Resource resource) {
        if (resource == null) {
            return null;
        }
        try {
            File file;
            for (file = resource.getFile(); file != null && !file.getName().equals(GRAILS_APP_DIR); file = file.getParentFile()) {
            }
            if (file != null) {
                return new FileSystemResource(file.getAbsolutePath() + FOLDER_SEPARATOR);
            }
        }
        catch (IOException file) {
            // empty catch block
        }
        try {
            String url = resource.getURL().toString();
            int i = url.lastIndexOf(GRAILS_APP_DIR);
            if (i > -1) {
                url = url.substring(0, i + 10);
                return new UrlResource(url + FOLDER_SEPARATOR);
            }
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getRelativeInsideWebInf(Resource resource) {
        if (resource == null) {
            return null;
        }
        try {
            String url = resource.getURL().toString();
            int i = url.indexOf(WEB_INF);
            if (i > -1) {
                return url.substring(i);
            }
            Matcher m = PLUGIN_PATTERN.matcher(url);
            if (m.find()) {
                return WEB_INF + m.group(1);
            }
            i = url.lastIndexOf(GRAILS_APP_DIR);
            if (i > -1) {
                return "/WEB-INF/" + url.substring(i);
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public static String getStaticResourcePathForResource(Resource resource, String contextPath) {
        String url;
        if (contextPath == null) {
            contextPath = "";
        }
        if (resource == null) {
            return contextPath;
        }
        try {
            url = resource.getURL().toString();
        }
        catch (IOException e) {
            return contextPath;
        }
        Matcher m = PLUGIN_RESOURCE_PATTERN.matcher(url);
        if (m.find()) {
            return (String)(contextPath.length() > 0 ? contextPath + FOLDER_SEPARATOR : "") + m.group(1);
        }
        return contextPath;
    }

    public static String getPathFromRoot(String path) {
        for (Pattern COMPILER_ROOT_PATTERN : COMPILER_ROOT_PATTERNS) {
            Matcher m = COMPILER_ROOT_PATTERN.matcher(path);
            if (!m.find()) continue;
            return m.group(m.groupCount() - 1);
        }
        return null;
    }

    public static String getPathFromBaseDir(String path) {
        int i = path.indexOf("grails-app/");
        if (i > -1) {
            return path.substring(i + 11);
        }
        try {
            String basePath;
            File baseDir = BuildSettings.BASE_DIR;
            String string = basePath = baseDir != null ? baseDir.getCanonicalPath() : null;
            if (basePath != null) {
                String canonicalPath = new File(path).getCanonicalPath();
                return canonicalPath.contains(basePath) ? canonicalPath.substring(basePath.length() + 1) : canonicalPath;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String getArtefactDirectory(String path) {
        Matcher matcher;
        if (path != null && (matcher = RESOURCE_PATH_PATTERN.matcher(path)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String appendPiecesForUri(String ... pieces) {
        if (pieces == null || pieces.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(16 * pieces.length);
        int previous = 0;
        for (int i = 0; i < pieces.length; ++i) {
            String piece = pieces[i];
            if (piece == null || piece.length() <= 0) continue;
            int maxlen = piece.length();
            for (int j = 0; j < maxlen; ++j) {
                char current = piece.charAt(j);
                if (previous == 47 && current == '/') continue;
                builder.append(current);
                previous = current;
            }
            if (i + 1 >= pieces.length || previous == 47) continue;
            builder.append('/');
            previous = 47;
        }
        return builder.toString();
    }

    public static Object instantiateFromConfig(ConfigObject config, String configKey, String defaultClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, LinkageError {
        return GrailsResourceUtils.instantiateFromFlatConfig(config.flatten(), configKey, defaultClassName);
    }

    public static Object instantiateFromFlatConfig(Map<String, Object> flatConfig, String configKey, String defaultClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, LinkageError {
        String className = defaultClassName;
        Object configName = flatConfig.get(configKey);
        if (configName instanceof CharSequence) {
            className = configName.toString();
        }
        return GrailsResourceUtils.forName(className, DefaultResourceLoader.getDefaultClassLoader()).newInstance();
    }

    private static Class<?> forName(String className, ClassLoader defaultClassLoader) throws ClassNotFoundException {
        return defaultClassLoader.loadClass(className);
    }

    static {
        String fs = REGEX_FILE_SEPARATOR;
        GRAILS_RESOURCE_PATTERN_FIRST_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, GRAILS_APP_DIR + fs + "conf" + fs + "spring"));
        GRAILS_RESOURCE_PATTERN_THIRD_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, GRAILS_APP_DIR + fs + "[\\w-]+"));
        GRAILS_RESOURCE_PATTERN_SEVENTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "src" + fs + "main" + fs + "java"));
        GRAILS_RESOURCE_PATTERN_EIGHTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "src" + fs + "main" + fs + "groovy"));
        GRAILS_RESOURCE_PATTERN_NINTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "src" + fs + "test" + fs + "groovy"));
        GRAILS_RESOURCE_PATTERN_TENTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "src" + fs + "test" + fs + "java"));
        GRAILS_RESOURCE_PATTERN_ELEVENTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "src" + fs + "test" + fs + "functional"));
        GRAILS_RESOURCE_PATTERN_FIFTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "grails-tests"));
        fs = FOLDER_SEPARATOR;
        GRAILS_RESOURCE_PATTERN_SECOND_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, GRAILS_APP_DIR + fs + "conf" + fs + "spring"));
        GRAILS_RESOURCE_PATTERN_FOURTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, GRAILS_APP_DIR + fs + "[\\w-]+"));
        GRAILS_RESOURCE_PATTERN_SIXTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "grails-tests"));
        patterns = new Pattern[]{GRAILS_RESOURCE_PATTERN_FIRST_MATCH, GRAILS_RESOURCE_PATTERN_THIRD_MATCH, GRAILS_RESOURCE_PATTERN_SEVENTH_MATCH, GRAILS_RESOURCE_PATTERN_EIGHTH_MATCH, GRAILS_RESOURCE_PATTERN_FOURTH_MATCH, GRAILS_RESOURCE_PATTERN_FIFTH_MATCH, GRAILS_RESOURCE_PATTERN_SIXTH_MATCH, GRAILS_RESOURCE_PATTERN_NINTH_MATCH, GRAILS_RESOURCE_PATTERN_TENTH_MATCH, GRAILS_RESOURCE_PATTERN_ELEVENTH_MATCH};
        grailsAppResourcePatterns = new Pattern[]{GRAILS_RESOURCE_PATTERN_FIRST_MATCH, GRAILS_RESOURCE_PATTERN_THIRD_MATCH, GRAILS_RESOURCE_PATTERN_FOURTH_MATCH, GRAILS_RESOURCE_PATTERN_FIFTH_MATCH, GRAILS_RESOURCE_PATTERN_SIXTH_MATCH, GRAILS_RESOURCE_PATTERN_ELEVENTH_MATCH};
        KNOWN_PATHS = new LinkedHashMap<String, Boolean>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 100;
            }
        };
        KNOWN_DOMAIN_CLASSES = DefaultGroovyMethods.withDefault((Map)new LinkedHashMap<String, Boolean>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
                return this.size() > 100;
            }
        }, (Closure)new Closure(GrailsResourceUtils.class){

            public Object call(Object ... args) {
                String path = args[0].toString();
                return DOMAIN_PATH_PATTERN.matcher(path).find();
            }
        });
        PLUGIN_PATTERN = Pattern.compile(".+?(/plugins/.+?/grails-app/.+)");
        PLUGIN_RESOURCE_PATTERN = Pattern.compile(".+?/(plugins/.+?)/grails-app/.+");
    }
}

