/*
 * Decompiled with CFR 0.152.
 */
package grails.build.logging;

import grails.build.logging.ConsoleLogger;
import grails.util.Environment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import jline.Terminal;
import jline.TerminalFactory;
import jline.UnixTerminal;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.console.completer.CompletionHandler;
import jline.console.history.FileHistory;
import jline.console.history.History;
import jline.internal.Log;
import jline.internal.TerminalLineSettings;
import org.apache.tools.ant.BuildException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.codehaus.groovy.runtime.typehandling.NumberMath;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.grails.build.interactive.CandidateListCompletionHandler;
import org.grails.build.logging.GrailsConsoleErrorPrintStream;
import org.grails.build.logging.GrailsConsolePrintStream;

public class GrailsConsole
implements ConsoleLogger {
    private static GrailsConsole instance;
    public static final String ENABLE_TERMINAL = "grails.console.enable.terminal";
    public static final String ENABLE_INTERACTIVE = "grails.console.enable.interactive";
    public static final String LINE_SEPARATOR;
    public static final String CATEGORY_SEPARATOR = "|";
    public static final String PROMPT = "grails> ";
    public static final String SPACE = " ";
    public static final String ERROR = "Error";
    public static final String WARNING = "Warning";
    public static final String HISTORYFILE = ".grails_history";
    public static final String STACKTRACE_FILTERED_MESSAGE = " (NOTE: Stack trace has been filtered. Use --verbose to see entire trace.)";
    public static final String STACKTRACE_MESSAGE = " (Use --stacktrace to see the full trace)";
    public static final Character SECURE_MASK_CHAR;
    private PrintStream originalSystemOut;
    private PrintStream originalSystemErr;
    private StringBuilder maxIndicatorString;
    private int cursorMove = 1;
    private Thread shutdownHookThread;
    private Character defaultInputMask = null;
    private boolean verbose = Boolean.getBoolean("grails.verbose");
    private boolean stacktrace = Boolean.getBoolean("grails.show.stacktrace");
    private boolean progressIndicatorActive = false;
    String indicator = ".";
    String lastMessage = "";
    Ansi lastStatus = null;
    ConsoleReader reader;
    Terminal terminal;
    PrintStream out;
    PrintStream err;
    History history;
    Stack<String> category = new Stack<String>(){

        @Override
        public String toString() {
            if (this.size() == 1) {
                return (String)this.peek() + GrailsConsole.CATEGORY_SEPARATOR;
            }
            return DefaultGroovyMethods.join((Iterable)this, (String)GrailsConsole.CATEGORY_SEPARATOR) + GrailsConsole.CATEGORY_SEPARATOR;
        }
    };
    private boolean ansiEnabled = true;
    private boolean userInputActive;
    private boolean appendCalled = false;

    public void addShutdownHook() {
        if (!Environment.isFork()) {
            this.shutdownHookThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    GrailsConsole.this.beforeShutdown();
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        }
    }

    public void removeShutdownHook() {
        if (this.shutdownHookThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
        }
    }

    protected GrailsConsole() throws IOException {
        this.initialize(System.in, System.out, System.err);
        this.maxIndicatorString = new StringBuilder(this.indicator).append(this.indicator).append(this.indicator).append(this.indicator).append(this.indicator);
    }

    public void reinitialize(InputStream systemIn, PrintStream systemOut, PrintStream systemErr) throws IOException {
        if (this.reader != null) {
            this.reader.shutdown();
        }
        this.initialize(systemIn, systemOut, systemErr);
    }

    protected void initialize(InputStream systemIn, PrintStream systemOut, PrintStream systemErr) throws IOException {
        this.bindSystemOutAndErr(systemOut, systemErr);
        this.redirectSystemOutAndErr(true);
        System.setProperty("jline.shutdownhook", "false");
        if (this.isInteractiveEnabled()) {
            this.reader = this.createConsoleReader(systemIn);
            this.reader.setBellEnabled(false);
            this.reader.setCompletionHandler((CompletionHandler)new CandidateListCompletionHandler());
            if (this.isActivateTerminal()) {
                this.terminal = this.createTerminal();
            }
            this.history = this.prepareHistory();
            if (this.history != null) {
                this.reader.setHistory(this.history);
            }
        } else if (this.isActivateTerminal()) {
            this.terminal = this.createTerminal();
        }
    }

    protected void bindSystemOutAndErr(PrintStream systemOut, PrintStream systemErr) {
        this.originalSystemOut = this.unwrapPrintStream(systemOut);
        this.out = this.wrapInPrintStream(this.originalSystemOut);
        this.originalSystemErr = this.unwrapPrintStream(systemErr);
        this.err = this.wrapInPrintStream(this.originalSystemErr);
    }

    private PrintStream unwrapPrintStream(PrintStream printStream) {
        if (printStream instanceof GrailsConsolePrintStream) {
            return ((GrailsConsolePrintStream)printStream).getTargetOut();
        }
        if (printStream instanceof GrailsConsoleErrorPrintStream) {
            return ((GrailsConsoleErrorPrintStream)printStream).getTargetOut();
        }
        return printStream;
    }

    private PrintStream wrapInPrintStream(PrintStream printStream) {
        OutputStream ansiWrapped = this.ansiWrap(printStream);
        if (ansiWrapped instanceof PrintStream) {
            return (PrintStream)ansiWrapped;
        }
        return new PrintStream(ansiWrapped, true);
    }

    public PrintStream getErr() {
        return this.err;
    }

    public void setErr(PrintStream err) {
        this.err = err;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public boolean isInteractiveEnabled() {
        return this.readPropOrTrue(ENABLE_INTERACTIVE);
    }

    private boolean isActivateTerminal() {
        return this.readPropOrTrue(ENABLE_TERMINAL);
    }

    private boolean readPropOrTrue(String prop) {
        String property = System.getProperty(prop);
        return property == null ? true : Boolean.valueOf(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConsoleReader createConsoleReader(InputStream systemIn) throws IOException {
        PrintStream nullOutput = new PrintStream(new ByteArrayOutputStream());
        PrintStream originalOut = Log.getOutput();
        try {
            Log.setOutput((PrintStream)nullOutput);
            ConsoleReader consoleReader = new ConsoleReader(systemIn, (OutputStream)this.out);
            consoleReader.setExpandEvents(false);
            ConsoleReader consoleReader2 = consoleReader;
            return consoleReader2;
        }
        finally {
            Log.setOutput((PrintStream)originalOut);
        }
    }

    protected Terminal createTerminal() {
        this.terminal = TerminalFactory.create();
        if (this.isWindows()) {
            this.terminal.setEchoEnabled(true);
        }
        return this.terminal;
    }

    public void resetCompleters() {
        ConsoleReader reader = this.getReader();
        if (reader != null) {
            Collection completers = reader.getCompleters();
            for (Completer completer : completers) {
                reader.removeCompleter(completer);
            }
            completers = reader.getCompleters();
            for (Completer completer : completers) {
                reader.removeCompleter(completer);
            }
        }
    }

    protected History prepareHistory() throws IOException {
        File file = new File(System.getProperty("user.home"), HISTORYFILE);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file.canWrite() ? new FileHistory(file) : null;
    }

    protected OutputStream ansiWrap(OutputStream out) {
        return AnsiConsole.wrapOutputStream((OutputStream)out);
    }

    public boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
    }

    public static synchronized GrailsConsole getInstance() {
        if (instance == null) {
            try {
                GrailsConsole console = GrailsConsole.createInstance();
                console.addShutdownHook();
                GrailsConsole.setInstance(console);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot create grails console: " + e.getMessage(), e);
            }
        }
        return instance;
    }

    public static synchronized void removeInstance() {
        if (instance != null) {
            instance.removeShutdownHook();
            instance.restoreOriginalSystemOutAndErr();
            if (instance.getReader() != null) {
                instance.getReader().shutdown();
            }
            instance = null;
        }
    }

    public void beforeShutdown() {
        this.persistHistory();
        this.restoreTerminal();
    }

    protected void restoreTerminal() {
        try {
            this.terminal.restore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.terminal instanceof UnixTerminal) {
            try {
                new TerminalLineSettings().set("sane");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void persistHistory() {
        if (this.history instanceof Flushable) {
            try {
                ((Flushable)this.history).flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void setInstance(GrailsConsole newConsole) {
        instance = newConsole;
        instance.redirectSystemOutAndErr(false);
    }

    protected void redirectSystemOutAndErr(boolean force) {
        if (force || !(System.out instanceof GrailsConsolePrintStream)) {
            System.setOut(new GrailsConsolePrintStream(this.out));
        }
        if (force || !(System.err instanceof GrailsConsoleErrorPrintStream)) {
            System.setErr(new GrailsConsoleErrorPrintStream(this.err));
        }
    }

    public static GrailsConsole createInstance() throws IOException {
        String className = System.getProperty("grails.console.class");
        if (className != null) {
            try {
                Class<?> klass = Class.forName(className);
                return (GrailsConsole)klass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new GrailsConsole();
    }

    public void setAnsiEnabled(boolean ansiEnabled) {
        this.ansiEnabled = ansiEnabled;
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            System.setProperty("grails.full.stacktrace", "true");
        }
        this.verbose = verbose;
    }

    public void setStacktrace(boolean stacktrace) {
        this.stacktrace = stacktrace;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isStacktrace() {
        return this.stacktrace;
    }

    public InputStream getInput() {
        this.assertAllowInput();
        return this.reader.getInput();
    }

    private void assertAllowInput() {
        this.assertAllowInput(null);
    }

    private void assertAllowInput(String prompt) {
        if (this.reader == null) {
            Object msg = "User input is not enabled, cannot obtain input stream";
            if (prompt != null) {
                msg = (String)msg + " - while trying: " + prompt;
            }
            throw new IllegalStateException((String)msg);
        }
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public void setLastMessage(String lastMessage) {
        this.lastMessage = lastMessage;
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public Stack<String> getCategory() {
        return this.category;
    }

    @Override
    public void indicateProgress() {
        this.verifySystemOut();
        this.progressIndicatorActive = true;
        if (this.isAnsiEnabled()) {
            if (this.lastMessage != null && this.lastMessage.length() > 0 && !this.lastMessage.contains(this.maxIndicatorString)) {
                this.updateStatus(this.lastMessage + this.indicator);
            }
        } else {
            this.out.print(this.indicator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indicateProgress(int number, int total) {
        this.progressIndicatorActive = true;
        String currMsg = this.lastMessage;
        try {
            this.updateStatus(currMsg + SPACE + number + " of " + total);
        }
        finally {
            this.lastMessage = currMsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indicateProgressPercentage(long number, long total) {
        this.verifySystemOut();
        this.progressIndicatorActive = true;
        String currMsg = this.lastMessage;
        try {
            int percentage = Math.round(NumberMath.multiply((Number)NumberMath.divide((Number)number, (Number)total), (Number)100).floatValue());
            if (!this.isAnsiEnabled()) {
                this.out.print("..");
                this.out.print(percentage + 37);
            } else {
                this.updateStatus(currMsg + SPACE + percentage + "%");
            }
        }
        finally {
            this.lastMessage = currMsg;
        }
    }

    @Override
    public void indicateProgress(int number) {
        this.verifySystemOut();
        this.progressIndicatorActive = true;
        String currMsg = this.lastMessage;
        try {
            if (this.isAnsiEnabled()) {
                this.updateStatus(currMsg + SPACE + number);
            } else {
                this.out.print("..");
                this.out.print(number);
            }
        }
        finally {
            this.lastMessage = currMsg;
        }
    }

    @Override
    public void updateStatus(String msg) {
        this.outputMessage(msg, 1);
    }

    private void outputMessage(String msg, int replaceCount) {
        this.verifySystemOut();
        if (msg == null || msg.trim().length() == 0) {
            return;
        }
        try {
            if (this.isAnsiEnabled()) {
                if (replaceCount > 0) {
                    this.out.print(this.erasePreviousLine(CATEGORY_SEPARATOR));
                }
                this.lastStatus = this.outputCategory(Ansi.ansi(), CATEGORY_SEPARATOR).fg(Ansi.Color.DEFAULT).a(msg).reset();
                this.out.println(this.lastStatus);
                if (!this.userInputActive) {
                    this.cursorMove = replaceCount;
                }
            } else {
                if (this.lastMessage != null && this.lastMessage.equals(msg)) {
                    return;
                }
                if (this.progressIndicatorActive) {
                    this.out.println();
                }
                this.out.print(CATEGORY_SEPARATOR);
                this.out.println(msg);
            }
            this.lastMessage = msg;
        }
        finally {
            this.postPrintMessage();
        }
    }

    private Ansi moveDownToSkipPrompt() {
        return Ansi.ansi().cursorDown(1).cursorLeft(PROMPT.length());
    }

    private void postPrintMessage() {
        this.progressIndicatorActive = false;
        this.appendCalled = false;
        if (this.userInputActive) {
            this.showPrompt();
        }
    }

    @Override
    public void addStatus(String msg) {
        this.outputMessage(msg, 0);
        this.lastMessage = "";
    }

    @Override
    public void error(String msg) {
        this.error(ERROR, msg);
    }

    @Override
    public void warning(String msg) {
        this.error(WARNING, msg);
    }

    @Override
    public void warn(String msg) {
        this.warning(msg);
    }

    private void logSimpleError(String msg) {
        this.verifySystemOut();
        if (this.progressIndicatorActive) {
            this.out.println();
        }
        this.out.println(CATEGORY_SEPARATOR);
        this.out.println(msg);
    }

    public boolean isAnsiEnabled() {
        return Ansi.isEnabled() && this.terminal != null && this.terminal.isAnsiSupported() && this.ansiEnabled;
    }

    @Override
    public void error(String msg, Throwable error) {
        try {
            if ((this.verbose || this.stacktrace) && error != null) {
                this.printStackTrace(msg, error);
                this.error(ERROR, msg);
            } else {
                this.error(ERROR, msg + STACKTRACE_MESSAGE);
            }
        }
        finally {
            this.postPrintMessage();
        }
    }

    @Override
    public void error(Throwable error) {
        this.printStackTrace(null, error);
    }

    private void printStackTrace(String message, Throwable error) {
        if (error instanceof BuildException && error.getCause() != null) {
            error = error.getCause();
        }
        if (!this.isVerbose() && !Boolean.getBoolean("grails.full.stacktrace")) {
            StackTraceUtils.deepSanitize((Throwable)error);
        }
        StringWriter sw = new StringWriter();
        PrintWriter ps = new PrintWriter(sw);
        Object object = message = message == null ? error.getMessage() : message;
        if (!this.isVerbose()) {
            message = (String)message + STACKTRACE_FILTERED_MESSAGE;
        }
        ps.println((String)message);
        error.printStackTrace(ps);
        this.error(sw.toString());
    }

    @Override
    public void log(String msg) {
        this.verifySystemOut();
        PrintStream printStream = this.out;
        try {
            if (this.userInputActive) {
                this.erasePrompt(printStream);
            }
            if (msg.endsWith(LINE_SEPARATOR)) {
                printStream.print(msg);
            } else {
                printStream.println(msg);
            }
            this.cursorMove = 0;
        }
        finally {
            printStream.flush();
            this.postPrintMessage();
        }
    }

    private void erasePrompt(PrintStream printStream) {
        printStream.print(Ansi.ansi().eraseLine(Ansi.Erase.BACKWARD).cursorLeft(PROMPT.length()));
    }

    public void append(String msg) {
        this.verifySystemOut();
        PrintStream printStream = this.out;
        try {
            if (this.userInputActive && !this.appendCalled) {
                printStream.print(this.moveDownToSkipPrompt());
                this.appendCalled = true;
            }
            if (msg.endsWith(LINE_SEPARATOR)) {
                printStream.print(msg);
            } else {
                printStream.println(msg);
            }
            this.cursorMove = 0;
        }
        finally {
            this.progressIndicatorActive = false;
        }
    }

    @Override
    public void info(String msg) {
        this.log(msg);
    }

    @Override
    public void verbose(String msg) {
        this.verifySystemOut();
        try {
            if (this.verbose) {
                this.out.println(msg);
                this.cursorMove = 0;
            }
        }
        finally {
            this.postPrintMessage();
        }
    }

    public void echoStatus() {
        if (this.lastStatus != null) {
            this.updateStatus(this.lastStatus.toString());
        }
    }

    public String userInput(String msg) {
        return this.doUserInput(msg, false);
    }

    public String secureUserInput(String msg) {
        return this.doUserInput(msg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doUserInput(String msg, boolean secure) {
        if (!((String)msg).endsWith(SPACE) && !((String)msg).endsWith("\t")) {
            msg = (String)msg + SPACE;
        }
        this.lastMessage = "";
        msg = this.isAnsiEnabled() ? this.outputCategory(Ansi.ansi(), ">").fg(Ansi.Color.DEFAULT).a((String)msg).reset().toString() : msg;
        try {
            String string = this.readLine((String)msg, secure);
            return string;
        }
        finally {
            this.cursorMove = 0;
        }
    }

    private String showPrompt(String prompt) {
        this.verifySystemOut();
        this.cursorMove = 0;
        if (!this.userInputActive) {
            return this.readLine(prompt, false);
        }
        this.out.print(prompt);
        this.out.flush();
        return null;
    }

    private String readLine(String prompt, boolean secure) {
        this.assertAllowInput(prompt);
        this.userInputActive = true;
        try {
            Character inputMask = secure ? SECURE_MASK_CHAR : this.defaultInputMask;
            String string = this.reader.readLine(prompt, inputMask);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading input: " + e.getMessage());
        }
        finally {
            this.userInputActive = false;
        }
    }

    public String showPrompt() {
        String prompt = this.isAnsiEnabled() ? this.ansiPrompt(PROMPT).toString() : PROMPT;
        return this.showPrompt(prompt);
    }

    private Ansi ansiPrompt(String prompt) {
        return Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).fg(Ansi.Color.YELLOW).a(prompt).a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT);
    }

    public String userInput(String message, List<String> validResponses) {
        return this.userInput(message, validResponses.toArray(new String[validResponses.size()]));
    }

    public String userInput(String message, String[] validResponses) {
        if (validResponses == null) {
            return this.userInput(message);
        }
        String question = this.createQuestion(message, validResponses);
        String response = this.userInput(question);
        for (String validResponse : validResponses) {
            if (!validResponse.equalsIgnoreCase(response)) continue;
            return response;
        }
        this.cursorMove = 0;
        return this.userInput("Invalid input. Must be one of ", validResponses);
    }

    private String createQuestion(String message, String[] validResponses) {
        return message + "[" + DefaultGroovyMethods.join((Object[])validResponses, (String)",") + "] ";
    }

    private Ansi outputCategory(Ansi ansi, String categoryName) {
        return ansi.a(Ansi.Attribute.INTENSITY_BOLD).fg(Ansi.Color.YELLOW).a(categoryName).a(SPACE).a(Ansi.Attribute.INTENSITY_BOLD_OFF);
    }

    private Ansi outputErrorLabel(Ansi ansi, String label) {
        return ansi.a(Ansi.Attribute.INTENSITY_BOLD).fg(Ansi.Color.RED).a(CATEGORY_SEPARATOR).a(SPACE).a(label).a(SPACE).a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT);
    }

    private Ansi erasePreviousLine(String categoryName) {
        int cursorMove = this.cursorMove;
        if (this.userInputActive) {
            ++cursorMove;
        }
        if (cursorMove > 0) {
            int moveLeftLength = categoryName.length() + this.lastMessage.length();
            if (this.userInputActive) {
                moveLeftLength += PROMPT.length();
            }
            return Ansi.ansi().cursorUp(cursorMove).cursorLeft(moveLeftLength).eraseLine(Ansi.Erase.FORWARD);
        }
        return Ansi.ansi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(String label, String message) {
        this.verifySystemOut();
        if (message == null) {
            return;
        }
        this.cursorMove = 0;
        try {
            if (this.isAnsiEnabled()) {
                Ansi ansi = this.outputErrorLabel(this.userInputActive ? this.moveDownToSkipPrompt() : Ansi.ansi(), label).a(message).reset();
                if (message.endsWith(LINE_SEPARATOR)) {
                    this.out.print(ansi);
                } else {
                    this.out.println(ansi);
                }
            } else {
                this.out.print(label);
                this.out.print(SPACE);
                this.logSimpleError(message);
            }
        }
        finally {
            this.postPrintMessage();
        }
    }

    private void verifySystemOut() {
        this.redirectSystemOutAndErr(false);
    }

    public void restoreOriginalSystemOutAndErr() {
        System.setOut(this.originalSystemOut);
        System.setErr(this.originalSystemErr);
    }

    public void cleanlyExit(int status) {
        this.flush();
        System.exit(status);
    }

    public void flush() {
        if (this.isAnsiEnabled()) {
            this.out.print(Ansi.ansi().reset().toString());
        }
        this.out.flush();
    }

    public Character getDefaultInputMask() {
        return this.defaultInputMask;
    }

    public void setDefaultInputMask(Character defaultInputMask) {
        this.defaultInputMask = defaultInputMask;
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
        SECURE_MASK_CHAR = new Character('*');
    }
}

