/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import grails.util.BuildSettings;
import grails.util.BuildSettingsHolder;
import grails.util.CollectionUtils;
import grails.util.Holder;
import grails.util.Metadata;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import java.util.Locale;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Environment {
    DEVELOPMENT,
    PRODUCTION,
    TEST,
    APPLICATION,
    CUSTOM;

    public static String KEY;
    public static String RELOAD_ENABLED;
    public static final String RELOAD_LOCATION = "grails.reload.location";
    public static final String INTERACTIVE_MODE_ENABLED = "grails.interactive.mode.enabled";
    public static final String DEFAULT = "grails.env.default";
    public static final String INITIALIZING = "grails.env.initializing";
    private static final String PRODUCTION_ENV_SHORT_NAME = "prod";
    private static final String DEVELOPMENT_ENVIRONMENT_SHORT_NAME = "dev";
    private static final String TEST_ENVIRONMENT_SHORT_NAME = "test";
    private static Map<String, String> envNameMappings;
    private static Holder<Environment> cachedCurrentEnvironment;
    private static final boolean cachedHasGrailsHome;
    private static boolean initializingState;
    private String name;

    private Environment() {
        this.initialize();
    }

    private void initialize() {
        this.name = this.toString().toLowerCase(Locale.ENGLISH);
    }

    public static Environment getCurrent() {
        Environment current = cachedCurrentEnvironment.get();
        if (current != null) {
            return current;
        }
        return Environment.resolveCurrentEnvironment();
    }

    private static Environment resolveCurrentEnvironment() {
        Environment env;
        String envName = System.getProperty(KEY);
        if (Environment.isBlank(envName)) {
            Metadata metadata = Metadata.getCurrent();
            if (metadata != null) {
                envName = metadata.getEnvironment();
            }
            if (Environment.isBlank(envName)) {
                return DEVELOPMENT;
            }
        }
        if ((env = Environment.getEnvironment(envName)) == null) {
            try {
                env = Environment.valueOf(envName.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (env == null) {
            env = CUSTOM;
            env.setName(envName);
        }
        return env;
    }

    public static void cacheCurrentEnvironment() {
        cachedCurrentEnvironment.set(Environment.resolveCurrentEnvironment());
    }

    public static Environment getCurrentEnvironment() {
        return Environment.getCurrent();
    }

    public static boolean isDevelopmentMode() {
        return Environment.getCurrent() == DEVELOPMENT && !Metadata.getCurrent().isWarDeployed() && cachedHasGrailsHome;
    }

    public static boolean isWarDeployed() {
        return Metadata.getCurrent().isWarDeployed();
    }

    public static boolean isFork() {
        return Boolean.getBoolean("grails.fork.active");
    }

    public static boolean isWithinShell() {
        return DefaultGroovyMethods.getRootLoader((ClassLoader)Environment.class.getClassLoader()) != null;
    }

    public static boolean isSystemSet() {
        return System.getProperty(KEY) != null;
    }

    public static Environment getEnvironment(String shortName) {
        String envName = envNameMappings.get(shortName);
        if (envName != null) {
            return Environment.valueOf(envName.toUpperCase());
        }
        return null;
    }

    public static Closure<?> getEnvironmentSpecificBlock(Closure<?> closure) {
        Environment env = Environment.getCurrent();
        return Environment.getEnvironmentSpecificBlock(env, closure);
    }

    public static Closure<?> getEnvironmentSpecificBlock(Environment env, Closure<?> closure) {
        if (closure == null) {
            return null;
        }
        EnvironmentBlockEvaluator evaluator = Environment.evaluateEnvironmentSpecificBlock(env, closure);
        return evaluator.getCallable();
    }

    public static Object executeForCurrentEnvironment(Closure<?> closure) {
        Environment env = Environment.getCurrent();
        return Environment.executeForEnvironment(env, closure);
    }

    public static Object executeForEnvironment(Environment env, Closure<?> closure) {
        if (closure == null) {
            return null;
        }
        EnvironmentBlockEvaluator evaluator = Environment.evaluateEnvironmentSpecificBlock(env, closure);
        return evaluator.execute();
    }

    private static EnvironmentBlockEvaluator evaluateEnvironmentSpecificBlock(Environment environment, Closure<?> closure) {
        EnvironmentBlockEvaluator evaluator = new EnvironmentBlockEvaluator(environment);
        closure.setDelegate((Object)evaluator);
        closure.call();
        return evaluator;
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isReloadEnabled() {
        boolean reloadOverride = Boolean.getBoolean(RELOAD_ENABLED);
        String reloadLocation = this.getReloadLocationInternal();
        boolean reloadLocationSpecified = this.hasLocation(reloadLocation);
        return this == DEVELOPMENT && reloadLocationSpecified && !Metadata.getCurrent().isWarDeployed() || reloadOverride && reloadLocationSpecified;
    }

    public static boolean isInteractiveMode() {
        return Boolean.getBoolean(INTERACTIVE_MODE_ENABLED);
    }

    public static boolean isInitializing() {
        return initializingState;
    }

    public static void setInitializing(boolean initializing) {
        initializingState = initializing;
        System.setProperty(INITIALIZING, String.valueOf(initializing));
    }

    public static boolean isReloadingAgentEnabled() {
        try {
            Class.forName("org.springsource.loaded.TypeRegistry");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String getReloadLocation() {
        String location = this.getReloadLocationInternal();
        if (this.hasLocation(location)) {
            return location;
        }
        return ".";
    }

    private boolean hasLocation(String location) {
        return location != null && location.length() > 0;
    }

    public boolean hasReloadLocation() {
        String reloadingLocation = this.getReloadLocationInternal();
        return this.hasLocation(reloadingLocation);
    }

    private String getReloadLocationInternal() {
        BuildSettings settings;
        String location = System.getProperty(RELOAD_LOCATION);
        if (!this.hasLocation(location)) {
            location = System.getProperty("base.dir");
        }
        if (!this.hasLocation(location) && (settings = BuildSettingsHolder.getSettings()) != null) {
            location = settings.getBaseDir().getAbsolutePath();
        }
        return location;
    }

    static {
        KEY = "grails.env";
        RELOAD_ENABLED = "grails.reload.enabled";
        envNameMappings = CollectionUtils.newMap(DEVELOPMENT_ENVIRONMENT_SHORT_NAME, DEVELOPMENT.getName(), PRODUCTION_ENV_SHORT_NAME, PRODUCTION.getName(), TEST_ENVIRONMENT_SHORT_NAME, TEST.getName());
        cachedCurrentEnvironment = new Holder("Environment");
        cachedHasGrailsHome = System.getProperty("grails.home") != null;
        initializingState = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnvironmentBlockEvaluator
    extends GroovyObjectSupport {
        private Environment current;
        private Closure<?> callable;

        public Closure<?> getCallable() {
            return this.callable;
        }

        Object execute() {
            return this.callable == null ? null : this.callable.call();
        }

        private EnvironmentBlockEvaluator(Environment e) {
            this.current = e;
        }

        public void environments(Closure<?> c) {
            if (c != null) {
                c.setDelegate((Object)this);
                c.call();
            }
        }

        public void production(Closure<?> c) {
            if (this.current == PRODUCTION) {
                this.callable = c;
            }
        }

        public void development(Closure<?> c) {
            if (this.current == DEVELOPMENT) {
                this.callable = c;
            }
        }

        public void test(Closure<?> c) {
            if (this.current == TEST) {
                this.callable = c;
            }
        }

        public Object methodMissing(String name, Object args) {
            Object[] argsArray = (Object[])args;
            if (args != null && argsArray.length > 0 && argsArray[0] instanceof Closure) {
                if (this.current == CUSTOM && this.current.getName().equals(name)) {
                    this.callable = (Closure)argsArray[0];
                }
                return null;
            }
            throw new MissingMethodException(name, Environment.class, argsArray);
        }
    }
}

