/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIvyDependencyManager {
    public static Configuration BUILD_CONFIGURATION = new Configuration("build", Configuration.Visibility.PUBLIC, "Build system dependencies", new String[]{"default"}, true, null);
    public static Configuration COMPILE_CONFIGURATION = new Configuration("compile", Configuration.Visibility.PUBLIC, "Compile time dependencies", new String[]{"default"}, true, null);
    public static Configuration RUNTIME_CONFIGURATION = new Configuration("runtime", Configuration.Visibility.PUBLIC, "Runtime time dependencies", new String[]{"compile"}, true, null);
    public static Configuration TEST_CONFIGURATION = new Configuration("test", Configuration.Visibility.PUBLIC, "Testing dependencies", new String[]{"runtime"}, true, null);
    public static Configuration PROVIDED_CONFIGURATION = new Configuration("provided", Configuration.Visibility.PUBLIC, "Dependencies provided by the container", new String[]{"default"}, true, null);
    public static Configuration DOCS_CONFIGURATION = new Configuration("docs", Configuration.Visibility.PUBLIC, "Dependencies for the documenation engine", new String[]{"build"}, true, null);
    public static List<Configuration> ALL_CONFIGURATIONS = new ArrayList<Configuration>(){
        {
            this.add(BUILD_CONFIGURATION);
            this.add(COMPILE_CONFIGURATION);
            this.add(RUNTIME_CONFIGURATION);
            this.add(TEST_CONFIGURATION);
            this.add(PROVIDED_CONFIGURATION);
            this.add(DOCS_CONFIGURATION);
        }
    };
    Map<String, List> configurationMappings = new HashMap<String, List>(){
        {
            this.put("runtime", new ArrayList<String>(){
                {
                    this.add("runtime(*)");
                    this.add("master(*)");
                }
            });
            this.put("build", new ArrayList<String>(){
                {
                    this.add("default");
                }
            });
            this.put("compile", new ArrayList<String>(){
                {
                    this.add("'compile(*)");
                    this.add("master(*)");
                }
            });
            this.put("provided", new ArrayList<String>(){
                {
                    this.add("'compile(*)");
                    this.add("master(*)");
                }
            });
            this.put("docs", new ArrayList<String>(){
                {
                    this.add("'compile(*)");
                    this.add("master(*)");
                }
            });
            this.put("test", new ArrayList<String>(){
                {
                    this.add("''runtime(*)'(*)");
                    this.add("master(*)");
                }
            });
        }
    };
    protected String[] configurationNames = this.configurationMappings.keySet().toArray(new String[this.configurationMappings.size()]);
    protected Set<ModuleId> modules = new HashSet<ModuleId>();
    protected Set<ModuleRevisionId> dependencies = new HashSet<ModuleRevisionId>();
    protected Set<DependencyDescriptor> dependencyDescriptors = new HashSet<DependencyDescriptor>();
    protected Set<DependencyDescriptor> pluginDependencyDescriptors = new HashSet<DependencyDescriptor>();
    protected Set<String> pluginDependencyNames = new HashSet<String>();
    protected Set<String> metadataRegisteredPluginNames = new HashSet<String>();
    protected Map<String, Collection<ModuleRevisionId>> orgToDepMap = new HashMap<String, Collection<ModuleRevisionId>>();
    protected Map<String, DependencyDescriptor> pluginNameToDescriptorMap = new ConcurrentHashMap<String, DependencyDescriptor>();
    protected String applicationName;
    protected String applicationVersion;

    Set<DependencyDescriptor> getDependencyDescriptors() {
        return this.dependencyDescriptors;
    }

    public Set<String> getMetadataRegisteredPluginNames() {
        return this.metadataRegisteredPluginNames;
    }

    public void setMetadataRegisteredPluginNames(Set<String> metadataRegisteredPluginNames) {
        this.metadataRegisteredPluginNames = metadataRegisteredPluginNames;
    }

    Set<DependencyDescriptor> getPluginDependencyDescriptors() {
        return this.pluginDependencyDescriptors;
    }

    public DependencyDescriptor getPluginDependencyDescriptor(String pluginName) {
        return this.pluginNameToDescriptorMap.get(pluginName);
    }

    public Set<String> getPluginDependencyNames() {
        return this.pluginDependencyNames;
    }

    public Set<ModuleRevisionId> getDependencies() {
        return this.dependencies;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public String[] getConfigurationNames() {
        return this.configurationNames;
    }

    public Map<String, List> getConfigurationMappings() {
        return this.configurationMappings;
    }

    public boolean isPluginTransitive(String pluginName) {
        DependencyDescriptor dd = this.pluginNameToDescriptorMap.get(pluginName);
        return dd == null || dd.isTransitive();
    }

    public void addDependency(ModuleRevisionId revisionId) {
        this.modules.add(revisionId.getModuleId());
        this.dependencies.add(revisionId);
        String org = revisionId.getOrganisation();
        if (this.orgToDepMap.containsKey(org)) {
            this.orgToDepMap.get(org).add(revisionId);
        } else {
            HashSet<ModuleRevisionId> deps = new HashSet<ModuleRevisionId>();
            deps.add(revisionId);
            this.orgToDepMap.put(org, deps);
        }
    }

    protected ArtifactId createExcludeArtifactId(String excludeName) {
        return this.createExcludeArtifactId(excludeName, "*");
    }

    protected ArtifactId createExcludeArtifactId(String excludeName, String group) {
        ModuleId mid = ModuleId.newInstance((String)group, (String)excludeName);
        return new ArtifactId(mid, "*", "*", "*");
    }

    public void addDependencyDescriptor(DependencyDescriptor dd) {
        if (dd != null) {
            this.dependencyDescriptors.add(dd);
            this.addDependency(dd.getDependencyRevisionId());
        }
    }

    public ModuleDescriptor createModuleDescriptor() {
        DefaultModuleDescriptor moduleDescriptor = DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)ModuleRevisionId.newInstance((String)"org.grails.internal", (String)this.applicationName, (String)this.applicationVersion));
        moduleDescriptor.addConfiguration(BUILD_CONFIGURATION);
        moduleDescriptor.addConfiguration(COMPILE_CONFIGURATION);
        moduleDescriptor.addConfiguration(RUNTIME_CONFIGURATION);
        moduleDescriptor.addConfiguration(TEST_CONFIGURATION);
        moduleDescriptor.addConfiguration(PROVIDED_CONFIGURATION);
        moduleDescriptor.addConfiguration(DOCS_CONFIGURATION);
        return moduleDescriptor;
    }

    public boolean isExcludedFromPlugin(String plugin, String dependencyName) {
        DependencyDescriptor dd = this.pluginNameToDescriptorMap.get(plugin);
        if (dd == null) {
            return false;
        }
        if (!dd.isTransitive()) {
            return true;
        }
        ArtifactId aid = this.createExcludeArtifactId(dependencyName);
        return this.isExcludedFromPlugin(dd, aid);
    }

    public boolean isExcludedFromPlugin(DependencyDescriptor currentPlugin, ArtifactId dependency) {
        return currentPlugin != null && currentPlugin.doesExclude(this.configurationNames, dependency);
    }

    public Set<String> getPluginExcludes(String plugin) {
        HashSet<String> excludes = new HashSet<String>();
        DependencyDescriptor dd = this.pluginNameToDescriptorMap.get(plugin);
        if (dd != null) {
            for (ExcludeRule er : dd.getAllExcludeRules()) {
                excludes.add(er.getId().getName());
            }
        }
        return excludes;
    }
}

