/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.codehaus.groovy.ant.CompileTaskSupport;
import org.codehaus.groovy.tools.javac.JavaStubCompilationUnit;

public class GenerateStubsTask
extends CompileTaskSupport {
    protected void compile() throws Exception {
        GroovyClassLoader gcl = this.createClassLoader();
        JavaStubCompilationUnit compilation = new JavaStubCompilationUnit(this.config, gcl, this.destdir);
        int count = 0;
        String[] list = this.src.list();
        for (int i = 0; i < list.length; ++i) {
            File basedir = this.getProject().resolveFile(list[i]);
            if (!basedir.exists()) {
                throw new BuildException("Source directory does not exist: " + basedir, this.getLocation());
            }
            DirectoryScanner scanner = this.getDirectoryScanner(basedir);
            String[] includes = scanner.getIncludedFiles();
            this.log.debug("Including files from: " + basedir);
            for (int j = 0; j < includes.length; ++j) {
                String currentInclude = includes[j];
                this.log.debug("    " + currentInclude);
                File file = new File(basedir, currentInclude);
                if (this.isSource(currentInclude)) {
                    compilation.addSourceFile(file);
                }
                if (!currentInclude.endsWith(".groovy")) continue;
                ++count;
            }
        }
        if (count > 0) {
            this.log.info("Generating " + count + " Java stub" + (count > 1 ? "s" : "") + " to " + this.destdir);
            compilation.compile(3);
        } else {
            this.log.info("No sources found for stub generation");
        }
    }

    private boolean isSource(String currentInclude) {
        return currentInclude.endsWith(".groovy") || currentInclude.endsWith(".java");
    }
}

