/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class CommandLineHelper {
    private PrintStream out = System.out;

    public CommandLineHelper() {
    }

    public CommandLineHelper(PrintStream out) {
        this.out = out;
    }

    public String userInput(String message) {
        return this.userInput(message, null);
    }

    public String userInput(String message, String[] validResponses) {
        String responsesString = null;
        if (validResponses != null) {
            responsesString = DefaultGroovyMethods.join((Object[])validResponses, (String)",");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        for (int it = 0; it < 3; ++it) {
            this.out.print(message);
            if (responsesString != null) {
                this.out.print(" [");
                this.out.print(responsesString);
                this.out.print("] ");
            }
            try {
                String line = reader.readLine();
                if (validResponses == null) {
                    return line;
                }
                for (String validResponse : validResponses) {
                    if (line == null || !line.equals(validResponse)) continue;
                    return line;
                }
                this.out.println();
                this.out.println("Invalid option '" + line + "' - must be one of: [" + responsesString + "]");
                this.out.println();
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        this.out.println("No valid response entered - giving up asking.");
        return null;
    }
}

