/*
 * Decompiled with CFR 0.152.
 */
package grails.ant;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.codehaus.groovy.grails.cli.support.GrailsBuildHelper;
import org.codehaus.groovy.grails.cli.support.GrailsRootLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsTask
extends Task {
    private File home;
    private String script;
    private String args;
    private String environment;
    private boolean includeRuntimeClasspath = true;
    private Path classpath;
    private Path compileClasspath;
    private Path testClasspath;
    private Path runtimeClasspath;

    public void execute() throws BuildException {
        if (this.script == null) {
            throw new BuildException("'script' must be provided.");
        }
        if (this.home == null && this.classpath == null) {
            throw new BuildException("One of 'home' or 'classpath' must be provided.");
        }
        if (this.home != null && this.classpath != null) {
            throw new BuildException("You cannot use both 'home' and 'classpath' with the Grails task.");
        }
        this.runGrails(this.script, this.args);
    }

    protected void runGrails(String targetName, String args) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.classpath != null) {
            urls.addAll(this.pathsToUrls(this.classpath));
        } else {
            urls.addAll(this.getRequiredLibsFromHome());
        }
        if (this.includeRuntimeClasspath && this.runtimeClasspath != null) {
            urls.addAll(this.pathsToUrls(this.runtimeClasspath));
        }
        try {
            URL[] loaderUrls = urls.toArray(new URL[urls.size()]);
            GrailsRootLoader rootLoader = new GrailsRootLoader(loaderUrls, ((Object)((Object)this)).getClass().getClassLoader());
            GrailsBuildHelper helper = new GrailsBuildHelper((ClassLoader)((Object)rootLoader), this.home == null ? null : this.home.getCanonicalPath());
            this.configureBuildSettings(helper);
            int retval = this.environment == null ? helper.execute(targetName, args) : helper.execute(targetName, args, this.environment);
            if (retval != 0) {
                throw new BuildException("Grails returned non-zero value: " + retval);
            }
        }
        catch (Exception ex) {
            throw new BuildException("Unable to start Grails", (Throwable)ex);
        }
    }

    private List<URL> getRequiredLibsFromHome() {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            File[] files;
            for (File file : files = new File(this.home, "lib").listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("gant_") || name.startsWith("groovy-all");
                }
            })) {
                urls.add(file.toURI().toURL());
            }
            for (File file : files = new File(this.home, "dist").listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("grails-bootstrap");
                }
            })) {
                urls.add(file.toURI().toURL());
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void configureBuildSettings(GrailsBuildHelper helper) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        helper.setCompileDependencies(this.pathsToFiles(this.compileClasspath));
        helper.setTestDependencies(this.pathsToFiles(this.testClasspath));
        helper.setRuntimeDependencies(this.pathsToFiles(this.runtimeClasspath));
    }

    private List<URL> pathsToUrls(Path path) {
        if (path == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> urls = new ArrayList<URL>(path.size());
        for (String filePath : path.list()) {
            try {
                urls.add(new File(filePath).toURI().toURL());
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
        return urls;
    }

    private List<File> pathsToFiles(Path path) {
        if (path == null) {
            return Collections.emptyList();
        }
        ArrayList<File> files = new ArrayList<File>(path.size());
        for (String filePath : path.list()) {
            files.add(new File(filePath));
        }
        return files;
    }

    public File getHome() {
        return this.home;
    }

    public void setHome(File home) {
        this.home = home;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public boolean isIncludeRuntimeClasspath() {
        return this.includeRuntimeClasspath;
    }

    public void setIncludeRuntimeClasspath(boolean includeRuntimeClasspath) {
        this.includeRuntimeClasspath = includeRuntimeClasspath;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void addClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public void setClasspathRef(Reference ref) {
        this.addClasspath((Path)ref.getReferencedObject());
    }

    public Path getCompileClasspath() {
        return this.compileClasspath;
    }

    public void addCompileClasspath(Path compileClasspath) {
        this.compileClasspath = compileClasspath;
    }

    public Path getTestClasspath() {
        return this.testClasspath;
    }

    public void addTestClasspath(Path testClasspath) {
        this.testClasspath = testClasspath;
    }

    public Path getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    public void addRuntimeClasspath(Path runtimeClasspath) {
        this.runtimeClasspath = runtimeClasspath;
    }
}

