/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.compiler;

import com.oracle.truffle.dsl.processor.java.compiler.Compiler;
import com.oracle.truffle.dsl.processor.java.compiler.GeneratedCompiler;
import com.oracle.truffle.dsl.processor.java.compiler.JDTCompiler;
import com.oracle.truffle.dsl.processor.java.compiler.JavaCCompiler;
import javax.lang.model.element.Element;

public class CompilerFactory {
    private static Compiler javac;
    private static Compiler jdt;
    private static Compiler generated;

    public static Compiler getCompiler(Element currentElement) {
        if (GeneratedCompiler.isValidElement(currentElement)) {
            if (generated == null) {
                generated = new GeneratedCompiler();
            }
            return generated;
        }
        if (JavaCCompiler.isValidElement(currentElement)) {
            if (javac == null) {
                javac = new JavaCCompiler();
            }
            return javac;
        }
        if (JDTCompiler.isValidElement(currentElement)) {
            if (jdt == null) {
                jdt = new JDTCompiler(currentElement);
            }
            return jdt;
        }
        throw new UnsupportedOperationException("Unsupported compiler for element " + currentElement.getClass().getName() + ".");
    }
}

