/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.AbstractRegistrationProcessor;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationValue;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

@SupportedAnnotationTypes(value={"com.oracle.truffle.api.TruffleLanguage.Registration"})
public final class LanguageRegistrationProcessor
extends AbstractRegistrationProcessor {
    private static final Set<String> RESERVED_IDS = new HashSet<String>(Arrays.asList("host", "graal", "truffle", "language", "instrument", "graalvm", "context", "polyglot", "compiler", "vm", "file", "engine", "log", "image-build-time"));
    private static final Set<String> IGNORED_ATTRIBUTES = Set.of("services", "fileTypeDetectors", "internalResources");

    static String resolveLanguageId(Element annotatedElement, AnnotationMirror registration) {
        String id = ElementUtils.getAnnotationValue(String.class, registration, "id");
        if (id.isEmpty()) {
            return LanguageRegistrationProcessor.getDefaultLanguageId(annotatedElement);
        }
        return id;
    }

    private static String getDefaultLanguageId(Element annotatedElement) {
        String className = annotatedElement.toString();
        assert (TruffleTypes.TEST_PACKAGES.stream().anyMatch(className::startsWith));
        return className.replaceAll("[.$]", "_").toLowerCase();
    }

    @Override
    boolean validateRegistration(Element annotatedElement, AnnotationMirror registrationMirror) {
        boolean bl;
        boolean processingTruffleLanguage;
        if (annotatedElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.emitError("Registered language class must be at least package protected", annotatedElement);
            return false;
        }
        if (annotatedElement.getEnclosingElement().getKind() != ElementKind.PACKAGE && !annotatedElement.getModifiers().contains((Object)Modifier.STATIC)) {
            this.emitError("Registered language inner-class must be static", annotatedElement);
            return false;
        }
        ProcessorContext context = ProcessorContext.getInstance();
        TruffleTypes types = context.getTypes();
        TypeMirror truffleLang = this.processingEnv.getTypeUtils().erasure(types.TruffleLanguage);
        DeclaredType truffleLangProvider = types.TruffleLanguageProvider;
        if (this.processingEnv.getTypeUtils().isAssignable(annotatedElement.asType(), truffleLang)) {
            processingTruffleLanguage = true;
        } else if (this.processingEnv.getTypeUtils().isAssignable(annotatedElement.asType(), truffleLangProvider)) {
            processingTruffleLanguage = false;
        } else {
            this.emitError("Registered language class must subclass TruffleLanguage", annotatedElement);
            return false;
        }
        boolean foundConstructor = false;
        for (ExecutableElement executableElement : ElementFilter.constructorsIn(annotatedElement.getEnclosedElements())) {
            if (executableElement.getModifiers().contains((Object)Modifier.PRIVATE) || !executableElement.getParameters().isEmpty()) continue;
            foundConstructor = true;
            break;
        }
        Element singletonElement = null;
        for (Element element : annotatedElement.getEnclosedElements()) {
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC) || element.getKind() != ElementKind.FIELD || !element.getModifiers().contains((Object)Modifier.FINAL) || !"INSTANCE".equals(element.getSimpleName().toString()) || !this.processingEnv.getTypeUtils().isAssignable(element.asType(), truffleLang)) continue;
            singletonElement = element;
            break;
        }
        boolean bl2 = true;
        if (processingTruffleLanguage && singletonElement != null) {
            this.emitWarning("Using a singleton field is deprecated. Please provide a public no-argument constructor instead.", singletonElement);
            bl = false;
        } else if (!foundConstructor) {
            this.emitError("A TruffleLanguage subclass must have at least package protected no argument constructor.", annotatedElement);
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        List<String> characterMimeTypes = ElementUtils.getAnnotationValueList(String.class, registrationMirror, "characterMimeTypes");
        if (!this.validateMimeTypes(hashSet, annotatedElement, registrationMirror, ElementUtils.getAnnotationValue(registrationMirror, "characterMimeTypes"), characterMimeTypes)) {
            return false;
        }
        List<String> byteMimeTypes = ElementUtils.getAnnotationValueList(String.class, registrationMirror, "byteMimeTypes");
        if (!this.validateMimeTypes(hashSet, annotatedElement, registrationMirror, ElementUtils.getAnnotationValue(registrationMirror, "byteMimeTypes"), byteMimeTypes)) {
            return false;
        }
        String defaultMimeType = ElementUtils.getAnnotationValue(String.class, registrationMirror, "defaultMimeType");
        if (hashSet.size() > 1 && (defaultMimeType == null || defaultMimeType.equals(""))) {
            this.emitError("No defaultMimeType attribute specified. The defaultMimeType attribute needs to be specified if more than one MIME type was specified.", annotatedElement, registrationMirror, ElementUtils.getAnnotationValue(registrationMirror, "defaultMimeType"));
            return false;
        }
        if (defaultMimeType != null && !defaultMimeType.equals("") && !hashSet.contains(defaultMimeType)) {
            this.emitError("The defaultMimeType is not contained in the list of supported characterMimeTypes or byteMimeTypes. Add the specified default MIME type to character or byte MIME types to resolve this.", annotatedElement, registrationMirror, ElementUtils.getAnnotationValue(registrationMirror, "defaultMimeType"));
            return false;
        }
        String id = ElementUtils.getAnnotationValue(String.class, registrationMirror, "id");
        if (id.isEmpty()) {
            String className = annotatedElement.toString();
            if (TruffleTypes.TEST_PACKAGES.stream().noneMatch(className::startsWith)) {
                this.emitError("The attribute id is mandatory.", annotatedElement, registrationMirror, null);
                return false;
            }
        }
        if (RESERVED_IDS.contains(id)) {
            this.emitError(String.format("Id '%s' is reserved for other use and must not be used as id.", id), annotatedElement, registrationMirror, ElementUtils.getAnnotationValue(registrationMirror, "id"));
            return false;
        }
        if (!this.validateFileTypeDetectors(annotatedElement, registrationMirror)) {
            return false;
        }
        if (!this.validateInternalResources(annotatedElement, registrationMirror, context)) {
            return false;
        }
        if (bl) {
            LanguageRegistrationProcessor.assertNoErrorExpected(annotatedElement);
        }
        return processingTruffleLanguage;
    }

    @Override
    DeclaredType getProviderClass() {
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        return types.TruffleLanguageProvider;
    }

    @Override
    Iterable<AnnotationMirror> getProviderAnnotations(TypeElement annotatedElement) {
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>(2);
        TruffleTypes types = ProcessorContext.getInstance().getTypes();
        DeclaredType registrationType = types.TruffleLanguage_Registration;
        CodeAnnotationMirror registration = LanguageRegistrationProcessor.copyAnnotations(ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)registrationType), t -> !IGNORED_ATTRIBUTES.contains(t.getSimpleName().toString()));
        if (ElementUtils.getAnnotationValue(String.class, registration, "id").isEmpty()) {
            registration.setElementValue(registration.findExecutableElement("id"), (AnnotationValue)new CodeAnnotationValue(LanguageRegistrationProcessor.getDefaultLanguageId(annotatedElement)));
        }
        result.add(registration);
        AnnotationMirror providedTags = ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)types.ProvidedTags);
        if (providedTags != null) {
            result.add(providedTags);
        }
        return result;
    }

    @Override
    void implementMethod(TypeElement annotatedElement, CodeExecutableElement methodToImplement) {
        ProcessorContext context = ProcessorContext.getInstance();
        TruffleTypes types = context.getTypes();
        CodeTreeBuilder builder = methodToImplement.createBuilder();
        switch (methodToImplement.getSimpleName().toString()) {
            case "create": {
                DeclaredType languageType = (DeclaredType)annotatedElement.asType();
                List<? extends TypeParameterElement> typeParams = annotatedElement.getTypeParameters();
                if (!typeParams.isEmpty()) {
                    builder.startReturn().string("new " + String.valueOf(annotatedElement.getQualifiedName()) + "<>()").end();
                    break;
                }
                builder.startReturn().startNew(languageType).end(2);
                break;
            }
            case "getLanguageClassName": {
                Elements elements = context.getEnvironment().getElementUtils();
                builder.startReturn().doubleQuote(elements.getBinaryName(annotatedElement).toString()).end();
                break;
            }
            case "getServicesClassNames": {
                AnnotationMirror registration = ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)types.TruffleLanguage_Registration);
                LanguageRegistrationProcessor.generateGetServicesClassNames(registration, builder, context);
                break;
            }
            case "getInternalResourceIds": {
                AnnotationMirror registration = ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)types.TruffleLanguage_Registration);
                LanguageRegistrationProcessor.generateGetInternalResourceIds(registration, builder, context);
                break;
            }
            case "createInternalResource": {
                AnnotationMirror registration = ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)types.TruffleLanguage_Registration);
                LanguageRegistrationProcessor.generateCreateInternalResource(registration, methodToImplement.getParameters().get(0), builder, context);
                break;
            }
            case "createFileTypeDetectors": {
                AnnotationMirror registration = ElementUtils.findAnnotationMirror(annotatedElement.getAnnotationMirrors(), (TypeMirror)types.TruffleLanguage_Registration);
                LanguageRegistrationProcessor.generateCreateFileTypeDetectors(registration, builder, context);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported method: " + String.valueOf(methodToImplement.getSimpleName()));
            }
        }
    }

    private static void generateCreateFileTypeDetectors(AnnotationMirror registration, CodeTreeBuilder builder, ProcessorContext context) {
        List<TypeMirror> detectors = ElementUtils.getAnnotationValueList(TypeMirror.class, registration, "fileTypeDetectors");
        if (detectors.isEmpty()) {
            builder.startReturn().startStaticCall(context.getType(List.class), "of").end().end();
        } else {
            builder.startReturn();
            builder.startStaticCall(context.getType(List.class), "of");
            for (TypeMirror detector : detectors) {
                builder.startGroup().startNew(detector).end(2);
            }
            builder.end(2);
        }
    }

    private boolean validateMimeTypes(Set<String> collectedMimeTypes, Element e, AnnotationMirror mirror, AnnotationValue value, List<String> loadedMimeTypes) {
        for (String mimeType : loadedMimeTypes) {
            if (!this.validateMimeType(e, mirror, value, mimeType)) {
                return false;
            }
            if (collectedMimeTypes.contains(mimeType)) {
                this.emitError(String.format("Duplicate MIME type specified '%s'. MIME types must be unique.", mimeType), e, mirror, value);
                return false;
            }
            collectedMimeTypes.add(mimeType);
        }
        return true;
    }

    private boolean validateMimeType(Element type, AnnotationMirror mirror, AnnotationValue value, String mimeType) {
        int index = mimeType.indexOf(47);
        if (index == -1 || index == 0 || index == mimeType.length() - 1) {
            this.emitError(String.format("Invalid MIME type '%s' provided. MIME types consist of a type and a subtype separated by '/'.", mimeType), type, mirror, value);
            return false;
        }
        if (mimeType.indexOf(47, index + 1) != -1) {
            this.emitError(String.format("Invalid MIME type '%s' provided. MIME types consist of a type and a subtype separated by '/'.", mimeType), type, mirror, value);
            return false;
        }
        return true;
    }

    private boolean validateFileTypeDetectors(Element annotatedElement, AnnotationMirror mirror) {
        AnnotationValue value = ElementUtils.getAnnotationValue(mirror, "fileTypeDetectors", true);
        for (TypeMirror fileTypeDetectorImpl : ElementUtils.getAnnotationValueList(TypeMirror.class, mirror, "fileTypeDetectors")) {
            TypeElement fileTypeDetectorImplElement = ElementUtils.fromTypeMirror(fileTypeDetectorImpl);
            PackageElement targetPackage = ElementUtils.findPackageElement(annotatedElement);
            boolean samePackage = targetPackage.equals(ElementUtils.findPackageElement(fileTypeDetectorImplElement));
            Set<Modifier> modifiers = fileTypeDetectorImplElement.getModifiers();
            if (samePackage ? modifiers.contains((Object)Modifier.PRIVATE) : !modifiers.contains((Object)Modifier.PUBLIC)) {
                this.emitError(String.format("The class %s must be public or package protected in the %s package. To resolve this, make the %s public or move it to the %s package.", LanguageRegistrationProcessor.getScopedName(fileTypeDetectorImplElement), targetPackage.getQualifiedName(), LanguageRegistrationProcessor.getScopedName(fileTypeDetectorImplElement), targetPackage.getQualifiedName()), annotatedElement, mirror, value);
                return false;
            }
            if (fileTypeDetectorImplElement.getEnclosingElement().getKind() != ElementKind.PACKAGE && !modifiers.contains((Object)Modifier.STATIC)) {
                this.emitError(String.format("The class %s must be a static inner-class or a top-level class. To resolve this, make the %s static or top-level class.", LanguageRegistrationProcessor.getScopedName(fileTypeDetectorImplElement), fileTypeDetectorImplElement.getSimpleName()), annotatedElement, mirror, value);
                return false;
            }
            boolean foundConstructor = false;
            for (ExecutableElement constructor : ElementFilter.constructorsIn(fileTypeDetectorImplElement.getEnclosedElements())) {
                modifiers = constructor.getModifiers();
                if ((!samePackage ? !modifiers.contains((Object)Modifier.PUBLIC) : modifiers.contains((Object)Modifier.PRIVATE)) || !constructor.getParameters().isEmpty()) continue;
                foundConstructor = true;
                break;
            }
            if (foundConstructor) continue;
            this.emitError(String.format("The class %s must have a no argument public constructor. To resolve this, add public %s() constructor.", LanguageRegistrationProcessor.getScopedName(fileTypeDetectorImplElement), ElementUtils.getSimpleName(fileTypeDetectorImplElement)), annotatedElement, mirror, value);
            return false;
        }
        return true;
    }
}

