/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public final class ExpectError {
    public static void assertNoErrorExpected(Element element) {
        for (DeclaredType errorType : ProcessorContext.types().ExpectErrorTypes) {
            ExpectError.assertNoErrorExpectedImpl(element, errorType);
        }
    }

    private static void assertNoErrorExpectedImpl(Element element, DeclaredType eee) {
        AnnotationMirror am;
        if (eee != null && (am = ElementUtils.findAnnotationMirror(element, (TypeMirror)eee)) != null) {
            ProcessorContext.getInstance().getEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, "Expected an error, but none found!", element);
        }
    }

    public static boolean isExpectedError(Element element, String actualText) {
        List<String> expectedErrors = ExpectError.getExpectedErrors(element);
        for (String expectedText : expectedErrors) {
            String newExpectedText = expectedText.replaceAll("%n", System.lineSeparator());
            if (newExpectedText.endsWith("%") && actualText.startsWith(newExpectedText.substring(0, newExpectedText.length() - 1))) {
                return true;
            }
            if (!actualText.equals(newExpectedText)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getExpectedErrors(Element element) {
        if (element == null || ProcessorContext.types().ExpectErrorTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> expectedErrors = new ArrayList<String>();
        for (DeclaredType errorType : ProcessorContext.types().ExpectErrorTypes) {
            ExpectError.collectExpectedErrors(expectedErrors, element, errorType);
        }
        return expectedErrors;
    }

    private static void collectExpectedErrors(List<String> expectedErrors, Element element, DeclaredType type) {
        AnnotationMirror mirror;
        if (type != null && (mirror = ElementUtils.findAnnotationMirror(element, (TypeMirror)type)) != null) {
            expectedErrors.addAll(ElementUtils.getAnnotationValueList(String.class, mirror, "value"));
        }
    }
}

