/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.Log;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.GeneratedElement;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public abstract class MessageContainer
implements Iterable<MessageContainer> {
    private List<Message> messages;
    protected final TruffleTypes types = ProcessorContext.getInstance().getTypes();
    private static final int MAX_MARKER_BYTE_LENGTH = 60000;

    public final void addWarning(String text, Object ... params) {
        this.getMessagesForModification().add(new Message(null, null, null, this, String.format(text, params), Diagnostic.Kind.WARNING, null));
    }

    public final void addWarning(Element enclosedElement, String text, Object ... params) {
        this.getMessagesForModification().add(new Message(null, null, enclosedElement, this, String.format(text, params), Diagnostic.Kind.WARNING, null));
    }

    public final void addSuppressableWarning(String suppressionKey, String text, Object ... params) {
        this.getMessagesForModification().add(new Message(null, null, null, this, String.format(text, params), Diagnostic.Kind.WARNING, suppressionKey));
    }

    public final void addSuppressableWarning(String suppressionKey, AnnotationMirror mirror, AnnotationValue value, String text, Object ... params) {
        this.getMessagesForModification().add(new Message(mirror, value, null, this, String.format(text, params), Diagnostic.Kind.WARNING, suppressionKey));
    }

    public final void addWarning(AnnotationValue value, String text, Object ... params) {
        this.getMessagesForModification().add(new Message(null, value, null, this, String.format(text, params), Diagnostic.Kind.WARNING, null));
    }

    public final void addWarning(AnnotationMirror mirror, AnnotationValue value, String text, Object ... params) {
        this.getMessagesForModification().add(new Message(mirror, value, null, this, String.format(text, params), Diagnostic.Kind.WARNING, null));
    }

    public final void addSuppressableWarning(String suppressionKey, AnnotationValue value, String text, Object ... params) {
        this.getMessagesForModification().add(new Message(null, value, null, this, String.format(text, params), Diagnostic.Kind.WARNING, suppressionKey));
    }

    public final void addError(String text, Object ... params) {
        this.addError((AnnotationValue)null, text, params);
    }

    public final void addError(Element enclosedElement, String text, Object ... params) {
        this.getMessagesForModification().add(new Message(null, null, enclosedElement, this, String.format(text, params), Diagnostic.Kind.ERROR, null));
    }

    public final void addError(AnnotationValue value, String text, Object ... params) {
        this.getMessagesForModification().add(new Message(null, value, null, this, String.format(text, params), Diagnostic.Kind.ERROR, null));
    }

    public final void addError(AnnotationMirror mirror, AnnotationValue value, String text, Object ... params) {
        this.getMessagesForModification().add(new Message(mirror, value, null, this, String.format(text, params), Diagnostic.Kind.ERROR, null));
    }

    protected List<MessageContainer> findChildContainers() {
        return Collections.emptyList();
    }

    public abstract Element getMessageElement();

    @Override
    public Iterator<MessageContainer> iterator() {
        return this.findChildContainers().iterator();
    }

    public final void redirectMessages(MessageContainer to) {
        if (this.messages != null) {
            List<Message> list = this.getMessagesForModification();
            for (Message message : list) {
                if (message.getKind() == Diagnostic.Kind.WARNING) continue;
                Element element = message.getEnclosedElement();
                if (element == null) {
                    element = message.getOriginalContainer().getMessageElement();
                }
                String reference = ElementUtils.getReadableReference(to.getMessageElement(), element);
                String prefix = "Message redirected from element " + reference + ":" + System.lineSeparator();
                to.getMessagesForModification().add(message.redirect(prefix, to.getMessageElement()));
            }
            list.clear();
        }
        for (MessageContainer container : this.findChildContainers()) {
            container.redirectMessages(to);
        }
    }

    public final void redirectMessagesOnGeneratedElements(MessageContainer to) {
        Element messageElement;
        if (this.messages != null && ((messageElement = this.getMessageElement()) == null || messageElement instanceof GeneratedElement || messageElement.getEnclosingElement() instanceof GeneratedElement)) {
            List<Message> list = this.getMessagesForModification();
            for (Message message : list) {
                to.getMessagesForModification().add(message.redirect("", to.getMessageElement()));
            }
            list.clear();
        }
        for (MessageContainer container : this.findChildContainers()) {
            container.redirectMessagesOnGeneratedElements(to);
        }
    }

    public final void emitMessages(Log log) {
        HashMap<Element, List<Message>> emittedMessages = new HashMap<Element, List<Message>>();
        LinkedHashSet relevantTypes = new LinkedHashSet();
        this.visit(container -> {
            List<Message> m = container.getMessages();
            for (int i = m.size() - 1; i >= 0; --i) {
                Message message = m.get(i);
                Element targetElement = container.emitDefault(log, message);
                emittedMessages.computeIfAbsent(targetElement, e -> new ArrayList()).add(message);
            }
            if (container.getMessageElement() instanceof TypeElement) {
                relevantTypes.add(container.getMessageElement());
            }
            return true;
        });
        if (!ProcessorContext.types().ExpectErrorTypes.isEmpty()) {
            for (Element element : relevantTypes) {
                MessageContainer.verifyExpectedErrors(element, emittedMessages);
            }
        }
    }

    private static void verifyExpectedErrors(Element element, Map<Element, List<Message>> emitted) {
        List<String> expectedErrors = ExpectError.getExpectedErrors(element);
        if (!expectedErrors.isEmpty()) {
            List<Message> foundMessages = emitted.get(element);
            ProcessorContext processorContext = ProcessorContext.getInstance();
            List messages = null;
            if (foundMessages != null) {
                for (Message m : foundMessages) {
                    if (processorContext.getLog().isSuppressed(m.kind, m.suppressionKey, m.originalContainer.getMessageElement(), false)) continue;
                    if (messages == null) {
                        messages = new ArrayList();
                    }
                    messages.add(m);
                }
            }
            List list = messages = messages == null ? Collections.emptyList() : messages;
            if (expectedErrors.size() != messages.size()) {
                ProcessorContext.getInstance().getLog().message(Diagnostic.Kind.ERROR, element, null, null, "Error count expected %s but was %s. Expected errors %s but got %s.", expectedErrors.size(), messages.size(), expectedErrors.toString(), messages.toString());
            }
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (element2 instanceof TypeElement) continue;
            MessageContainer.verifyExpectedErrors(element2, emitted);
        }
    }

    private Element emitDefault(Log log, Message message) {
        Element enclosedElement;
        Element targetElement;
        Diagnostic.Kind kind = message.getKind();
        Element messageElement = this.getMessageElement();
        AnnotationMirror messageAnnotation = this.getMessageAnnotation();
        AnnotationValue messageValue = this.getMessageAnnotationValue();
        if (message.getAnnotationValue() != null) {
            messageValue = message.getAnnotationValue();
        }
        if (message.getAnnotationMirror() != null) {
            messageAnnotation = message.getAnnotationMirror();
        }
        Element element = targetElement = (enclosedElement = message.getEnclosedElement()) == null ? messageElement : enclosedElement;
        if (targetElement instanceof GeneratedElement) {
            throw new AssertionError((Object)("Tried to emit message to generated element: " + String.valueOf(messageElement) + ". Make sure messages are redirected correctly. Message: " + message.getText()));
        }
        if (log.isSuppressed(kind, message.suppressionKey, messageElement)) {
            return targetElement;
        }
        Object text = MessageContainer.trimLongMessage(message.getText());
        List<String> expectedErrors = ExpectError.getExpectedErrors(targetElement);
        if (!expectedErrors.isEmpty()) {
            if (ExpectError.isExpectedError(targetElement, (String)text)) {
                return targetElement;
            }
            log.message(Diagnostic.Kind.ERROR, targetElement, null, null, "Message expected one of '%s' but was '%s'.", expectedErrors, text);
        } else {
            if (message.suppressionKey != null) {
                text = (String)text + " This warning may be suppressed using @SuppressWarnings(\"" + message.suppressionKey + "\").";
            }
            if (enclosedElement == null) {
                log.message(kind, targetElement, messageAnnotation, messageValue, (String)text, new Object[0]);
            } else {
                log.message(kind, targetElement, null, null, (String)text, new Object[0]);
            }
        }
        return targetElement;
    }

    private static String trimLongMessage(String valueString) {
        byte[] bytes;
        if (valueString.length() < 21000) {
            return valueString;
        }
        try {
            bytes = valueString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return valueString;
        }
        if (bytes.length > 60000) {
            return String.format("Java compiler message is too long. Showing the first few 8000 and the last 2000 characters only: %n%s%n ... truncated ... %n%s", valueString.substring(0, 8000), valueString.substring(valueString.length() - 2000, valueString.length()));
        }
        return valueString;
    }

    public AnnotationMirror getMessageAnnotation() {
        return null;
    }

    public AnnotationValue getMessageAnnotationValue() {
        return null;
    }

    public final boolean hasErrors() {
        return !this.visit(container -> {
            for (Message msg : container.getMessages()) {
                if (msg.getKind() != Diagnostic.Kind.ERROR) continue;
                return false;
            }
            return true;
        });
    }

    public final boolean hasErrorsOrWarnings() {
        return !this.visit(container -> {
            for (Message msg : container.getMessages()) {
                if (msg.getKind() != Diagnostic.Kind.ERROR && msg.getKind() != Diagnostic.Kind.WARNING) continue;
                return false;
            }
            return true;
        });
    }

    private boolean visit(Predicate<MessageContainer> vistor) {
        return this.visitImpl(new HashSet<MessageContainer>(), vistor);
    }

    private boolean visitImpl(Set<MessageContainer> visited, Predicate<MessageContainer> visitor) {
        if (visited.contains(this)) {
            return true;
        }
        visited.add(this);
        if (!visitor.test(this)) {
            return false;
        }
        for (MessageContainer sink : this.findChildContainers()) {
            if (sink.visitImpl(visited, visitor)) continue;
            return false;
        }
        return true;
    }

    public final List<Message> collectMessages() {
        ArrayList<Message> foundMessages = new ArrayList<Message>();
        this.visit(s -> {
            foundMessages.addAll(s.getMessages());
            return true;
        });
        return foundMessages;
    }

    protected final List<Message> getMessagesForModification() {
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        return this.messages;
    }

    public final List<Message> getMessages() {
        if (this.messages == null) {
            return Collections.emptyList();
        }
        return this.messages;
    }

    public static final class Message {
        private final MessageContainer originalContainer;
        private final Element enclosedElement;
        private final AnnotationMirror annotationMirror;
        private final AnnotationValue annotationValue;
        private final String text;
        private final Diagnostic.Kind kind;
        private final String suppressionKey;

        public Message(AnnotationMirror annotationMirror, AnnotationValue annotationValue, Element enclosedElement, MessageContainer originalContainer, String text, Diagnostic.Kind kind, String suppressionKey) {
            this.annotationMirror = annotationMirror;
            this.annotationValue = annotationValue;
            this.enclosedElement = enclosedElement;
            this.originalContainer = originalContainer;
            this.text = text;
            this.kind = kind;
            this.suppressionKey = suppressionKey;
        }

        public Message redirect(String textPrefix, Element element) {
            return new Message(null, null, element, this.originalContainer, textPrefix + this.text, this.kind, null);
        }

        public Element getEnclosedElement() {
            return this.enclosedElement;
        }

        public AnnotationMirror getAnnotationMirror() {
            return this.annotationMirror;
        }

        public AnnotationValue getAnnotationValue() {
            return this.annotationValue;
        }

        public MessageContainer getOriginalContainer() {
            return this.originalContainer;
        }

        public String getText() {
            return this.text;
        }

        public Diagnostic.Kind getKind() {
            return this.kind;
        }

        public String toString() {
            return String.valueOf((Object)this.kind) + ": " + this.text;
        }
    }
}

