/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.library;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.expression.DSLExpression;
import com.oracle.truffle.dsl.processor.expression.DSLExpressionResolver;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.compiler.CompilerFactory;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationValue;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeNames;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.library.ExportMessageData;
import com.oracle.truffle.dsl.processor.library.ExportsData;
import com.oracle.truffle.dsl.processor.library.ExportsLibrary;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.library.LibraryDefaultExportData;
import com.oracle.truffle.dsl.processor.library.LibraryMessage;
import com.oracle.truffle.dsl.processor.library.LibraryParser;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.parser.AbstractParser;
import com.oracle.truffle.dsl.processor.parser.NodeParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class ExportsParser
extends AbstractParser<ExportsData> {
    public static final String EXECUTE_PREFIX = "execute";
    public static final String EXECUTE_SUFFIX = "_";

    @Override
    public boolean isDelegateToRootDeclaredType() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ExportsData parse(Element element, List<AnnotationMirror> elementMirrors) {
        LibraryMessage message;
        TypeElement type = (TypeElement)element;
        ExportsData model = this.parseExports(type, elementMirrors);
        if (model.hasErrors()) {
            return model;
        }
        HashSet<TypeElement> declaringTypes = new HashSet<TypeElement>();
        HashSet<TypeElement> declaringInTemplateTypes = new HashSet<TypeElement>();
        declaringInTemplateTypes.add(type);
        for (ExportsLibrary exportsLibrary : model.getExportedLibraries().values()) {
            declaringTypes.addAll(exportsLibrary.getDeclaringTypes());
            if (!exportsLibrary.isDeclaredInTemplate()) continue;
            declaringInTemplateTypes.addAll(exportsLibrary.getDeclaringTypes());
        }
        PackageElement packageElement = ElementUtils.findPackageElement(type);
        for (TypeElement typeElement : declaringInTemplateTypes) {
            if (ElementUtils.elementEquals(typeElement, element)) continue;
            ArrayList<Object> foundInvisibleMembers = new ArrayList<Object>();
            Iterator<Object> superTypeMembers = this.loadMembers(null, typeElement);
            Iterator<? extends Element> iterator = superTypeMembers.iterator();
            while (iterator.hasNext()) {
                Element superTypeMember = iterator.next();
                List<AnnotationMirror> list = ElementUtils.getRepeatedAnnotation(superTypeMember.getAnnotationMirrors(), this.types.ExportMessage);
                if (list.isEmpty()) continue;
                if (!ElementUtils.isVisible(packageElement, superTypeMember)) {
                    foundInvisibleMembers.add(superTypeMember);
                    continue;
                }
                if (!superTypeMember.getKind().isClass()) continue;
                for (Element element2 : this.loadMembers(null, (TypeElement)superTypeMember)) {
                    if (ElementUtils.findAnnotationMirror(element2, (TypeMirror)this.types.Specialization) == null || ElementUtils.isVisible(packageElement, element2)) continue;
                    foundInvisibleMembers.add(element2);
                }
            }
            if (foundInvisibleMembers.isEmpty()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            for (Element element3 : foundInvisibleMembers) {
                stringBuilder.append(System.lineSeparator()).append("   - ");
                stringBuilder.append(ElementUtils.getReadableReference(element, element3));
            }
            model.addError("Found invisible exported elements in super type '%s': %s%nIncrease their visibility to resolve this problem.", ElementUtils.getSimpleName(typeElement), stringBuilder.toString());
        }
        if (model.getExportedLibraries().isEmpty()) {
            for (Element element4 : this.loadMembers(null, type)) {
                List<AnnotationMirror> exportedMessageMirrors = ElementUtils.getRepeatedAnnotation(element4.getAnnotationMirrors(), this.types.ExportMessage);
                if (exportedMessageMirrors.isEmpty()) continue;
                model.addError("Class declares @%s annotations but does not export any libraries. Exported messages cannot be resolved without exported library. Add @%s(MyLibrary.class) to the class to fix this.", ElementUtils.getSimpleName(this.types.ExportMessage), ElementUtils.getSimpleName(this.types.ExportLibrary));
                return model;
            }
        }
        List<? extends Element> list = this.loadMembers(declaringInTemplateTypes, type);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        List<Object> exportedElements = new ArrayList<ExportMessageData>();
        for (Element element5 : list) {
            List<AnnotationMirror> exportedMessageMirrors = ElementUtils.getRepeatedAnnotation(element5.getAnnotationMirrors(), this.types.ExportMessage);
            if (exportedMessageMirrors.isEmpty()) {
                void var16_71;
                boolean bl = ExportsParser.isMethodElement(element5);
                boolean bl2 = ExportsParser.isNodeElement(element5);
                Object var16_68 = null;
                if (bl) {
                    String string = element5.getSimpleName().toString();
                } else if (bl2) {
                    String string = ExportsParser.inferNodeMessageName((TypeElement)element5);
                }
                if (!bl && !bl2) continue;
                Element enclosingType = element5.getEnclosingElement();
                if (!ElementUtils.elementEquals(model.getTemplateType(), enclosingType)) continue;
                linkedHashMap.computeIfAbsent((String)var16_71, n -> new ArrayList()).add(element5);
                continue;
            }
            for (AnnotationMirror annotationMirror : exportedMessageMirrors) {
                exportedElements.addAll(this.parseExportedMessage(model, element5, annotationMirror));
            }
        }
        for (ExportMessageData exportMessageData : exportedElements) {
            Element member = exportMessageData.getMessageElement();
            String string = exportMessageData.getResolvedMessage().getName();
            Map<String, ExportMessageData> map = exportMessageData.getExportsLibrary().getExportedMessages();
            ExportMessageData exportMessageData2 = map.get(string);
            if (exportMessageData2 != null) {
                Element currentEnclosingElement;
                Element existingEnclosingElement = exportMessageData2.getMessageElement().getEnclosingElement();
                if (ElementUtils.elementEquals(existingEnclosingElement, currentEnclosingElement = exportMessageData.getMessageElement().getEnclosingElement())) {
                    String error = String.format("Duplicate exported library message %s.", string);
                    model.addError(member, error, new Object[0]);
                    model.addError(exportMessageData2.getMessageElement(), error, new Object[0]);
                    continue;
                }
                if (ElementUtils.isSubtype(currentEnclosingElement.asType(), existingEnclosingElement.asType())) {
                    map.put(string, exportMessageData);
                    exportMessageData2.setOverriden(true);
                    continue;
                }
                exportMessageData.setOverriden(true);
                continue;
            }
            map.put(string, exportMessageData);
        }
        for (ExportsLibrary exportsLibrary : model.getExportedLibraries().values()) {
            if (!exportsLibrary.hasExportDelegation()) continue;
            Object accepts = exportsLibrary.getExportedMessages().get("accepts");
            if (accepts == null) {
                String string = exportsLibrary.getDelegationVariable().getSimpleName().toString();
                CodeAnnotationMirror codeAnnotationMirror = new CodeAnnotationMirror(this.types.CachedLibrary);
                codeAnnotationMirror.setElementValue(ElementUtils.findExecutableElement(this.types.CachedLibrary, "value"), (AnnotationValue)new CodeAnnotationValue("receiver_." + string));
                CodeExecutableElement codeExecutableElement = CodeExecutableElement.clone(ElementUtils.findMethod(this.types.Library, "accepts"));
                codeExecutableElement.changeTypes(exportsLibrary.getReceiverType());
                codeExecutableElement.renameArguments("receiver_");
                codeExecutableElement.getModifiers().add(Modifier.STATIC);
                CodeVariableElement var = new CodeVariableElement(exportsLibrary.getLibrary().getTemplateType().asType(), string);
                var.addAnnotationMirror(codeAnnotationMirror);
                codeExecutableElement.setEnclosingElement(exportsLibrary.getTemplateType());
                codeExecutableElement.getParameters().add(var);
                message = null;
                for (LibraryMessage libMessage : exportsLibrary.getLibrary().getMethods()) {
                    if (!libMessage.getName().equals("accepts")) continue;
                    message = libMessage;
                    break;
                }
                accepts = new ExportMessageData(exportsLibrary, message, codeExecutableElement, codeAnnotationMirror);
                exportsLibrary.getExportedMessages().put("accepts", (ExportMessageData)accepts);
                exportedElements.add(accepts);
                continue;
            }
            ((MessageContainer)accepts).addError("Exporting a custom accepts method is currently not supported when export delegation is used in @%s. Remove delegateTo from all exports or remove the accepts export to resolve this.", ElementUtils.getSimpleName(this.types.ExportLibrary));
        }
        for (ExportsLibrary exportsLibrary : model.getExportedLibraries().values()) {
            if (exportsLibrary.isDeclaredInTemplate()) continue;
            for (ExportMessageData exportMessageData : exportsLibrary.getExportedMessages().values()) {
                if (!ElementUtils.elementEquals(exportMessageData.getMessageElement().getEnclosingElement(), type)) continue;
                exportMessageData.addError("The @%s declaration is missing for this exported message. Add @%s(%s.class) to the enclosing class %s to resolve this.", ElementUtils.getSimpleName(this.types.ExportLibrary), ElementUtils.getSimpleName(this.types.ExportLibrary), ElementUtils.getSimpleName(exportsLibrary.getLibrary().getTemplateType()), ElementUtils.getSimpleName(type));
            }
        }
        if (model.hasErrors()) {
            return model;
        }
        for (ExportsLibrary exportsLibrary : model.getExportedLibraries().values()) {
            if (exportsLibrary.isBuiltinDefaultExport() || !exportsLibrary.isDeclaredInTemplate()) continue;
            boolean foundDeclared = false;
            for (ExportMessageData exportMessageData : exportsLibrary.getExportedMessages().values()) {
                if (!exportMessageData.isDeclared()) continue;
                foundDeclared = true;
                break;
            }
            if (foundDeclared) continue;
            exportsLibrary.addWarning("Exported library %s does not export any messages and therefore has no effect. Remove the export declaration to resolve this.", ElementUtils.getSimpleName(exportsLibrary.getLibrary().getTemplateType()));
        }
        if (model.hasErrors()) {
            return model;
        }
        Predicate<ExportsLibrary> filterpredicate = library -> {
            if (library.isDynamicDispatchTarget()) {
                return true;
            }
            return library.isDeclaredInTemplate();
        };
        Set set = model.getExportedLibraries().values().stream().filter(filterpredicate).collect(Collectors.toSet());
        model.getExportedLibraries().values().removeIf(e -> !declaredExports.contains(e));
        exportedElements = exportedElements.stream().filter(e -> declaredExports.contains(e.getExportsLibrary())).collect(Collectors.toList());
        for (ExportsLibrary exportsLibrary : set) {
            for (ExportMessageData exportMessageData : exportsLibrary.getExportedMessages().values()) {
                LibraryMessage overload;
                Iterator<ExportMessageData> member = exportMessageData.getMessageElement();
                LibraryMessage libraryMessage = exportMessageData.getResolvedMessage();
                List<LibraryMessage> overloads = libraryMessage.getDeprecatedOverloads();
                if (overloads.isEmpty()) continue;
                List<TypeMirror> actualTypes = this.computeGenericSignature((Element)((Object)member));
                if (!member.getModifiers().contains((Object)Modifier.STATIC)) {
                    actualTypes.add(0, exportsLibrary.getReceiverType());
                }
                if ((overload = ExportsParser.resolveOverload(overloads, actualTypes)) == null) continue;
                exportMessageData.updateOverload(overload);
            }
        }
        for (ExportsLibrary exportsLibrary : set) {
            void var16_79;
            HashMap<String, NodeData> hashMap = new HashMap<String, NodeData>();
            boolean bl = false;
            for (ExportMessageData exportedElement : exportsLibrary.getExportedMessages().values()) {
                if (exportedElement.isOverriden()) continue;
                Element member = exportedElement.getMessageElement();
                if (ExportsParser.isMethodElement(member)) {
                    this.initializeExportedMethod(hashMap, model, exportedElement);
                } else if (ExportsParser.isNodeElement(member)) {
                    this.initializeExportedNode(hashMap, exportedElement);
                } else {
                    throw new AssertionError((Object)"should not be reachable");
                }
                if (exportedElement.getSpecializedNode() == null) continue;
                ++var16_79;
            }
            for (ExportMessageData exportedElement : exportsLibrary.getExportedMessages().values()) {
                if (exportedElement.isOverriden() || exportedElement.getSpecializedNode() == null) continue;
                exportedElement.getSpecializedNode().setActivationProbability(1.0 / (double)var16_79);
            }
        }
        TypeMirror receiverClass = null;
        for (Map.Entry<String, ExportsLibrary> entry : model.getExportedLibraries().entrySet()) {
            ExportsLibrary exportsLibrary = entry.getValue();
            if (exportsLibrary.hasErrors()) continue;
            if (receiverClass == null) {
                receiverClass = exportsLibrary.getReceiverType();
            } else if (!ElementUtils.typeEquals(exportsLibrary.getReceiverType(), receiverClass)) {
                exportsLibrary.addError("All receiver classes must match for a declared java type. Found '%s' and '%s'.", ElementUtils.getSimpleName(receiverClass), ElementUtils.getSimpleName(exportsLibrary.getReceiverType()));
                continue;
            }
            LinkedHashSet<LibraryMessage> missingAbstractMessage = new LinkedHashSet<LibraryMessage>();
            LinkedHashSet<LibraryMessage> missingAbstractMessageAsWarning = new LinkedHashSet<LibraryMessage>();
            block21: for (LibraryMessage message4 : exportsLibrary.getLibrary().getMethods()) {
                boolean isAbstract;
                List elementsWithSameName = linkedHashMap.getOrDefault(message4.getName(), Collections.emptyList());
                if (!elementsWithSameName.isEmpty()) {
                    for (Element overridingElement : elementsWithSameName) {
                        if (ElementUtils.findAnnotationMirror(overridingElement, (TypeMirror)this.types.ExportMessage_Ignore) != null) continue;
                        exportsLibrary.addError(overridingElement, "The method has the same name '%s' as a message in the exported library %s. Did you forget to export it? Use @%s to export the message, @%s to ignore this warning, rename the method or reduce the visibility of the method to private to resolve this warning.", overridingElement.getSimpleName().toString(), ElementUtils.getSimpleName(exportsLibrary.getLibrary().getTemplateType()), this.types.ExportMessage.asElement().getSimpleName().toString(), this.types.ExportMessage_Ignore.asElement().getSimpleName().toString());
                    }
                }
                if (!message4.isAbstract() || message4.getName().equals("accepts") || exportsLibrary.isExported(message4)) continue;
                if (!message4.getAbstractIfExported().isEmpty()) {
                    isAbstract = false;
                    for (LibraryMessage abstractIfExported : message4.getAbstractIfExported()) {
                        if (!exportsLibrary.getExportedMessages().containsKey(abstractIfExported.getName())) continue;
                        isAbstract = true;
                        break;
                    }
                } else {
                    isAbstract = message4.getAbstractIfExportedAsWarning().isEmpty() ? !exportsLibrary.hasExportDelegation() : false;
                }
                if (isAbstract) {
                    missingAbstractMessage.add(message4);
                }
                if (message4.getAbstractIfExportedAsWarning().isEmpty()) continue;
                for (LibraryMessage abstractIfExportedAsWarning : message4.getAbstractIfExportedAsWarning()) {
                    if (!exportsLibrary.getExportedMessages().containsKey(abstractIfExportedAsWarning.getName())) continue;
                    missingAbstractMessageAsWarning.add(message4);
                    continue block21;
                }
            }
            if (missingAbstractMessage.isEmpty() && missingAbstractMessageAsWarning.isEmpty()) continue;
            LinkedHashSet<LibraryMessage> missingAbstractMessages = new LinkedHashSet<LibraryMessage>(missingAbstractMessage);
            missingAbstractMessages.addAll(missingAbstractMessageAsWarning);
            StringBuilder msg = new StringBuilder(String.format("The following message(s) of library %s are abstract and should be exported using:%n", ElementUtils.getSimpleName(exportsLibrary.getLibrary().getTemplateType())));
            for (LibraryMessage message5 : missingAbstractMessages) {
                msg.append("  ").append(ExportsParser.generateExpectedSignature(type, message5, exportsLibrary.getExplicitReceiver())).append(" {");
                if (!ElementUtils.isVoid(message5.getExecutable().getReturnType())) {
                    msg.append(" return ").append(ElementUtils.defaultValue(message5.getExecutable().getReturnType()));
                    msg.append(";");
                }
                msg.append(" }%n");
            }
            if (!missingAbstractMessage.isEmpty()) {
                exportsLibrary.addError(msg.toString(), new Object[0]);
                continue;
            }
            exportsLibrary.addSuppressableWarning("truffle-abstract-export", msg.toString(), new Object[0]);
        }
        for (ExportsLibrary exportsLibrary : model.getExportedLibraries().values()) {
            for (ExportMessageData export : exportsLibrary.getExportedMessages().values()) {
                message = export.getResolvedMessage();
                if (!message.isDeprecated()) continue;
                LibraryMessage replacement = message.getDeprecatedReplacement();
                if (replacement != null) {
                    export.addSuppressableWarning("deprecation", "The message with signature '%s' of library '%s' is deprecated and should be updated to be compatible with its new signature '%s'. Update the signature to resolve this problem.", ElementUtils.getReadableSignature(message.getExecutable()), ElementUtils.getSimpleName(message.getLibrary().getTemplateType()), ElementUtils.getReadableSignature(replacement.getExecutable()));
                    continue;
                }
                export.addSuppressableWarning("deprecation", "The message '%s' from library '%s' is deprecated. Please refer to the library documentation on how to resolve this problem.", message.getExecutable().getSimpleName().toString(), ElementUtils.getSimpleName(message.getLibrary().getTemplateType()));
            }
        }
        for (ExportsLibrary exportsLibrary : model.getExportedLibraries().values()) {
            ArrayList<NodeData> arrayList = new ArrayList<NodeData>();
            ArrayList<ExportMessageData> exportedMessages = new ArrayList<ExportMessageData>();
            for (ExportMessageData export : exportsLibrary.getExportedMessages().values()) {
                NodeData node = export.getSpecializedNode();
                if (node == null) continue;
                arrayList.add(node);
                exportedMessages.add(export);
            }
            exportsLibrary.setSharedExpressions(NodeParser.computeSharing(exportsLibrary.getTemplateType(), arrayList, true));
            for (int i = 0; i < arrayList.size(); ++i) {
                NodeData nodeData = (NodeData)arrayList.get(i);
                ExportMessageData exportedMessage = (ExportMessageData)exportedMessages.get(i);
                if (nodeData.hasErrorsOrWarnings()) {
                    nodeData.redirectMessagesOnGeneratedElements(exportedMessage);
                }
                nodeData.setGenerateUncached(false);
            }
        }
        for (ExportMessageData exportMessageData : exportedElements) {
            if (ElementUtils.elementEquals(exportMessageData.getMessageElement().getEnclosingElement(), model.getTemplateType())) continue;
            exportMessageData.redirectMessages(exportMessageData.getExportsLibrary());
        }
        for (ExportsLibrary exportsLibrary : model.getExportedLibraries().values()) {
            for (ExportMessageData export : exportsLibrary.getExportedMessages().values()) {
                if (!export.isClass() || export.getSpecializedNode() == null) continue;
                NodeParser.removeSpecializations(export.getSpecializedNode(), exportsLibrary.getSharedExpressions(), this.isGenerateSlowPathOnly(type));
            }
        }
        return model;
    }

    private static LibraryMessage resolveOverload(List<LibraryMessage> overloads, List<TypeMirror> genericSignature) {
        for (LibraryMessage overload : overloads) {
            if (!overload.isCompatibleExact(genericSignature)) continue;
            return overload;
        }
        for (LibraryMessage overload : overloads) {
            if (!overload.isCompatibleAssignable(genericSignature)) continue;
            return overload;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private List<TypeMirror> computeGenericSignature(Element member) {
        if (ExportsParser.isMethodElement(member)) {
            ExecutableElement exportedMethod = (ExecutableElement)member;
            return ExportsParser.computeSpecializationSignature(exportedMethod);
        }
        if (ExportsParser.isNodeElement(member)) {
            void var6_9;
            TypeElement type = (TypeElement)member;
            ArrayList<List<TypeMirror>> signatures = new ArrayList<List<TypeMirror>>();
            int maxArguments = 0;
            for (Element element : this.loadMembers(Set.of(type), type)) {
                if (element.getKind() != ElementKind.METHOD || ElementUtils.findAnnotationMirror(element, (TypeMirror)this.types.Specialization) == null && ElementUtils.findAnnotationMirror(element, (TypeMirror)this.types.Fallback) == null) continue;
                List<TypeMirror> signature = ExportsParser.computeSpecializationSignature((ExecutableElement)element);
                maxArguments = Math.max(maxArguments, signature.size());
                signatures.add(signature);
            }
            if (signatures.size() == 1) {
                return (List)signatures.get(0);
            }
            ArrayList<TypeMirror> commonTypes = new ArrayList<TypeMirror>(maxArguments);
            boolean bl = false;
            while (var6_9 < maxArguments) {
                ArrayList<TypeMirror> possibleTypes = new ArrayList<TypeMirror>();
                for (List list : signatures) {
                    possibleTypes.add((TypeMirror)list.get((int)var6_9));
                }
                commonTypes.add(ElementUtils.getCommonSuperType(this.context, possibleTypes));
                ++var6_9;
            }
            return commonTypes;
        }
        throw new AssertionError((Object)"should not be reachable");
    }

    private static List<TypeMirror> computeSpecializationSignature(ExecutableElement exportedMethod) {
        List<TypeMirror> cachedAnnotations = NodeParser.getCachedAnnotations();
        ArrayList<TypeMirror> signature = new ArrayList<TypeMirror>();
        for (VariableElement variableElement : exportedMethod.getParameters()) {
            for (TypeMirror cachedAnnotation : cachedAnnotations) {
                AnnotationMirror found = ElementUtils.findAnnotationMirror(variableElement.getAnnotationMirrors(), cachedAnnotation);
                if (found == null) continue;
                return signature;
            }
            signature.add(variableElement.asType());
        }
        return signature;
    }

    private List<? extends Element> loadMembers(Set<TypeElement> relevantTypes, TypeElement templateType) {
        if (relevantTypes != null && relevantTypes.isEmpty()) {
            return Collections.emptyList();
        }
        List<? extends Element> elements = relevantTypes == null || relevantTypes.size() == 1 && ElementUtils.elementEquals(relevantTypes.iterator().next(), templateType) ? CompilerFactory.getCompiler(templateType).getEnclosedElementsInDeclarationOrder(templateType) : CompilerFactory.getCompiler(templateType).getAllMembersInDeclarationOrder(this.context.getEnvironment(), templateType);
        elements = new ArrayList<Element>(elements);
        HashSet<String> relevantTypeIds = null;
        if (relevantTypes != null) {
            relevantTypeIds = new HashSet<String>();
            for (TypeElement typeElement : relevantTypes) {
                relevantTypeIds.add(ElementUtils.getTypeSimpleId(typeElement.asType()));
            }
        }
        Iterator<? extends Element> elementIterator = elements.iterator();
        while (elementIterator.hasNext()) {
            Element element = elementIterator.next();
            TypeMirror enclosingType = element.getEnclosingElement().asType();
            if (relevantTypeIds != null && !relevantTypeIds.contains(ElementUtils.getTypeSimpleId(enclosingType))) {
                elementIterator.remove();
                continue;
            }
            if (!ElementUtils.typeEquals(templateType.asType(), enclosingType) && !ElementUtils.isVisible(templateType, element)) {
                elementIterator.remove();
                continue;
            }
            if (!ElementUtils.isObject(enclosingType)) continue;
            elementIterator.remove();
        }
        return elements;
    }

    private ExportsData parseExports(TypeElement type, List<AnnotationMirror> elementMirrors) {
        ExportsData model = new ExportsData(this.context, type, null);
        if (type.getKind().isInterface()) {
            model.addError("@%s is not supported for interfaces at the moment.", this.types.ExportLibrary.asElement().getSimpleName().toString());
            return model;
        }
        if (ElementUtils.getVisibility(type.getModifiers()) == Modifier.PRIVATE) {
            model.addError("The exported type must not be private. Increase visibility to resolve this.", new Object[0]);
            return model;
        }
        LinkedHashMap<AnnotationMirror, TypeElement> mirrors = new LinkedHashMap<AnnotationMirror, TypeElement>();
        for (AnnotationMirror annotationMirror : elementMirrors) {
            mirrors.put(annotationMirror, type);
        }
        TypeElement superType = type;
        while ((superType = ElementUtils.getSuperType(superType)) != null) {
            for (AnnotationMirror mirror : ElementUtils.getRepeatedAnnotation(superType.getAnnotationMirrors(), this.types.ExportLibrary)) {
                mirrors.put(mirror, superType);
            }
        }
        LinkedHashMap<String, List> linkedHashMap = new LinkedHashMap<String, List>();
        for (AnnotationMirror annotationMirror : mirrors.keySet()) {
            TypeMirror library = ElementUtils.getAnnotationValue(TypeMirror.class, annotationMirror, "value");
            linkedHashMap.computeIfAbsent(ElementUtils.getTypeSimpleId(library), id -> new ArrayList()).add(annotationMirror);
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            String delegateTo;
            boolean explicitReceiver;
            String libraryId = (String)entry.getKey();
            List annotationMirrors = (List)entry.getValue();
            AnnotationMirror annotationMirror = (AnnotationMirror)annotationMirrors.get(0);
            TypeMirror libraryMirror = ElementUtils.getAnnotationValue(TypeMirror.class, annotationMirror, "value");
            AnnotationValue receiverClassValue = ElementUtils.getAnnotationValue(annotationMirror, "receiverType");
            TypeMirror receiverClass = ElementUtils.getAnnotationValue(TypeMirror.class, annotationMirror, "receiverType", false);
            if (receiverClass == null) {
                explicitReceiver = false;
                receiverClass = type.asType();
            } else {
                explicitReceiver = true;
            }
            LibraryData libraryData = this.context.parseIfAbsent(ElementUtils.fromTypeMirror(libraryMirror), LibraryParser.class, t -> (LibraryData)new LibraryParser().parse((Element)t));
            ExportsLibrary lib = new ExportsLibrary(this.context, type, annotationMirror, model, libraryData, receiverClass, explicitReceiver);
            ExportsLibrary otherLib = model.getExportedLibraries().get(libraryId);
            for (AnnotationMirror mirror : annotationMirrors) {
                lib.getDeclaringTypes().add((TypeElement)mirrors.get(mirror));
            }
            model.getExportedLibraries().put(libraryId, lib);
            Integer priority = ElementUtils.getAnnotationValue(Integer.class, annotationMirror, "priority", false);
            if (priority == null && lib.needsDefaultExportProvider()) {
                lib.addError("The priority property must be set for default exports based on service providers. See @%s(priority=...) for details.", ElementUtils.getSimpleName(this.types.ExportLibrary));
                continue;
            }
            if (priority != null) {
                LibraryDefaultExportData builtinDefaultExport;
                int prio = priority;
                AnnotationValue annotationValue = ElementUtils.getAnnotationValue(annotationMirror, "priority");
                if (prio < 0 && (builtinDefaultExport = libraryData.getBuiltinDefaultExport(receiverClass)) != null) {
                    lib.addError(annotationValue, "The provided export receiver type '%s' is not reachable with the given priority. The '%s' library specifies @%s(%s) which has receiver type '%s' and that shadows this export. Increase the priority to a positive integer to resolve this.", ElementUtils.getSimpleName(receiverClass), ElementUtils.getSimpleName(libraryData.getTemplateType()), ElementUtils.getSimpleName(this.types.GenerateLibrary_DefaultExport), ElementUtils.getSimpleName(builtinDefaultExport.getImplType()), ElementUtils.getSimpleName(builtinDefaultExport.getReceiverType()));
                    continue;
                }
                if (prio == 0) {
                    lib.addError(annotationValue, "The set priority must be either positive or negative, but must not be 0.", new Object[0]);
                    continue;
                }
                lib.setDefaultExportPriority(priority);
            }
            if (ElementUtils.isPrimitive(receiverClass)) {
                lib.addError(annotationMirror, receiverClassValue, "Primitive receiver types are not supported yet.", new Object[0]);
                continue;
            }
            if (libraryData == null) {
                lib.addError("Class '%s' is not a library annotated with @%s.", ElementUtils.getSimpleName(libraryMirror), this.types.GenerateLibrary.asElement().getSimpleName().toString());
                continue;
            }
            if (libraryData.hasErrors()) {
                lib.addError("Library specification %s has errors. Please resolve them first.", ElementUtils.getSimpleName(libraryMirror));
                continue;
            }
            if (otherLib != null) {
                String message = String.format("Duplicate library specified %s.", ElementUtils.getSimpleName(libraryMirror));
                otherLib.addError(message, new Object[0]);
                lib.addError(message, new Object[0]);
                continue;
            }
            lib.setUseForAOT(ElementUtils.getAnnotationValue(Boolean.class, annotationMirror, "useForAOT"));
            if (libraryData.isGenerateAOT()) {
                Integer useForAOTPriority;
                AnnotationValue useForAOT = ElementUtils.getAnnotationValue(annotationMirror, "useForAOT", false);
                if (useForAOT == null) {
                    lib.addError(annotationMirror, useForAOT, "The useForAOT property needs to be declared for exports of libraries annotated with @%s. Declare the useForAOT property to resolve this problem.", ElementUtils.getSimpleName(this.types.GenerateAOT));
                }
                if ((useForAOTPriority = ElementUtils.getAnnotationValue(Integer.class, annotationMirror, "useForAOTPriority", false)) == null && lib.isUseForAOT()) {
                    lib.addError("The useForAOTPriority property must also be set for libraries used for AOT. See @%s(useForAOTPriority=...) for details.", ElementUtils.getSimpleName(this.types.ExportLibrary));
                    continue;
                }
                if (useForAOTPriority != null) {
                    lib.setUseForAOTPriority(useForAOTPriority);
                }
            }
            if (lib.isUseForAOT() && !lib.isFinalReceiver()) {
                AnnotationValue useForAOT = ElementUtils.getAnnotationValue(annotationMirror, "useForAOT", false);
                lib.addError(annotationMirror, useForAOT, "If useForAOT is set to true the receiver type must be a final. The compiled code would otherwise cause performance warnings. Add the final modifier to the receiver class or set useForAOT to false to resolve this.", new Object[0]);
            } else if (lib.isUseForAOT() && lib.isDynamicDispatchTarget()) {
                AnnotationMirror dynamicDispatchExportMirror = lib.getReceiverDynamicDispatchExport();
                if (dynamicDispatchExportMirror == null) {
                    throw new AssertionError((Object)"Should not reach here. isDynamicDispatchTarget should not return true");
                }
                if (!ElementUtils.getAnnotationValue(Boolean.class, dynamicDispatchExportMirror, "useForAOT").booleanValue()) {
                    AnnotationValue useForAOT = ElementUtils.getAnnotationValue(annotationMirror, "useForAOT", false);
                    lib.addError(annotationMirror, useForAOT, "The dynamic dispatch target must set useForAOT to true also for the DynamicDispatch export of the receiver type %s. ", ElementUtils.getSimpleName(lib.getReceiverType()));
                }
            }
            if (lib.isUseForAOT() && !libraryData.isGenerateAOT() && !libraryData.isDynamicDispatch()) {
                AnnotationValue useForAOT = ElementUtils.getAnnotationValue(annotationMirror, "useForAOT", false);
                lib.addError(annotationMirror, useForAOT, "The exported library does not support AOT. Add the @%s annotation to the library class %s to resolve this.", ElementUtils.getSimpleName(this.types.GenerateAOT), ElementUtils.getQualifiedName(libraryData.getTemplateType()));
            }
            if (explicitReceiver) {
                TypeMirror receiverTypeErasure = this.context.getEnvironment().getTypeUtils().erasure(libraryData.getSignatureReceiverType());
                if (!ElementUtils.isSubtype(receiverClass, receiverTypeErasure)) {
                    lib.addError(annotationMirror, receiverClassValue, "The export receiver type %s is not compatible with the library receiver type '%s' of library '%s'. ", ElementUtils.getSimpleName(receiverClass), ElementUtils.getSimpleName(libraryData.getSignatureReceiverType()), ElementUtils.getSimpleName(libraryData.getTemplateType().asType()));
                }
            } else if (!ElementUtils.isSubtype(type.asType(), libraryData.getExportsReceiverType())) {
                lib.addError("Type %s is not compatible with the receiver type '%s' of exported library '%s'. Inhert from type '%s' to resolve this.", ElementUtils.getSimpleName(type.asType()), ElementUtils.getSimpleName(libraryData.getExportsReceiverType()), ElementUtils.getSimpleName(libraryData.getTemplateType().asType()), ElementUtils.getSimpleName(libraryData.getExportsReceiverType()));
            }
            String transitionLimit = ElementUtils.getAnnotationValue(String.class, annotationMirror, "transitionLimit", false);
            if (transitionLimit != null) {
                DSLExpressionResolver resolver = new DSLExpressionResolver(this.context, model.getTemplateType(), NodeParser.importVisibleStaticMembers(model.getTemplateType(), model.getTemplateType(), false));
                lib.setTransitionLimit(DSLExpression.parseAndResolve(resolver, lib, "transitionLimit", transitionLimit));
            }
            if ((delegateTo = ElementUtils.getAnnotationValue(String.class, annotationMirror, "delegateTo", false)) != null) {
                TypeMirror exportsReceiverType;
                AnnotationValue delegateToValue = ElementUtils.getAnnotationValue(annotationMirror, "delegateTo");
                if (receiverClass.getKind() != TypeKind.DECLARED) {
                    lib.addError(delegateToValue, "The receiver type must be declared type for delegation.", new Object[0]);
                    continue;
                }
                VariableElement delegateVar = ElementUtils.findVariableElement((DeclaredType)receiverClass, delegateTo);
                if (delegateVar == null) {
                    lib.addError(delegateToValue, "The delegation variable with name '%s' could not be found in type '%s'. Declare a field 'final Object %s' in '%s' to resolve this problem.", delegateTo, ElementUtils.getSimpleName(receiverClass), delegateTo, ElementUtils.getSimpleName(receiverClass));
                    continue;
                }
                if (!delegateVar.getModifiers().contains((Object)Modifier.FINAL)) {
                    lib.addError(delegateToValue, "The delegation variable with name '%s' in type '%s' must be have the modifier final. Make the variable final to resolve the problem.", delegateTo, ElementUtils.getSimpleName(receiverClass));
                    continue;
                }
                PackageElement packageElement = ElementUtils.findPackageElement(lib.getTemplateType());
                if (!ElementUtils.isVisible(packageElement, delegateVar)) {
                    lib.addError(delegateToValue, "The delegation variable with name '%s' in type '%s' is not visible in package '%s'. Increase the visibility to resolve this problem.", delegateTo, ElementUtils.getSimpleName(receiverClass), ElementUtils.getPackageName(packageElement));
                    continue;
                }
                TypeMirror delegateType = delegateVar.asType();
                if (!ElementUtils.isAssignable(delegateType, exportsReceiverType = lib.getLibrary().getSignatureReceiverType())) {
                    lib.addError(delegateToValue, "The type of export delegation field '%s' is not assignable to the expected type '%s'. Change the field type to '%s' to resolve this.", ElementUtils.getSimpleName(receiverClass) + "." + delegateTo, ElementUtils.getSimpleName(exportsReceiverType), ElementUtils.getSimpleName(exportsReceiverType));
                    continue;
                }
                lib.setDelegationVariable(delegateVar);
            }
            for (LibraryMessage message : libraryData.getMethods()) {
                model.getLibraryMessages().computeIfAbsent(message.getName(), n -> new ArrayList()).add(message);
            }
        }
        for (ExportsLibrary exportsLibrary : model.getExportedLibraries().values()) {
            if (exportsLibrary.hasErrors()) continue;
            boolean explicitReceiver = exportsLibrary.isExplicitReceiver();
            int dynamicDispatchEnabledCount = 0;
            for (ExportsLibrary library : model.getExportedLibraries().values()) {
                if (!library.getLibrary().isDynamicDispatchEnabled()) continue;
                ++dynamicDispatchEnabledCount;
            }
            if (exportsLibrary.getLibrary().isDynamicDispatch() && dynamicDispatchEnabledCount > 0) {
                exportsLibrary.addError("@%s cannot be used for other libraries if the %s library is exported. Using dynamic dispatch and other libraries is mutually exclusive. To resolve this use the dynamic dispatch mechanism of the receiver type instead to export libraries.", this.types.ExportLibrary.asElement().getSimpleName().toString(), this.types.DynamicDispatchLibrary.asElement().getSimpleName().toString());
                continue;
            }
            if (explicitReceiver && !exportsLibrary.getLibrary().isDefaultExportLookupEnabled() && !exportsLibrary.isDynamicDispatchTarget() && !exportsLibrary.isBuiltinDefaultExport()) {
                String dynamicDispatchDisabled = "";
                if (!exportsLibrary.getLibrary().isDynamicDispatchEnabled()) {
                    dynamicDispatchDisabled = String.format("Note that dynamic dispatch is disabled for the exported library '%s'.%n", ElementUtils.getSimpleName(exportsLibrary.getLibrary().getTemplateType()));
                }
                exportsLibrary.addError(exportsLibrary.getTemplateTypeAnnotation(), ElementUtils.getAnnotationValue(exportsLibrary.getTemplateTypeAnnotation(), "receiverType"), "Using explicit receiver types is only supported for default exports or types that export %s.%n%sTo resolve this use one of the following strategies:%n  - Make the receiver type implicit by applying '@%s(%s.class)' to the receiver type '%s' instead.%n  - Declare a default export on the '%s' library with '@%s(%s.class)'%n  - Enable default exports with service providers using @%s(defaultExportLookupEnabled=true) on the library and specify an export priority%n  - Enable dynamic dispatch by annotating the receiver type with '@%s(%s.class)'.", this.types.DynamicDispatchLibrary.asElement().getSimpleName().toString(), dynamicDispatchDisabled, this.types.ExportLibrary.asElement().getSimpleName().toString(), exportsLibrary.getLibrary().getTemplateType().getSimpleName().toString(), ElementUtils.getSimpleName(exportsLibrary.getExplicitReceiver()), exportsLibrary.getLibrary().getTemplateType().getSimpleName().toString(), this.types.GenerateLibrary_DefaultExport.asElement().getSimpleName().toString(), ElementUtils.getSimpleName(exportsLibrary.getTemplateType().asType()), ElementUtils.getSimpleName(this.types.GenerateLibrary), this.types.ExportLibrary.asElement().getSimpleName().toString(), this.types.DynamicDispatchLibrary.asElement().getSimpleName().toString());
                continue;
            }
            if (!explicitReceiver || exportsLibrary.isBuiltinDefaultExport()) continue;
            boolean foundInvalidExportsOnReceiver = false;
            superType = ElementUtils.castTypeElement(exportsLibrary.getExplicitReceiver());
            while (superType != null) {
                List<AnnotationMirror> exports = ElementUtils.getRepeatedAnnotation(superType.getAnnotationMirrors(), this.types.ExportLibrary);
                for (AnnotationMirror export : exports) {
                    TypeMirror exportedLibraryType = ElementUtils.getAnnotationValue(TypeMirror.class, export, "value");
                    if (ElementUtils.typeEquals(exportedLibraryType, this.types.DynamicDispatchLibrary)) continue;
                    foundInvalidExportsOnReceiver = true;
                    break;
                }
                superType = ElementUtils.getSuperType(superType);
            }
            if (!foundInvalidExportsOnReceiver) continue;
            AnnotationValue receiverClassValue = ElementUtils.getAnnotationValue(exportsLibrary.getMessageAnnotation(), "receiverType");
            exportsLibrary.addError(exportsLibrary.getMessageAnnotation(), receiverClassValue, "An export that is used for dynamic dispatch must not export any libraries other than %s with the receiver type.", this.types.DynamicDispatchLibrary.asElement().getSimpleName().toString());
        }
        return model;
    }

    private List<ExportMessageData> parseExportedMessage(ExportsData model, Element member, AnnotationMirror exportAnnotation) throws AssertionError {
        ArrayList<ExportMessageData> exportMessages;
        block25: {
            Iterator iterator;
            AnnotationValue nameValue = ElementUtils.getAnnotationValue(exportAnnotation, "name", false);
            String name = ElementUtils.getAnnotationValue(String.class, exportAnnotation, "name");
            Object error = null;
            AnnotationValue errorValue = null;
            if (nameValue == null) {
                if (ExportsParser.isMethodElement(member)) {
                    name = member.getSimpleName().toString();
                } else if (ExportsParser.isNodeElement(member)) {
                    TypeElement type = (TypeElement)member;
                    name = ExportsParser.inferNodeMessageName(type);
                } else {
                    error = "Unsupported exported element.";
                }
            }
            AnnotationValue libraryValue = ElementUtils.getAnnotationValue(exportAnnotation, "library", false);
            TypeMirror library = ElementUtils.getAnnotationValue(TypeMirror.class, exportAnnotation, "library");
            if (libraryValue == null) {
                List<LibraryMessage> messages = model.getLibraryMessages().get(name);
                if (messages == null || messages.size() == 0) {
                    if (model.getExportedLibraries().isEmpty()) {
                        error = String.format("No libraries exported. Use @%s(MyLibrary.class) on the enclosing type to export libraries.", this.types.ExportLibrary.asElement().getSimpleName().toString());
                    } else {
                        StringBuilder libBuilder = new StringBuilder();
                        String sep = "";
                        for (ExportsLibrary lib : model.getExportedLibraries().values()) {
                            libBuilder.append(sep);
                            libBuilder.append(ElementUtils.getSimpleName(lib.getLibrary().getTemplateType().asType()));
                            sep = ", ";
                        }
                        error = model.getExportedLibraries().size() <= 1 ? String.format("No message '%s' found for library %s.", name, libBuilder) : String.format("No message '%s' found for libraries %s.", name, libBuilder);
                        List<String> fuzzyMatches = ExportsParser.fuzzyMatch(model.getLibraryMessages().keySet(), name, 0.7f);
                        if (fuzzyMatches.isEmpty()) {
                            fuzzyMatches = ExportsParser.fuzzyMatch(model.getLibraryMessages().keySet(), name, 0.5f);
                        }
                        if (!fuzzyMatches.isEmpty()) {
                            StringBuilder appendix = new StringBuilder(" Did you mean ");
                            sep = "";
                            for (String string : fuzzyMatches) {
                                appendix.append(sep);
                                appendix.append('\'').append(string).append('\'');
                                sep = ", ";
                            }
                            error = (String)error + appendix.toString() + "?";
                        }
                        errorValue = nameValue;
                    }
                    model.addError(member, (String)error, new Object[0]);
                    return Collections.emptyList();
                }
                if (messages.size() > 1) {
                    Object prevMessage = null;
                    boolean signatureMatches = true;
                    for (LibraryMessage message : messages) {
                        if (prevMessage != null && !ElementUtils.signatureEquals(((LibraryMessage)prevMessage).getExecutable(), message.getExecutable())) {
                            signatureMatches = false;
                            break;
                        }
                        prevMessage = message;
                    }
                    if (!signatureMatches) {
                        StringBuilder libBuilder = new StringBuilder();
                        String sep = "";
                        for (LibraryMessage ambiguousMessage : messages) {
                            libBuilder.append(sep);
                            libBuilder.append(ElementUtils.getSimpleName(ambiguousMessage.getLibrary().getTemplateType().asType()));
                            sep = " and ";
                        }
                        error = String.format("The message name '%s' is ambiguous for libraries %s. Disambiguate the library by specifying the library explicitely using @%s(library=Library.class).", name, libBuilder.toString(), this.types.ExportMessage.asElement().getSimpleName().toString());
                        model.addError(member, (String)error, new Object[0]);
                        return Collections.emptyList();
                    }
                }
                exportMessages = new ArrayList<ExportMessageData>(messages.size());
                for (LibraryMessage message : messages) {
                    ExportsLibrary exportsLibrary = model.getExportedLibraries().get(ElementUtils.getTypeSimpleId(((TypeElement)message.getLibrary().getMessageElement()).asType()));
                    exportMessages.add(new ExportMessageData(exportsLibrary, message, member, exportAnnotation));
                }
            } else {
                ExportsLibrary exportsLibrary = model.getExportedLibraries().get(ElementUtils.getTypeSimpleId(library));
                if (exportsLibrary == null) {
                    AnnotationMirror mirror = ElementUtils.findAnnotationMirror(library.getAnnotationMirrors(), (TypeMirror)this.types.GenerateLibrary);
                    String qualifiedName = ElementUtils.getQualifiedName(library);
                    error = mirror == null ? String.format("Class '%s' is not a library annotated with @%s.", qualifiedName, this.types.GenerateLibrary.asElement().getSimpleName().toString()) : String.format("Explicitely specified library '%s' also needs to be exported on the class using @%s(%s.class).", qualifiedName, this.types.ExportLibrary.asElement().getSimpleName().toString(), ElementUtils.getSimpleName(library));
                    model.addError(member, (String)error, new Object[0]);
                    return Collections.emptyList();
                }
                List<LibraryMessage> searchMessages = model.getLibraryMessages().get(name);
                LibraryMessage message = null;
                if (searchMessages != null) {
                    for (LibraryMessage searchMessage : searchMessages) {
                        if (searchMessage.getLibrary() != exportsLibrary.getLibrary()) continue;
                        message = searchMessage;
                        break;
                    }
                }
                if (message == null) {
                    StringBuilder libBuilder = new StringBuilder();
                    String sep = "";
                    for (ExportsLibrary lib : model.getExportedLibraries().values()) {
                        libBuilder.append(sep);
                        libBuilder.append(ElementUtils.getSimpleName(lib.getLibrary().getTemplateType().asType()));
                        sep = ", ";
                    }
                    error = String.format("No message '%s' found for library %s.", name, ElementUtils.getSimpleName(exportsLibrary.getLibrary().getTemplateType().asType()));
                    errorValue = nameValue;
                }
                exportMessages = new ArrayList(1);
                exportMessages.add(new ExportMessageData(exportsLibrary, message, member, exportAnnotation));
            }
            if (error == null || !(iterator = exportMessages.iterator()).hasNext()) break block25;
            ExportMessageData export = (ExportMessageData)iterator.next();
            export.addError(errorValue, (String)error, new Object[0]);
        }
        return exportMessages;
    }

    private void initializeExportedNode(Map<String, NodeData> parsedNodeCache, ExportMessageData exportElement) {
        TypeElement exportedTypeElement = (TypeElement)exportElement.getMessageElement();
        if (exportedTypeElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            exportElement.addError("Exported message node class must not be private.", new Object[0]);
            return;
        }
        if (!exportedTypeElement.getModifiers().contains((Object)Modifier.STATIC)) {
            exportElement.addError("Inner message node class must be static.", new Object[0]);
            return;
        }
        List<? extends Element> typeMembers = this.loadMembers(null, exportedTypeElement);
        boolean hasSpecialization = false;
        boolean hasExecute = false;
        for (ExecutableElement method : ElementFilter.methodsIn(typeMembers)) {
            Set<Modifier> modifiers;
            if (!hasSpecialization && ElementUtils.findAnnotationMirror((Element)method, (TypeMirror)this.types.Specialization) != null) {
                hasSpecialization = true;
            }
            if ((modifiers = method.getModifiers()).contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC) || !method.getSimpleName().toString().startsWith(EXECUTE_PREFIX)) continue;
            exportElement.addError(method, "An @%s annotated class must not declare any visible methods starting with 'execute'. Use @%s annotated methods instead.", this.types.ExportMessage.asElement().getSimpleName().toString(), this.types.Specialization.asElement().getSimpleName().toString());
            return;
        }
        if (!ElementUtils.typeEquals(exportedTypeElement.getSuperclass(), this.context.getType(Object.class))) {
            exportElement.addError("An @%s annotated class must extend Object. Other base classes are not supported.", this.types.ExportMessage.asElement().getSimpleName().toString(), this.types.Node.asElement().getSimpleName().toString());
            return;
        }
        if (!hasSpecialization) {
            ExecutableElement signature = exportElement.getResolvedMessage().getExecutable();
            StringBuilder fix = new StringBuilder();
            fix.append("@").append(this.types.Specialization.asElement().getSimpleName().toString()).append(" ");
            fix.append("static ");
            fix.append(ElementUtils.getSimpleName(signature.getReturnType()));
            fix.append(" ").append("doDefault(");
            String sep = "";
            for (VariableElement variableElement : signature.getParameters()) {
                fix.append(sep);
                TypeMirror type = sep.length() == 0 ? exportElement.getExportsLibrary().getReceiverType() : variableElement.asType();
                fix.append(ElementUtils.getSimpleName(type));
                fix.append(" ");
                fix.append(variableElement.getSimpleName().toString());
                sep = ", ";
            }
            fix.append(") { ");
            if (!ElementUtils.isVoid(signature.getReturnType())) {
                fix.append("return ").append(ElementUtils.defaultValue(signature.getReturnType())).append("; ");
            }
            fix.append("}");
            exportElement.addError("An @%s annotated class must have at least one method with @%s annotation. Add the following method to resolve this:%n     %s", this.types.ExportMessage.asElement().getSimpleName().toString(), this.types.Specialization.asElement().getSimpleName().toString(), fix.toString());
            return;
        }
        if (hasExecute) {
            exportElement.addError("An @%s annotated class must not declary any visible methods starting with 'execute'.", this.types.ExportMessage.asElement().getSimpleName().toString());
            return;
        }
        if (exportElement.hasErrors()) {
            return;
        }
        NodeData parsedNodeData = this.parseNode(parsedNodeCache, exportedTypeElement, exportElement, typeMembers);
        if (parsedNodeData == null) {
            exportElement.addError("Could not parse invalid node.", new Object[0]);
            return;
        }
        parsedNodeData.getNodeId();
        parsedNodeData.setGenerateUncached(false);
        exportElement.setSpecializedNode(parsedNodeData);
    }

    private void initializeExportedMethod(Map<String, NodeData> parsedNodeCache, ExportsData model, ExportMessageData exportedElement) {
        boolean aotExcluded;
        ExecutableElement exportedMethod = (ExecutableElement)exportedElement.getMessageElement();
        LibraryMessage message = exportedElement.getResolvedMessage();
        ExportsLibrary exportsLibrary = exportedElement.getExportsLibrary();
        if (ElementUtils.getVisibility(exportedMethod.getModifiers()) == Modifier.PRIVATE) {
            exportedElement.addError("The exported method must not be private. Increase visibility to resolve this.", new Object[0]);
            return;
        }
        List<TypeMirror> cachedAnnotations = NodeParser.getCachedAnnotations();
        ArrayList<VariableElement> cachedNodes = new ArrayList<VariableElement>();
        ArrayList<VariableElement> cachedLibraries = new ArrayList<VariableElement>();
        int realParameterCount = 0;
        block0: for (VariableElement variableElement : exportedMethod.getParameters()) {
            AnnotationMirror cachedMirror = null;
            for (TypeMirror cachedAnnotation : cachedAnnotations) {
                AnnotationMirror found = ElementUtils.findAnnotationMirror(variableElement.getAnnotationMirrors(), cachedAnnotation);
                if (found == null) continue;
                if (cachedMirror == null) {
                    cachedMirror = found;
                    continue;
                }
                StringBuilder b = new StringBuilder();
                String sep = "";
                for (TypeMirror stringCachedAnnotation : cachedAnnotations) {
                    b.append(sep);
                    b.append("@");
                    b.append(ElementUtils.getSimpleName(stringCachedAnnotation));
                    sep = ", ";
                }
                exportedElement.addError(variableElement, "The following annotations are mutually exclusive for a parameter: %s.", b.toString());
                continue block0;
            }
            if (this.isCachedLibrary(variableElement)) {
                cachedLibraries.add(variableElement);
                continue;
            }
            if (cachedMirror != null) {
                cachedNodes.add(variableElement);
                continue;
            }
            ++realParameterCount;
        }
        ExportsParser.verifyMethodSignature(model.getTemplateType(), message, exportedElement, exportedMethod, exportsLibrary.getReceiverType(), realParameterCount, true);
        boolean bl = aotExcluded = ElementUtils.findAnnotationMirror((Element)exportedMethod, (TypeMirror)this.types.GenerateAOT_Exclude) != null;
        if (aotExcluded && message.getName().equals("accepts")) {
            exportedElement.addError("Cannot use with @%s.%s with the accepts message. The accepts message must always be usable for AOT.", ElementUtils.getSimpleName(this.types.GenerateAOT), ElementUtils.getSimpleName(this.types.GenerateAOT_Exclude));
        }
        if (exportedElement.hasErrors()) {
            return;
        }
        if (!cachedNodes.isEmpty() || !cachedLibraries.isEmpty()) {
            boolean isStatic;
            String string = ElementUtils.firstLetterUpperCase(exportedMethod.getSimpleName().toString()) + "Node_";
            CodeTypeElement type = GeneratorUtils.createClass(model, null, ElementUtils.modifiers(Modifier.PUBLIC, Modifier.STATIC), string, (TypeMirror)this.types.Node);
            AnnotationMirror importStatic = ElementUtils.findAnnotationMirror(model.getMessageElement(), (TypeMirror)this.types.ImportStatic);
            if (importStatic != null) {
                type.getAnnotationMirrors().add(importStatic);
            }
            type.getAnnotationMirrors().add(exportedElement.getMessageAnnotation());
            CodeExecutableElement element = CodeExecutableElement.clone(exportedMethod);
            element.getParameters().clear();
            element.getParameters().addAll(exportedMethod.getParameters());
            DeclaredType specializationType = this.types.Specialization;
            CodeAnnotationMirror specialization = new CodeAnnotationMirror(specializationType);
            specialization.setElementValue(ElementUtils.findExecutableElement(specializationType, "limit"), ElementUtils.getAnnotationValue(exportedElement.getMessageAnnotation(), "limit", false));
            element.getAnnotationMirrors().clear();
            element.addAnnotationMirror(specialization);
            if (aotExcluded) {
                element.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.GenerateAOT_Exclude));
            }
            if (!(isStatic = element.getModifiers().contains((Object)Modifier.STATIC))) {
                element.getParameters().add(0, new CodeVariableElement(exportedElement.getReceiverType(), "this"));
                element.getModifiers().add(Modifier.STATIC);
            }
            if (message.getName().equals("accepts")) {
                GeneratorUtils.mergeSuppressWarnings(element, "truffle-neverdefault");
            }
            type.add(element);
            NodeData parsedNodeData = this.parseNode(parsedNodeCache, type, exportedElement, Collections.emptyList());
            if (parsedNodeData == null) {
                exportedElement.addError("Error could not parse synthetic node: %s", element);
            }
            element.setEnclosingElement(exportedMethod.getEnclosingElement());
            exportedElement.setSpecializedNode(parsedNodeData);
        }
        if (exportsLibrary.isExplicitReceiver() && !exportedMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            exportedElement.addError("Exported method must be static. @%s annotated types with explcit receiverClass must only contain static methods.", this.types.ExportLibrary.asElement().getSimpleName().toString());
        }
    }

    private boolean isCachedLibrary(VariableElement exportParameter) {
        return ElementUtils.findAnnotationMirror(exportParameter.getAnnotationMirrors(), (TypeMirror)this.types.CachedLibrary) != null;
    }

    private NodeData parseNode(Map<String, NodeData> parsedNodeCache, TypeElement nodeType, ExportMessageData exportedMessage, List<? extends Element> members) {
        Object cachedData;
        String nodeTypeId = ElementUtils.getTypeSimpleId(nodeType.asType());
        if (!exportedMessage.isGenerated() && (cachedData = parsedNodeCache.get(nodeTypeId)) != null) {
            return cachedData;
        }
        for (ExecutableElement method : ElementFilter.methodsIn(members)) {
            if (method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.STATIC) || !method.getSimpleName().toString().startsWith(EXECUTE_PREFIX)) continue;
            exportedMessage.addError(method, "A class annotated with with @%s must not specify methods starting with execute. Execute methods for such classes can be inferred automatically from the message signature.", this.types.ExportMessage.asElement().getSimpleName().toString());
        }
        if (exportedMessage.hasErrors()) {
            return null;
        }
        LibraryMessage message = exportedMessage.getResolvedMessage();
        CodeExecutableElement syntheticExecute = null;
        CodeTypeElement clonedType = CodeTypeElement.cloneShallow(nodeType);
        clonedType.setSuperClass(this.types.Node);
        clonedType.setEnclosingElement(exportedMessage.getMessageElement().getEnclosingElement());
        syntheticExecute = CodeExecutableElement.clone(message.getExecutable());
        syntheticExecute.setSimpleName(CodeNames.of(EXECUTE_PREFIX + ElementUtils.firstLetterUpperCase(message.getName()) + EXECUTE_SUFFIX));
        syntheticExecute.getParameters().set(0, new CodeVariableElement(exportedMessage.getReceiverType(), "receiver"));
        syntheticExecute.getModifiers().add(Modifier.ABSTRACT);
        syntheticExecute.setVarArgs(false);
        clonedType.add(syntheticExecute);
        AnnotationMirror generateUncached = ElementUtils.findAnnotationMirror((Element)nodeType, (TypeMirror)this.types.GenerateUncached);
        AnnotationMirror importStatic = ElementUtils.findAnnotationMirror((Element)nodeType, (TypeMirror)this.types.ImportStatic);
        ArrayList<CodeAnnotationValue> staticImports = new ArrayList<CodeAnnotationValue>();
        if (importStatic != null) {
            for (TypeMirror existingImport : ElementUtils.getAnnotationValueList(TypeMirror.class, importStatic, "value")) {
                staticImports.add(new CodeAnnotationValue(existingImport));
            }
        }
        DeclaredType importStaticType = this.types.ImportStatic;
        staticImports.add(new CodeAnnotationValue(exportedMessage.getExportsLibrary().getTemplateType().asType()));
        CodeAnnotationMirror newImports = new CodeAnnotationMirror(importStaticType);
        newImports.setElementValue(ElementUtils.findExecutableElement(importStaticType, "value"), (AnnotationValue)new CodeAnnotationValue(staticImports));
        clonedType.getAnnotationMirrors().clear();
        clonedType.getAnnotationMirrors().add(newImports);
        if (exportedMessage.getExportsLibrary().isUseForAOT()) {
            clonedType.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.GenerateAOT));
        }
        if (generateUncached != null) {
            clonedType.getAnnotationMirrors().add(generateUncached);
        } else {
            clonedType.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.GenerateUncached));
        }
        this.transferReportPolymorphismAnnotations(nodeType, clonedType);
        NodeData parsedNodeData = (NodeData)NodeParser.createExportParser(exportedMessage.getExportsLibrary().getLibrary().getTemplateType().asType(), exportedMessage.getExportsLibrary().getTemplateType(), exportedMessage.getExportsLibrary().hasExportDelegation()).parse((Element)clonedType, false);
        parsedNodeCache.put(nodeTypeId, parsedNodeData);
        return parsedNodeData;
    }

    private void transferReportPolymorphismAnnotations(TypeElement nodeType, CodeTypeElement clonedType) {
        AnnotationMirror reportPolymorphismMegamorphic;
        AnnotationMirror reportPolymorphismExclude;
        AnnotationMirror reportPolymorphism = ElementUtils.findAnnotationMirror((Element)nodeType, (TypeMirror)this.types.ReportPolymorphism);
        if (reportPolymorphism != null) {
            clonedType.getAnnotationMirrors().add(reportPolymorphism);
        }
        if ((reportPolymorphismExclude = ElementUtils.findAnnotationMirror((Element)nodeType, (TypeMirror)this.types.ReportPolymorphism_Exclude)) != null) {
            clonedType.getAnnotationMirrors().add(reportPolymorphismExclude);
        }
        if ((reportPolymorphismMegamorphic = ElementUtils.findAnnotationMirror((Element)nodeType, (TypeMirror)this.types.ReportPolymorphism_Megamorphic)) != null) {
            clonedType.getAnnotationMirrors().add(reportPolymorphismMegamorphic);
        }
    }

    private static boolean isNodeElement(Element member) {
        return member.getKind().isClass();
    }

    private static boolean isMethodElement(Element member) {
        return member.getKind() == ElementKind.METHOD;
    }

    private static String inferNodeMessageName(TypeElement type) {
        String name = type.getSimpleName().toString();
        return ElementUtils.firstLetterLowerCase(name);
    }

    private static boolean verifyMethodSignature(TypeElement type, LibraryMessage message, ExportMessageData exportedMessage, ExecutableElement exportedMethod, TypeMirror receiverType, int realParameterCount, boolean emitErrors) {
        TypeMirror expectedStaticReceiverType;
        ExecutableElement libraryMethod = message.getExecutable();
        if (exportedMessage.getExportsLibrary().isExplicitReceiver() && !exportedMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            if (emitErrors) {
                exportedMessage.addError("Exported methods with explicit receiver must be static.", new Object[0]);
            }
            return false;
        }
        boolean explicitReceiver = exportedMethod.getModifiers().contains((Object)Modifier.STATIC);
        int paramOffset = !explicitReceiver ? 1 : 0;
        List<? extends VariableElement> expectedParameters = libraryMethod.getParameters().subList(paramOffset, libraryMethod.getParameters().size());
        List<? extends VariableElement> exportedParameters = exportedMethod.getParameters().subList(0, realParameterCount);
        TypeMirror typeMirror = expectedStaticReceiverType = explicitReceiver || exportedMessage.getExportsLibrary().isExplicitReceiver() ? receiverType : null;
        if (exportedParameters.size() != expectedParameters.size()) {
            if (emitErrors) {
                exportedMessage.addError(exportedMethod, "Expected parameter count %s for exported message, but was %s. Expected signature:%n    %s", expectedParameters.size(), exportedParameters.size(), ExportsParser.generateExpectedSignature(type, message, expectedStaticReceiverType));
            }
            return false;
        }
        if (!ElementUtils.isAssignable(exportedMethod.getReturnType(), libraryMethod.getReturnType())) {
            if (emitErrors) {
                exportedMessage.addError(exportedMethod, "Invalid exported return type. Expected '%s' but was '%s'. Expected signature:%n    %s", ElementUtils.getSimpleName(libraryMethod.getReturnType()), ElementUtils.getSimpleName(exportedMethod.getReturnType()), ExportsParser.generateExpectedSignature(type, message, expectedStaticReceiverType));
            }
            return false;
        }
        for (int i = 0; i < exportedParameters.size(); ++i) {
            TypeMirror libraryArgType;
            VariableElement exportedArg = exportedParameters.get(i);
            VariableElement libraryArg = expectedParameters.get(i);
            TypeMirror exportedArgType = exportedArg.asType();
            TypeMirror typeMirror2 = libraryArgType = explicitReceiver && i == 0 ? receiverType : libraryArg.asType();
            if (ElementUtils.typeEquals(exportedArgType, libraryArgType)) continue;
            if (emitErrors) {
                exportedMessage.addError(exportedArg, "Invalid parameter type. Expected '%s' but was '%s'. Expected signature:%n    %s", ElementUtils.getSimpleName(libraryArgType), ElementUtils.getSimpleName(exportedArgType), ExportsParser.generateExpectedSignature(type, message, expectedStaticReceiverType));
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static String generateExpectedSignature(TypeElement targetType, LibraryMessage message, TypeMirror staticReceiverType) {
        StringBuilder b = new StringBuilder();
        b.append("@").append(ProcessorContext.getInstance().getTypes().ExportMessage.asElement().getSimpleName().toString()).append(" ");
        if (staticReceiverType != null) {
            b.append("static ");
        } else if (!targetType.getModifiers().contains((Object)Modifier.FINAL)) {
            b.append("final ");
        }
        b.append(ElementUtils.getSimpleName(message.getExecutable().getReturnType()));
        b.append(" ");
        b.append(message.getName());
        b.append("(");
        int startIndex = staticReceiverType == null ? 1 : 0;
        List<? extends VariableElement> parameters = message.getExecutable().getParameters();
        for (int i = startIndex; i < parameters.size(); ++i) {
            void var8_9;
            VariableElement parameter = parameters.get(i);
            if (i == startIndex && staticReceiverType != null) {
                TypeMirror typeMirror = staticReceiverType;
            } else {
                TypeMirror typeMirror = parameter.asType();
            }
            if (i > startIndex) {
                b.append(", ");
            }
            b.append(ElementUtils.getSimpleName((TypeMirror)var8_9));
            b.append(" ");
            b.append(parameter.getSimpleName().toString());
        }
        b.append(")");
        if (!message.getExecutable().getThrownTypes().isEmpty()) {
            b.append(" throws ");
            String sep = "";
            for (TypeMirror typeMirror : message.getExecutable().getThrownTypes()) {
                b.append(sep);
                b.append(ElementUtils.getSimpleName(typeMirror));
                sep = ", ";
            }
        }
        return b.toString();
    }

    public static List<String> fuzzyMatch(Collection<String> descriptors, String optionKey, float minScore) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String string : descriptors) {
            float score = ExportsParser.stringSimiliarity(string, optionKey);
            if (!(score >= minScore)) continue;
            matches.add(string);
        }
        return matches;
    }

    private static float stringSimiliarity(String str1, String str2) {
        int hit = 0;
        block0: for (int i = 0; i < str1.length() - 1; ++i) {
            for (int j = 0; j < str2.length() - 1; ++j) {
                if (str1.charAt(i) != str2.charAt(j) || str1.charAt(i + 1) != str2.charAt(j + 1)) continue;
                ++hit;
                continue block0;
            }
        }
        return 2.0f * (float)hit / (float)(str1.length() + str2.length());
    }

    @Override
    public DeclaredType getAnnotationType() {
        return this.types.ExportLibrary;
    }

    @Override
    public DeclaredType getRepeatAnnotationType() {
        return this.types.ExportLibrary_Repeat;
    }

    @Override
    public List<DeclaredType> getTypeDelegatedAnnotationTypes() {
        return Arrays.asList(this.types.ExportMessage, this.types.ExportMessage_Repeat);
    }
}

