/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.model;

import com.oracle.truffle.dsl.processor.java.model.CodeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeNames;
import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeMirror;

public final class GeneratedPackageElement
extends CodeElement<Element>
implements PackageElement {
    private final Name qualifiedName;
    private final Name simpleName;

    public GeneratedPackageElement(String qualifiedName) {
        super(Collections.emptySet());
        this.qualifiedName = CodeNames.of(qualifiedName);
        int lastIndex = qualifiedName.lastIndexOf(46);
        this.simpleName = lastIndex == -1 ? CodeNames.of("") : CodeNames.of(qualifiedName.substring(lastIndex, qualifiedName.length()));
    }

    @Override
    public TypeMirror asType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.PACKAGE;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitPackage(this, p);
    }

    @Override
    public Name getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public Name getSimpleName() {
        return this.simpleName;
    }

    @Override
    public boolean isUnnamed() {
        return this.simpleName.toString().equals("");
    }

    @Override
    public int hashCode() {
        return this.qualifiedName.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PackageElement) {
            return this.qualifiedName.equals(((PackageElement)obj).getQualifiedName());
        }
        return super.equals(obj);
    }
}

