/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.model;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;

public class CodeAnnotationMirror
implements AnnotationMirror {
    private final DeclaredType annotationType;
    private final Map<ExecutableElement, AnnotationValue> values = new LinkedHashMap<ExecutableElement, AnnotationValue>();

    public CodeAnnotationMirror(DeclaredType annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public DeclaredType getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValues() {
        return this.values;
    }

    public void setElementValue(ExecutableElement method, AnnotationValue value) {
        this.values.put(method, value);
    }

    public void setElementValue(String methodName, AnnotationValue value) {
        this.setElementValue(this.findExecutableElement(methodName), value);
    }

    public ExecutableElement findExecutableElement(String name) {
        return ElementUtils.findExecutableElement(this.annotationType, name);
    }
}

