/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.generator;

import com.oracle.truffle.dsl.processor.generator.BitStateList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

final class StateQuery {
    final Collection<? extends Object> keys;
    final Class<? extends BitStateList.State<?>> filterClass;

    private StateQuery(Class<? extends BitStateList.State<?>> filterClass, Collection<? extends Object> keys) {
        this.keys = keys;
        this.filterClass = filterClass;
    }

    boolean isEmpty() {
        return this.keys != null && this.keys.isEmpty();
    }

    boolean match(BitStateList.State<?> state) {
        if (this.filterClass == null) {
            return true;
        }
        return this.filterClass.isInstance(state);
    }

    boolean filtersClass() {
        return this.filterClass != null;
    }

    @SafeVarargs
    static <T> StateQuery create(Class<? extends BitStateList.State<T>> clazz, T ... keys) {
        return StateQuery.create(clazz, Arrays.asList(keys));
    }

    static <T> StateQuery create(Class<? extends BitStateList.State<T>> clazz, Collection<T> keys) {
        Objects.requireNonNull(keys);
        return new StateQuery(clazz, keys);
    }
}

