/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.generator;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.generator.BitStateList;
import com.oracle.truffle.dsl.processor.generator.FlatNodeGenFactory;
import com.oracle.truffle.dsl.processor.generator.StateQuery;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.type.TypeMirror;

final class BitSet {
    private final BitStateList states;
    private final String name;
    private final long allMask;
    private final TypeMirror type;

    BitSet(String name, BitStateList states) {
        this.name = name;
        this.states = states;
        int bitCount = states.getBitCount();
        if (bitCount <= 32) {
            this.type = ProcessorContext.getInstance().getType(Integer.TYPE);
        } else if (bitCount <= 64) {
            this.type = ProcessorContext.getInstance().getType(Long.TYPE);
        } else {
            throw new UnsupportedOperationException("State space too big " + bitCount + ". Only <= 64 supported.");
        }
        this.allMask = this.createMask(StateQuery.create(null, this.getStates().queryKeys(null)));
    }

    public BitStateList getStates() {
        return this.states;
    }

    public int getBitCount() {
        return this.states.getBitCount();
    }

    public TypeMirror getType() {
        return this.type;
    }

    public boolean contains(StateQuery element) {
        return this.getStates().contains(element);
    }

    public boolean contains(StateQuery ... element) {
        for (StateQuery stateQuery : element) {
            if (!this.getStates().contains(stateQuery)) continue;
            return true;
        }
        return false;
    }

    private CodeTree createLocalReference(FlatNodeGenFactory.FrameState frameState) {
        FlatNodeGenFactory.LocalVariable var;
        FlatNodeGenFactory.LocalVariable localVariable = var = frameState != null ? frameState.get(this.getName()) : null;
        if (var != null) {
            return var.createReference();
        }
        return null;
    }

    public boolean hasLocal(FlatNodeGenFactory.FrameState frameState) {
        return frameState.get(this.getName()) != null;
    }

    public CodeTree createReference(FlatNodeGenFactory.FrameState frameState) {
        CodeTree ref = this.createLocalReference(frameState);
        if (ref == null) {
            CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
            builder.string(this.getName(), "_");
            ref = FlatNodeGenFactory.createInlinedAccess(frameState, null, builder.build(), null);
        }
        return ref;
    }

    public StateQuery filter(StateQuery elements) {
        return this.getStates().filter(elements);
    }

    public CodeTree createLoad(FlatNodeGenFactory.FrameState frameState) {
        return this.createLoad(frameState, false);
    }

    public CodeTree createLoad(FlatNodeGenFactory.FrameState frameState, boolean forceLoad) {
        FlatNodeGenFactory.LocalVariable var = frameState.get(this.name);
        if (!forceLoad && var != null) {
            return CodeTreeBuilder.singleString("");
        }
        String fieldName = this.name + "_";
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        CodeTreeBuilder init = builder.create();
        init.string("this.").tree(CodeTreeBuilder.singleString(fieldName));
        CodeTree inlinedAccess = FlatNodeGenFactory.createInlinedAccess(frameState, null, init.build(), null);
        if (var == null) {
            var = new FlatNodeGenFactory.LocalVariable(this.type, this.name, null);
            frameState.set(this.name, var);
            builder.tree(var.createDeclaration(inlinedAccess));
        } else {
            builder.startStatement();
            builder.string(this.name).string(" = ").tree(inlinedAccess);
            builder.end();
        }
        return builder.build();
    }

    public void clearLoaded(FlatNodeGenFactory.FrameState frameState) {
        frameState.clear(this.name);
    }

    public CodeTree createContainsOnly(FlatNodeGenFactory.FrameState frameState, int offset, int length, StateQuery selectedElements, StateQuery allElements) {
        long mask = (this.createMask(offset, length, selectedElements) ^ 0xFFFFFFFFFFFFFFFFL) & this.createMask(allElements);
        if (mask == 0L) {
            return null;
        }
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.tree(this.createMaskedReference(frameState, mask));
        builder.string(" == 0");
        builder.string(" /* only-active ", this.getStates().toString(selectedElements, " && "), " */");
        return builder.build();
    }

    public CodeTree createIs(FlatNodeGenFactory.FrameState frameState, StateQuery selectedElements, StateQuery maskedElements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.tree(this.createMaskedReference(frameState, maskedElements));
        builder.string(" == ").string(this.formatMask(this.createMask(selectedElements)));
        return builder.build();
    }

    private CodeTree createMaskedReference(CodeTree receiver, long maskedElements) {
        if (maskedElements == this.allMask) {
            return receiver;
        }
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.string("(").tree(receiver).string(" & ").string(this.formatMask(maskedElements)).string(")");
        return builder.build();
    }

    private CodeTree createMaskedReference(FlatNodeGenFactory.FrameState frameState, long maskedElements) {
        return this.createMaskedReference(this.createReference(frameState), maskedElements);
    }

    public CodeTree createMaskedReference(CodeTree receiver, StateQuery ... maskedElements) {
        return this.createMaskedReference(receiver, this.createMask(maskedElements));
    }

    public CodeTree createMaskedReference(FlatNodeGenFactory.FrameState frameState, StateQuery ... maskedElements) {
        return this.createMaskedReference(frameState, this.createMask(maskedElements));
    }

    public CodeTree createIsNotAny(FlatNodeGenFactory.FrameState frameState, StateQuery elements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.tree(this.createMaskedReference(frameState, elements));
        builder.string(" != 0 ");
        builder.string(" /* is-not ", this.getStates().toString(elements, " && "), " */");
        return builder.build();
    }

    public String formatMask(long mask) {
        return BitSet.formatMask(mask, this.getBitCount());
    }

    public static String formatMask(long mask, int bitCount) {
        if (mask == 0L) {
            return "0";
        }
        int bitsUsed = 64 - Long.numberOfLeadingZeros(mask);
        if (bitsUsed <= 16) {
            return "0b" + Integer.toBinaryString((int)mask);
        }
        if (bitCount <= 32) {
            return "0x" + Integer.toHexString((int)mask);
        }
        return "0x" + Long.toHexString(mask) + "L";
    }

    public CodeTree createIsOneBitOf(FlatNodeGenFactory.FrameState frameState, StateQuery elements) {
        CodeTree masked = this.createMaskedReference(frameState, elements);
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startParantheses().tree(masked).string(" & ").startParantheses().tree(masked).string(" - 1").end().end().string(" == 0");
        builder.string(" /* ", "is-single ", " */");
        return builder.build();
    }

    public CodeTree createContains(FlatNodeGenFactory.FrameState frameState, StateQuery query) {
        return this.createContains(this.createReference(frameState), query);
    }

    public CodeTree createContains(CodeTree receiver, StateQuery query) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.tree(this.createMaskedReference(receiver, query));
        builder.string(" != 0");
        builder.string(" /* ", "is ", this.getStates().toString(query, " || "), " */");
        return builder.build();
    }

    public CodeTree createNotContains(CodeTree receiver, StateQuery elements) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startParantheses();
        builder.tree(this.createMaskedReference(receiver, elements));
        builder.end();
        builder.string(" == 0");
        builder.string(" /* ", "is-not ", this.getStates().toString(elements, " && "), " */");
        return builder.build();
    }

    public CodeTree createNotContains(FlatNodeGenFactory.FrameState frameState, StateQuery elements) {
        return this.createNotContains(this.createReference(frameState), elements);
    }

    public String getName() {
        return this.name;
    }

    public CodeTree createExtractInteger(CodeTree receiver, StateQuery query) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        if (this.getBitCount() > 32) {
            builder.string("(int)(");
        }
        builder.tree(this.createMaskedReference(receiver, this.createMask(query)));
        builder.string(" >>> ", Integer.toString(this.getStateOffset(query)));
        if (this.getBitCount() > 32) {
            builder.string(")");
        }
        builder.string(" /* ", "get-int ", this.getStates().toString(query, ""), " */");
        return builder.build();
    }

    public CodeTree createExtractInteger(FlatNodeGenFactory.FrameState frameState, StateQuery query) {
        return this.createExtractInteger(this.createReference(frameState), query);
    }

    public CodeTree createSetZero(FlatNodeGenFactory.FrameState frameState, boolean persist) {
        return this.createPersist(frameState, persist, CodeTreeBuilder.singleString("0"), false);
    }

    public CodeTree createSetExpression(CodeTree receiver, StateQuery elements, Boolean value) {
        CodeTreeBuilder valueBuilder = CodeTreeBuilder.createBuilder();
        valueBuilder.tree(receiver);
        if (elements != null) {
            if (value.booleanValue()) {
                valueBuilder.string(" | ");
                valueBuilder.string(this.formatMask(this.createMask(elements)));
                valueBuilder.string(" /* ", "add ", this.getStates().toString(elements, ", "), " */");
            } else {
                valueBuilder.string(" & ");
                valueBuilder.string(this.formatMask(this.createMask(elements) ^ 0xFFFFFFFFFFFFFFFFL));
                valueBuilder.string(" /* ", "remove ", this.getStates().toString(elements, ", "), " */");
            }
        }
        return valueBuilder.build();
    }

    public CodeTree createSet(FlatNodeGenFactory.FrameState frameState, StateQuery elements, Boolean value, boolean persist) {
        boolean isEmpty;
        CodeTreeBuilder valueBuilder = CodeTreeBuilder.createBuilder();
        boolean bl = isEmpty = elements == null || elements.isEmpty();
        if (!this.hasLocal(frameState) && isEmpty) {
            return valueBuilder.build();
        }
        valueBuilder.tree(this.createSetExpression(this.createReference(frameState), elements, value));
        return this.createPersist(frameState, persist, valueBuilder.build(), !isEmpty);
    }

    private CodeTree createPersist(FlatNodeGenFactory.FrameState frameState, boolean persist, CodeTree valueTree, boolean update) {
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.startStatement();
        if (persist) {
            builder.string("this.", this.name, "_");
            if (frameState != null && frameState.isInlinedNode()) {
                builder.startCall(".set");
                builder.tree(frameState.getValue(0).createReference());
            } else {
                builder.string(" = ");
            }
            builder.startGroup();
            CodeTree localReference = this.createLocalReference(frameState);
            if (localReference != null && update) {
                builder.tree(localReference).string(" = ");
            }
        } else {
            builder.startGroup();
            builder.tree(this.createReference(frameState)).string(" = ");
        }
        builder.tree(valueTree);
        builder.end();
        if (persist && frameState != null && frameState.isInlinedNode()) {
            builder.end();
        }
        builder.end();
        return builder.build();
    }

    public CodeTree createSetInteger(CodeTree receiver, StateQuery element, CodeTree value) {
        int offset = this.getStateOffset(element);
        CodeTreeBuilder builder = CodeTreeBuilder.createBuilder();
        builder.tree(receiver).string(" = ");
        builder.startParantheses();
        builder.tree(receiver);
        builder.string(" | (");
        if (this.getBitCount() > 32) {
            builder.string("(long) ");
        }
        builder.tree(value).string(" << ", Integer.toString(offset), ")");
        builder.string(" /* ", "set-int ", this.getStates().toString(element, ""), " */");
        builder.end();
        return builder.build();
    }

    public CodeTree createSetInteger(FlatNodeGenFactory.FrameState frameState, StateQuery element, CodeTree value) {
        return this.createSetInteger(this.createReference(frameState), element, value);
    }

    public long createMask(StateQuery ... e) {
        return this.createMask(0, -1, e);
    }

    private long createMask(int offset, int length, StateQuery ... queries) {
        long mask = 0L;
        for (StateQuery e : queries) {
            for (BitRange range : this.getStates().queryRanges(e)) {
                int realLength = length < 0 ? range.length : Math.min(range.length, offset + length);
                for (int i = offset; i < realLength; ++i) {
                    mask |= 1L << range.offset + i;
                }
            }
        }
        return mask;
    }

    private int getStateOffset(StateQuery query) {
        List<BitRange> ranges = this.getStates().queryRanges(query);
        Iterator<BitRange> iterator = ranges.iterator();
        if (iterator.hasNext()) {
            BitRange range = iterator.next();
            return range.offset;
        }
        return 0;
    }

    static final class BitRange {
        final int offset;
        final int length;

        BitRange(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

