/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.bytecode.model;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.bytecode.model.BytecodeDSLModel;
import com.oracle.truffle.dsl.processor.bytecode.model.CustomOperationModel;
import com.oracle.truffle.dsl.processor.bytecode.model.OperationModel;
import com.oracle.truffle.dsl.processor.bytecode.model.PrettyPrintable;
import com.oracle.truffle.dsl.processor.bytecode.model.ShortCircuitInstructionModel;
import com.oracle.truffle.dsl.processor.bytecode.model.Signature;
import com.oracle.truffle.dsl.processor.bytecode.parser.SpecializationSignatureParser;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.SpecializationData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.TypeMirror;

public final class InstructionModel
implements PrettyPrintable {
    public static final int OPCODE_WIDTH = 2;
    private short id = (short)-1;
    private int byteLength = 2;
    public final InstructionKind kind;
    public final String name;
    public final String quickeningName;
    public final Signature signature;
    public CodeTypeElement nodeType;
    public NodeData nodeData;
    public int variadicPopCount = -1;
    public final List<InstructionImmediate> immediates = new ArrayList<InstructionImmediate>();
    public List<InstructionModel> subInstructions;
    public final List<InstructionModel> quickenedInstructions = new ArrayList<InstructionModel>();
    public List<SpecializationData> filteredSpecializations;
    public InstructionModel quickeningBase;
    public OperationModel operation;
    public boolean returnTypeQuickening;
    public boolean generic;
    public TypeMirror specializedType;
    public ShortCircuitInstructionModel shortCircuitModel;
    public final List<InstructionModel> shortCircuitInstructions = new ArrayList<InstructionModel>();

    public InstructionModel(InstructionKind kind, String name, Signature signature, String quickeningName) {
        this.kind = kind;
        this.name = name;
        this.signature = signature;
        this.quickeningName = quickeningName;
    }

    public boolean isShortCircuitConverter() {
        return !this.shortCircuitInstructions.isEmpty();
    }

    public boolean isEpilogReturn() {
        if (this.operation == null) {
            return false;
        }
        CustomOperationModel epilogReturn = this.operation.parent.epilogReturn;
        if (epilogReturn == null) {
            return false;
        }
        return epilogReturn.operation.instruction == this;
    }

    public SpecializationSignatureParser.SpecializationSignature getSpecializationSignature() {
        return this.operation.getSpecializationSignature(this.filteredSpecializations);
    }

    public boolean isEpilogExceptional() {
        if (this.operation == null) {
            return false;
        }
        CustomOperationModel epilogExceptional = this.operation.parent.epilogExceptional;
        if (epilogExceptional == null) {
            return false;
        }
        return epilogExceptional.operation.instruction == this;
    }

    public short getId() {
        if (this.id == -1) {
            throw new IllegalStateException("Id not yet assigned");
        }
        return this.id;
    }

    void setId(short id) {
        if (id < 0) {
            throw new IllegalArgumentException("Invalid id.");
        }
        if (this.id != -1) {
            throw new IllegalStateException("Id already assigned ");
        }
        this.id = id;
    }

    public List<InstructionModel> getFlattenedQuickenedInstructions() {
        if (this.quickenedInstructions.isEmpty()) {
            return this.quickenedInstructions;
        }
        ArrayList<InstructionModel> allInstructions = new ArrayList<InstructionModel>();
        for (InstructionModel child : this.quickenedInstructions) {
            allInstructions.add(child);
            allInstructions.addAll(child.getFlattenedQuickenedInstructions());
        }
        return allInstructions;
    }

    public String getQuickeningName() {
        return this.quickeningName;
    }

    public InstructionModel getQuickeningRoot() {
        if (this.quickeningBase != null) {
            return this.quickeningBase.getQuickeningRoot();
        }
        return this;
    }

    public String getQualifiedQuickeningName() {
        InstructionModel current = this;
        ArrayList<String> quickeningNames = new ArrayList<String>();
        while (current != null) {
            if (current.quickeningName != null) {
                quickeningNames.add(0, current.quickeningName.replace('#', '_'));
            }
            current = current.quickeningBase;
        }
        return String.join((CharSequence)"$", quickeningNames);
    }

    public boolean hasQuickenings() {
        return !this.quickenedInstructions.isEmpty();
    }

    public boolean isSpecializedQuickening() {
        return this.quickeningBase != null && !this.returnTypeQuickening && !this.generic;
    }

    public boolean hasSpecializedQuickenings() {
        for (InstructionModel instr : this.quickenedInstructions) {
            if (!instr.isSpecializedQuickening()) continue;
            return true;
        }
        return false;
    }

    public boolean isQuickening() {
        return this.quickeningBase != null;
    }

    public boolean isReturnTypeQuickening() {
        return this.returnTypeQuickening;
    }

    @Override
    public void pp(PrettyPrintable.PrettyPrinter printer) {
        printer.print("Instruction %s", this.name);
        printer.field("kind", (Object)this.kind);
        printer.field("encoding", this.prettyPrintEncoding());
        if (this.nodeType != null) {
            printer.field("nodeType", this.nodeType.getSimpleName());
        }
        if (this.signature != null) {
            printer.field("signature", this.signature);
        }
        if (this.getQuickeningRoot().hasQuickenings()) {
            String quickenKind = this.quickeningBase == null ? "base" : (this.isReturnTypeQuickening() ? "return-type" : (this.generic ? "generic" : "specialized"));
            printer.field("quicken-kind", quickenKind);
        }
    }

    public boolean isTagInstrumentation() {
        switch (this.kind.ordinal()) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public boolean isInstrumentation() {
        if (this.isTagInstrumentation()) {
            return true;
        }
        if (this.kind == InstructionKind.CUSTOM) {
            return this.operation.kind == OperationModel.OperationKind.CUSTOM_INSTRUMENTATION;
        }
        return false;
    }

    public boolean isControlFlow() {
        switch (this.kind.ordinal()) {
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    public boolean hasNodeImmediate() {
        switch (this.kind.ordinal()) {
            case 20: {
                return !this.canUseNodeSingleton();
            }
        }
        return false;
    }

    public InstructionModel addImmediate(ImmediateKind immediateKind, String immediateName) {
        this.immediates.add(new InstructionImmediate(this.byteLength, immediateKind, immediateName));
        this.byteLength += immediateKind.width.byteSize;
        return this;
    }

    public InstructionImmediate findImmediate(ImmediateKind immediateKind, String immediateName) {
        for (InstructionImmediate immediate : this.immediates) {
            if (immediate.kind != immediateKind || !immediate.name.equals(immediateName)) continue;
            return immediate;
        }
        return null;
    }

    public List<InstructionImmediate> getImmediates() {
        return this.immediates;
    }

    public List<InstructionImmediate> getImmediates(ImmediateKind immediateKind) {
        return this.immediates.stream().filter(imm -> imm.kind == immediateKind).toList();
    }

    public boolean hasImmediate(ImmediateKind immediateKind) {
        return !this.getImmediates(immediateKind).isEmpty();
    }

    public InstructionImmediate getImmediate(ImmediateKind immediateKind) {
        List<InstructionImmediate> filteredImmediates = this.getImmediates(immediateKind);
        if (filteredImmediates.isEmpty()) {
            return null;
        }
        if (filteredImmediates.size() > 1) {
            throw new AssertionError((Object)("Too many immediates of kind " + String.valueOf((Object)immediateKind) + ". Use getImmediates() instead. Found immediates: " + String.valueOf(filteredImmediates)));
        }
        return filteredImmediates.get(0);
    }

    public InstructionImmediate getImmediate(String immediateName) {
        return this.immediates.stream().filter(imm -> imm.name.equals(immediateName)).findAny().get();
    }

    public int getInstructionLength() {
        return this.byteLength;
    }

    public InstructionEncoding getInstructionEncoding() {
        ImmediateWidth[] immediateWidths = new ImmediateWidth[this.immediates.size()];
        for (int i = 0; i < immediateWidths.length; ++i) {
            immediateWidths[i] = this.immediates.get((int)i).kind.width;
        }
        return new InstructionEncoding(immediateWidths, this.byteLength);
    }

    public String getInternalName() {
        String operationName = switch (this.kind.ordinal()) {
            case 20 -> {
                if (!$assertionsDisabled && !this.name.startsWith("c.")) {
                    throw new AssertionError();
                }
                yield this.name.substring(2) + "_";
            }
            case 21 -> {
                if (!$assertionsDisabled && !this.name.startsWith("sc.")) {
                    throw new AssertionError();
                }
                yield this.name.substring(3) + "_";
            }
            default -> this.name;
        };
        StringBuilder b = new StringBuilder(operationName);
        block8: for (int i = 0; i < b.length(); ++i) {
            char c = b.charAt(i);
            switch (c) {
                case '.': {
                    if (i + 1 < b.length()) {
                        b.setCharAt(i + 1, Character.toUpperCase(b.charAt(i + 1)));
                    }
                    b.deleteCharAt(i);
                    continue block8;
                }
                case '#': {
                    b.setCharAt(i, '$');
                }
            }
        }
        return b.toString();
    }

    public String getConstantName() {
        return ElementUtils.createConstantName(this.getInternalName());
    }

    public SpecializationData resolveSingleSpecialization() {
        List<SpecializationData> specializations = null;
        if (this.filteredSpecializations != null) {
            specializations = this.filteredSpecializations;
        } else if (this.nodeData != null) {
            specializations = this.nodeData.getReachableSpecializations();
        }
        if (specializations != null && specializations.size() == 1) {
            return specializations.get(0);
        }
        return null;
    }

    public String toString() {
        return String.format("Instruction(%s)", this.name);
    }

    public String prettyPrintEncoding() {
        StringBuilder b = new StringBuilder("[");
        b.append(this.getId());
        b.append(" : short");
        for (InstructionImmediate imm : this.immediates) {
            b.append(", ");
            b.append(imm.name);
            if (!imm.name.equals(imm.kind.shortName)) {
                b.append(" (");
                b.append(imm.kind.shortName);
                b.append(")");
            }
            b.append(" : ");
            b.append((Object)imm.kind.width);
        }
        b.append("]");
        return b.toString();
    }

    public boolean canUseNodeSingleton() {
        if (this.nodeData == null) {
            return false;
        }
        if (this.nodeData.needsState(ProcessorContext.getInstance())) {
            return false;
        }
        for (SpecializationData specialization : this.nodeData.getReachableSpecializations()) {
            if (!specialization.isNodeReceiverBoundInAnyExpression()) continue;
            return false;
        }
        return true;
    }

    public boolean needsBoxingElimination(BytecodeDSLModel model, int valueIndex) {
        if (!model.usesBoxingElimination()) {
            return false;
        }
        if (this.signature.isVariadicParameter(valueIndex)) {
            return false;
        }
        if (model.isBoxingEliminated(this.signature.getSpecializedType(valueIndex))) {
            return true;
        }
        for (InstructionModel quickenedInstruction : this.quickenedInstructions) {
            if (!quickenedInstruction.needsBoxingElimination(model, valueIndex)) continue;
            return true;
        }
        return false;
    }

    public InstructionModel findSpecializedInstruction(TypeMirror type) {
        for (InstructionModel specialization : this.quickenedInstructions) {
            if (specialization.generic || !ElementUtils.typeEquals(type, specialization.specializedType)) continue;
            return specialization;
        }
        return null;
    }

    public InstructionModel findGenericInstruction() {
        for (InstructionModel specialization : this.quickenedInstructions) {
            if (!specialization.generic) continue;
            return specialization;
        }
        return null;
    }

    public void validateAlignment() {
        if (this.getInstructionLength() % 2 != 0) {
            throw new AssertionError((Object)String.format("All instructions should be short-aligned, but instruction %s has length %s.", this.name, this.getInstructionLength()));
        }
        for (InstructionImmediate immediate : this.immediates) {
            if (immediate.kind == ImmediateKind.SHORT && immediate.offset % 2 != 0) {
                throw new AssertionError((Object)String.format("Immediate %s of instruction %s should be short-aligned, but it appears at offset %s.", immediate.name, this.name, immediate.offset));
            }
        }
    }

    public static enum InstructionKind {
        LOAD_ARGUMENT,
        LOAD_CONSTANT,
        LOAD_LOCAL,
        CLEAR_LOCAL,
        STORE_LOCAL,
        BRANCH,
        BRANCH_BACKWARD,
        BRANCH_FALSE,
        POP,
        DUP,
        LOAD_VARIADIC,
        MERGE_VARIADIC,
        STORE_NULL,
        LOAD_LOCAL_MATERIALIZED,
        STORE_LOCAL_MATERIALIZED,
        LOAD_NULL,
        RETURN,
        YIELD,
        THROW,
        MERGE_CONDITIONAL,
        CUSTOM,
        CUSTOM_SHORT_CIRCUIT,
        SUPERINSTRUCTION,
        LOAD_EXCEPTION,
        TAG_ENTER,
        TAG_LEAVE,
        TAG_LEAVE_VOID,
        TAG_YIELD,
        TAG_RESUME,
        INVALIDATE;


        public boolean isLocalVariableAccess() {
            switch (this.ordinal()) {
                case 2: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        public boolean isLocalVariableMaterializedAccess() {
            switch (this.ordinal()) {
                case 13: 
                case 14: {
                    return true;
                }
            }
            return false;
        }
    }

    public record InstructionImmediate(int offset, ImmediateKind kind, String name) {
    }

    public static enum ImmediateKind {
        FRAME_INDEX("frame_index", ImmediateWidth.SHORT),
        LOCAL_INDEX("local_index", ImmediateWidth.SHORT),
        LOCAL_ROOT("local_root", ImmediateWidth.SHORT),
        SHORT("short", ImmediateWidth.SHORT),
        BYTECODE_INDEX("bci", ImmediateWidth.INT),
        STACK_POINTER("sp", ImmediateWidth.SHORT),
        CONSTANT("const", ImmediateWidth.INT),
        NODE_PROFILE("node", ImmediateWidth.INT),
        TAG_NODE("tag", ImmediateWidth.INT),
        BRANCH_PROFILE("branch_profile", ImmediateWidth.INT);

        public final String shortName;
        public final ImmediateWidth width;

        private ImmediateKind(String shortName, ImmediateWidth width) {
            this.shortName = shortName;
            this.width = width;
        }

        public TypeMirror toType(ProcessorContext context) {
            return this.width.toType(context);
        }
    }

    public static enum ImmediateWidth {
        BYTE(1),
        SHORT(2),
        INT(4);

        public final int byteSize;

        private ImmediateWidth(int byteSize) {
            this.byteSize = byteSize;
        }

        public TypeMirror toType(ProcessorContext context) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> context.getType(Byte.TYPE);
                case 1 -> context.getType(Short.TYPE);
                case 2 -> context.getType(Integer.TYPE);
            };
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static final class InstructionEncoding
    implements Comparable<InstructionEncoding> {
        public final ImmediateWidth[] immediates;
        public final int length;

        public InstructionEncoding(ImmediateWidth[] immediates, int length) {
            this.immediates = immediates;
            this.length = length;
        }

        public int hashCode() {
            return Arrays.hashCode((Object[])this.immediates);
        }

        public boolean equals(Object other) {
            if (!(other instanceof InstructionEncoding)) {
                return false;
            }
            InstructionEncoding otherEncoding = (InstructionEncoding)other;
            if (this.immediates.length != otherEncoding.immediates.length) {
                return false;
            }
            for (int i = 0; i < this.immediates.length; ++i) {
                if (this.immediates[i] == otherEncoding.immediates[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public int compareTo(InstructionEncoding other) {
            int diff = this.length - other.length;
            if (diff != 0) {
                return diff;
            }
            diff = this.immediates.length - other.immediates.length;
            if (diff != 0) {
                return diff;
            }
            for (int i = 0; i < this.immediates.length; ++i) {
                if (this.immediates[i] == other.immediates[i]) continue;
                return this.immediates[i].byteSize - other.immediates[i].byteSize;
            }
            return 0;
        }
    }
}

