// CheckStyle: start generated
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.strings.TStringInternalNodes.CalcStringAttributesNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetCodePointLengthNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.CalcStringAttributesNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodePointLengthNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen;
import com.oracle.truffle.api.strings.TruffleString.Encoding;
import com.oracle.truffle.api.strings.TruffleString.ToIndexableNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendArrayIntlNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendByteNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendCharUTF16Node;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendCodePointIntlNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendCodePointNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendIntNumberNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendJavaStringUTF16Node;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendLongNumberNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendStringNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.AppendSubstringByteIndexNode;
import com.oracle.truffle.api.strings.TruffleStringBuilder.ToStringNode;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.Lock;

@GeneratedBy(TruffleStringBuilder.class)
public final class TruffleStringBuilderFactory {

    @GeneratedBy(AppendByteNode.class)
    static final class AppendByteNodeGen extends AppendByteNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private ConditionProfile bufferGrowProfile_;
        @CompilationFinal private BranchProfile errorProfile_;

        private AppendByteNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, byte arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 append(TruffleStringBuilder, byte, ConditionProfile, BranchProfile) */) {
                AppendByteNode.append(arg0Value, arg1Value, this.bufferGrowProfile_, this.errorProfile_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value);
            return;
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, byte arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.bufferGrowProfile_ = (ConditionProfile.create());
                this.errorProfile_ = (BranchProfile.create());
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 append(TruffleStringBuilder, byte, ConditionProfile, BranchProfile) */;
                lock.unlock();
                hasLock = false;
                AppendByteNode.append(arg0Value, arg1Value, this.bufferGrowProfile_, this.errorProfile_);
                return;
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static AppendByteNode create() {
            return new AppendByteNodeGen();
        }

        public static AppendByteNode getUncached() {
            return AppendByteNodeGen.UNCACHED;
        }

        @GeneratedBy(AppendByteNode.class)
        @DenyReplace
        private static final class Uncached extends AppendByteNode {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, byte arg1Value) {
                AppendByteNode.append(arg0Value, arg1Value, (ConditionProfile.getUncached()), (BranchProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(AppendCharUTF16Node.class)
    static final class AppendCharUTF16NodeGen extends AppendCharUTF16Node {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private volatile int exclude_;
        @CompilationFinal private CachedData cached_cache;
        @CompilationFinal private ConditionProfile uncached_bufferGrowProfile_;
        @CompilationFinal private BranchProfile uncached_errorProfile_;

        private AppendCharUTF16NodeGen() {
        }

        @ExplodeLoop
        @Override
        public void execute(TruffleStringBuilder arg0Value, char arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doCached(TruffleStringBuilder, char, int, int, ConditionProfile, BranchProfile) || doUncached(TruffleStringBuilder, char, ConditionProfile, BranchProfile) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doCached(TruffleStringBuilder, char, int, int, ConditionProfile, BranchProfile) */) {
                    CachedData s0_ = this.cached_cache;
                    while (s0_ != null) {
                        if ((s0_.cachedCurStride_ == arg0Value.stride) && (s0_.cachedNewStride_ == TruffleStringBuilder.utf16Stride(arg0Value, arg1Value))) {
                            doCached(arg0Value, arg1Value, s0_.cachedCurStride_, s0_.cachedNewStride_, s0_.bufferGrowProfile_, s0_.errorProfile_);
                            return;
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doUncached(TruffleStringBuilder, char, ConditionProfile, BranchProfile) */) {
                    doUncached(arg0Value, arg1Value, this.uncached_bufferGrowProfile_, this.uncached_errorProfile_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value);
            return;
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, char arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                if ((exclude) == 0 /* is-not-exclude doCached(TruffleStringBuilder, char, int, int, ConditionProfile, BranchProfile) */) {
                    int count0_ = 0;
                    CachedData s0_ = this.cached_cache;
                    if ((state_0 & 0b1) != 0 /* is-state_0 doCached(TruffleStringBuilder, char, int, int, ConditionProfile, BranchProfile) */) {
                        while (s0_ != null) {
                            if ((s0_.cachedCurStride_ == arg0Value.stride) && (s0_.cachedNewStride_ == TruffleStringBuilder.utf16Stride(arg0Value, arg1Value))) {
                                break;
                            }
                            s0_ = s0_.next_;
                            count0_++;
                        }
                    }
                    if (s0_ == null) {
                        {
                            int cachedNewStride__ = (TruffleStringBuilder.utf16Stride(arg0Value, arg1Value));
                            // assert (s0_.cachedCurStride_ == arg0Value.stride);
                            if ((cachedNewStride__ == TruffleStringBuilder.utf16Stride(arg0Value, arg1Value)) && count0_ < (9)) {
                                s0_ = new CachedData(cached_cache);
                                s0_.cachedCurStride_ = (arg0Value.stride);
                                s0_.cachedNewStride_ = cachedNewStride__;
                                s0_.bufferGrowProfile_ = (ConditionProfile.create());
                                s0_.errorProfile_ = (BranchProfile.create());
                                VarHandle.storeStoreFence();
                                this.cached_cache = s0_;
                                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doCached(TruffleStringBuilder, char, int, int, ConditionProfile, BranchProfile) */;
                            }
                        }
                    }
                    if (s0_ != null) {
                        lock.unlock();
                        hasLock = false;
                        doCached(arg0Value, arg1Value, s0_.cachedCurStride_, s0_.cachedNewStride_, s0_.bufferGrowProfile_, s0_.errorProfile_);
                        return;
                    }
                }
                this.uncached_bufferGrowProfile_ = (ConditionProfile.create());
                this.uncached_errorProfile_ = (BranchProfile.create());
                this.exclude_ = exclude = exclude | 0b1 /* add-exclude doCached(TruffleStringBuilder, char, int, int, ConditionProfile, BranchProfile) */;
                this.cached_cache = null;
                state_0 = state_0 & 0xfffffffe /* remove-state_0 doCached(TruffleStringBuilder, char, int, int, ConditionProfile, BranchProfile) */;
                this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doUncached(TruffleStringBuilder, char, ConditionProfile, BranchProfile) */;
                lock.unlock();
                hasLock = false;
                doUncached(arg0Value, arg1Value, this.uncached_bufferGrowProfile_, this.uncached_errorProfile_);
                return;
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedData s0_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static AppendCharUTF16Node create() {
            return new AppendCharUTF16NodeGen();
        }

        public static AppendCharUTF16Node getUncached() {
            return AppendCharUTF16NodeGen.UNCACHED;
        }

        @GeneratedBy(AppendCharUTF16Node.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int cachedCurStride_;
            @CompilationFinal int cachedNewStride_;
            @CompilationFinal ConditionProfile bufferGrowProfile_;
            @CompilationFinal BranchProfile errorProfile_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(AppendCharUTF16Node.class)
        @DenyReplace
        private static final class Uncached extends AppendCharUTF16Node {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, char arg1Value) {
                doUncached(arg0Value, arg1Value, (ConditionProfile.getUncached()), (BranchProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(AppendCodePointNode.class)
    static final class AppendCodePointNodeGen extends AppendCodePointNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private AppendData append_cache;

        private AppendCodePointNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, int arg1Value, int arg2Value, boolean arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 append(TruffleStringBuilder, int, int, boolean, AppendCodePointIntlNode, ConditionProfile, BranchProfile) */) {
                AppendData s0_ = this.append_cache;
                if (s0_ != null) {
                    AppendCodePointNode.append(arg0Value, arg1Value, arg2Value, arg3Value, s0_.appendCodePointIntlNode_, s0_.bufferGrowProfile_, s0_.errorProfile_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            return;
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, int arg1Value, int arg2Value, boolean arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                AppendData s0_ = super.insert(new AppendData());
                s0_.appendCodePointIntlNode_ = s0_.insertAccessor((AppendCodePointIntlNodeGen.create()));
                s0_.bufferGrowProfile_ = (ConditionProfile.create());
                s0_.errorProfile_ = (BranchProfile.create());
                VarHandle.storeStoreFence();
                this.append_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 append(TruffleStringBuilder, int, int, boolean, AppendCodePointIntlNode, ConditionProfile, BranchProfile) */;
                lock.unlock();
                hasLock = false;
                AppendCodePointNode.append(arg0Value, arg1Value, arg2Value, arg3Value, s0_.appendCodePointIntlNode_, s0_.bufferGrowProfile_, s0_.errorProfile_);
                return;
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static AppendCodePointNode create() {
            return new AppendCodePointNodeGen();
        }

        public static AppendCodePointNode getUncached() {
            return AppendCodePointNodeGen.UNCACHED;
        }

        @GeneratedBy(AppendCodePointNode.class)
        private static final class AppendData extends Node {

            @Child AppendCodePointIntlNode appendCodePointIntlNode_;
            @CompilationFinal ConditionProfile bufferGrowProfile_;
            @CompilationFinal BranchProfile errorProfile_;

            AppendData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(AppendCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends AppendCodePointNode {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, int arg1Value, int arg2Value, boolean arg3Value) {
                AppendCodePointNode.append(arg0Value, arg1Value, arg2Value, arg3Value, (AppendCodePointIntlNodeGen.getUncached()), (ConditionProfile.getUncached()), (BranchProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(AppendCodePointIntlNode.class)
    static final class AppendCodePointIntlNodeGen extends AppendCodePointIntlNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private volatile int exclude_;
        @CompilationFinal private Utf16CachedData utf16Cached_cache;
        @CompilationFinal private ConditionProfile utf16Uncached_bmpProfile_;
        @CompilationFinal private Utf32CachedData utf32Cached_cache;

        private AppendCodePointIntlNodeGen() {
        }

        @ExplodeLoop
        @Override
        void execute(TruffleStringBuilder arg0Value, int arg1Value, Encoding arg2Value, int arg3Value, boolean arg4Value, ConditionProfile arg5Value, BranchProfile arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 bytes(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile) || utf8(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile) || utf16Cached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, int, int, ConditionProfile) || utf16Uncached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, ConditionProfile) || utf32Cached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, int, int) || utf32Uncached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile) || unsupported(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 bytes(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile) */) {
                    if ((TStringGuards.isAsciiBytesOrLatin1(arg2Value))) {
                        AppendCodePointIntlNode.bytes(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        return;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 utf8(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile) */) {
                    if ((TStringGuards.isUTF8(arg2Value))) {
                        AppendCodePointIntlNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 utf16Cached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, int, int, ConditionProfile) */ && (TStringGuards.isUTF16(arg2Value))) {
                    Utf16CachedData s2_ = this.utf16Cached_cache;
                    while (s2_ != null) {
                        if ((s2_.cachedCurStride_ == arg0Value.stride) && (s2_.cachedNewStride_ == TruffleStringBuilder.utf16Stride(arg0Value, arg1Value))) {
                            utf16Cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s2_.cachedCurStride_, s2_.cachedNewStride_, s2_.bmpProfile_);
                            return;
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 utf16Uncached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, ConditionProfile) */) {
                    if ((TStringGuards.isUTF16(arg2Value))) {
                        utf16Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf16Uncached_bmpProfile_);
                        return;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is-state_0 utf32Cached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, int, int) */ && (TStringGuards.isUTF32(arg2Value))) {
                    Utf32CachedData s4_ = this.utf32Cached_cache;
                    while (s4_ != null) {
                        if ((s4_.cachedCurStride_ == arg0Value.stride) && (s4_.cachedNewStride_ == TruffleStringBuilder.utf32Stride(arg0Value, arg1Value))) {
                            utf32Cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s4_.cachedCurStride_, s4_.cachedNewStride_);
                            return;
                        }
                        s4_ = s4_.next_;
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is-state_0 utf32Uncached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile) */) {
                    if ((TStringGuards.isUTF32(arg2Value))) {
                        utf32Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        return;
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is-state_0 unsupported(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile) */) {
                    if ((TStringGuards.isUnsupportedEncoding(arg2Value))) {
                        AppendCodePointIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            return;
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, int arg1Value, Encoding arg2Value, int arg3Value, boolean arg4Value, ConditionProfile arg5Value, BranchProfile arg6Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                if ((TStringGuards.isAsciiBytesOrLatin1(arg2Value))) {
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 bytes(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    AppendCodePointIntlNode.bytes(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    return;
                }
                if ((TStringGuards.isUTF8(arg2Value))) {
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 utf8(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    AppendCodePointIntlNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    return;
                }
                if (((exclude & 0b1)) == 0 /* is-not-exclude utf16Cached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, int, int, ConditionProfile) */ && (TStringGuards.isUTF16(arg2Value))) {
                    int count2_ = 0;
                    Utf16CachedData s2_ = this.utf16Cached_cache;
                    if ((state_0 & 0b100) != 0 /* is-state_0 utf16Cached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, int, int, ConditionProfile) */) {
                        while (s2_ != null) {
                            if ((s2_.cachedCurStride_ == arg0Value.stride) && (s2_.cachedNewStride_ == TruffleStringBuilder.utf16Stride(arg0Value, arg1Value))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        {
                            int cachedNewStride__ = (TruffleStringBuilder.utf16Stride(arg0Value, arg1Value));
                            // assert (s2_.cachedCurStride_ == arg0Value.stride);
                            if ((cachedNewStride__ == TruffleStringBuilder.utf16Stride(arg0Value, arg1Value)) && count2_ < (9)) {
                                s2_ = new Utf16CachedData(utf16Cached_cache);
                                s2_.cachedCurStride_ = (arg0Value.stride);
                                s2_.cachedNewStride_ = cachedNewStride__;
                                s2_.bmpProfile_ = (ConditionProfile.create());
                                VarHandle.storeStoreFence();
                                this.utf16Cached_cache = s2_;
                                this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 utf16Cached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, int, int, ConditionProfile) */;
                            }
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        utf16Cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s2_.cachedCurStride_, s2_.cachedNewStride_, s2_.bmpProfile_);
                        return;
                    }
                }
                if ((TStringGuards.isUTF16(arg2Value))) {
                    this.utf16Uncached_bmpProfile_ = (ConditionProfile.create());
                    this.exclude_ = exclude = exclude | 0b1 /* add-exclude utf16Cached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, int, int, ConditionProfile) */;
                    this.utf16Cached_cache = null;
                    state_0 = state_0 & 0xfffffffb /* remove-state_0 utf16Cached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, int, int, ConditionProfile) */;
                    this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 utf16Uncached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    utf16Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf16Uncached_bmpProfile_);
                    return;
                }
                if (((exclude & 0b10)) == 0 /* is-not-exclude utf32Cached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, int, int) */ && (TStringGuards.isUTF32(arg2Value))) {
                    int count4_ = 0;
                    Utf32CachedData s4_ = this.utf32Cached_cache;
                    if ((state_0 & 0b10000) != 0 /* is-state_0 utf32Cached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, int, int) */) {
                        while (s4_ != null) {
                            if ((s4_.cachedCurStride_ == arg0Value.stride) && (s4_.cachedNewStride_ == TruffleStringBuilder.utf32Stride(arg0Value, arg1Value))) {
                                break;
                            }
                            s4_ = s4_.next_;
                            count4_++;
                        }
                    }
                    if (s4_ == null) {
                        {
                            int cachedNewStride__1 = (TruffleStringBuilder.utf32Stride(arg0Value, arg1Value));
                            // assert (s4_.cachedCurStride_ == arg0Value.stride);
                            if ((cachedNewStride__1 == TruffleStringBuilder.utf32Stride(arg0Value, arg1Value)) && count4_ < (9)) {
                                s4_ = new Utf32CachedData(utf32Cached_cache);
                                s4_.cachedCurStride_ = (arg0Value.stride);
                                s4_.cachedNewStride_ = cachedNewStride__1;
                                VarHandle.storeStoreFence();
                                this.utf32Cached_cache = s4_;
                                this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 utf32Cached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, int, int) */;
                            }
                        }
                    }
                    if (s4_ != null) {
                        lock.unlock();
                        hasLock = false;
                        utf32Cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s4_.cachedCurStride_, s4_.cachedNewStride_);
                        return;
                    }
                }
                if ((TStringGuards.isUTF32(arg2Value))) {
                    this.exclude_ = exclude = exclude | 0b10 /* add-exclude utf32Cached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, int, int) */;
                    this.utf32Cached_cache = null;
                    state_0 = state_0 & 0xffffffef /* remove-state_0 utf32Cached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile, int, int) */;
                    this.state_0_ = state_0 = state_0 | 0b100000 /* add-state_0 utf32Uncached(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    utf32Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    return;
                }
                if ((TStringGuards.isUnsupportedEncoding(arg2Value))) {
                    this.state_0_ = state_0 = state_0 | 0b1000000 /* add-state_0 unsupported(TruffleStringBuilder, int, Encoding, int, boolean, ConditionProfile, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    AppendCodePointIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    Utf16CachedData s2_ = this.utf16Cached_cache;
                    Utf32CachedData s4_ = this.utf32Cached_cache;
                    if ((s2_ == null || s2_.next_ == null) && (s4_ == null || s4_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static AppendCodePointIntlNode create() {
            return new AppendCodePointIntlNodeGen();
        }

        public static AppendCodePointIntlNode getUncached() {
            return AppendCodePointIntlNodeGen.UNCACHED;
        }

        @GeneratedBy(AppendCodePointIntlNode.class)
        private static final class Utf16CachedData {

            @CompilationFinal Utf16CachedData next_;
            @CompilationFinal int cachedCurStride_;
            @CompilationFinal int cachedNewStride_;
            @CompilationFinal ConditionProfile bmpProfile_;

            Utf16CachedData(Utf16CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(AppendCodePointIntlNode.class)
        private static final class Utf32CachedData {

            @CompilationFinal Utf32CachedData next_;
            @CompilationFinal int cachedCurStride_;
            @CompilationFinal int cachedNewStride_;

            Utf32CachedData(Utf32CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(AppendCodePointIntlNode.class)
        @DenyReplace
        private static final class Uncached extends AppendCodePointIntlNode {

            @TruffleBoundary
            @Override
            void execute(TruffleStringBuilder arg0Value, int arg1Value, Encoding arg2Value, int arg3Value, boolean arg4Value, ConditionProfile arg5Value, BranchProfile arg6Value) {
                if ((TStringGuards.isAsciiBytesOrLatin1(arg2Value))) {
                    AppendCodePointIntlNode.bytes(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    return;
                }
                if ((TStringGuards.isUTF8(arg2Value))) {
                    AppendCodePointIntlNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    return;
                }
                if ((TStringGuards.isUTF16(arg2Value))) {
                    utf16Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (ConditionProfile.getUncached()));
                    return;
                }
                if ((TStringGuards.isUTF32(arg2Value))) {
                    utf32Uncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    return;
                }
                if ((TStringGuards.isUnsupportedEncoding(arg2Value))) {
                    AppendCodePointIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(AppendIntNumberNode.class)
    static final class AppendIntNumberNodeGen extends AppendIntNumberNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private AppendData append_cache;

        private AppendIntNumberNodeGen() {
        }

        @ExplodeLoop
        @Override
        public void execute(TruffleStringBuilder arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doAppend(TruffleStringBuilder, int, int, ConditionProfile, BranchProfile) */) {
                AppendData s0_ = this.append_cache;
                while (s0_ != null) {
                    if ((s0_.cachedStride_ == arg0Value.stride)) {
                        doAppend(arg0Value, arg1Value, s0_.cachedStride_, s0_.bufferGrowProfile_, s0_.errorProfile_);
                        return;
                    }
                    s0_ = s0_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value);
            return;
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, int arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int count0_ = 0;
                AppendData s0_ = this.append_cache;
                if (state_0 != 0 /* is-state_0 doAppend(TruffleStringBuilder, int, int, ConditionProfile, BranchProfile) */) {
                    while (s0_ != null) {
                        if ((s0_.cachedStride_ == arg0Value.stride)) {
                            break;
                        }
                        s0_ = s0_.next_;
                        count0_++;
                    }
                }
                if (s0_ == null) {
                    // assert (s0_.cachedStride_ == arg0Value.stride);
                    if (count0_ < (3)) {
                        s0_ = new AppendData(append_cache);
                        s0_.cachedStride_ = (arg0Value.stride);
                        s0_.bufferGrowProfile_ = (ConditionProfile.create());
                        s0_.errorProfile_ = (BranchProfile.create());
                        VarHandle.storeStoreFence();
                        this.append_cache = s0_;
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doAppend(TruffleStringBuilder, int, int, ConditionProfile, BranchProfile) */;
                    }
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    doAppend(arg0Value, arg1Value, s0_.cachedStride_, s0_.bufferGrowProfile_, s0_.errorProfile_);
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    AppendData s0_ = this.append_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static AppendIntNumberNode create() {
            return new AppendIntNumberNodeGen();
        }

        public static AppendIntNumberNode getUncached() {
            return AppendIntNumberNodeGen.UNCACHED;
        }

        @GeneratedBy(AppendIntNumberNode.class)
        private static final class AppendData {

            @CompilationFinal AppendData next_;
            @CompilationFinal int cachedStride_;
            @CompilationFinal ConditionProfile bufferGrowProfile_;
            @CompilationFinal BranchProfile errorProfile_;

            AppendData(AppendData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(AppendIntNumberNode.class)
        @DenyReplace
        private static final class Uncached extends AppendIntNumberNode {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, int arg1Value) {
                // assert ((arg0Value.stride) == arg0Value.stride);
                doAppend(arg0Value, arg1Value, (arg0Value.stride), (ConditionProfile.getUncached()), (BranchProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(AppendLongNumberNode.class)
    static final class AppendLongNumberNodeGen extends AppendLongNumberNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private AppendData append_cache;

        private AppendLongNumberNodeGen() {
        }

        @ExplodeLoop
        @Override
        public void execute(TruffleStringBuilder arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doAppend(TruffleStringBuilder, long, int, ConditionProfile, BranchProfile) */) {
                AppendData s0_ = this.append_cache;
                while (s0_ != null) {
                    if ((s0_.cachedStride_ == arg0Value.stride)) {
                        doAppend(arg0Value, arg1Value, s0_.cachedStride_, s0_.bufferGrowProfile_, s0_.errorProfile_);
                        return;
                    }
                    s0_ = s0_.next_;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value);
            return;
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, long arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int count0_ = 0;
                AppendData s0_ = this.append_cache;
                if (state_0 != 0 /* is-state_0 doAppend(TruffleStringBuilder, long, int, ConditionProfile, BranchProfile) */) {
                    while (s0_ != null) {
                        if ((s0_.cachedStride_ == arg0Value.stride)) {
                            break;
                        }
                        s0_ = s0_.next_;
                        count0_++;
                    }
                }
                if (s0_ == null) {
                    // assert (s0_.cachedStride_ == arg0Value.stride);
                    if (count0_ < (3)) {
                        s0_ = new AppendData(append_cache);
                        s0_.cachedStride_ = (arg0Value.stride);
                        s0_.bufferGrowProfile_ = (ConditionProfile.create());
                        s0_.errorProfile_ = (BranchProfile.create());
                        VarHandle.storeStoreFence();
                        this.append_cache = s0_;
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doAppend(TruffleStringBuilder, long, int, ConditionProfile, BranchProfile) */;
                    }
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    doAppend(arg0Value, arg1Value, s0_.cachedStride_, s0_.bufferGrowProfile_, s0_.errorProfile_);
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    AppendData s0_ = this.append_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static AppendLongNumberNode create() {
            return new AppendLongNumberNodeGen();
        }

        public static AppendLongNumberNode getUncached() {
            return AppendLongNumberNodeGen.UNCACHED;
        }

        @GeneratedBy(AppendLongNumberNode.class)
        private static final class AppendData {

            @CompilationFinal AppendData next_;
            @CompilationFinal int cachedStride_;
            @CompilationFinal ConditionProfile bufferGrowProfile_;
            @CompilationFinal BranchProfile errorProfile_;

            AppendData(AppendData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(AppendLongNumberNode.class)
        @DenyReplace
        private static final class Uncached extends AppendLongNumberNode {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, long arg1Value) {
                // assert ((arg0Value.stride) == arg0Value.stride);
                doAppend(arg0Value, arg1Value, (arg0Value.stride), (ConditionProfile.getUncached()), (BranchProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(AppendStringNode.class)
    static final class AppendStringNodeGen extends AppendStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private AppendData append_cache;

        private AppendStringNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, AbstractTruffleString arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 append(TruffleStringBuilder, AbstractTruffleString, ToIndexableNode, GetCodePointLengthNode, GetCodeRangeNode, AppendArrayIntlNode) */) {
                AppendData s0_ = this.append_cache;
                if (s0_ != null) {
                    AppendStringNode.append(arg0Value, arg1Value, s0_.toIndexableNode_, s0_.getCodePointLengthNode_, s0_.getCodeRangeNode_, s0_.appendArrayIntlNode_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value);
            return;
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, AbstractTruffleString arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                AppendData s0_ = super.insert(new AppendData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodePointLengthNode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.getCodeRangeNode_ = s0_.insertAccessor((GetCodeRangeNodeGen.create()));
                s0_.appendArrayIntlNode_ = s0_.insertAccessor((AppendArrayIntlNodeGen.create()));
                VarHandle.storeStoreFence();
                this.append_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 append(TruffleStringBuilder, AbstractTruffleString, ToIndexableNode, GetCodePointLengthNode, GetCodeRangeNode, AppendArrayIntlNode) */;
                lock.unlock();
                hasLock = false;
                AppendStringNode.append(arg0Value, arg1Value, s0_.toIndexableNode_, s0_.getCodePointLengthNode_, s0_.getCodeRangeNode_, s0_.appendArrayIntlNode_);
                return;
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static AppendStringNode create() {
            return new AppendStringNodeGen();
        }

        public static AppendStringNode getUncached() {
            return AppendStringNodeGen.UNCACHED;
        }

        @GeneratedBy(AppendStringNode.class)
        private static final class AppendData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child GetCodePointLengthNode getCodePointLengthNode_;
            @Child GetCodeRangeNode getCodeRangeNode_;
            @Child AppendArrayIntlNode appendArrayIntlNode_;

            AppendData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(AppendStringNode.class)
        @DenyReplace
        private static final class Uncached extends AppendStringNode {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, AbstractTruffleString arg1Value) {
                AppendStringNode.append(arg0Value, arg1Value, (ToIndexableNode.getUncached()), (GetCodePointLengthNode.getUncached()), (GetCodeRangeNode.getUncached()), (AppendArrayIntlNodeGen.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(AppendSubstringByteIndexNode.class)
    static final class AppendSubstringByteIndexNodeGen extends AppendSubstringByteIndexNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private AppendData append_cache;

        private AppendSubstringByteIndexNodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 append(TruffleStringBuilder, AbstractTruffleString, int, int, ToIndexableNode, GetCodePointLengthNode, GetCodeRangeNode, AppendArrayIntlNode, CalcStringAttributesNode, ConditionProfile) */) {
                AppendData s0_ = this.append_cache;
                if (s0_ != null) {
                    AppendSubstringByteIndexNode.append(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodePointLengthNode_, s0_.getCodeRangeNode_, s0_.appendArrayIntlNode_, s0_.calcAttributesNode_, s0_.calcAttrsProfile_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            return;
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                AppendData s0_ = super.insert(new AppendData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodePointLengthNode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.getCodeRangeNode_ = s0_.insertAccessor((GetCodeRangeNodeGen.create()));
                s0_.appendArrayIntlNode_ = s0_.insertAccessor((AppendArrayIntlNodeGen.create()));
                s0_.calcAttributesNode_ = s0_.insertAccessor((CalcStringAttributesNodeGen.create()));
                s0_.calcAttrsProfile_ = (ConditionProfile.create());
                VarHandle.storeStoreFence();
                this.append_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 append(TruffleStringBuilder, AbstractTruffleString, int, int, ToIndexableNode, GetCodePointLengthNode, GetCodeRangeNode, AppendArrayIntlNode, CalcStringAttributesNode, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                AppendSubstringByteIndexNode.append(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodePointLengthNode_, s0_.getCodeRangeNode_, s0_.appendArrayIntlNode_, s0_.calcAttributesNode_, s0_.calcAttrsProfile_);
                return;
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static AppendSubstringByteIndexNode create() {
            return new AppendSubstringByteIndexNodeGen();
        }

        public static AppendSubstringByteIndexNode getUncached() {
            return AppendSubstringByteIndexNodeGen.UNCACHED;
        }

        @GeneratedBy(AppendSubstringByteIndexNode.class)
        private static final class AppendData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child GetCodePointLengthNode getCodePointLengthNode_;
            @Child GetCodeRangeNode getCodeRangeNode_;
            @Child AppendArrayIntlNode appendArrayIntlNode_;
            @Child CalcStringAttributesNode calcAttributesNode_;
            @CompilationFinal ConditionProfile calcAttrsProfile_;

            AppendData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(AppendSubstringByteIndexNode.class)
        @DenyReplace
        private static final class Uncached extends AppendSubstringByteIndexNode {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value) {
                AppendSubstringByteIndexNode.append(arg0Value, arg1Value, arg2Value, arg3Value, (ToIndexableNode.getUncached()), (GetCodePointLengthNode.getUncached()), (GetCodeRangeNode.getUncached()), (AppendArrayIntlNodeGen.getUncached()), (CalcStringAttributesNode.getUncached()), (ConditionProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(AppendJavaStringUTF16Node.class)
    static final class AppendJavaStringUTF16NodeGen extends AppendJavaStringUTF16Node {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private AppendArrayIntlNode appendArrayIntlNode_;
        @CompilationFinal private ConditionProfile stride0Profile_;

        private AppendJavaStringUTF16NodeGen() {
        }

        @Override
        public void execute(TruffleStringBuilder arg0Value, String arg1Value, int arg2Value, int arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 append(TruffleStringBuilder, String, int, int, AppendArrayIntlNode, ConditionProfile) */) {
                append(arg0Value, arg1Value, arg2Value, arg3Value, this.appendArrayIntlNode_, this.stride0Profile_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            return;
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, String arg1Value, int arg2Value, int arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.appendArrayIntlNode_ = super.insert((AppendArrayIntlNodeGen.create()));
                this.stride0Profile_ = (ConditionProfile.create());
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 append(TruffleStringBuilder, String, int, int, AppendArrayIntlNode, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                append(arg0Value, arg1Value, arg2Value, arg3Value, this.appendArrayIntlNode_, this.stride0Profile_);
                return;
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static AppendJavaStringUTF16Node create() {
            return new AppendJavaStringUTF16NodeGen();
        }

        public static AppendJavaStringUTF16Node getUncached() {
            return AppendJavaStringUTF16NodeGen.UNCACHED;
        }

        @GeneratedBy(AppendJavaStringUTF16Node.class)
        @DenyReplace
        private static final class Uncached extends AppendJavaStringUTF16Node {

            @TruffleBoundary
            @Override
            public void execute(TruffleStringBuilder arg0Value, String arg1Value, int arg2Value, int arg3Value) {
                append(arg0Value, arg1Value, arg2Value, arg3Value, (AppendArrayIntlNodeGen.getUncached()), (ConditionProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ToStringNode.class)
    static final class ToStringNodeGen extends ToStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private ConditionProfile calcAttributesProfile_;
        @Child private CalcStringAttributesNode calcAttributesNode_;

        private ToStringNodeGen() {
        }

        @Override
        public TruffleString execute(TruffleStringBuilder arg0Value, boolean arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 createString(TruffleStringBuilder, boolean, ConditionProfile, CalcStringAttributesNode) */) {
                return ToStringNode.createString(arg0Value, arg1Value, this.calcAttributesProfile_, this.calcAttributesNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private TruffleString executeAndSpecialize(TruffleStringBuilder arg0Value, boolean arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.calcAttributesProfile_ = (ConditionProfile.create());
                this.calcAttributesNode_ = super.insert((CalcStringAttributesNodeGen.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 createString(TruffleStringBuilder, boolean, ConditionProfile, CalcStringAttributesNode) */;
                lock.unlock();
                hasLock = false;
                return ToStringNode.createString(arg0Value, arg1Value, this.calcAttributesProfile_, this.calcAttributesNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static ToStringNode create() {
            return new ToStringNodeGen();
        }

        public static ToStringNode getUncached() {
            return ToStringNodeGen.UNCACHED;
        }

        @GeneratedBy(ToStringNode.class)
        @DenyReplace
        private static final class Uncached extends ToStringNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(TruffleStringBuilder arg0Value, boolean arg1Value) {
                return ToStringNode.createString(arg0Value, arg1Value, (ConditionProfile.getUncached()), (CalcStringAttributesNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(AppendArrayIntlNode.class)
    static final class AppendArrayIntlNodeGen extends AppendArrayIntlNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private volatile int exclude_;
        @CompilationFinal private CachedData cached_cache;
        @CompilationFinal private ConditionProfile uncached_bufferGrowProfile_;
        @CompilationFinal private BranchProfile uncached_errorProfile_;

        private AppendArrayIntlNodeGen() {
        }

        @ExplodeLoop
        @Override
        void execute(TruffleStringBuilder arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value, int arg5Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doCached(TruffleStringBuilder, Object, int, int, int, int, int, int, int, ConditionProfile, BranchProfile) || doUncached(TruffleStringBuilder, Object, int, int, int, int, ConditionProfile, BranchProfile) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doCached(TruffleStringBuilder, Object, int, int, int, int, int, int, int, ConditionProfile, BranchProfile) */) {
                    CachedData s0_ = this.cached_cache;
                    while (s0_ != null) {
                        if ((arg0Value.stride == s0_.cachedStrideSB_) && (arg4Value == s0_.cachedStrideA_) && (arg5Value == s0_.cachedStrideNew_)) {
                            doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.cachedStrideSB_, s0_.cachedStrideA_, s0_.cachedStrideNew_, s0_.bufferGrowProfile_, s0_.errorProfile_);
                            return;
                        }
                        s0_ = s0_.next_;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doUncached(TruffleStringBuilder, Object, int, int, int, int, ConditionProfile, BranchProfile) */) {
                    doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.uncached_bufferGrowProfile_, this.uncached_errorProfile_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            return;
        }

        private void executeAndSpecialize(TruffleStringBuilder arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value, int arg5Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                if ((exclude) == 0 /* is-not-exclude doCached(TruffleStringBuilder, Object, int, int, int, int, int, int, int, ConditionProfile, BranchProfile) */) {
                    int count0_ = 0;
                    CachedData s0_ = this.cached_cache;
                    if ((state_0 & 0b1) != 0 /* is-state_0 doCached(TruffleStringBuilder, Object, int, int, int, int, int, int, int, ConditionProfile, BranchProfile) */) {
                        while (s0_ != null) {
                            if ((arg0Value.stride == s0_.cachedStrideSB_) && (arg4Value == s0_.cachedStrideA_) && (arg5Value == s0_.cachedStrideNew_)) {
                                break;
                            }
                            s0_ = s0_.next_;
                            count0_++;
                        }
                    }
                    if (s0_ == null) {
                        // assert (arg0Value.stride == s0_.cachedStrideSB_);
                        // assert (arg4Value == s0_.cachedStrideA_);
                        // assert (arg5Value == s0_.cachedStrideNew_);
                        if (count0_ < (9)) {
                            s0_ = new CachedData(cached_cache);
                            s0_.cachedStrideSB_ = (arg0Value.stride);
                            s0_.cachedStrideA_ = (arg4Value);
                            s0_.cachedStrideNew_ = (arg5Value);
                            s0_.bufferGrowProfile_ = (ConditionProfile.create());
                            s0_.errorProfile_ = (BranchProfile.create());
                            VarHandle.storeStoreFence();
                            this.cached_cache = s0_;
                            this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doCached(TruffleStringBuilder, Object, int, int, int, int, int, int, int, ConditionProfile, BranchProfile) */;
                        }
                    }
                    if (s0_ != null) {
                        lock.unlock();
                        hasLock = false;
                        doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.cachedStrideSB_, s0_.cachedStrideA_, s0_.cachedStrideNew_, s0_.bufferGrowProfile_, s0_.errorProfile_);
                        return;
                    }
                }
                this.uncached_bufferGrowProfile_ = (ConditionProfile.create());
                this.uncached_errorProfile_ = (BranchProfile.create());
                this.exclude_ = exclude = exclude | 0b1 /* add-exclude doCached(TruffleStringBuilder, Object, int, int, int, int, int, int, int, ConditionProfile, BranchProfile) */;
                this.cached_cache = null;
                state_0 = state_0 & 0xfffffffe /* remove-state_0 doCached(TruffleStringBuilder, Object, int, int, int, int, int, int, int, ConditionProfile, BranchProfile) */;
                this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doUncached(TruffleStringBuilder, Object, int, int, int, int, ConditionProfile, BranchProfile) */;
                lock.unlock();
                hasLock = false;
                doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.uncached_bufferGrowProfile_, this.uncached_errorProfile_);
                return;
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    CachedData s0_ = this.cached_cache;
                    if ((s0_ == null || s0_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static AppendArrayIntlNode create() {
            return new AppendArrayIntlNodeGen();
        }

        public static AppendArrayIntlNode getUncached() {
            return AppendArrayIntlNodeGen.UNCACHED;
        }

        @GeneratedBy(AppendArrayIntlNode.class)
        private static final class CachedData {

            @CompilationFinal CachedData next_;
            @CompilationFinal int cachedStrideSB_;
            @CompilationFinal int cachedStrideA_;
            @CompilationFinal int cachedStrideNew_;
            @CompilationFinal ConditionProfile bufferGrowProfile_;
            @CompilationFinal BranchProfile errorProfile_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(AppendArrayIntlNode.class)
        @DenyReplace
        private static final class Uncached extends AppendArrayIntlNode {

            @TruffleBoundary
            @Override
            void execute(TruffleStringBuilder arg0Value, Object arg1Value, int arg2Value, int arg3Value, int arg4Value, int arg5Value) {
                doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ConditionProfile.getUncached()), (BranchProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
