/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.frame;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.SuppressFBWarnings;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public final class FrameDescriptor
implements Cloneable {
    private final Object defaultValue;
    private final ArrayList<FrameSlot> slots = new ArrayList();
    private final EconomicMap<Object, FrameSlot> identifierToSlotMap = EconomicMap.create();
    @CompilerDirectives.CompilationFinal
    private volatile Assumption version;
    private EconomicMap<Object, Assumption> identifierToNotInFrameAssumptionMap;
    @CompilerDirectives.CompilationFinal
    private volatile int size;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] indexedSlotTags;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Object[] indexedSlotNames;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Object[] indexedSlotInfos;
    private volatile EconomicMap<Object, Integer> auxiliarySlotMap;
    private volatile BitSet disabledAuxiliarySlots;
    @CompilerDirectives.CompilationFinal
    private volatile int activeAuxiliarySlotCount;
    private volatile int auxiliarySlotCount;
    boolean materializeCalled;
    private static final String NEVER_PART_OF_COMPILATION_MESSAGE = "interpreter-only. includes hashmap operations.";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public FrameDescriptor() {
        this(null);
    }

    public FrameDescriptor(Object defaultValue) {
        CompilerAsserts.neverPartOfCompilation("do not create a FrameDescriptor from compiled code");
        this.indexedSlotTags = EMPTY_BYTE_ARRAY;
        this.indexedSlotNames = null;
        this.indexedSlotInfos = null;
        this.defaultValue = defaultValue;
        FrameDescriptor.newVersion(this);
    }

    private FrameDescriptor(Object defaultValue, byte[] indexedSlotTags, Object[] indexedSlotNames, Object[] indexedSlotInfos) {
        CompilerAsserts.neverPartOfCompilation("do not create a FrameDescriptor from compiled code");
        this.indexedSlotTags = indexedSlotTags;
        this.indexedSlotNames = indexedSlotNames;
        this.indexedSlotInfos = indexedSlotInfos;
        this.defaultValue = defaultValue;
        FrameDescriptor.newVersion(this);
    }

    @Deprecated
    public FrameSlot addFrameSlot(Object identifier) {
        return this.addFrameSlot(identifier, null, FrameSlotKind.Illegal);
    }

    @Deprecated
    public FrameSlot addFrameSlot(Object identifier, FrameSlotKind kind) {
        return this.addFrameSlot(identifier, null, kind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="All increments and decrements are synchronized.")
    public FrameSlot addFrameSlot(Object identifier, Object info, FrameSlotKind kind) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Objects.requireNonNull(identifier, "identifier");
        Objects.requireNonNull(kind, "kind");
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            if (this.identifierToSlotMap.containsKey(identifier)) {
                throw new IllegalArgumentException("duplicate frame slot: " + identifier);
            }
            FrameSlot slot = new FrameSlot(this, identifier, info, kind, this.size);
            ++this.size;
            this.slots.add(slot);
            this.identifierToSlotMap.put(identifier, (Object)slot);
            this.updateVersion();
            this.invalidateNotInFrameAssumption(identifier);
            return slot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public FrameSlot findFrameSlot(Object identifier) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            return (FrameSlot)this.identifierToSlotMap.get(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public FrameSlot findOrAddFrameSlot(Object identifier) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            FrameSlot result = this.findFrameSlot(identifier);
            if (result != null) {
                return result;
            }
            return this.addFrameSlot(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public FrameSlot findOrAddFrameSlot(Object identifier, FrameSlotKind kind) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            FrameSlot result = this.findFrameSlot(identifier);
            if (result != null) {
                return result;
            }
            return this.addFrameSlot(identifier, kind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public FrameSlot findOrAddFrameSlot(Object identifier, Object info, FrameSlotKind kind) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            FrameSlot result = this.findFrameSlot(identifier);
            if (result != null) {
                return result;
            }
            return this.addFrameSlot(identifier, info, kind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeFrameSlot(Object identifier) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            FrameSlot slot = (FrameSlot)this.identifierToSlotMap.get(identifier);
            if (slot == null) {
                throw new IllegalArgumentException("no such frame slot: " + identifier);
            }
            this.slots.remove(slot);
            this.identifierToSlotMap.removeKey(identifier);
            this.updateVersion();
            this.getNotInFrameAssumption(identifier);
        }
    }

    @Deprecated
    public FrameSlotKind getFrameSlotKind(FrameSlot frameSlot) {
        assert (this.checkFrameSlotOwnership(frameSlot));
        return frameSlot.kind;
    }

    @Deprecated
    public void setFrameSlotKind(FrameSlot frameSlot, FrameSlotKind kind) {
        if (frameSlot.kind != kind) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setFrameSlotKindSlow(frameSlot, kind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFrameSlotKindSlow(FrameSlot frameSlot, FrameSlotKind kind) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            assert (this.checkFrameSlotOwnershipUnsafe(frameSlot));
            if (frameSlot.kind != kind) {
                FrameDescriptor.invalidateVersion(this);
                frameSlot.kind = kind;
                FrameDescriptor.newVersion(this);
            }
        }
    }

    private boolean checkFrameSlotOwnershipUnsafe(FrameSlot frameSlot) {
        return frameSlot.descriptor == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean checkFrameSlotOwnership(FrameSlot frameSlot) {
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            return this.checkFrameSlotOwnershipUnsafe(frameSlot);
        }
    }

    @Deprecated
    public int getSize() {
        if (CompilerDirectives.inCompiledCode() && !this.version.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<? extends FrameSlot> getSlots() {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            return Collections.unmodifiableList(new ArrayList<FrameSlot>(this.slots));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Set<Object> getIdentifiers() {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            return FrameDescriptor.unmodifiableSetFromEconomicMap(EconomicMap.create(this.identifierToSlotMap));
        }
    }

    private static <K> Set<K> unmodifiableSetFromEconomicMap(final EconomicMap<K, ?> map) {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    private final Iterator<K> it;
                    {
                        this.it = map.getKeys().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public K next() {
                        return this.it.next();
                    }
                };
            }

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean contains(Object o) {
                return map.containsKey(o);
            }

            @Override
            public boolean add(K e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends K> coll) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> coll) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> coll) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeIf(Predicate<? super K> filter) {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameDescriptor copy() {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            FrameDescriptor clonedFrameDescriptor = new FrameDescriptor(this.defaultValue, this.indexedSlotTags == null ? null : (byte[])this.indexedSlotTags.clone(), this.indexedSlotNames == null ? null : (Object[])this.indexedSlotNames.clone(), this.indexedSlotInfos == null ? null : (Object[])this.indexedSlotInfos.clone());
            for (int i = 0; i < this.slots.size(); ++i) {
                FrameSlot slot = this.slots.get(i);
                clonedFrameDescriptor.addFrameSlot(slot.getIdentifier(), slot.getInfo(), FrameSlotKind.Illegal);
            }
            clonedFrameDescriptor.auxiliarySlotCount = this.auxiliarySlotCount;
            clonedFrameDescriptor.activeAuxiliarySlotCount = this.activeAuxiliarySlotCount;
            if (this.auxiliarySlotMap != null) {
                clonedFrameDescriptor.auxiliarySlotMap = EconomicMap.create(this.auxiliarySlotMap);
            }
            if (this.disabledAuxiliarySlots != null) {
                clonedFrameDescriptor.disabledAuxiliarySlots = new BitSet();
                clonedFrameDescriptor.disabledAuxiliarySlots.or(this.disabledAuxiliarySlots);
            }
            return clonedFrameDescriptor;
        }
    }

    private void updateVersion() {
        FrameDescriptor.invalidateVersion(this);
        FrameDescriptor.newVersion(this);
    }

    private static void newVersion(FrameDescriptor descriptor) {
        descriptor.version = Truffle.getRuntime().createAssumption("frame version");
    }

    private static void invalidateVersion(FrameDescriptor descriptor) {
        descriptor.version.invalidate();
    }

    @Deprecated
    public Assumption getVersion() {
        return this.version;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Assumption getNotInFrameAssumption(Object identifier) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            Assumption assumption;
            if (this.identifierToSlotMap.containsKey(identifier)) {
                throw new IllegalArgumentException("Cannot get not-in-frame assumption for existing frame slot!");
            }
            if (this.identifierToNotInFrameAssumptionMap == null) {
                this.identifierToNotInFrameAssumptionMap = EconomicMap.create();
            } else {
                assumption = (Assumption)this.identifierToNotInFrameAssumptionMap.get(identifier);
                if (assumption != null) {
                    return assumption;
                }
            }
            assumption = Truffle.getRuntime().createAssumption("identifier not in frame");
            this.identifierToNotInFrameAssumptionMap.put(identifier, (Object)assumption);
            return assumption;
        }
    }

    private void invalidateNotInFrameAssumption(Object identifier) {
        Assumption assumption;
        if (this.identifierToNotInFrameAssumptionMap != null && (assumption = (Assumption)this.identifierToNotInFrameAssumptionMap.get(identifier)) != null) {
            assumption.invalidate();
            this.identifierToNotInFrameAssumptionMap.removeKey(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            StringBuilder sb = new StringBuilder();
            sb.append("FrameDescriptor@").append(Integer.toHexString(this.hashCode()));
            sb.append("{");
            boolean comma = false;
            for (FrameSlot slot : this.slots) {
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                sb.append(slot.index).append(":").append(slot.getIdentifier());
            }
            for (int slot = 0; slot < this.indexedSlotTags.length; ++slot) {
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                sb.append('#').append(slot);
                if (this.getSlotName(slot) == null) continue;
                sb.append(":").append(this.getSlotName(slot));
            }
            EconomicMap<Object, Integer> map = this.auxiliarySlotMap;
            if (map != null) {
                MapCursor entries = map.getEntries();
                while (entries.advance()) {
                    if (comma) {
                        sb.append(", ");
                    } else {
                        comma = true;
                    }
                    sb.append('@').append(entries.getKey()).append(":").append(entries.getValue());
                }
            }
            sb.append("}");
            return sb.toString();
        }
    }

    public int getNumberOfSlots() {
        return this.indexedSlotTags.length;
    }

    public FrameSlotKind getSlotKind(int slot) {
        return FrameSlotKind.fromTag(this.indexedSlotTags[slot]);
    }

    public void setSlotKind(int slot, FrameSlotKind kind) {
        if (this.indexedSlotTags[slot] != kind.tag) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.indexedSlotTags[slot] = kind.tag;
        }
    }

    public Object getSlotName(int slot) {
        return this.indexedSlotNames == null ? null : this.indexedSlotNames[slot];
    }

    public Object getSlotInfo(int slot) {
        return this.indexedSlotInfos == null ? null : this.indexedSlotInfos[slot];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findOrAddAuxiliarySlot(Object key) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            Integer index;
            EconomicMap map = this.auxiliarySlotMap;
            if (map == null) {
                this.auxiliarySlotMap = map = EconomicMap.create();
            }
            if ((index = (Integer)map.get(key)) == null) {
                index = this.auxiliarySlotCount++;
                map.put(key, (Object)index);
                this.activeAuxiliarySlotCount = this.auxiliarySlotCount;
            } else if (this.disabledAuxiliarySlots != null) {
                this.disabledAuxiliarySlots.clear(index);
                this.recalculateAuxiliarySlotSize();
            }
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAuxiliarySlot(Object key) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            Integer index;
            EconomicMap<Object, Integer> map = this.auxiliarySlotMap;
            if (map != null && (index = (Integer)map.get(key)) != null) {
                BitSet set = this.disabledAuxiliarySlots;
                if (set == null) {
                    this.disabledAuxiliarySlots = set = new BitSet();
                }
                set.set(index);
                this.recalculateAuxiliarySlotSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Object, Integer> getAuxiliarySlots() {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        FrameDescriptor frameDescriptor = this;
        synchronized (frameDescriptor) {
            HashMap<Object, Integer> result = new HashMap<Object, Integer>();
            EconomicMap<Object, Integer> map = this.auxiliarySlotMap;
            BitSet disabled = this.disabledAuxiliarySlots;
            if (map != null) {
                MapCursor cursor = map.getEntries();
                while (cursor.advance()) {
                    Object identifier = cursor.getKey();
                    int index = (Integer)cursor.getValue();
                    if (disabled != null && disabled.get(index)) continue;
                    result.put(identifier, index);
                }
            }
            return result;
        }
    }

    private void recalculateAuxiliarySlotSize() {
        int i;
        BitSet set = this.disabledAuxiliarySlots;
        for (i = this.auxiliarySlotCount; i > 0 && set.get(i - 1); --i) {
        }
        this.activeAuxiliarySlotCount = i;
    }

    public int getNumberOfAuxiliarySlots() {
        return this.activeAuxiliarySlotCount;
    }

    public static Builder newBuilder() {
        return new Builder(8);
    }

    public static Builder newBuilder(int capacity) {
        return new Builder(capacity);
    }

    public static final class Builder {
        private static final int DEFAULT_CAPACITY = 8;
        private Object defaultValue;
        private byte[] tags;
        private Object[] names;
        private Object[] infos;
        private int size;

        private Builder(int capacity) {
            this.tags = new byte[capacity];
        }

        private void ensureCapacity(int count) {
            if (this.tags.length < this.size + count) {
                int newLength = Math.max(this.size + count, this.size * 2);
                this.tags = Arrays.copyOf(this.tags, newLength);
                if (this.names != null) {
                    this.names = Arrays.copyOf(this.names, newLength);
                }
                if (this.infos != null) {
                    this.infos = Arrays.copyOf(this.infos, newLength);
                }
            }
        }

        public Builder defaultValue(Object newDefaultValue) {
            this.defaultValue = newDefaultValue;
            return this;
        }

        public int addSlots(int count, FrameSlotKind kind) {
            if (count < 0 || this.size + count < 0) {
                throw new IllegalArgumentException("invalid slot count: " + count);
            }
            this.ensureCapacity(count);
            Arrays.fill(this.tags, this.size, this.size + count, kind.tag);
            int newIndex = this.size;
            this.size += count;
            return newIndex;
        }

        public int addSlot(FrameSlotKind kind, Object name, Object info) {
            this.ensureCapacity(1);
            this.tags[this.size] = kind.tag;
            if (name != null) {
                if (this.names == null) {
                    this.names = new Object[this.tags.length];
                }
                this.names[this.size] = name;
            }
            if (info != null) {
                if (this.infos == null) {
                    this.infos = new Object[this.tags.length];
                }
                this.infos[this.size] = info;
            }
            this.tags[this.size] = kind.tag;
            int newIndex = this.size++;
            return newIndex;
        }

        public FrameDescriptor build() {
            return new FrameDescriptor(this.defaultValue, Arrays.copyOf(this.tags, this.size), this.names == null ? null : Arrays.copyOf(this.names, this.size), this.infos == null ? null : Arrays.copyOf(this.infos, this.size));
        }
    }
}

