/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZoneId;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.ProcessHandler;

final class PolyglotEngineDispatch
extends AbstractPolyglotImpl.AbstractEngineDispatch {
    private final PolyglotImpl polyglot;

    protected PolyglotEngineDispatch(PolyglotImpl polyglot) {
        super((AbstractPolyglotImpl)polyglot);
        this.polyglot = polyglot;
    }

    public void setAPI(Object oreceiver, Engine engine) {
        ((PolyglotEngineImpl)oreceiver).api = engine;
    }

    public Language requirePublicLanguage(Object oreceiver, String id) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return receiver.requirePublicLanguage(id);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(receiver, t);
        }
    }

    public Instrument requirePublicInstrument(Object oreceiver, String id) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return receiver.requirePublicInstrument(id);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(receiver, t);
        }
    }

    public void close(Object oreceiver, Object apiObject, boolean cancelIfExecuting) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            receiver.ensureClosed(cancelIfExecuting, false);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(receiver, t);
        }
    }

    public Map<String, Instrument> getInstruments(Object oreceiver) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return receiver.getInstruments();
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(receiver, t);
        }
    }

    public Map<String, Language> getLanguages(Object oreceiver) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return receiver.getLanguages();
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(receiver, t);
        }
    }

    public OptionDescriptors getOptions(Object oreceiver) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return receiver.getOptions();
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(receiver, t);
        }
    }

    public Context createContext(Object oreceiver, OutputStream out, OutputStream err, InputStream in, boolean allowHostAccess, HostAccess hostAccess, PolyglotAccess polyglotAccess, boolean allowNativeAccess, boolean allowCreateThread, boolean allowHostIO, boolean allowHostClassLoading, boolean allowExperimentalOptions, Predicate<String> classFilter, Map<String, String> options, Map<String, String[]> arguments, String[] onlyLanguages, FileSystem fileSystem, Object logHandlerOrStream, boolean allowCreateProcess, ProcessHandler processHandler, EnvironmentAccess environmentAccess, Map<String, String> environment, ZoneId zone, Object limitsImpl, String currentWorkingDirectory, ClassLoader hostClassLoader, boolean allowValueSharing) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        PolyglotContextImpl context = receiver.createContext(out, err, in, allowHostAccess, hostAccess, polyglotAccess, allowNativeAccess, allowCreateThread, allowHostIO, allowHostClassLoading, allowExperimentalOptions, classFilter, options, arguments, onlyLanguages, fileSystem, logHandlerOrStream, allowCreateProcess, processHandler, environmentAccess, environment, zone, limitsImpl, currentWorkingDirectory, hostClassLoader, allowValueSharing);
        return this.polyglot.getAPIAccess().newContext((AbstractPolyglotImpl.AbstractContextDispatch)this.polyglot.contextDispatch, (Object)context, context.engine.api);
    }

    public String getImplementationName(Object oreceiver) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return Truffle.getRuntime().getName();
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(receiver, t);
        }
    }

    public Set<Source> getCachedSources(Object oreceiver) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return receiver.getCachedSources();
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(receiver, t);
        }
    }

    public String getVersion(Object oreceiver) {
        PolyglotEngineImpl receiver = (PolyglotEngineImpl)oreceiver;
        try {
            return receiver.getVersion();
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(receiver, t);
        }
    }
}

