// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.polyglot.HostExecuteNode;
import com.oracle.truffle.polyglot.HostExecuteNodeGen;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.ToHostNode;
import com.oracle.truffle.polyglot.ToHostNodeGen;
import com.oracle.truffle.polyglot.HostObject.ArrayGet;
import com.oracle.truffle.polyglot.HostObject.ArraySet;
import com.oracle.truffle.polyglot.HostObject.Instantiate;
import com.oracle.truffle.polyglot.HostObject.IsArrayElementExisting;
import com.oracle.truffle.polyglot.HostObject.IsArrayElementRemovable;
import com.oracle.truffle.polyglot.HostObject.IsArrayNode;
import com.oracle.truffle.polyglot.HostObject.IsIdenticalOrUndefined;
import com.oracle.truffle.polyglot.HostObject.IsInstantiable;
import com.oracle.truffle.polyglot.HostObject.IsListNode;
import com.oracle.truffle.polyglot.HostObject.IsMemberInternal;
import com.oracle.truffle.polyglot.HostObject.IsMemberInvocable;
import com.oracle.truffle.polyglot.HostObject.IsMemberModifiable;
import com.oracle.truffle.polyglot.HostObject.IsMemberReadable;
import com.oracle.truffle.polyglot.HostObject.LookupConstructorNode;
import com.oracle.truffle.polyglot.HostObject.LookupFieldNode;
import com.oracle.truffle.polyglot.HostObject.LookupFunctionalMethodNode;
import com.oracle.truffle.polyglot.HostObject.LookupInnerClassNode;
import com.oracle.truffle.polyglot.HostObject.LookupMethodNode;
import com.oracle.truffle.polyglot.HostObject.ReadArrayElement;
import com.oracle.truffle.polyglot.HostObject.ReadFieldNode;
import com.oracle.truffle.polyglot.HostObject.RemoveArrayElement;
import com.oracle.truffle.polyglot.HostObject.WriteArrayElement;
import com.oracle.truffle.polyglot.HostObject.WriteFieldNode;
import com.oracle.truffle.polyglot.HostObjectFactory.ArrayGetNodeGen;
import com.oracle.truffle.polyglot.HostObjectFactory.ArraySetNodeGen;
import com.oracle.truffle.polyglot.HostObjectFactory.IsArrayNodeGen;
import com.oracle.truffle.polyglot.HostObjectFactory.IsListNodeGen;
import com.oracle.truffle.polyglot.HostObjectFactory.LookupConstructorNodeGen;
import com.oracle.truffle.polyglot.HostObjectFactory.LookupFieldNodeGen;
import com.oracle.truffle.polyglot.HostObjectFactory.LookupFunctionalMethodNodeGen;
import com.oracle.truffle.polyglot.HostObjectFactory.LookupInnerClassNodeGen;
import com.oracle.truffle.polyglot.HostObjectFactory.LookupMethodNodeGen;
import com.oracle.truffle.polyglot.HostObjectFactory.ReadFieldNodeGen;
import com.oracle.truffle.polyglot.HostObjectFactory.WriteFieldNodeGen;
import com.oracle.truffle.polyglot.PolyglotLanguageContext.ToGuestValueNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContextFactory.ToGuestValueNodeGen;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.concurrent.locks.Lock;

@GeneratedBy(HostObject.class)
@SuppressWarnings("unused")
final class HostObjectGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(HostObject.class, new InteropLibraryExports());
    }

    private HostObjectGen() {
    }

    @GeneratedBy(HostObject.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, HostObject.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof HostObject;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof HostObject;
            return new Cached();
        }

        @GeneratedBy(HostObject.class)
        private static final class Cached extends InteropLibrary {

            @CompilationFinal private volatile long state_;
            @CompilationFinal private volatile int exclude_;
            @Child private IsArrayNode isArray;
            @Child private IsListNode isList;
            @Child private ToHostNode toHost;
            @CompilationFinal private BranchProfile error;
            @Child private ToGuestValueNode toGuest;
            @Child private LookupConstructorNode lookupConstructor;
            @Child private HostExecuteNode hostExecute;
            @Child private LookupFieldNode lookupField;
            @Child private ReadFieldNode readField;
            @Child private LookupMethodNode lookupMethod;
            @Child private LookupFunctionalMethodNode lookupFunctionalMethod;
            @Child private InteropLibrary numbers;
            @CompilationFinal private IsMemberReadableCachedData isMemberReadable_cached_cache;
            @CompilationFinal private IsMemberModifiableCachedData isMemberModifiable_cached_cache;
            @CompilationFinal private IsMemberInternalCachedData isMemberInternal_cached_cache;
            @CompilationFinal private IsMemberInvocableCachedData isMemberInvocable_cached_cache;
            @Child private ArraySet writeArrayElement_array_arraySet_;
            @Child private ArrayGet readArrayElement_array_arrayGet_;
            @Child private InteropLibrary instantiate_arrayCached_indexes_;
            @Child private LookupInnerClassNode readMemberNode__lookupInnerClass_;
            @Child private WriteFieldNode writeMemberNode__writeField_;
            @Child private InteropLibrary invokeMemberNode__fieldValues_;

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof HostObject) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof HostObject;
            }

            @ExplodeLoop
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0b11) != 0 /* is-active doCached(HostObject, String, boolean, Class<>, String, boolean) || doUncached(HostObject, String) */) {
                    if ((state & 0b1) != 0 /* is-active doCached(HostObject, String, boolean, Class<>, String, boolean) */ && (arg0Value.isStaticClass())) {
                        IsMemberReadableCachedData s1_ = this.isMemberReadable_cached_cache;
                        while (s1_ != null) {
                            if ((arg0Value.isStaticClass() == s1_.cachedStatic_) && (arg0Value.getLookupClass() == s1_.cachedClazz_) && (s1_.cachedName_.equals(arg1Value))) {
                                return IsMemberReadable.doCached(arg0Value, arg1Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedReadable_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active doUncached(HostObject, String) */) {
                        return IsMemberReadable.doUncached(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberReadableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableAndSpecialize(HostObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b1)) == 0 /* is-not-excluded doCached(HostObject, String, boolean, Class<>, String, boolean) */ && (arg0Value.isStaticClass())) {
                        int count1_ = 0;
                        IsMemberReadableCachedData s1_ = this.isMemberReadable_cached_cache;
                        if ((state & 0b1) != 0 /* is-active doCached(HostObject, String, boolean, Class<>, String, boolean) */) {
                            while (s1_ != null) {
                                if ((arg0Value.isStaticClass() == s1_.cachedStatic_) && (arg0Value.getLookupClass() == s1_.cachedClazz_) && (s1_.cachedName_.equals(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            {
                                boolean cachedStatic__ = (arg0Value.isStaticClass());
                                if ((arg0Value.isStaticClass() == cachedStatic__)) {
                                    Class<?> cachedClazz__ = (arg0Value.getLookupClass());
                                    if ((arg0Value.getLookupClass() == cachedClazz__)) {
                                        // assert (s1_.cachedName_.equals(arg1Value));
                                        if (count1_ < (HostObject.LIMIT)) {
                                            s1_ = new IsMemberReadableCachedData(isMemberReadable_cached_cache);
                                            s1_.cachedStatic_ = cachedStatic__;
                                            s1_.cachedClazz_ = cachedClazz__;
                                            s1_.cachedName_ = (arg1Value);
                                            s1_.cachedReadable_ = (IsMemberReadable.doUncached(arg0Value, arg1Value));
                                            this.isMemberReadable_cached_cache = s1_;
                                            this.state_ = state = state | 0b1 /* add-active doCached(HostObject, String, boolean, Class<>, String, boolean) */;
                                        }
                                    }
                                }
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return IsMemberReadable.doCached(arg0Value, arg1Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedReadable_);
                        }
                    }
                    this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(HostObject, String, boolean, Class<>, String, boolean) */;
                    this.isMemberReadable_cached_cache = null;
                    state = state & 0xfffffffffffffffeL /* remove-active doCached(HostObject, String, boolean, Class<>, String, boolean) */;
                    this.state_ = state = state | 0b10 /* add-active doUncached(HostObject, String) */;
                    lock.unlock();
                    hasLock = false;
                    return IsMemberReadable.doUncached(arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                long state = state_;
                if ((state & 0b11) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if (((state & 0b11) & ((state & 0b11) - 1)) == 0 /* is-single-active  */) {
                    IsMemberReadableCachedData s1_ = this.isMemberReadable_cached_cache;
                    if ((s1_ == null || s1_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @ExplodeLoop
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0b1100) != 0 /* is-active doCached(HostObject, String, boolean, Class<>, String, boolean) || doUncached(HostObject, String) */) {
                    if ((state & 0b100) != 0 /* is-active doCached(HostObject, String, boolean, Class<>, String, boolean) */ && (arg0Value.isStaticClass())) {
                        IsMemberModifiableCachedData s1_ = this.isMemberModifiable_cached_cache;
                        while (s1_ != null) {
                            if ((arg0Value.isStaticClass() == s1_.cachedStatic_) && (arg0Value.getLookupClass() == s1_.cachedClazz_) && (s1_.cachedName_.equals(arg1Value))) {
                                return IsMemberModifiable.doCached(arg0Value, arg1Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedModifiable_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b1000) != 0 /* is-active doUncached(HostObject, String) */) {
                        return IsMemberModifiable.doUncached(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberModifiableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberModifiableAndSpecialize(HostObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b10)) == 0 /* is-not-excluded doCached(HostObject, String, boolean, Class<>, String, boolean) */ && (arg0Value.isStaticClass())) {
                        int count1_ = 0;
                        IsMemberModifiableCachedData s1_ = this.isMemberModifiable_cached_cache;
                        if ((state & 0b100) != 0 /* is-active doCached(HostObject, String, boolean, Class<>, String, boolean) */) {
                            while (s1_ != null) {
                                if ((arg0Value.isStaticClass() == s1_.cachedStatic_) && (arg0Value.getLookupClass() == s1_.cachedClazz_) && (s1_.cachedName_.equals(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            {
                                boolean cachedStatic__ = (arg0Value.isStaticClass());
                                if ((arg0Value.isStaticClass() == cachedStatic__)) {
                                    Class<?> cachedClazz__ = (arg0Value.getLookupClass());
                                    if ((arg0Value.getLookupClass() == cachedClazz__)) {
                                        // assert (s1_.cachedName_.equals(arg1Value));
                                        if (count1_ < (HostObject.LIMIT)) {
                                            s1_ = new IsMemberModifiableCachedData(isMemberModifiable_cached_cache);
                                            s1_.cachedStatic_ = cachedStatic__;
                                            s1_.cachedClazz_ = cachedClazz__;
                                            s1_.cachedName_ = (arg1Value);
                                            s1_.cachedModifiable_ = (IsMemberModifiable.doUncached(arg0Value, arg1Value));
                                            this.isMemberModifiable_cached_cache = s1_;
                                            this.state_ = state = state | 0b100 /* add-active doCached(HostObject, String, boolean, Class<>, String, boolean) */;
                                        }
                                    }
                                }
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return IsMemberModifiable.doCached(arg0Value, arg1Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedModifiable_);
                        }
                    }
                    this.exclude_ = exclude = exclude | 0b10 /* add-excluded doCached(HostObject, String, boolean, Class<>, String, boolean) */;
                    this.isMemberModifiable_cached_cache = null;
                    state = state & 0xfffffffffffffffbL /* remove-active doCached(HostObject, String, boolean, Class<>, String, boolean) */;
                    this.state_ = state = state | 0b1000 /* add-active doUncached(HostObject, String) */;
                    lock.unlock();
                    hasLock = false;
                    return IsMemberModifiable.doUncached(arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @ExplodeLoop
            @Override
            public boolean isMemberInternal(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0b110000) != 0 /* is-active doCached(HostObject, String, boolean, Class<>, String, boolean) || doUncached(HostObject, String) */) {
                    if ((state & 0b10000) != 0 /* is-active doCached(HostObject, String, boolean, Class<>, String, boolean) */ && (arg0Value.isStaticClass())) {
                        IsMemberInternalCachedData s1_ = this.isMemberInternal_cached_cache;
                        while (s1_ != null) {
                            if ((arg0Value.isStaticClass() == s1_.cachedStatic_) && (arg0Value.getLookupClass() == s1_.cachedClazz_) && (s1_.cachedName_.equals(arg1Value))) {
                                return IsMemberInternal.doCached(arg0Value, arg1Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedInternal_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b100000) != 0 /* is-active doUncached(HostObject, String) */) {
                        return IsMemberInternal.doUncached(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInternalAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInternalAndSpecialize(HostObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b100)) == 0 /* is-not-excluded doCached(HostObject, String, boolean, Class<>, String, boolean) */ && (arg0Value.isStaticClass())) {
                        int count1_ = 0;
                        IsMemberInternalCachedData s1_ = this.isMemberInternal_cached_cache;
                        if ((state & 0b10000) != 0 /* is-active doCached(HostObject, String, boolean, Class<>, String, boolean) */) {
                            while (s1_ != null) {
                                if ((arg0Value.isStaticClass() == s1_.cachedStatic_) && (arg0Value.getLookupClass() == s1_.cachedClazz_) && (s1_.cachedName_.equals(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            {
                                boolean cachedStatic__ = (arg0Value.isStaticClass());
                                if ((arg0Value.isStaticClass() == cachedStatic__)) {
                                    Class<?> cachedClazz__ = (arg0Value.getLookupClass());
                                    if ((arg0Value.getLookupClass() == cachedClazz__)) {
                                        // assert (s1_.cachedName_.equals(arg1Value));
                                        if (count1_ < (HostObject.LIMIT)) {
                                            s1_ = new IsMemberInternalCachedData(isMemberInternal_cached_cache);
                                            s1_.cachedStatic_ = cachedStatic__;
                                            s1_.cachedClazz_ = cachedClazz__;
                                            s1_.cachedName_ = (arg1Value);
                                            s1_.cachedInternal_ = (IsMemberInternal.doUncached(arg0Value, arg1Value));
                                            this.isMemberInternal_cached_cache = s1_;
                                            this.state_ = state = state | 0b10000 /* add-active doCached(HostObject, String, boolean, Class<>, String, boolean) */;
                                        }
                                    }
                                }
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return IsMemberInternal.doCached(arg0Value, arg1Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedInternal_);
                        }
                    }
                    this.exclude_ = exclude = exclude | 0b100 /* add-excluded doCached(HostObject, String, boolean, Class<>, String, boolean) */;
                    this.isMemberInternal_cached_cache = null;
                    state = state & 0xffffffffffffffefL /* remove-active doCached(HostObject, String, boolean, Class<>, String, boolean) */;
                    this.state_ = state = state | 0b100000 /* add-active doUncached(HostObject, String) */;
                    lock.unlock();
                    hasLock = false;
                    return IsMemberInternal.doUncached(arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @ExplodeLoop
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0b11000000) != 0 /* is-active doCached(HostObject, String, boolean, Class<>, String, boolean) || doUncached(HostObject, String) */) {
                    if ((state & 0b1000000) != 0 /* is-active doCached(HostObject, String, boolean, Class<>, String, boolean) */ && (arg0Value.isStaticClass())) {
                        IsMemberInvocableCachedData s1_ = this.isMemberInvocable_cached_cache;
                        while (s1_ != null) {
                            if ((arg0Value.isStaticClass() == s1_.cachedStatic_) && (arg0Value.getLookupClass() == s1_.cachedClazz_) && (s1_.cachedName_.equals(arg1Value))) {
                                return IsMemberInvocable.doCached(arg0Value, arg1Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedInvokable_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0b10000000) != 0 /* is-active doUncached(HostObject, String) */) {
                        return IsMemberInvocable.doUncached(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInvocableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInvocableAndSpecialize(HostObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                int exclude = exclude_;
                try {
                    if (((exclude & 0b1000)) == 0 /* is-not-excluded doCached(HostObject, String, boolean, Class<>, String, boolean) */ && (arg0Value.isStaticClass())) {
                        int count1_ = 0;
                        IsMemberInvocableCachedData s1_ = this.isMemberInvocable_cached_cache;
                        if ((state & 0b1000000) != 0 /* is-active doCached(HostObject, String, boolean, Class<>, String, boolean) */) {
                            while (s1_ != null) {
                                if ((arg0Value.isStaticClass() == s1_.cachedStatic_) && (arg0Value.getLookupClass() == s1_.cachedClazz_) && (s1_.cachedName_.equals(arg1Value))) {
                                    break;
                                }
                                s1_ = s1_.next_;
                                count1_++;
                            }
                        }
                        if (s1_ == null) {
                            {
                                boolean cachedStatic__ = (arg0Value.isStaticClass());
                                if ((arg0Value.isStaticClass() == cachedStatic__)) {
                                    Class<?> cachedClazz__ = (arg0Value.getLookupClass());
                                    if ((arg0Value.getLookupClass() == cachedClazz__)) {
                                        // assert (s1_.cachedName_.equals(arg1Value));
                                        if (count1_ < (HostObject.LIMIT)) {
                                            s1_ = new IsMemberInvocableCachedData(isMemberInvocable_cached_cache);
                                            s1_.cachedStatic_ = cachedStatic__;
                                            s1_.cachedClazz_ = cachedClazz__;
                                            s1_.cachedName_ = (arg1Value);
                                            s1_.cachedInvokable_ = (IsMemberInvocable.doUncached(arg0Value, arg1Value));
                                            this.isMemberInvocable_cached_cache = s1_;
                                            this.state_ = state = state | 0b1000000 /* add-active doCached(HostObject, String, boolean, Class<>, String, boolean) */;
                                        }
                                    }
                                }
                            }
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return IsMemberInvocable.doCached(arg0Value, arg1Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedInvokable_);
                        }
                    }
                    this.exclude_ = exclude = exclude | 0b1000 /* add-excluded doCached(HostObject, String, boolean, Class<>, String, boolean) */;
                    this.isMemberInvocable_cached_cache = null;
                    state = state & 0xffffffffffffffbfL /* remove-active doCached(HostObject, String, boolean, Class<>, String, boolean) */;
                    this.state_ = state = state | 0b10000000 /* add-active doUncached(HostObject, String) */;
                    lock.unlock();
                    hasLock = false;
                    return IsMemberInvocable.doUncached(arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0b11100000000) != 0 /* is-active doArray(HostObject, long, IsArrayNode) || doList(HostObject, long, IsListNode) || doNotArrayOrList(HostObject, long, IsListNode, IsArrayNode) */) {
                    if ((state & 0b100000000) != 0 /* is-active doArray(HostObject, long, IsArrayNode) */) {
                        if ((this.isArray.execute(arg0Value))) {
                            return IsArrayElementExisting.doArray(arg0Value, arg1Value, this.isArray);
                        }
                    }
                    if ((state & 0b1000000000) != 0 /* is-active doList(HostObject, long, IsListNode) */) {
                        if ((this.isList.execute(arg0Value))) {
                            return IsArrayElementExisting.doList(arg0Value, arg1Value, this.isList);
                        }
                    }
                    if ((state & 0b10000000000) != 0 /* is-active doNotArrayOrList(HostObject, long, IsListNode, IsArrayNode) */) {
                        if ((!(this.isList.execute(arg0Value))) && (!(this.isArray.execute(arg0Value)))) {
                            return IsArrayElementExisting.doNotArrayOrList(arg0Value, arg1Value, this.isList, this.isArray);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementExistingAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementExistingAndSpecialize(HostObject arg0Value, long arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    boolean Array_duplicateFound_ = false;
                    if ((state & 0b100000000) != 0 /* is-active doArray(HostObject, long, IsArrayNode) */) {
                        if ((this.isArray.execute(arg0Value))) {
                            Array_duplicateFound_ = true;
                        }
                    }
                    if (!Array_duplicateFound_) {
                        {
                            IsArrayNode isArrayElementExisting_array_isArray__ = super.insert((IsArrayNodeGen.create()));
                            if ((isArrayElementExisting_array_isArray__.execute(arg0Value)) && ((state & 0b100000000)) == 0 /* is-not-active doArray(HostObject, long, IsArrayNode) */) {
                                if (this.isArray == null) {
                                    this.isArray = super.insert(isArrayElementExisting_array_isArray__);
                                }
                                this.state_ = state = state | 0b100000000 /* add-active doArray(HostObject, long, IsArrayNode) */;
                                Array_duplicateFound_ = true;
                            }
                        }
                    }
                    if (Array_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return IsArrayElementExisting.doArray(arg0Value, arg1Value, this.isArray);
                    }
                    boolean List_duplicateFound_ = false;
                    if ((state & 0b1000000000) != 0 /* is-active doList(HostObject, long, IsListNode) */) {
                        if ((this.isList.execute(arg0Value))) {
                            List_duplicateFound_ = true;
                        }
                    }
                    if (!List_duplicateFound_) {
                        {
                            IsListNode isArrayElementExisting_list_isList__ = super.insert((IsListNodeGen.create()));
                            if ((isArrayElementExisting_list_isList__.execute(arg0Value)) && ((state & 0b1000000000)) == 0 /* is-not-active doList(HostObject, long, IsListNode) */) {
                                if (this.isList == null) {
                                    this.isList = super.insert(isArrayElementExisting_list_isList__);
                                }
                                this.state_ = state = state | 0b1000000000 /* add-active doList(HostObject, long, IsListNode) */;
                                List_duplicateFound_ = true;
                            }
                        }
                    }
                    if (List_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return IsArrayElementExisting.doList(arg0Value, arg1Value, this.isList);
                    }
                    boolean NotArrayOrList_duplicateFound_ = false;
                    if ((state & 0b10000000000) != 0 /* is-active doNotArrayOrList(HostObject, long, IsListNode, IsArrayNode) */) {
                        if ((!(this.isList.execute(arg0Value))) && (!(this.isArray.execute(arg0Value)))) {
                            NotArrayOrList_duplicateFound_ = true;
                        }
                    }
                    if (!NotArrayOrList_duplicateFound_) {
                        {
                            IsListNode isArrayElementExisting_notArrayOrList_isList__ = super.insert((IsListNodeGen.create()));
                            if ((!(isArrayElementExisting_notArrayOrList_isList__.execute(arg0Value)))) {
                                IsArrayNode isArrayElementExisting_notArrayOrList_isArray__ = super.insert((IsArrayNodeGen.create()));
                                if ((!(isArrayElementExisting_notArrayOrList_isArray__.execute(arg0Value))) && ((state & 0b10000000000)) == 0 /* is-not-active doNotArrayOrList(HostObject, long, IsListNode, IsArrayNode) */) {
                                    if (this.isList == null) {
                                        this.isList = super.insert(isArrayElementExisting_notArrayOrList_isList__);
                                    }
                                    if (this.isArray == null) {
                                        this.isArray = super.insert(isArrayElementExisting_notArrayOrList_isArray__);
                                    }
                                    this.state_ = state = state | 0b10000000000 /* add-active doNotArrayOrList(HostObject, long, IsListNode, IsArrayNode) */;
                                    NotArrayOrList_duplicateFound_ = true;
                                }
                            }
                        }
                    }
                    if (NotArrayOrList_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return IsArrayElementExisting.doNotArrayOrList(arg0Value, arg1Value, this.isList, this.isArray);
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0b11100000000) != 0 /* is-active doArray(HostObject, long, IsArrayNode) || doList(HostObject, long, IsListNode) || doNotArrayOrList(HostObject, long, IsListNode, IsArrayNode) */) {
                    if ((state & 0b100000000) != 0 /* is-active doArray(HostObject, long, IsArrayNode) */) {
                        if ((this.isArray.execute(arg0Value))) {
                            return IsArrayElementExisting.doArray(arg0Value, arg1Value, this.isArray);
                        }
                    }
                    if ((state & 0b1000000000) != 0 /* is-active doList(HostObject, long, IsListNode) */) {
                        if ((this.isList.execute(arg0Value))) {
                            return IsArrayElementExisting.doList(arg0Value, arg1Value, this.isList);
                        }
                    }
                    if ((state & 0b10000000000) != 0 /* is-active doNotArrayOrList(HostObject, long, IsListNode, IsArrayNode) */) {
                        if ((!(this.isList.execute(arg0Value))) && (!(this.isArray.execute(arg0Value)))) {
                            return IsArrayElementExisting.doNotArrayOrList(arg0Value, arg1Value, this.isList, this.isArray);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementExistingAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0b11100000000000) != 0 /* is-active doArray(HostObject, long, Object, ToHostNode, IsArrayNode, ArraySet, BranchProfile) || doList(HostObject, long, Object, IsListNode, ToHostNode, BranchProfile) || doNotArrayOrList(HostObject, long, Object, IsListNode, IsArrayNode) */) {
                    if ((state & 0b100000000000) != 0 /* is-active doArray(HostObject, long, Object, ToHostNode, IsArrayNode, ArraySet, BranchProfile) */) {
                        if ((this.isArray.execute(arg0Value))) {
                            WriteArrayElement.doArray(arg0Value, arg1Value, arg2Value, this.toHost, this.isArray, this.writeArrayElement_array_arraySet_, this.error);
                            return;
                        }
                    }
                    if ((state & 0b1000000000000) != 0 /* is-active doList(HostObject, long, Object, IsListNode, ToHostNode, BranchProfile) */) {
                        if ((this.isList.execute(arg0Value))) {
                            WriteArrayElement.doList(arg0Value, arg1Value, arg2Value, this.isList, this.toHost, this.error);
                            return;
                        }
                    }
                    if ((state & 0b10000000000000) != 0 /* is-active doNotArrayOrList(HostObject, long, Object, IsListNode, IsArrayNode) */) {
                        if ((!(this.isList.execute(arg0Value))) && (!(this.isArray.execute(arg0Value)))) {
                            WriteArrayElement.doNotArrayOrList(arg0Value, arg1Value, arg2Value, this.isList, this.isArray);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeArrayElementAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeArrayElementAndSpecialize(HostObject arg0Value, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedTypeException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    boolean Array_duplicateFound_ = false;
                    if ((state & 0b100000000000) != 0 /* is-active doArray(HostObject, long, Object, ToHostNode, IsArrayNode, ArraySet, BranchProfile) */) {
                        if ((this.isArray.execute(arg0Value))) {
                            Array_duplicateFound_ = true;
                        }
                    }
                    if (!Array_duplicateFound_) {
                        {
                            IsArrayNode writeArrayElement_array_isArray__ = super.insert((IsArrayNodeGen.create()));
                            if ((writeArrayElement_array_isArray__.execute(arg0Value)) && ((state & 0b100000000000)) == 0 /* is-not-active doArray(HostObject, long, Object, ToHostNode, IsArrayNode, ArraySet, BranchProfile) */) {
                                if (this.toHost == null) {
                                    this.toHost = super.insert((ToHostNodeGen.create()));
                                }
                                if (this.isArray == null) {
                                    this.isArray = super.insert(writeArrayElement_array_isArray__);
                                }
                                this.writeArrayElement_array_arraySet_ = super.insert((ArraySetNodeGen.create()));
                                if (this.error == null) {
                                    this.error = (BranchProfile.create());
                                }
                                this.state_ = state = state | 0b100000000000 /* add-active doArray(HostObject, long, Object, ToHostNode, IsArrayNode, ArraySet, BranchProfile) */;
                                Array_duplicateFound_ = true;
                            }
                        }
                    }
                    if (Array_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        WriteArrayElement.doArray(arg0Value, arg1Value, arg2Value, this.toHost, this.isArray, this.writeArrayElement_array_arraySet_, this.error);
                        return;
                    }
                    boolean List_duplicateFound_ = false;
                    if ((state & 0b1000000000000) != 0 /* is-active doList(HostObject, long, Object, IsListNode, ToHostNode, BranchProfile) */) {
                        if ((this.isList.execute(arg0Value))) {
                            List_duplicateFound_ = true;
                        }
                    }
                    if (!List_duplicateFound_) {
                        {
                            IsListNode writeArrayElement_list_isList__ = super.insert((IsListNodeGen.create()));
                            if ((writeArrayElement_list_isList__.execute(arg0Value)) && ((state & 0b1000000000000)) == 0 /* is-not-active doList(HostObject, long, Object, IsListNode, ToHostNode, BranchProfile) */) {
                                if (this.isList == null) {
                                    this.isList = super.insert(writeArrayElement_list_isList__);
                                }
                                if (this.toHost == null) {
                                    this.toHost = super.insert((ToHostNodeGen.create()));
                                }
                                if (this.error == null) {
                                    this.error = (BranchProfile.create());
                                }
                                this.state_ = state = state | 0b1000000000000 /* add-active doList(HostObject, long, Object, IsListNode, ToHostNode, BranchProfile) */;
                                List_duplicateFound_ = true;
                            }
                        }
                    }
                    if (List_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        WriteArrayElement.doList(arg0Value, arg1Value, arg2Value, this.isList, this.toHost, this.error);
                        return;
                    }
                    boolean NotArrayOrList_duplicateFound_ = false;
                    if ((state & 0b10000000000000) != 0 /* is-active doNotArrayOrList(HostObject, long, Object, IsListNode, IsArrayNode) */) {
                        if ((!(this.isList.execute(arg0Value))) && (!(this.isArray.execute(arg0Value)))) {
                            NotArrayOrList_duplicateFound_ = true;
                        }
                    }
                    if (!NotArrayOrList_duplicateFound_) {
                        {
                            IsListNode writeArrayElement_notArrayOrList_isList__ = super.insert((IsListNodeGen.create()));
                            if ((!(writeArrayElement_notArrayOrList_isList__.execute(arg0Value)))) {
                                IsArrayNode writeArrayElement_notArrayOrList_isArray__ = super.insert((IsArrayNodeGen.create()));
                                if ((!(writeArrayElement_notArrayOrList_isArray__.execute(arg0Value))) && ((state & 0b10000000000000)) == 0 /* is-not-active doNotArrayOrList(HostObject, long, Object, IsListNode, IsArrayNode) */) {
                                    if (this.isList == null) {
                                        this.isList = super.insert(writeArrayElement_notArrayOrList_isList__);
                                    }
                                    if (this.isArray == null) {
                                        this.isArray = super.insert(writeArrayElement_notArrayOrList_isArray__);
                                    }
                                    this.state_ = state = state | 0b10000000000000 /* add-active doNotArrayOrList(HostObject, long, Object, IsListNode, IsArrayNode) */;
                                    NotArrayOrList_duplicateFound_ = true;
                                }
                            }
                        }
                    }
                    if (NotArrayOrList_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        WriteArrayElement.doNotArrayOrList(arg0Value, arg1Value, arg2Value, this.isList, this.isArray);
                        return;
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0b1100000000000000) != 0 /* is-active doList(HostObject, long, IsListNode) || doOther(HostObject, long, IsListNode) */) {
                    if ((state & 0b100000000000000) != 0 /* is-active doList(HostObject, long, IsListNode) */) {
                        if ((this.isList.execute(arg0Value))) {
                            return IsArrayElementRemovable.doList(arg0Value, arg1Value, this.isList);
                        }
                    }
                    if ((state & 0b1000000000000000) != 0 /* is-active doOther(HostObject, long, IsListNode) */) {
                        if ((!(this.isList.execute(arg0Value)))) {
                            return IsArrayElementRemovable.doOther(arg0Value, arg1Value, this.isList);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementRemovableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementRemovableAndSpecialize(HostObject arg0Value, long arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    boolean List_duplicateFound_ = false;
                    if ((state & 0b100000000000000) != 0 /* is-active doList(HostObject, long, IsListNode) */) {
                        if ((this.isList.execute(arg0Value))) {
                            List_duplicateFound_ = true;
                        }
                    }
                    if (!List_duplicateFound_) {
                        {
                            IsListNode isArrayElementRemovable_list_isList__ = super.insert((IsListNodeGen.create()));
                            if ((isArrayElementRemovable_list_isList__.execute(arg0Value)) && ((state & 0b100000000000000)) == 0 /* is-not-active doList(HostObject, long, IsListNode) */) {
                                if (this.isList == null) {
                                    this.isList = super.insert(isArrayElementRemovable_list_isList__);
                                }
                                this.state_ = state = state | 0b100000000000000 /* add-active doList(HostObject, long, IsListNode) */;
                                List_duplicateFound_ = true;
                            }
                        }
                    }
                    if (List_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return IsArrayElementRemovable.doList(arg0Value, arg1Value, this.isList);
                    }
                    boolean Other_duplicateFound_ = false;
                    if ((state & 0b1000000000000000) != 0 /* is-active doOther(HostObject, long, IsListNode) */) {
                        if ((!(this.isList.execute(arg0Value)))) {
                            Other_duplicateFound_ = true;
                        }
                    }
                    if (!Other_duplicateFound_) {
                        {
                            IsListNode isArrayElementRemovable_other_isList__ = super.insert((IsListNodeGen.create()));
                            if ((!(isArrayElementRemovable_other_isList__.execute(arg0Value))) && ((state & 0b1000000000000000)) == 0 /* is-not-active doOther(HostObject, long, IsListNode) */) {
                                if (this.isList == null) {
                                    this.isList = super.insert(isArrayElementRemovable_other_isList__);
                                }
                                this.state_ = state = state | 0b1000000000000000 /* add-active doOther(HostObject, long, IsListNode) */;
                                Other_duplicateFound_ = true;
                            }
                        }
                    }
                    if (Other_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return IsArrayElementRemovable.doOther(arg0Value, arg1Value, this.isList);
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x30000L) != 0 /* is-active doList(HostObject, long, IsListNode, BranchProfile) || doOther(HostObject, long, IsListNode) */) {
                    if ((state & 0x10000L) != 0 /* is-active doList(HostObject, long, IsListNode, BranchProfile) */) {
                        if ((this.isList.execute(arg0Value))) {
                            RemoveArrayElement.doList(arg0Value, arg1Value, this.isList, this.error);
                            return;
                        }
                    }
                    if ((state & 0x20000L) != 0 /* is-active doOther(HostObject, long, IsListNode) */) {
                        if ((!(this.isList.execute(arg0Value)))) {
                            RemoveArrayElement.doOther(arg0Value, arg1Value, this.isList);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                removeArrayElementAndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void removeArrayElementAndSpecialize(HostObject arg0Value, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    boolean List_duplicateFound_ = false;
                    if ((state & 0x10000L) != 0 /* is-active doList(HostObject, long, IsListNode, BranchProfile) */) {
                        if ((this.isList.execute(arg0Value))) {
                            List_duplicateFound_ = true;
                        }
                    }
                    if (!List_duplicateFound_) {
                        {
                            IsListNode removeArrayElement_list_isList__ = super.insert((IsListNodeGen.create()));
                            if ((removeArrayElement_list_isList__.execute(arg0Value)) && ((state & 0x10000L)) == 0 /* is-not-active doList(HostObject, long, IsListNode, BranchProfile) */) {
                                if (this.isList == null) {
                                    this.isList = super.insert(removeArrayElement_list_isList__);
                                }
                                if (this.error == null) {
                                    this.error = (BranchProfile.create());
                                }
                                this.state_ = state = state | 0x10000L /* add-active doList(HostObject, long, IsListNode, BranchProfile) */;
                                List_duplicateFound_ = true;
                            }
                        }
                    }
                    if (List_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        RemoveArrayElement.doList(arg0Value, arg1Value, this.isList, this.error);
                        return;
                    }
                    boolean Other_duplicateFound_ = false;
                    if ((state & 0x20000L) != 0 /* is-active doOther(HostObject, long, IsListNode) */) {
                        if ((!(this.isList.execute(arg0Value)))) {
                            Other_duplicateFound_ = true;
                        }
                    }
                    if (!Other_duplicateFound_) {
                        {
                            IsListNode removeArrayElement_other_isList__ = super.insert((IsListNodeGen.create()));
                            if ((!(removeArrayElement_other_isList__.execute(arg0Value))) && ((state & 0x20000L)) == 0 /* is-not-active doOther(HostObject, long, IsListNode) */) {
                                if (this.isList == null) {
                                    this.isList = super.insert(removeArrayElement_other_isList__);
                                }
                                this.state_ = state = state | 0x20000L /* add-active doOther(HostObject, long, IsListNode) */;
                                Other_duplicateFound_ = true;
                            }
                        }
                    }
                    if (Other_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        RemoveArrayElement.doOther(arg0Value, arg1Value, this.isList);
                        return;
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x1c0000L) != 0 /* is-active doArray(HostObject, long, ArrayGet, IsArrayNode, ToGuestValueNode, BranchProfile) || doList(HostObject, long, IsListNode, ToGuestValueNode, BranchProfile) || doNotArrayOrList(HostObject, long, IsArrayNode, IsListNode) */) {
                    if ((state & 0x40000L) != 0 /* is-active doArray(HostObject, long, ArrayGet, IsArrayNode, ToGuestValueNode, BranchProfile) */) {
                        if ((this.isArray.execute(arg0Value))) {
                            return ReadArrayElement.doArray(arg0Value, arg1Value, this.readArrayElement_array_arrayGet_, this.isArray, this.toGuest, this.error);
                        }
                    }
                    if ((state & 0x80000L) != 0 /* is-active doList(HostObject, long, IsListNode, ToGuestValueNode, BranchProfile) */) {
                        if ((this.isList.execute(arg0Value))) {
                            return ReadArrayElement.doList(arg0Value, arg1Value, this.isList, this.toGuest, this.error);
                        }
                    }
                    if ((state & 0x100000L) != 0 /* is-active doNotArrayOrList(HostObject, long, IsArrayNode, IsListNode) */) {
                        if ((!(this.isArray.execute(arg0Value))) && (!(this.isList.execute(arg0Value)))) {
                            return ReadArrayElement.doNotArrayOrList(arg0Value, arg1Value, this.isArray, this.isList);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readArrayElementAndSpecialize(arg0Value, arg1Value);
            }

            private Object readArrayElementAndSpecialize(HostObject arg0Value, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    boolean Array_duplicateFound_ = false;
                    if ((state & 0x40000L) != 0 /* is-active doArray(HostObject, long, ArrayGet, IsArrayNode, ToGuestValueNode, BranchProfile) */) {
                        if ((this.isArray.execute(arg0Value))) {
                            Array_duplicateFound_ = true;
                        }
                    }
                    if (!Array_duplicateFound_) {
                        {
                            IsArrayNode readArrayElement_array_isArray__ = super.insert((IsArrayNodeGen.create()));
                            if ((readArrayElement_array_isArray__.execute(arg0Value)) && ((state & 0x40000L)) == 0 /* is-not-active doArray(HostObject, long, ArrayGet, IsArrayNode, ToGuestValueNode, BranchProfile) */) {
                                this.readArrayElement_array_arrayGet_ = super.insert((ArrayGetNodeGen.create()));
                                if (this.isArray == null) {
                                    this.isArray = super.insert(readArrayElement_array_isArray__);
                                }
                                if (this.toGuest == null) {
                                    this.toGuest = super.insert((ToGuestValueNodeGen.create()));
                                }
                                if (this.error == null) {
                                    this.error = (BranchProfile.create());
                                }
                                this.state_ = state = state | 0x40000L /* add-active doArray(HostObject, long, ArrayGet, IsArrayNode, ToGuestValueNode, BranchProfile) */;
                                Array_duplicateFound_ = true;
                            }
                        }
                    }
                    if (Array_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return ReadArrayElement.doArray(arg0Value, arg1Value, this.readArrayElement_array_arrayGet_, this.isArray, this.toGuest, this.error);
                    }
                    boolean List_duplicateFound_ = false;
                    if ((state & 0x80000L) != 0 /* is-active doList(HostObject, long, IsListNode, ToGuestValueNode, BranchProfile) */) {
                        if ((this.isList.execute(arg0Value))) {
                            List_duplicateFound_ = true;
                        }
                    }
                    if (!List_duplicateFound_) {
                        {
                            IsListNode readArrayElement_list_isList__ = super.insert((IsListNodeGen.create()));
                            if ((readArrayElement_list_isList__.execute(arg0Value)) && ((state & 0x80000L)) == 0 /* is-not-active doList(HostObject, long, IsListNode, ToGuestValueNode, BranchProfile) */) {
                                if (this.isList == null) {
                                    this.isList = super.insert(readArrayElement_list_isList__);
                                }
                                if (this.toGuest == null) {
                                    this.toGuest = super.insert((ToGuestValueNodeGen.create()));
                                }
                                if (this.error == null) {
                                    this.error = (BranchProfile.create());
                                }
                                this.state_ = state = state | 0x80000L /* add-active doList(HostObject, long, IsListNode, ToGuestValueNode, BranchProfile) */;
                                List_duplicateFound_ = true;
                            }
                        }
                    }
                    if (List_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return ReadArrayElement.doList(arg0Value, arg1Value, this.isList, this.toGuest, this.error);
                    }
                    boolean NotArrayOrList_duplicateFound_ = false;
                    if ((state & 0x100000L) != 0 /* is-active doNotArrayOrList(HostObject, long, IsArrayNode, IsListNode) */) {
                        if ((!(this.isArray.execute(arg0Value))) && (!(this.isList.execute(arg0Value)))) {
                            NotArrayOrList_duplicateFound_ = true;
                        }
                    }
                    if (!NotArrayOrList_duplicateFound_) {
                        {
                            IsArrayNode readArrayElement_notArrayOrList_isArray__ = super.insert((IsArrayNodeGen.create()));
                            if ((!(readArrayElement_notArrayOrList_isArray__.execute(arg0Value)))) {
                                IsListNode readArrayElement_notArrayOrList_isList__ = super.insert((IsListNodeGen.create()));
                                if ((!(readArrayElement_notArrayOrList_isList__.execute(arg0Value))) && ((state & 0x100000L)) == 0 /* is-not-active doNotArrayOrList(HostObject, long, IsArrayNode, IsListNode) */) {
                                    if (this.isArray == null) {
                                        this.isArray = super.insert(readArrayElement_notArrayOrList_isArray__);
                                    }
                                    if (this.isList == null) {
                                        this.isList = super.insert(readArrayElement_notArrayOrList_isList__);
                                    }
                                    this.state_ = state = state | 0x100000L /* add-active doNotArrayOrList(HostObject, long, IsArrayNode, IsListNode) */;
                                    NotArrayOrList_duplicateFound_ = true;
                                }
                            }
                        }
                    }
                    if (NotArrayOrList_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        return ReadArrayElement.doNotArrayOrList(arg0Value, arg1Value, this.isArray, this.isList);
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isInstantiable(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0xe00000L) != 0 /* is-active doUnsupported(HostObject) || doArrayCached(HostObject) || doObjectCached(HostObject, LookupConstructorNode) */) {
                    if ((state & 0x200000L) != 0 /* is-active doUnsupported(HostObject) */) {
                        if ((!(arg0Value.isClass()))) {
                            return IsInstantiable.doUnsupported(arg0Value);
                        }
                    }
                    if ((state & 0x400000L) != 0 /* is-active doArrayCached(HostObject) */) {
                        if ((arg0Value.isArrayClass())) {
                            return IsInstantiable.doArrayCached(arg0Value);
                        }
                    }
                    if ((state & 0x800000L) != 0 /* is-active doObjectCached(HostObject, LookupConstructorNode) */) {
                        if ((arg0Value.isDefaultClass())) {
                            return IsInstantiable.doObjectCached(arg0Value, this.lookupConstructor);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isInstantiableAndSpecialize(arg0Value);
            }

            private boolean isInstantiableAndSpecialize(HostObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if ((!(arg0Value.isClass()))) {
                        this.state_ = state = state | 0x200000L /* add-active doUnsupported(HostObject) */;
                        lock.unlock();
                        hasLock = false;
                        return IsInstantiable.doUnsupported(arg0Value);
                    }
                    if ((arg0Value.isArrayClass())) {
                        this.state_ = state = state | 0x400000L /* add-active doArrayCached(HostObject) */;
                        lock.unlock();
                        hasLock = false;
                        return IsInstantiable.doArrayCached(arg0Value);
                    }
                    if ((arg0Value.isDefaultClass())) {
                        if (this.lookupConstructor == null) {
                            this.lookupConstructor = super.insert((LookupConstructorNodeGen.create()));
                        }
                        this.state_ = state = state | 0x800000L /* add-active doObjectCached(HostObject, LookupConstructorNode) */;
                        lock.unlock();
                        hasLock = false;
                        return IsInstantiable.doObjectCached(arg0Value, this.lookupConstructor);
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x7000000L) != 0 /* is-active doUnsupported(HostObject, Object[]) || doArrayCached(HostObject, Object[], InteropLibrary, BranchProfile) || doObjectCached(HostObject, Object[], LookupConstructorNode, HostExecuteNode, BranchProfile) */) {
                    if ((state & 0x1000000L) != 0 /* is-active doUnsupported(HostObject, Object[]) */) {
                        if ((!(arg0Value.isClass()))) {
                            return Instantiate.doUnsupported(arg0Value, arg1Value);
                        }
                    }
                    if ((state & 0x2000000L) != 0 /* is-active doArrayCached(HostObject, Object[], InteropLibrary, BranchProfile) */) {
                        if ((arg0Value.isArrayClass())) {
                            return Instantiate.doArrayCached(arg0Value, arg1Value, this.instantiate_arrayCached_indexes_, this.error);
                        }
                    }
                    if ((state & 0x4000000L) != 0 /* is-active doObjectCached(HostObject, Object[], LookupConstructorNode, HostExecuteNode, BranchProfile) */) {
                        if ((arg0Value.isDefaultClass())) {
                            return Instantiate.doObjectCached(arg0Value, arg1Value, this.lookupConstructor, this.hostExecute, this.error);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return instantiateAndSpecialize(arg0Value, arg1Value);
            }

            private Object instantiateAndSpecialize(HostObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if ((!(arg0Value.isClass()))) {
                        this.state_ = state = state | 0x1000000L /* add-active doUnsupported(HostObject, Object[]) */;
                        lock.unlock();
                        hasLock = false;
                        return Instantiate.doUnsupported(arg0Value, arg1Value);
                    }
                    if ((arg0Value.isArrayClass())) {
                        this.instantiate_arrayCached_indexes_ = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                        if (this.error == null) {
                            this.error = (BranchProfile.create());
                        }
                        this.state_ = state = state | 0x2000000L /* add-active doArrayCached(HostObject, Object[], InteropLibrary, BranchProfile) */;
                        lock.unlock();
                        hasLock = false;
                        return Instantiate.doArrayCached(arg0Value, arg1Value, this.instantiate_arrayCached_indexes_, this.error);
                    }
                    if ((arg0Value.isDefaultClass())) {
                        if (this.lookupConstructor == null) {
                            this.lookupConstructor = super.insert((LookupConstructorNodeGen.create()));
                        }
                        if (this.hostExecute == null) {
                            this.hostExecute = super.insert((HostExecuteNode.create()));
                        }
                        if (this.error == null) {
                            this.error = (BranchProfile.create());
                        }
                        this.state_ = state = state | 0x4000000L /* add-active doObjectCached(HostObject, Object[], LookupConstructorNode, HostExecuteNode, BranchProfile) */;
                        lock.unlock();
                        hasLock = false;
                        return Instantiate.doObjectCached(arg0Value, arg1Value, this.lookupConstructor, this.hostExecute, this.error);
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x18000000L) != 0 /* is-active doHostObject(HostObject, HostObject) || doOther(HostObject, Object) */) {
                    if ((state & 0x8000000L) != 0 /* is-active doHostObject(HostObject, HostObject) */ && arg1Value instanceof HostObject) {
                        HostObject arg1Value_ = (HostObject) arg1Value;
                        return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                    }
                    if ((state & 0x10000000L) != 0 /* is-active doOther(HostObject, Object) */) {
                        if (isIdenticalOrUndefinedFallbackGuard_(state, arg0Value, arg1Value)) {
                            return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isIdenticalOrUndefinedAndSpecialize(arg0Value, arg1Value);
            }

            private TriState isIdenticalOrUndefinedAndSpecialize(HostObject arg0Value, Object arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (arg1Value instanceof HostObject) {
                        HostObject arg1Value_ = (HostObject) arg1Value;
                        this.state_ = state = state | 0x8000000L /* add-active doHostObject(HostObject, HostObject) */;
                        lock.unlock();
                        hasLock = false;
                        return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                    }
                    this.state_ = state = state | 0x10000000L /* add-active doOther(HostObject, Object) */;
                    lock.unlock();
                    hasLock = false;
                    return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).getMembers(includeInternal);
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x20000000L) != 0 /* is-active readMember(HostObject, String, LookupFieldNode, ReadFieldNode, LookupMethodNode, LookupInnerClassNode, BranchProfile) */) {
                    return arg0Value.readMember(arg1Value, this.lookupField, this.readField, this.lookupMethod, this.readMemberNode__lookupInnerClass_, this.error);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(HostObject arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.lookupField == null) {
                        this.lookupField = super.insert((LookupFieldNodeGen.create()));
                    }
                    if (this.readField == null) {
                        this.readField = super.insert((ReadFieldNodeGen.create()));
                    }
                    if (this.lookupMethod == null) {
                        this.lookupMethod = super.insert((LookupMethodNodeGen.create()));
                    }
                    this.readMemberNode__lookupInnerClass_ = super.insert((LookupInnerClassNodeGen.create()));
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x20000000L /* add-active readMember(HostObject, String, LookupFieldNode, ReadFieldNode, LookupMethodNode, LookupInnerClassNode, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.readMember(arg1Value, this.lookupField, this.readField, this.lookupMethod, this.readMemberNode__lookupInnerClass_, this.error);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInsertable(Object receiver, String member) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isMemberInsertable(member);
            }

            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x40000000L) != 0 /* is-active writeMember(HostObject, String, Object, LookupFieldNode, WriteFieldNode, BranchProfile) */) {
                    arg0Value.writeMember(arg1Value, arg2Value, this.lookupField, this.writeMemberNode__writeField_, this.error);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeMemberNode_AndSpecialize(HostObject arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.lookupField == null) {
                        this.lookupField = super.insert((LookupFieldNodeGen.create()));
                    }
                    this.writeMemberNode__writeField_ = super.insert((WriteFieldNodeGen.create()));
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x40000000L /* add-active writeMember(HostObject, String, Object, LookupFieldNode, WriteFieldNode, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    arg0Value.writeMember(arg1Value, arg2Value, this.lookupField, this.writeMemberNode__writeField_, this.error);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x80000000L) != 0 /* is-active invokeMember(HostObject, String, Object[], LookupMethodNode, HostExecuteNode, LookupFieldNode, ReadFieldNode, InteropLibrary, BranchProfile) */) {
                    return arg0Value.invokeMember(arg1Value, arg2Value, this.lookupMethod, this.hostExecute, this.lookupField, this.readField, this.invokeMemberNode__fieldValues_, this.error);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(HostObject arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.lookupMethod == null) {
                        this.lookupMethod = super.insert((LookupMethodNodeGen.create()));
                    }
                    if (this.hostExecute == null) {
                        this.hostExecute = super.insert((HostExecuteNode.create()));
                    }
                    if (this.lookupField == null) {
                        this.lookupField = super.insert((LookupFieldNodeGen.create()));
                    }
                    if (this.readField == null) {
                        this.readField = super.insert((ReadFieldNodeGen.create()));
                    }
                    this.invokeMemberNode__fieldValues_ = super.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x80000000L /* add-active invokeMember(HostObject, String, Object[], LookupMethodNode, HostExecuteNode, LookupFieldNode, ReadFieldNode, InteropLibrary, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.invokeMember(arg1Value, arg2Value, this.lookupMethod, this.hostExecute, this.lookupField, this.readField, this.invokeMemberNode__fieldValues_, this.error);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x100000000L) != 0 /* is-active isArrayElementInsertable(HostObject, long, IsListNode) */) {
                    return arg0Value.isArrayElementInsertable(arg1Value, this.isList);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementInsertableNode_AndSpecialize(HostObject arg0Value, long arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.isList == null) {
                        this.isList = super.insert((IsListNodeGen.create()));
                    }
                    this.state_ = state = state | 0x100000000L /* add-active isArrayElementInsertable(HostObject, long, IsListNode) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.isArrayElementInsertable(arg1Value, this.isList);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasArrayElements(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x200000000L) != 0 /* is-active hasArrayElements(HostObject, IsListNode, IsArrayNode) */) {
                    return arg0Value.hasArrayElements(this.isList, this.isArray);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasArrayElementsNode_AndSpecialize(arg0Value);
            }

            private boolean hasArrayElementsNode_AndSpecialize(HostObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.isList == null) {
                        this.isList = super.insert((IsListNodeGen.create()));
                    }
                    if (this.isArray == null) {
                        this.isArray = super.insert((IsArrayNodeGen.create()));
                    }
                    this.state_ = state = state | 0x200000000L /* add-active hasArrayElements(HostObject, IsListNode, IsArrayNode) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.hasArrayElements(this.isList, this.isArray);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x400000000L) != 0 /* is-active getArraySize(HostObject, IsArrayNode, IsListNode, BranchProfile) */) {
                    return arg0Value.getArraySize(this.isArray, this.isList, this.error);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getArraySizeNode_AndSpecialize(arg0Value);
            }

            private long getArraySizeNode_AndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.isArray == null) {
                        this.isArray = super.insert((IsArrayNodeGen.create()));
                    }
                    if (this.isList == null) {
                        this.isList = super.insert((IsListNodeGen.create()));
                    }
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x400000000L /* add-active getArraySize(HostObject, IsArrayNode, IsListNode, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.getArraySize(this.isArray, this.isList, this.error);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isNull(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isNull();
            }

            @Override
            public boolean isExecutable(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x800000000L) != 0 /* is-active isExecutable(HostObject, LookupFunctionalMethodNode) */) {
                    return arg0Value.isExecutable(this.lookupFunctionalMethod);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isExecutableNode_AndSpecialize(arg0Value);
            }

            private boolean isExecutableNode_AndSpecialize(HostObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.lookupFunctionalMethod == null) {
                        this.lookupFunctionalMethod = super.insert((LookupFunctionalMethodNodeGen.create()));
                    }
                    this.state_ = state = state | 0x800000000L /* add-active isExecutable(HostObject, LookupFunctionalMethodNode) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.isExecutable(this.lookupFunctionalMethod);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x1000000000L) != 0 /* is-active execute(HostObject, Object[], HostExecuteNode, LookupFunctionalMethodNode, BranchProfile) */) {
                    return arg0Value.execute(arg1Value, this.hostExecute, this.lookupFunctionalMethod, this.error);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object executeNode_AndSpecialize(HostObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.hostExecute == null) {
                        this.hostExecute = super.insert((HostExecuteNode.create()));
                    }
                    if (this.lookupFunctionalMethod == null) {
                        this.lookupFunctionalMethod = super.insert((LookupFunctionalMethodNodeGen.create()));
                    }
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x1000000000L /* add-active execute(HostObject, Object[], HostExecuteNode, LookupFunctionalMethodNode, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.execute(arg1Value, this.hostExecute, this.lookupFunctionalMethod, this.error);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isNumber(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isNumber();
            }

            @Override
            public boolean fitsInByte(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x2000000000L) != 0 /* is-active fitsInByte(HostObject, InteropLibrary) */) {
                    return arg0Value.fitsInByte(this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInByteNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInByteNode_AndSpecialize(HostObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                    }
                    this.state_ = state = state | 0x2000000000L /* add-active fitsInByte(HostObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.fitsInByte(this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInShort(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x4000000000L) != 0 /* is-active fitsInShort(HostObject, InteropLibrary) */) {
                    return arg0Value.fitsInShort(this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInShortNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInShortNode_AndSpecialize(HostObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                    }
                    this.state_ = state = state | 0x4000000000L /* add-active fitsInShort(HostObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.fitsInShort(this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInInt(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x8000000000L) != 0 /* is-active fitsInInt(HostObject, InteropLibrary) */) {
                    return arg0Value.fitsInInt(this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInIntNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInIntNode_AndSpecialize(HostObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                    }
                    this.state_ = state = state | 0x8000000000L /* add-active fitsInInt(HostObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.fitsInInt(this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInLong(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x10000000000L) != 0 /* is-active fitsInLong(HostObject, InteropLibrary) */) {
                    return arg0Value.fitsInLong(this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInLongNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInLongNode_AndSpecialize(HostObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                    }
                    this.state_ = state = state | 0x10000000000L /* add-active fitsInLong(HostObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.fitsInLong(this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInFloat(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x20000000000L) != 0 /* is-active fitsInFloat(HostObject, InteropLibrary) */) {
                    return arg0Value.fitsInFloat(this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInFloatNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInFloatNode_AndSpecialize(HostObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                    }
                    this.state_ = state = state | 0x20000000000L /* add-active fitsInFloat(HostObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.fitsInFloat(this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInDouble(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x40000000000L) != 0 /* is-active fitsInDouble(HostObject, InteropLibrary) */) {
                    return arg0Value.fitsInDouble(this.numbers);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInDoubleNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInDoubleNode_AndSpecialize(HostObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                    }
                    this.state_ = state = state | 0x40000000000L /* add-active fitsInDouble(HostObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.fitsInDouble(this.numbers);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x80000000000L) != 0 /* is-active asByte(HostObject, InteropLibrary, BranchProfile) */) {
                    return arg0Value.asByte(this.numbers, this.error);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asByteNode_AndSpecialize(arg0Value);
            }

            private byte asByteNode_AndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                    }
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x80000000000L /* add-active asByte(HostObject, InteropLibrary, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.asByte(this.numbers, this.error);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x100000000000L) != 0 /* is-active asShort(HostObject, InteropLibrary, BranchProfile) */) {
                    return arg0Value.asShort(this.numbers, this.error);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asShortNode_AndSpecialize(arg0Value);
            }

            private short asShortNode_AndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                    }
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x100000000000L /* add-active asShort(HostObject, InteropLibrary, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.asShort(this.numbers, this.error);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x200000000000L) != 0 /* is-active asInt(HostObject, InteropLibrary, BranchProfile) */) {
                    return arg0Value.asInt(this.numbers, this.error);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asIntNode_AndSpecialize(arg0Value);
            }

            private int asIntNode_AndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                    }
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x200000000000L /* add-active asInt(HostObject, InteropLibrary, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.asInt(this.numbers, this.error);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x400000000000L) != 0 /* is-active asLong(HostObject, InteropLibrary, BranchProfile) */) {
                    return arg0Value.asLong(this.numbers, this.error);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asLongNode_AndSpecialize(arg0Value);
            }

            private long asLongNode_AndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                    }
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x400000000000L /* add-active asLong(HostObject, InteropLibrary, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.asLong(this.numbers, this.error);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x800000000000L) != 0 /* is-active asFloat(HostObject, InteropLibrary, BranchProfile) */) {
                    return arg0Value.asFloat(this.numbers, this.error);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asFloatNode_AndSpecialize(arg0Value);
            }

            private float asFloatNode_AndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                    }
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x800000000000L /* add-active asFloat(HostObject, InteropLibrary, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.asFloat(this.numbers, this.error);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x1000000000000L) != 0 /* is-active asDouble(HostObject, InteropLibrary, BranchProfile) */) {
                    return arg0Value.asDouble(this.numbers, this.error);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asDoubleNode_AndSpecialize(arg0Value);
            }

            private double asDoubleNode_AndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                    }
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x1000000000000L /* add-active asDouble(HostObject, InteropLibrary, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.asDouble(this.numbers, this.error);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isString(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isString();
            }

            @Override
            public String asString(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x2000000000000L) != 0 /* is-active asString(HostObject, InteropLibrary, BranchProfile) */) {
                    return arg0Value.asString(this.numbers, this.error);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asStringNode_AndSpecialize(arg0Value);
            }

            private String asStringNode_AndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numbers == null) {
                        this.numbers = super.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                    }
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x2000000000000L /* add-active asString(HostObject, InteropLibrary, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.asString(this.numbers, this.error);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isBoolean(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isBoolean();
            }

            @Override
            public boolean asBoolean(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x4000000000000L) != 0 /* is-active asBoolean(HostObject, BranchProfile) */) {
                    return arg0Value.asBoolean(this.error);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asBooleanNode_AndSpecialize(arg0Value);
            }

            private boolean asBooleanNode_AndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x4000000000000L /* add-active asBoolean(HostObject, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.asBoolean(this.error);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isDate(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isDate();
            }

            @Override
            public LocalDate asDate(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).asDate();
            }

            @Override
            public boolean isTime(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isTime();
            }

            @Override
            public LocalTime asTime(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).asTime();
            }

            @Override
            public boolean isTimeZone(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isTimeZone();
            }

            @Override
            public ZoneId asTimeZone(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).asTimeZone();
            }

            @Override
            public Instant asInstant(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).asInstant();
            }

            @Override
            public boolean isDuration(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isDuration();
            }

            @Override
            public Duration asDuration(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).asDuration();
            }

            @Override
            public boolean isException(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isException();
            }

            @Override
            public RuntimeException throwException(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x8000000000000L) != 0 /* is-active throwException(HostObject, BranchProfile) */) {
                    return arg0Value.throwException(this.error);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return throwExceptionNode_AndSpecialize(arg0Value);
            }

            private RuntimeException throwExceptionNode_AndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x8000000000000L /* add-active throwException(HostObject, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.throwException(this.error);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).getLanguage();
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).toDisplayString(allowSideEffects);
            }

            @Override
            public boolean hasMetaObject(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).hasMetaObject();
            }

            @Override
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).getMetaObject();
            }

            @Override
            public boolean isMetaObject(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isMetaObject();
            }

            @Override
            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).getMetaQualifiedName();
            }

            @Override
            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).getMetaSimpleName();
            }

            @Override
            public boolean isMetaInstance(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                long state = state_;
                if ((state & 0x10000000000000L) != 0 /* is-active isMetaInstance(HostObject, Object, BranchProfile) */) {
                    return arg0Value.isMetaInstance(arg1Value, this.error);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMetaInstanceNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMetaInstanceNode_AndSpecialize(HostObject arg0Value, Object arg1Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.error == null) {
                        this.error = (BranchProfile.create());
                    }
                    this.state_ = state = state | 0x10000000000000L /* add-active isMetaInstance(HostObject, Object, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.isMetaInstance(arg1Value, this.error);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return HostObject.identityHashCode((((HostObject) receiver)));
            }

            private static boolean isIdenticalOrUndefinedFallbackGuard_(long state, HostObject arg0Value, Object arg1Value) {
                if (((state & 0x8000000L)) == 0 /* is-not-active doHostObject(HostObject, HostObject) */ && arg1Value instanceof HostObject) {
                    return false;
                }
                return true;
            }

            @GeneratedBy(HostObject.class)
            private static final class IsMemberReadableCachedData {

                @CompilationFinal IsMemberReadableCachedData next_;
                @CompilationFinal boolean cachedStatic_;
                @CompilationFinal Class<?> cachedClazz_;
                @CompilationFinal String cachedName_;
                @CompilationFinal boolean cachedReadable_;

                IsMemberReadableCachedData(IsMemberReadableCachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(HostObject.class)
            private static final class IsMemberModifiableCachedData {

                @CompilationFinal IsMemberModifiableCachedData next_;
                @CompilationFinal boolean cachedStatic_;
                @CompilationFinal Class<?> cachedClazz_;
                @CompilationFinal String cachedName_;
                @CompilationFinal boolean cachedModifiable_;

                IsMemberModifiableCachedData(IsMemberModifiableCachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(HostObject.class)
            private static final class IsMemberInternalCachedData {

                @CompilationFinal IsMemberInternalCachedData next_;
                @CompilationFinal boolean cachedStatic_;
                @CompilationFinal Class<?> cachedClazz_;
                @CompilationFinal String cachedName_;
                @CompilationFinal boolean cachedInternal_;

                IsMemberInternalCachedData(IsMemberInternalCachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(HostObject.class)
            private static final class IsMemberInvocableCachedData {

                @CompilationFinal IsMemberInvocableCachedData next_;
                @CompilationFinal boolean cachedStatic_;
                @CompilationFinal Class<?> cachedClazz_;
                @CompilationFinal String cachedName_;
                @CompilationFinal boolean cachedInvokable_;

                IsMemberInvocableCachedData(IsMemberInvocableCachedData next_) {
                    this.next_ = next_;
                }

            }
        }
        @GeneratedBy(HostObject.class)
        private static final class Uncached extends InteropLibrary {

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof HostObject) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof HostObject;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return IsMemberReadable.doUncached(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return IsMemberModifiable.doUncached(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInternal(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return IsMemberInternal.doUncached(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return IsMemberInvocable.doUncached(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if (((IsArrayNodeGen.getUncached()).execute(arg0Value))) {
                    return IsArrayElementExisting.doArray(arg0Value, arg1Value, (IsArrayNodeGen.getUncached()));
                }
                if (((IsListNodeGen.getUncached()).execute(arg0Value))) {
                    return IsArrayElementExisting.doList(arg0Value, arg1Value, (IsListNodeGen.getUncached()));
                }
                if ((!((IsListNodeGen.getUncached()).execute(arg0Value))) && (!((IsArrayNodeGen.getUncached()).execute(arg0Value)))) {
                    return IsArrayElementExisting.doNotArrayOrList(arg0Value, arg1Value, (IsListNodeGen.getUncached()), (IsArrayNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if (((IsArrayNodeGen.getUncached()).execute(arg0Value))) {
                    return IsArrayElementExisting.doArray(arg0Value, arg1Value, (IsArrayNodeGen.getUncached()));
                }
                if (((IsListNodeGen.getUncached()).execute(arg0Value))) {
                    return IsArrayElementExisting.doList(arg0Value, arg1Value, (IsListNodeGen.getUncached()));
                }
                if ((!((IsListNodeGen.getUncached()).execute(arg0Value))) && (!((IsArrayNodeGen.getUncached()).execute(arg0Value)))) {
                    return IsArrayElementExisting.doNotArrayOrList(arg0Value, arg1Value, (IsListNodeGen.getUncached()), (IsArrayNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedTypeException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if (((IsArrayNodeGen.getUncached()).execute(arg0Value))) {
                    WriteArrayElement.doArray(arg0Value, arg1Value, arg2Value, (ToHostNodeGen.getUncached()), (IsArrayNodeGen.getUncached()), (ArraySetNodeGen.getUncached()), (BranchProfile.getUncached()));
                    return;
                }
                if (((IsListNodeGen.getUncached()).execute(arg0Value))) {
                    WriteArrayElement.doList(arg0Value, arg1Value, arg2Value, (IsListNodeGen.getUncached()), (ToHostNodeGen.getUncached()), (BranchProfile.getUncached()));
                    return;
                }
                if ((!((IsListNodeGen.getUncached()).execute(arg0Value))) && (!((IsArrayNodeGen.getUncached()).execute(arg0Value)))) {
                    WriteArrayElement.doNotArrayOrList(arg0Value, arg1Value, arg2Value, (IsListNodeGen.getUncached()), (IsArrayNodeGen.getUncached()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if (((IsListNodeGen.getUncached()).execute(arg0Value))) {
                    return IsArrayElementRemovable.doList(arg0Value, arg1Value, (IsListNodeGen.getUncached()));
                }
                if ((!((IsListNodeGen.getUncached()).execute(arg0Value)))) {
                    return IsArrayElementRemovable.doOther(arg0Value, arg1Value, (IsListNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if (((IsListNodeGen.getUncached()).execute(arg0Value))) {
                    RemoveArrayElement.doList(arg0Value, arg1Value, (IsListNodeGen.getUncached()), (BranchProfile.getUncached()));
                    return;
                }
                if ((!((IsListNodeGen.getUncached()).execute(arg0Value)))) {
                    RemoveArrayElement.doOther(arg0Value, arg1Value, (IsListNodeGen.getUncached()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if (((IsArrayNodeGen.getUncached()).execute(arg0Value))) {
                    return ReadArrayElement.doArray(arg0Value, arg1Value, (ArrayGetNodeGen.getUncached()), (IsArrayNodeGen.getUncached()), (ToGuestValueNodeGen.getUncached()), (BranchProfile.getUncached()));
                }
                if (((IsListNodeGen.getUncached()).execute(arg0Value))) {
                    return ReadArrayElement.doList(arg0Value, arg1Value, (IsListNodeGen.getUncached()), (ToGuestValueNodeGen.getUncached()), (BranchProfile.getUncached()));
                }
                if ((!((IsArrayNodeGen.getUncached()).execute(arg0Value))) && (!((IsListNodeGen.getUncached()).execute(arg0Value)))) {
                    return ReadArrayElement.doNotArrayOrList(arg0Value, arg1Value, (IsArrayNodeGen.getUncached()), (IsListNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isInstantiable(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((!(arg0Value.isClass()))) {
                    return IsInstantiable.doUnsupported(arg0Value);
                }
                if ((arg0Value.isArrayClass())) {
                    return IsInstantiable.doArrayCached(arg0Value);
                }
                if ((arg0Value.isDefaultClass())) {
                    return IsInstantiable.doObjectCached(arg0Value, (LookupConstructorNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((!(arg0Value.isClass()))) {
                    return Instantiate.doUnsupported(arg0Value, arg1Value);
                }
                if ((arg0Value.isArrayClass())) {
                    return Instantiate.doArrayCached(arg0Value, arg1Value, (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
                }
                if ((arg0Value.isDefaultClass())) {
                    return Instantiate.doObjectCached(arg0Value, arg1Value, (LookupConstructorNodeGen.getUncached()), (HostExecuteNodeGen.getUncached()), (BranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if (arg1Value instanceof HostObject) {
                    HostObject arg1Value_ = (HostObject) arg1Value;
                    return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.readMember(arg1Value, (LookupFieldNodeGen.getUncached()), (ReadFieldNodeGen.getUncached()), (LookupMethodNodeGen.getUncached()), (LookupInnerClassNodeGen.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInsertable(Object receiver, String member) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isMemberInsertable(member);
            }

            @TruffleBoundary
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                arg0Value.writeMember(arg1Value, arg2Value, (LookupFieldNodeGen.getUncached()), (WriteFieldNodeGen.getUncached()), (BranchProfile.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.invokeMember(arg1Value, arg2Value, (LookupMethodNodeGen.getUncached()), (HostExecuteNodeGen.getUncached()), (LookupFieldNodeGen.getUncached()), (ReadFieldNodeGen.getUncached()), (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.isArrayElementInsertable(arg1Value, (IsListNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasArrayElements(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.hasArrayElements((IsListNodeGen.getUncached()), (IsArrayNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.getArraySize((IsArrayNodeGen.getUncached()), (IsListNodeGen.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isNull(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isNull();
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.isExecutable((LookupFunctionalMethodNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.execute(arg1Value, (HostExecuteNodeGen.getUncached()), (LookupFunctionalMethodNodeGen.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isNumber(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isNumber();
            }

            @TruffleBoundary
            @Override
            public boolean fitsInByte(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.fitsInByte((INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInShort(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.fitsInShort((INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInInt(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.fitsInInt((INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInLong(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.fitsInLong((INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInFloat(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.fitsInFloat((INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInDouble(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.fitsInDouble((INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.asByte((INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.asShort((INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.asInt((INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.asLong((INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.asFloat((INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.asDouble((INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isString(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isString();
            }

            @TruffleBoundary
            @Override
            public String asString(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.asString((INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isBoolean(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isBoolean();
            }

            @TruffleBoundary
            @Override
            public boolean asBoolean(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.asBoolean((BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isDate(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isDate();
            }

            @TruffleBoundary
            @Override
            public LocalDate asDate(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .asDate();
            }

            @TruffleBoundary
            @Override
            public boolean isTime(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isTime();
            }

            @TruffleBoundary
            @Override
            public LocalTime asTime(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .asTime();
            }

            @TruffleBoundary
            @Override
            public boolean isTimeZone(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isTimeZone();
            }

            @TruffleBoundary
            @Override
            public ZoneId asTimeZone(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .asTimeZone();
            }

            @TruffleBoundary
            @Override
            public Instant asInstant(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .asInstant();
            }

            @TruffleBoundary
            @Override
            public boolean isDuration(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isDuration();
            }

            @TruffleBoundary
            @Override
            public Duration asDuration(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .asDuration();
            }

            @TruffleBoundary
            @Override
            public boolean isException(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isException();
            }

            @TruffleBoundary
            @Override
            public RuntimeException throwException(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.throwException((BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .toDisplayString(allowSideEffects);
            }

            @TruffleBoundary
            @Override
            public boolean hasMetaObject(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .hasMetaObject();
            }

            @TruffleBoundary
            @Override
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .getMetaObject();
            }

            @TruffleBoundary
            @Override
            public boolean isMetaObject(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isMetaObject();
            }

            @TruffleBoundary
            @Override
            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .getMetaQualifiedName();
            }

            @TruffleBoundary
            @Override
            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .getMetaSimpleName();
            }

            @TruffleBoundary
            @Override
            public boolean isMetaInstance(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.isMetaInstance(arg1Value, (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return HostObject.identityHashCode(((HostObject) receiver) );
            }

        }
    }
}
