/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.LayoutFactory;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import java.util.ServiceLoader;

public abstract class Layout {
    public static final String OPTION_PREFIX = "truffle.object.";
    private static final LayoutFactory LAYOUT_FACTORY = Layout.loadLayoutFactory();

    protected Layout() {
    }

    public static Builder newLayout() {
        return new Builder();
    }

    public static Layout createLayout() {
        return Layout.newLayout().build();
    }

    public abstract DynamicObject newInstance(Shape var1);

    public abstract Class<? extends DynamicObject> getType();

    public abstract Shape createShape(ObjectType var1);

    public abstract Shape createShape(ObjectType var1, Object var2);

    public abstract Shape createShape(ObjectType var1, Object var2, int var3);

    public abstract Shape.Allocator createAllocator();

    protected static LayoutFactory getFactory() {
        return LAYOUT_FACTORY;
    }

    private static LayoutFactory loadLayoutFactory() {
        ServiceLoader<LayoutFactory> serviceLoader;
        LayoutFactory layoutFactory = Truffle.getRuntime().getCapability(LayoutFactory.class);
        if (layoutFactory == null && (layoutFactory = Layout.selectLayoutFactory(serviceLoader = ServiceLoader.load(LayoutFactory.class, Layout.class.getClassLoader()))) == null) {
            throw new AssertionError((Object)"LayoutFactory not found");
        }
        return layoutFactory;
    }

    private static LayoutFactory selectLayoutFactory(Iterable<LayoutFactory> availableLayoutFactories) {
        String layoutFactoryImplName = System.getProperty("truffle.object.LayoutFactory");
        LayoutFactory bestLayoutFactory = null;
        for (LayoutFactory currentLayoutFactory : availableLayoutFactories) {
            if (layoutFactoryImplName != null) {
                if (!currentLayoutFactory.getClass().getName().equals(layoutFactoryImplName)) continue;
                return currentLayoutFactory;
            }
            if (bestLayoutFactory == null) {
                bestLayoutFactory = currentLayoutFactory;
                continue;
            }
            if (currentLayoutFactory.getPriority() < bestLayoutFactory.getPriority()) continue;
            assert (currentLayoutFactory.getPriority() != bestLayoutFactory.getPriority());
            bestLayoutFactory = currentLayoutFactory;
        }
        return bestLayoutFactory;
    }

    protected static EnumSet<ImplicitCast> getAllowedImplicitCasts(Builder builder) {
        return builder.allowedImplicitCasts;
    }

    protected static boolean getPolymorphicUnboxing(Builder builder) {
        return builder.polymorphicUnboxing;
    }

    protected static abstract class Access {
        protected Access() {
            if (!this.getClass().getName().startsWith("com.oracle.truffle.object.")) {
                throw new IllegalAccessError();
            }
        }

        public final void setShape(DynamicObject object, Shape shape) {
            object.setShape(shape);
        }
    }

    public static final class Builder {
        private EnumSet<ImplicitCast> allowedImplicitCasts = EnumSet.noneOf(ImplicitCast.class);
        private boolean polymorphicUnboxing;

        private Builder() {
        }

        public Layout build() {
            return Layout.getFactory().createLayout(this);
        }

        public Builder setAllowedImplicitCasts(EnumSet<ImplicitCast> allowedImplicitCasts) {
            this.allowedImplicitCasts = allowedImplicitCasts;
            return this;
        }

        public Builder addAllowedImplicitCast(ImplicitCast allowedImplicitCast) {
            this.allowedImplicitCasts.add(allowedImplicitCast);
            return this;
        }

        public Builder setPolymorphicUnboxing(boolean polymorphicUnboxing) {
            this.polymorphicUnboxing = polymorphicUnboxing;
            return this;
        }
    }

    public static enum ImplicitCast {
        IntToDouble,
        IntToLong;

    }
}

