/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.instrumentation.InstrumentationHandler;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.io.InputStream;
import java.util.Set;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.io.MessageTransport;

final class InstrumentAccessor
extends Accessor {
    static final InstrumentAccessor ACCESSOR = new InstrumentAccessor();

    private InstrumentAccessor() {
    }

    static Accessor.NodeSupport nodesAccess() {
        return ACCESSOR.nodeSupport();
    }

    static Accessor.LanguageSupport langAccess() {
        return ACCESSOR.languageSupport();
    }

    static Accessor.EngineSupport engineAccess() {
        return ACCESSOR.engineSupport();
    }

    static Accessor.InteropSupport interopAccess() {
        return ACCESSOR.interopSupport();
    }

    protected boolean isTruffleObject(Object value) {
        return this.interopSupport().isTruffleObject(value);
    }

    static final class InstrumentImpl
    extends Accessor.InstrumentSupport {
        InstrumentImpl() {
        }

        @Override
        public Object createInstrumentationHandler(Object vm, DispatchOutputStream out, DispatchOutputStream err, InputStream in, MessageTransport messageInterceptor) {
            return new InstrumentationHandler(vm, out, err, in, messageInterceptor);
        }

        @Override
        public void initializeInstrument(Object instrumentationHandler, Object key, Class<?> instrumentClass) {
            ((InstrumentationHandler)instrumentationHandler).initializeInstrument(key, instrumentClass);
        }

        @Override
        public void createInstrument(Object instrumentationHandler, Object key, String[] expectedServices, OptionValues options) {
            ((InstrumentationHandler)instrumentationHandler).createInstrument(key, expectedServices, options);
        }

        @Override
        public Object getEngineInstrumenter(Object instrumentationHandler) {
            return ((InstrumentationHandler)instrumentationHandler).engineInstrumenter;
        }

        @Override
        public void onNodeInserted(RootNode rootNode, Node tree) {
            InstrumentationHandler handler = InstrumentImpl.getHandler(rootNode);
            if (handler != null) {
                handler.onNodeInserted(rootNode, tree);
            }
        }

        @Override
        public OptionDescriptors describeOptions(Object instrumentationHandler, Object key, String requiredGroup) {
            InstrumentationHandler.InstrumentClientInstrumenter instrumenter = (InstrumentationHandler.InstrumentClientInstrumenter)((InstrumentationHandler)instrumentationHandler).instrumenterMap.get(key);
            OptionDescriptors descriptors = instrumenter.instrument.getOptionDescriptors();
            if (descriptors == null) {
                descriptors = OptionDescriptors.EMPTY;
            }
            String groupPlusDot = requiredGroup + ".";
            for (OptionDescriptor descriptor : descriptors) {
                if (descriptor.getName().equals(requiredGroup) || descriptor.getName().startsWith(groupPlusDot)) continue;
                throw new IllegalArgumentException(String.format("Illegal option prefix in name '%s' specified for option described by instrument '%s'. The option prefix must match the id of the instrument '%s'.", descriptor.getName(), instrumenter.instrument.getClass().getName(), requiredGroup));
            }
            return descriptors;
        }

        @Override
        public void finalizeInstrument(Object instrumentationHandler, Object key) {
            ((InstrumentationHandler)instrumentationHandler).finalizeInstrumenter(key);
        }

        @Override
        public void disposeInstrument(Object instrumentationHandler, Object key, boolean cleanupRequired) {
            ((InstrumentationHandler)instrumentationHandler).disposeInstrumenter(key, cleanupRequired);
        }

        @Override
        public void collectEnvServices(Set<Object> collectTo, Object languageShared, TruffleLanguage<?> language) {
            InstrumentationHandler instrumentationHandler = (InstrumentationHandler)InstrumentAccessor.engineAccess().getInstrumentationHandler(languageShared);
            Instrumenter instrumenter = instrumentationHandler.forLanguage(language);
            collectTo.add(instrumenter);
            AllocationReporter allocationReporter = instrumentationHandler.getAllocationReporter(InstrumentAccessor.langAccess().getLanguageInfo(language));
            collectTo.add(allocationReporter);
        }

        @Override
        public <T> T getInstrumentationHandlerService(Object vm, Object key, Class<T> type) {
            InstrumentationHandler instrumentationHandler = (InstrumentationHandler)vm;
            return instrumentationHandler.lookup(key, type);
        }

        @Override
        public void onFirstExecution(RootNode rootNode) {
            InstrumentationHandler handler = InstrumentImpl.getHandler(rootNode);
            if (handler != null) {
                handler.onFirstExecution(rootNode);
            }
        }

        @Override
        public void onLoad(RootNode rootNode) {
            InstrumentationHandler handler = InstrumentImpl.getHandler(rootNode);
            if (handler != null) {
                handler.onLoad(rootNode);
            }
        }

        public Iterable<Scope> findTopScopes(TruffleLanguage.Env env) {
            return TruffleInstrument.Env.findTopScopes(env);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void notifyContextCreated(Object engine, TruffleContext context) {
            InstrumentationHandler instrumentationHandler = (InstrumentationHandler)InstrumentAccessor.engineAccess().getInstrumentationHandler(engine);
            instrumentationHandler.notifyContextCreated(context);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void notifyContextClosed(Object engine, TruffleContext context) {
            InstrumentationHandler instrumentationHandler = (InstrumentationHandler)InstrumentAccessor.engineAccess().getInstrumentationHandler(engine);
            instrumentationHandler.notifyContextClosed(context);
        }

        @Override
        public void notifyLanguageContextCreated(Object engine, TruffleContext context, LanguageInfo info) {
            InstrumentationHandler instrumentationHandler = (InstrumentationHandler)InstrumentAccessor.engineAccess().getInstrumentationHandler(engine);
            instrumentationHandler.notifyLanguageContextCreated(context, info);
        }

        @Override
        public void notifyLanguageContextInitialized(Object engine, TruffleContext context, LanguageInfo info) {
            InstrumentationHandler instrumentationHandler = (InstrumentationHandler)InstrumentAccessor.engineAccess().getInstrumentationHandler(engine);
            instrumentationHandler.notifyLanguageContextInitialized(context, info);
        }

        @Override
        public void notifyLanguageContextFinalized(Object engine, TruffleContext context, LanguageInfo info) {
            InstrumentationHandler instrumentationHandler = (InstrumentationHandler)InstrumentAccessor.engineAccess().getInstrumentationHandler(engine);
            instrumentationHandler.notifyLanguageContextFinalized(context, info);
        }

        @Override
        public void notifyLanguageContextDisposed(Object engine, TruffleContext context, LanguageInfo info) {
            InstrumentationHandler instrumentationHandler = (InstrumentationHandler)InstrumentAccessor.engineAccess().getInstrumentationHandler(engine);
            instrumentationHandler.notifyLanguageContextDisposed(context, info);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void notifyThreadStarted(Object engine, TruffleContext context, Thread thread) {
            InstrumentationHandler instrumentationHandler = (InstrumentationHandler)InstrumentAccessor.engineAccess().getInstrumentationHandler(engine);
            instrumentationHandler.notifyThreadStarted(context, thread);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void notifyThreadFinished(Object engine, TruffleContext context, Thread thread) {
            InstrumentationHandler instrumentationHandler = (InstrumentationHandler)InstrumentAccessor.engineAccess().getInstrumentationHandler(engine);
            instrumentationHandler.notifyThreadFinished(context, thread);
        }

        @Override
        public SourceSection createSourceSection(Object instrumentEnv, Source source, com.oracle.truffle.api.source.SourceSection ss) {
            TruffleInstrument.Env env = (TruffleInstrument.Env)instrumentEnv;
            return InstrumentAccessor.engineAccess().createSourceSection(env.getVMObject(), source, ss);
        }

        @Override
        public void patchInstrumentationHandler(Object vm, DispatchOutputStream out, DispatchOutputStream err, InputStream in) {
            InstrumentationHandler instrumentationHandler = (InstrumentationHandler)vm;
            instrumentationHandler.patch(out, err, in);
        }

        @Override
        public boolean isInputValueSlotIdentifier(Object identifier) {
            return identifier instanceof ProbeNode.EventProviderWithInputChainNode.SavedInputValueID;
        }

        private static InstrumentationHandler getHandler(RootNode rootNode) {
            LanguageInfo info = rootNode.getLanguageInfo();
            if (info == null) {
                return null;
            }
            Object languageShared = InstrumentAccessor.nodesAccess().getEngineObject(info);
            if (languageShared == null) {
                return null;
            }
            return (InstrumentationHandler)InstrumentAccessor.engineAccess().getInstrumentationHandler(languageShared);
        }
    }
}

